/*
 * Decompiled with CFR 0.152.
 */
package jaxe;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.swing.Action;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import jaxe.ActionInsertionBalise;
import jaxe.AllowedElementsPanel;
import jaxe.ArbreXML;
import jaxe.AttributePanel;
import jaxe.Config;
import jaxe.DialogueAttente;
import jaxe.DocumentRenderer;
import jaxe.HTMLFrame;
import jaxe.Jaxe;
import jaxe.JaxeDocument;
import jaxe.JaxeElement;
import jaxe.JaxeMenuBar;
import jaxe.JaxeResourceBundle;
import jaxe.JaxeTextPane;
import jaxe.Preferences;
import jaxe.SourceFrame;
import jaxe.ValidationFrame;
import jaxe.elements.JESwing;
import org.apache.log4j.Logger;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JaxeFrame
extends JFrame
implements ComponentListener {
    private static final Logger LOG = Logger.getLogger(JaxeFrame.class);
    private static final ResourceBundle rb = JaxeResourceBundle.getRB();
    JaxeTextPane textPane;
    private JScrollPane paneScrollPane;
    private JTabbedPane sidepane;
    private ArbreXML arbrexml;
    private AllowedElementsPanel allowed;
    private AttributePanel attpane;
    private JSplitPane split;
    private CaretListenerLabel caretListenerLabel;
    private boolean afficherSide = true;
    private boolean afficherArbre = true;
    private boolean afficherAllowed = true;
    private boolean afficherAttributs = true;
    private JaxeMenuBar menuBar;
    private String nomFichierCfg;
    private HTMLFrame htmlFrame = null;
    private ValidationFrame validationFrame = null;
    private SourceFrame sourceFrame = null;
    private JMenuBar barreBalises;
    public JaxeDocument doc;
    private File fichierAOuvrir;
    private File configAOuvrir;

    public JaxeFrame() {
        super("Jaxe");
        int n;
        int n2;
        int n3;
        Object object;
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                JaxeFrame.this.fermer(false);
            }
        });
        Properties properties = Preferences.getPref();
        if (properties != null) {
            String string;
            String string2;
            object = properties.getProperty("fenetreArbre");
            if (object != null) {
                this.afficherArbre = "true".equals(object);
            }
            if ((string2 = properties.getProperty("fenetreInsertion")) != null) {
                this.afficherAllowed = "true".equals(string2);
            }
            if ((string = properties.getProperty("fenetreAttributs")) != null) {
                this.afficherAttributs = "true".equals(string);
            }
            this.afficherSide = this.afficherArbre || this.afficherAllowed || this.afficherAttributs;
        }
        this.menuBar = new JaxeMenuBar(this);
        this.setJMenuBar(this.menuBar);
        object = this.getToolkit().getScreenSize();
        int n4 = ((Dimension)object).width * 2 / 3;
        if (n4 < 750) {
            n4 = ((Dimension)object).width - 20;
        }
        if ((n3 = ((Dimension)object).height * 3 / 4) < 550) {
            n3 = ((Dimension)object).height - 50;
        }
        if (Jaxe.allFrames.size() < 1) {
            n2 = 10;
            n = 40;
        } else {
            JaxeFrame jaxeFrame = Jaxe.allFrames.get(Jaxe.allFrames.size() - 1);
            Point point = jaxeFrame.getLocationOnScreen();
            n2 = point.x + 20;
            if (n2 + n4 > ((Dimension)object).width && ((Dimension)object).width - n2 > 300) {
                n4 = ((Dimension)object).width - n2;
            }
            n = point.y + 20;
        }
        this.setSize(new Dimension(n4, n3));
        this.setLocation(n2, n);
    }

    public JaxeTextPane getTextPane() {
        return this.textPane;
    }

    public JaxeMenuBar getJaxeMenuBar() {
        return this.menuBar;
    }

    public SourceFrame getSourceFrame() {
        return this.sourceFrame;
    }

    public void setSourceFrame(SourceFrame sourceFrame) {
        this.sourceFrame = sourceFrame;
    }

    public void setAffichageSide(boolean bl) {
        if (this.afficherSide != bl) {
            if (this.afficherArbre) {
                this.textPane.retirerEcouteurArbre(this.arbrexml);
            }
            if (this.afficherAllowed) {
                this.textPane.retirerEcouteurArbre(this.allowed);
            }
            if (this.afficherAttributs) {
                this.textPane.retirerEcouteurArbre(this.attpane);
            }
            if (!this.afficherSide) {
                this.getContentPane().remove(this.paneScrollPane);
            } else {
                this.getContentPane().remove(this.split);
            }
            this.afficherSide = bl;
            this.modifierSide();
            this.validate();
            this.textPane.getCaret().setVisible(true);
        }
    }

    public boolean getAffichageSide() {
        return this.afficherSide;
    }

    public void setAffichageArbre(boolean bl) {
        if (this.afficherArbre != bl) {
            if (!bl) {
                this.textPane.retirerEcouteurArbre(this.arbrexml);
            }
            if (this.afficherAllowed) {
                this.textPane.retirerEcouteurArbre(this.allowed);
            }
            if (this.afficherAttributs) {
                this.textPane.retirerEcouteurArbre(this.attpane);
            }
            if (!this.afficherSide) {
                this.getContentPane().remove(this.paneScrollPane);
            } else {
                this.getContentPane().remove(this.split);
            }
            this.afficherArbre = bl;
            this.afficherSide = this.afficherArbre || this.afficherAllowed || this.afficherAttributs;
            this.modifierSide();
            this.validate();
            this.textPane.getCaret().setVisible(true);
        }
    }

    public boolean getAffichageArbre() {
        return this.afficherArbre;
    }

    public void setAffichageAllowed(boolean bl) {
        if (this.afficherAllowed != bl) {
            if (this.afficherArbre) {
                this.textPane.retirerEcouteurArbre(this.arbrexml);
            }
            if (!bl) {
                this.textPane.retirerEcouteurArbre(this.allowed);
            }
            if (this.afficherAttributs) {
                this.textPane.retirerEcouteurArbre(this.attpane);
            }
            if (!this.afficherSide) {
                this.getContentPane().remove(this.paneScrollPane);
            } else {
                this.getContentPane().remove(this.split);
            }
            this.afficherAllowed = bl;
            this.afficherSide = this.afficherArbre || this.afficherAllowed || this.afficherAttributs;
            this.modifierSide();
            this.validate();
            this.textPane.getCaret().setVisible(true);
        }
    }

    public boolean getAffichageAllowed() {
        return this.afficherAllowed;
    }

    public void setAffichageAttributs(boolean bl) {
        if (this.afficherAttributs != bl) {
            if (this.afficherArbre) {
                this.textPane.retirerEcouteurArbre(this.arbrexml);
            }
            if (this.afficherAllowed) {
                this.textPane.retirerEcouteurArbre(this.allowed);
            }
            if (!bl) {
                this.textPane.retirerEcouteurArbre(this.attpane);
            }
            if (!this.afficherSide) {
                this.getContentPane().remove(this.paneScrollPane);
            } else {
                this.getContentPane().remove(this.split);
            }
            this.afficherAttributs = bl;
            this.afficherSide = this.afficherArbre || this.afficherAllowed || this.afficherAttributs;
            this.modifierSide();
            this.validate();
            this.textPane.getCaret().setVisible(true);
        }
    }

    public boolean getAffichageAttributs() {
        return this.afficherAttributs;
    }

    public void modifierSide() {
        if (this.afficherSide) {
            this.sidepane = new JTabbedPane();
            if (this.afficherAllowed) {
                this.allowed = new AllowedElementsPanel((JaxeDocument)this.textPane.getDocument());
                this.textPane.addCaretListener(this.allowed);
                this.textPane.ajouterEcouteurArbre(this.allowed);
                this.sidepane.addTab(rb.getString("tabs.insertion"), this.allowed);
            } else {
                this.allowed = null;
            }
            if (this.afficherArbre) {
                this.arbrexml = new ArbreXML(this.doc);
                this.textPane.ajouterEcouteurArbre(this.arbrexml);
                this.sidepane.addTab(rb.getString("tabs.arbre"), this.arbrexml);
            } else {
                this.arbrexml = null;
            }
            if (this.afficherAttributs) {
                this.attpane = new AttributePanel((JaxeDocument)this.textPane.getDocument());
                this.textPane.addCaretListener(this.attpane);
                this.textPane.ajouterEcouteurArbre(this.attpane);
                this.sidepane.addTab(rb.getString("tabs.attributs"), this.attpane);
            } else {
                this.attpane = null;
            }
            this.split = new JSplitPane(1);
            this.split.setLeftComponent(this.sidepane);
            this.split.setRightComponent(this.paneScrollPane);
            this.split.setDividerLocation(250);
            this.getContentPane().add((Component)this.split, "Center");
        } else {
            this.sidepane = null;
            this.arbrexml = null;
            this.allowed = null;
            this.attpane = null;
            this.getContentPane().add((Component)this.paneScrollPane, "Center");
        }
    }

    public void initNew(String string) {
        this.nomFichierCfg = string;
        this.getContentPane().removeAll();
        this.doc = new JaxeDocument(string);
        if (string == null || !new File(string).exists()) {
            JOptionPane.showMessageDialog(this, rb.getString("erreur.ConfigIntrouvable"), rb.getString("erreur.Fatale"), 0);
            System.exit(1);
        }
        this.affichageDoc();
        this.doc.nouveau();
        this.caretListenerLabel.setText("");
        this.textPane.addCaretListener(this.caretListenerLabel);
        this.majMenus(this.textPane.getCaretPosition());
        this.setTitle(rb.getString("document.Nouveau"));
        if (this.afficherArbre) {
            this.arbrexml.newdoc(this.doc);
        }
        this.setVisible(true);
        if (this.htmlFrame != null) {
            this.htmlFrame.setVisible(false);
            this.htmlFrame.dispose();
            this.htmlFrame = null;
        }
        if (this.validationFrame != null) {
            this.validationFrame.setVisible(false);
            this.validationFrame.dispose();
            this.validationFrame = null;
        }
        if (this.sourceFrame != null) {
            this.sourceFrame.setVisible(false);
            this.sourceFrame.dispose();
            this.sourceFrame = null;
        }
    }

    public void affichageDoc() {
        Object object;
        boolean bl = true;
        Properties properties = Preferences.getPref();
        if (properties != null && (object = properties.getProperty("iconeValide")) != null) {
            bl = "true".equals(object);
        }
        this.doc.textPane = this.textPane = new JaxeTextPane(this.doc, this, bl);
        this.paneScrollPane = new JScrollPane(this.textPane);
        this.paneScrollPane.setVerticalScrollBarPolicy(22);
        this.paneScrollPane.setPreferredSize(new Dimension(500, 400));
        this.paneScrollPane.setMinimumSize(new Dimension(100, 50));
        this.barreBalises = this.doc.cfg == null ? null : this.doc.cfg.makeMenus(this.doc);
        object = new JPanel(new GridLayout(1, 1));
        this.caretListenerLabel = new CaretListenerLabel(rb.getString("status.Chargement"), this.doc);
        ((Container)object).add(this.caretListenerLabel);
        if (this.barreBalises != null) {
            this.getContentPane().add((Component)this.barreBalises, "North");
        }
        this.getContentPane().add((Component)object, "South");
        this.modifierSide();
        this.textPane.ajouterEcouteurAnnulation(this.menuBar);
        this.removeComponentListener(this);
        this.addComponentListener(this);
        this.validate();
    }

    public void ouvrir(File file) {
        this.ouvrirAvecConf(file, null);
    }

    public void ouvrirAvecConf(File file, File file2) {
        this.fichierAOuvrir = file;
        this.configAOuvrir = file2;
        new ThreadOuverture().start();
    }

    public void ouvrirPlusTard() {
        String string;
        URL uRL;
        if (this.validationFrame != null) {
            this.validationFrame.setVisible(false);
            this.validationFrame.dispose();
            this.validationFrame = null;
        }
        if (this.sourceFrame != null) {
            this.sourceFrame.setVisible(false);
            this.sourceFrame.dispose();
            this.sourceFrame = null;
        }
        this.setVisible(true);
        DialogueAttente dialogueAttente = new DialogueAttente(this, rb.getString("status.Chargement"), 1, 100);
        dialogueAttente.setVisible(true);
        this.doc = new JaxeDocument();
        this.getContentPane().removeAll();
        this.affichageDoc();
        this.setCursor(new Cursor(3));
        this.getContentPane().setVisible(false);
        if (dialogueAttente != null) {
            dialogueAttente.setProgress(5);
        }
        try {
            uRL = this.fichierAOuvrir.toURI().toURL();
        }
        catch (MalformedURLException malformedURLException) {
            LOG.error("ouvrirPlusTard() - MalformedURLException", malformedURLException);
            if (dialogueAttente != null) {
                dialogueAttente.dispose();
            }
            this.setCursor(null);
            this.fermer(false);
            return;
        }
        String string2 = this.configAOuvrir == null ? null : this.configAOuvrir.getAbsolutePath();
        if (!this.doc.lire(uRL, string2)) {
            if (dialogueAttente != null) {
                dialogueAttente.dispose();
            }
            this.setCursor(null);
            this.fermer(false);
            return;
        }
        if (dialogueAttente != null) {
            dialogueAttente.setProgress(60);
        }
        this.nomFichierCfg = this.doc.nomFichierCfg;
        try {
            string = URLDecoder.decode(uRL.getFile(), "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            string = uRL.getFile();
            LOG.error("JaxeFrame.ouvrirPlusTard", unsupportedEncodingException);
        }
        this.setTitle(string);
        this.caretListenerLabel.setText("");
        this.textPane.addCaretListener(this.caretListenerLabel);
        if (this.barreBalises != null) {
            this.getContentPane().remove(this.barreBalises);
        }
        if (this.doc.cfg != null) {
            this.barreBalises = this.doc.cfg.makeMenus(this.doc);
            this.getContentPane().add((Component)this.barreBalises, "North");
        } else {
            this.barreBalises = null;
        }
        if (dialogueAttente != null) {
            dialogueAttente.setProgress(90);
        }
        if (this.arbrexml != null) {
            this.arbrexml.newdoc(this.doc);
        }
        if (this.afficherArbre) {
            this.sidepane.setSelectedComponent(this.arbrexml);
        }
        this.getContentPane().validate();
        this.getContentPane().setVisible(true);
        this.textPane.setCaretPosition(0);
        if (this.doc.cfg != null) {
            if (this.htmlFrame == null) {
                File file = HTMLFrame.fichierHTML(this.doc.fsave);
                if (file.exists()) {
                    this.htmlFrame = new HTMLFrame(this.doc);
                }
            } else {
                this.htmlFrame.newdoc(this.doc);
                this.htmlFrame.setVisible(true);
            }
        }
        if (dialogueAttente != null) {
            dialogueAttente.dispose();
        }
        this.setCursor(null);
        this.toFront();
    }

    public boolean fermer(boolean bl) {
        if (this.doc != null && this.doc.modif) {
            int n = JOptionPane.showConfirmDialog(this, rb.getString("fermeture.EnregistrerAvant"), rb.getString("fermeture.Fermeture"), 1);
            if (n == 0) {
                this.enregistrer();
            } else if (n == 2) {
                return false;
            }
        }
        this.setVisible(false);
        if (this.htmlFrame != null) {
            this.htmlFrame.setVisible(false);
            this.htmlFrame.dispose();
            this.htmlFrame = null;
        }
        if (this.validationFrame != null) {
            this.validationFrame.setVisible(false);
            this.validationFrame.dispose();
            this.validationFrame = null;
        }
        if (this.sourceFrame != null) {
            this.sourceFrame.setVisible(false);
            this.sourceFrame.dispose();
            this.sourceFrame = null;
        }
        Jaxe.allFrames.remove(this);
        this.getContentPane().removeAll();
        this.validate();
        this.textPane = null;
        this.paneScrollPane = null;
        this.sidepane = null;
        this.arbrexml = null;
        this.allowed = null;
        this.attpane = null;
        this.split = null;
        this.caretListenerLabel = null;
        this.menuBar = null;
        this.nomFichierCfg = null;
        this.barreBalises = null;
        this.doc = null;
        this.dispose();
        if (!bl && Jaxe.allFrames.size() == 0) {
            Jaxe.dialogueDepart();
        }
        return true;
    }

    public void enregistrer() {
        if (this.doc.fsave == null) {
            this.enregistrerSous();
        } else {
            try {
                this.doc.ecrire(this.doc.fsave);
            }
            catch (IOException iOException) {
                JOptionPane.showMessageDialog(this, iOException.getLocalizedMessage(), "IOException", 0);
                return;
            }
            this.setTitle(this.doc.fsave.getName());
        }
    }

    public void enregistrerSous() {
        FileDialog fileDialog = new FileDialog((Frame)this, null, 1);
        fileDialog.setVisible(true);
        String string = fileDialog.getFile();
        if (string != null) {
            File file = new File(fileDialog.getDirectory(), string);
            if (file.getName().indexOf(46) == -1 && (file = new File(file.getPath() + ".xml")).exists() && JOptionPane.showConfirmDialog(this, rb.getString("enregistrement.remplacer"), "", 0) == 1) {
                fileDialog = null;
                this.enregistrerSous();
                return;
            }
            try {
                this.doc.ecrire(file);
            }
            catch (IOException iOException) {
                JOptionPane.showMessageDialog(this, iOException.getLocalizedMessage(), "IOException", 0);
                return;
            }
            this.setTitle(file.getName());
        }
    }

    @Override
    public void componentHidden(ComponentEvent componentEvent) {
    }

    @Override
    public void componentMoved(ComponentEvent componentEvent) {
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
        if (this.sidepane != null && this.sidepane.getSize().width > 0 && this.sidepane.getSize().width < 100) {
            this.split.setDividerLocation(250);
        }
        if (this.doc != null) {
            this.doc.styleChanged();
        }
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
        if (this.textPane != null) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    JaxeFrame.this.textPane.requestFocus();
                    JaxeFrame.this.textPane.getCaret().setVisible(true);
                    JaxeFrame.this.textPane.invalidate();
                }
            });
        }
    }

    public void majMenus(int n) {
        if (this.doc.cfg == null || this.barreBalises == null) {
            return;
        }
        JaxeElement jaxeElement = null;
        if (this.doc.rootJE != null) {
            jaxeElement = this.doc.rootJE.elementA(n);
        }
        if (jaxeElement != null && jaxeElement.debut.getOffset() == n && !(jaxeElement instanceof JESwing)) {
            jaxeElement = jaxeElement.getParent();
        }
        if (jaxeElement != null && jaxeElement.noeud.getNodeType() == 3) {
            jaxeElement = jaxeElement.getParent();
        }
        ArrayList<String> arrayList = null;
        Config config = null;
        if (jaxeElement == null) {
            config = this.doc.cfg;
            arrayList = this.doc.cfg.listeRacines();
        } else {
            Element element = this.doc.cfg.getElementDef((Element)jaxeElement.noeud);
            if (element == null) {
                return;
            }
            config = this.doc.cfg.getDefConf(element);
            arrayList = config.listeSousbalises(element);
        }
        for (int i = 0; i < this.barreBalises.getMenuCount(); ++i) {
            JMenu jMenu = this.barreBalises.getMenu(i);
            this.majMenu(jMenu, config, arrayList);
        }
    }

    protected boolean majMenu(JMenu jMenu, Config config, ArrayList<String> arrayList) {
        boolean bl = false;
        for (int i = 0; i < jMenu.getItemCount(); ++i) {
            JMenuItem jMenuItem = jMenu.getItem(i);
            Action action = jMenuItem.getAction();
            if (action instanceof ActionInsertionBalise) {
                Element element = ((ActionInsertionBalise)action).getDefbalise();
                if (element == null) continue;
                Config config2 = this.doc.cfg.getDefConf(element);
                if (config2 == config) {
                    String string = config2.typeBalise(element);
                    String string2 = config2.nomBalise(element);
                    if (string.equals("style") && string2.equals("NORMAL")) continue;
                    boolean bl2 = false;
                    for (String string3 : arrayList) {
                        if (!string2.equals(string3)) continue;
                        bl2 = true;
                        bl = true;
                        break;
                    }
                    action.setEnabled(bl2);
                    continue;
                }
                action.setEnabled(true);
                continue;
            }
            if (!(jMenuItem instanceof JMenu)) continue;
            bl = this.majMenu((JMenu)jMenuItem, config, arrayList) || bl;
        }
        if (!jMenu.isTopLevelMenu()) {
            jMenu.setEnabled(bl);
        }
        return bl;
    }

    public void activerHTMLFrame() {
        if (this.htmlFrame == null) {
            this.htmlFrame = new HTMLFrame(this.doc);
        } else {
            this.htmlFrame.miseAJour();
        }
    }

    public void activerValidationFrame() {
        if (this.validationFrame == null) {
            this.validationFrame = new ValidationFrame(this.doc, this);
        } else {
            this.validationFrame.miseAJour();
        }
    }

    public void activerSourceFrame() {
        if (this.sourceFrame == null) {
            this.sourceFrame = new SourceFrame(this.doc, this);
        } else {
            this.sourceFrame.miseAJour();
        }
    }

    public void imprimer() {
        DocumentRenderer documentRenderer = new DocumentRenderer();
        documentRenderer.print(this.textPane);
    }

    protected class CaretListenerLabel
    extends JLabel
    implements CaretListener {
        public CaretListenerLabel(String string, JaxeDocument jaxeDocument) {
            super(string);
        }

        public void caretUpdate(CaretEvent caretEvent) {
            int n;
            int n2 = caretEvent.getDot();
            if (n2 == (n = caretEvent.getMark())) {
                this.setText(n2 + ": " + JaxeFrame.this.doc.getPathAsString(n2));
            }
            JaxeFrame.this.majMenus(n2);
        }
    }

    class ThreadOuverture
    extends Thread {
        ThreadOuverture() {
        }

        public void run() {
            JaxeFrame.this.ouvrirPlusTard();
        }
    }
}

