/*
 * Decompiled with CFR 0.152.
 */
package jaxe;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import jaxe.Config;
import jaxe.JaxeResourceBundle;
import org.apache.log4j.Logger;
import org.w3c.dom.Element;

public class DialogueAideElement
extends JDialog
implements ActionListener {
    private static final Logger LOG = Logger.getLogger(DialogueAideElement.class);
    private static final ResourceBundle rb = JaxeResourceBundle.getRB();
    private Element defElement;
    Config cfg;
    private JLabel labeldoc;
    JList listeParents;
    JList listeEnfants;
    private JLabel labelexpr;

    public DialogueAideElement(Element element, Config config, JFrame jFrame) {
        super(jFrame, rb.getString("aide.element") + " " + config.nomBalise(element), true);
        this.cfg = config;
        this.initialisation(jFrame);
        this.remplissage(element);
    }

    private void initialisation(JFrame jFrame) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        this.setContentPane(jPanel);
        JLabel jLabel = new JLabel(rb.getString("aide.description"));
        jLabel.setAlignmentX(0.0f);
        jPanel.add(jLabel);
        this.labeldoc = new JLabel("");
        JPanel jPanel2 = new JPanel();
        jPanel2.setAlignmentX(0.0f);
        jPanel2.add(this.labeldoc);
        jPanel.add(jPanel2);
        jPanel.add(Box.createRigidArea(new Dimension(1, 20)));
        JLabel jLabel2 = new JLabel(rb.getString("aide.parents"));
        jLabel2.setAlignmentX(0.0f);
        jPanel.add(jLabel2);
        this.listeParents = new JList();
        MouseAdapter mouseAdapter = new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                Element element;
                int n;
                if (mouseEvent.getClickCount() == 2 && (n = DialogueAideElement.this.listeParents.locationToIndex(mouseEvent.getPoint())) != -1 && (element = DialogueAideElement.this.cfg.getBaliseDef((String)DialogueAideElement.this.listeParents.getModel().getElementAt(n))) != null) {
                    DialogueAideElement.this.remplissage(element);
                }
            }
        };
        this.listeParents.addMouseListener(mouseAdapter);
        JScrollPane jScrollPane = new JScrollPane(this.listeParents);
        jScrollPane.setPreferredSize(new Dimension(250, 150));
        jScrollPane.setAlignmentX(0.0f);
        jPanel.add(jScrollPane);
        jPanel.add(Box.createRigidArea(new Dimension(1, 20)));
        JLabel jLabel3 = new JLabel(rb.getString("aide.enfants"));
        jLabel3.setAlignmentX(0.0f);
        jPanel.add(jLabel3);
        this.labelexpr = new JLabel("");
        this.labelexpr.setAlignmentX(0.0f);
        jPanel.add(this.labelexpr);
        this.listeEnfants = new JList();
        MouseAdapter mouseAdapter2 = new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                Element element;
                int n;
                if (mouseEvent.getClickCount() == 2 && (n = DialogueAideElement.this.listeEnfants.locationToIndex(mouseEvent.getPoint())) != -1 && (element = DialogueAideElement.this.cfg.getBaliseDef((String)DialogueAideElement.this.listeEnfants.getModel().getElementAt(n))) != null) {
                    DialogueAideElement.this.remplissage(element);
                }
            }
        };
        this.listeEnfants.addMouseListener(mouseAdapter2);
        JScrollPane jScrollPane2 = new JScrollPane(this.listeEnfants);
        jScrollPane2.setPreferredSize(new Dimension(250, 150));
        jScrollPane2.setAlignmentX(0.0f);
        jPanel.add(jScrollPane2);
        jPanel.add(Box.createRigidArea(new Dimension(1, 20)));
        JPanel jPanel3 = new JPanel(new FlowLayout());
        jPanel3.setAlignmentX(0.0f);
        JButton jButton = new JButton(rb.getString("aide.fermer"));
        jButton.setActionCommand("fermer");
        jButton.addActionListener(this);
        jPanel3.add(jButton);
        jPanel.add(jPanel3);
        this.getRootPane().setDefaultButton(jButton);
        if (jFrame != null) {
            Rectangle rectangle = jFrame.getBounds();
            this.setLocation(rectangle.x + rectangle.width / 4, rectangle.y + rectangle.height / 4);
        } else {
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            this.setLocation((dimension.width - this.getSize().width) / 3, (dimension.height - this.getSize().height) / 3);
        }
    }

    public void remplissage(Element element) {
        this.defElement = element;
        this.setTitle(rb.getString("aide.element") + " " + this.cfg.nomBalise(element));
        String string = this.cfg.documentation(element);
        this.labeldoc.setText(string);
        this.listeParents.clearSelection();
        ArrayList<String> arrayList = this.cfg.listeParents(element);
        this.listeParents.setListData(arrayList.toArray());
        this.labelexpr.setText(this.versHTML(this.cfg.expressionReguliere(element)));
        this.listeEnfants.clearSelection();
        ArrayList<String> arrayList2 = this.cfg.listeSousbalises(element);
        this.listeEnfants.setListData(arrayList2.toArray());
        this.pack();
    }

    protected String versHTML(String string) {
        if (string != null && (string = string.trim()).length() > 90) {
            int n = 0;
            for (int i = 0; i < string.length(); ++i) {
                if (i - n <= 80 || string.charAt(i) != '|' && string.charAt(i) != ',') continue;
                string = string.substring(0, i) + "<br>" + string.substring(i);
                n = i;
            }
            string = "<html><body>" + string + "</body></html>";
        }
        return string;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if ("fermer".equals(string)) {
            this.fermer();
        }
    }

    public void fermer() {
        this.setVisible(false);
        this.dispose();
    }
}

