/*
 * Decompiled with CFR 0.152.
 */
public class PNGParamOp
extends PNGParam {
    private final boolean debug_flag = false;
    private MNGLib mng;

    public boolean readIHDR(int n, byte[] byArray) {
        this.width = PNGFamily.byte2int(byArray, 0);
        this.height = PNGFamily.byte2int(byArray, 4);
        this.depth = byArray[8];
        this.color = byArray[9];
        this.compress = byArray[10];
        this.filter = byArray[11];
        this.interace = byArray[12];
        return true;
    }

    public boolean readPLTE(int n, byte[] byArray) {
        if (n == 0) {
            MNGParam mNGParam = null;
            if (this.mng != null) {
                mNGParam = this.mng.getInfo();
            }
            if (mNGParam != null && mNGParam.p_len > 0) {
                this.p_len = mNGParam.p_len;
                this.pallet = mNGParam.pallet;
                this.t_len = mNGParam.t_len;
                this.trans = mNGParam.trans;
                return true;
            }
            this.p_len = 0;
            this.pallet = null;
            return false;
        }
        if (n % 3 != 0) {
            return false;
        }
        this.p_len = n / 3;
        this.pallet = new byte[3][this.p_len];
        for (int i = 0; i < this.p_len; ++i) {
            this.pallet[0][i] = byArray[i * 3];
            this.pallet[1][i] = byArray[i * 3 + 1];
            this.pallet[2][i] = byArray[i * 3 + 2];
        }
        return true;
    }

    public boolean readtRNS(int n, byte[] byArray) {
        int n2;
        this.t_len = n;
        this.trans = new byte[this.p_len > n ? this.p_len : n];
        for (n2 = 0; n2 < n; ++n2) {
            this.trans[n2] = byArray[n2];
        }
        for (n2 = n; n2 < this.p_len; ++n2) {
            this.trans[n2] = -1;
        }
        return true;
    }

    public PNGParamOp() {
        this.mng = null;
    }

    public PNGParamOp(MNGLib mNGLib) {
        this.mng = mNGLib;
    }

    public PNGParam getParameter() {
        PNGParam pNGParam = new PNGParam();
        this.copyParameter(this, pNGParam);
        return pNGParam;
    }

    protected void copyParameter(PNGParam pNGParam, PNGParam pNGParam2) {
        this.copyIHDR(pNGParam, pNGParam2);
        this.copyPLTE(pNGParam, pNGParam2);
        this.copytRNS(pNGParam, pNGParam2);
    }

    protected void copyIHDR(PNGParam pNGParam, PNGParam pNGParam2) {
        pNGParam2.width = pNGParam.width;
        pNGParam2.height = pNGParam.height;
        pNGParam2.depth = pNGParam.depth;
        pNGParam2.color = pNGParam.color;
        pNGParam2.compress = pNGParam.compress;
        pNGParam2.filter = pNGParam.filter;
        pNGParam2.interace = pNGParam.interace;
    }

    protected void copyPLTE(PNGParam pNGParam, PNGParam pNGParam2) {
        pNGParam2.p_len = pNGParam.p_len;
        if (pNGParam.p_len > 0) {
            pNGParam2.pallet = new byte[3][pNGParam.p_len];
            for (int i = 0; i < 3; ++i) {
                System.arraycopy(pNGParam.pallet[i], 0, pNGParam2.pallet[i], 0, pNGParam.p_len);
            }
        }
    }

    protected void copytRNS(PNGParam pNGParam, PNGParam pNGParam2) {
        pNGParam2.t_len = pNGParam.t_len;
        if (pNGParam.t_len > 0) {
            pNGParam2.trans = new byte[pNGParam.trans.length];
            System.arraycopy(pNGParam.trans, 0, pNGParam2.trans, 0, pNGParam.trans.length);
        }
    }
}

