/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.io.File;
import java.io.IOException;
import java.net.URL;

public class MNGAnimation
extends Animation {
    private final boolean debug_flag = false;
    private final int debug_lv = 0;
    private MNGLib mng;
    private MNGParam param;
    private Image screen;
    private Graphics screenG;
    private MediaTracker mt;
    private Color bg;
    private long counter;
    private long delay;
    private boolean eoa;
    private boolean need_setup;

    public MNGAnimation(URL uRL) {
        this(uRL, false);
    }

    public MNGAnimation(URL uRL, boolean bl) {
        this.initialize();
        if (MNGLib.checkSignature(uRL)) {
            this.mng = new MNGLib(uRL);
            this.mng.setCaching(bl);
        } else {
            this.eoa = true;
            this.screen = MNGObject.getImage(uRL);
            if (this.screen != null) {
                this.mt = new MediaTracker(new Canvas());
                this.mt.addImage(this.screen, 0);
            }
        }
    }

    public MNGAnimation(File file) {
        this.initialize();
        if (MNGLib.checkSignature(file)) {
            this.mng = new MNGLib(file);
        } else {
            this.eoa = true;
            this.screen = MNGObject.getImage(file);
            if (this.screen != null) {
                this.mt = new MediaTracker(new Canvas());
                this.mt.addImage(this.screen, 0);
            }
        }
    }

    private void initialize() {
        this.mng = null;
        this.param = null;
        this.screen = null;
        this.screenG = null;
        this.mt = null;
        this.bg = Color.white;
        this.counter = 0L;
        this.delay = 0L;
        this.eoa = false;
        this.need_setup = true;
    }

    public void setDefaultBackground(Color color) {
        this.bg = color;
    }

    public void paintFrame(Graphics graphics) {
        if (this.screen == null || this.mt == null) {
            return;
        }
        try {
            this.mt.waitForID(0);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        graphics.drawImage(this.screen, 0, 0, null);
    }

    public void fetchNextFrame() {
        if (this.eoa) {
            return;
        }
        try {
            if (this.need_setup && !this.setup()) {
                this.eoa = true;
                return;
            }
            if (!this.drawNextFrame()) {
                this.eoa = true;
            }
        }
        catch (IOException iOException) {
            this.eoa = true;
        }
    }

    public long getInterFrameDelay() {
        return this.delay;
    }

    public boolean isEndOfAnimation() {
        return this.eoa;
    }

    private boolean drawNextFrame() throws IOException {
        while (!this.mng.isEOS()) {
            MNGObject mNGObject = this.mng.getMNGObject();
            this.param = this.mng.getInfo();
            if (this.param.tps != 0 && this.mng.wasFRAM() && (this.param.before_f_mode == 2 || this.param.before_f_mode == 4)) {
                this.delay = (long)(1.0 / (double)this.param.tps * 1000.0 * (double)this.param.f_delay);
                return true;
            }
            if (mNGObject == null) break;
            Image image = mNGObject.getImage();
            if (image == null) continue;
            if (this.param.f_mode == 3 || this.param.f_mode == 4 && this.mng.wasFRAM()) {
                this.screenG.fillRect(0, 0, this.param.width, this.param.height);
            }
            this.screenG.drawImage(image, this.param.x_location, this.param.y_location, null);
            if (this.param.tps == 0 || this.param.f_mode != 1 && this.param.f_mode != 3) continue;
            this.delay = (long)(1.0 / (double)this.param.tps * 1000.0 * (double)this.param.f_delay);
            return true;
        }
        return this.termination();
    }

    private boolean termination() throws IOException {
        this.mng.closeStream();
        this.need_setup = true;
        this.delay = 0L;
        if (this.param.tps == 0) {
            return false;
        }
        if (this.param.action == 3 && (this.counter < (long)this.param.limit || this.param.limit == 0)) {
            if (this.param.delay - this.param.f_delay > 0) {
                this.delay = (long)(1.0 / (double)this.param.tps * 1000.0 * (double)(this.param.delay - this.param.f_delay));
            }
            this.counter += this.param.limit == 0 ? 0L : 1L;
            return true;
        }
        if (this.param.action == 2 || this.param.after == 2) {
            this.fetchNextFrame();
            this.mng.closeStream();
        }
        if (this.param.action == 1 || this.param.after == 1) {
            this.screenG.fillRect(0, 0, this.param.width, this.param.height);
        }
        return false;
    }

    private boolean setup() throws IOException {
        this.mng.openStream();
        if (!this.mng.existsStream()) {
            return false;
        }
        if (!this.mng.readInfo()) {
            this.mng.closeStream();
            return false;
        }
        this.param = this.mng.getInfo();
        this.screen = this.createImage(this.param.width, this.param.height);
        this.screenG = this.screen.getGraphics();
        this.mt = new MediaTracker(new Canvas());
        this.mt.addImage(this.screen, 0);
        if (this.param.back != null) {
            int n = this.param.back[0] >> 8 & 0xFF;
            int n2 = this.param.back[1] >> 8 & 0xFF;
            int n3 = this.param.back[2] >> 8 & 0xFF;
            this.bg = new Color(n, n2, n3);
        }
        this.screenG.setColor(this.bg);
        this.screenG.fillRect(0, 0, this.param.width, this.param.height);
        this.need_setup = false;
        return true;
    }

    private Image createImage(int n, int n2) {
        Frame frame = new Frame();
        frame.pack();
        Image image = frame.createImage(n, n2);
        frame.dispose();
        frame = null;
        return image;
    }
}

