/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;

public class ImageCanvas
extends Canvas
implements Runnable {
    private final boolean debug_flag = false;
    private final int debug_lv = 0;
    private static final String DEFAULT_INITIAL_MESSAGE = "Chargement animation...";
    private Image offImg = null;
    private Graphics offG = null;
    private Thread th = null;
    private Image img = null;
    private Animation anim = null;
    private String msg = null;

    public void validate() {
        super.validate();
        Dimension dimension = this.size();
        if (dimension.width > 0 && dimension.height > 0) {
            this.offImg = this.createImage(dimension.width, dimension.height);
            this.offG = this.offImg.getGraphics();
        }
    }

    public void invalidate() {
        super.invalidate();
        if (this.offG != null) {
            this.offG.dispose();
        }
        if (this.offImg != null) {
            this.offImg.flush();
        }
        this.offG = null;
        this.offImg = null;
    }

    public void paint(Graphics graphics) {
        if (this.offImg == null) {
            this.validate();
        }
        super.paint(this.offG);
        if (this.img != null) {
            this.offG.drawImage(this.img, 0, 0, this);
        }
        if (this.msg != null) {
            this.paintMessage(this.offG);
        }
        if (this.anim != null) {
            this.anim.paintFrame(this.offG);
        }
        graphics.drawImage(this.offImg, 0, 0, null);
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void showImage(Image image) {
        this.anim = null;
        this.msg = null;
        this.img = image;
        this.repaint();
    }

    public void playAnimation(Animation animation) {
        this.img = null;
        this.msg = DEFAULT_INITIAL_MESSAGE;
        this.repaint();
        this.anim = animation;
        this.th = new Thread(this);
        this.th.start();
    }

    public synchronized void stopAnimation() {
        this.th = null;
    }

    public void run() {
        Thread thread = Thread.currentThread();
        while (thread == this.th) {
            this.anim.fetchNextFrame();
            if (this.msg != null) {
                this.clearCanvas(this.getGraphics());
                this.msg = null;
            }
            this.repaint();
            try {
                Thread.sleep(this.anim.getInterFrameDelay());
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!this.anim.isEndOfAnimation()) continue;
        }
        if (this.th == null) {
            this.anim = null;
        }
    }

    private void paintMessage(Graphics graphics) {
        int n = 10;
        int n2 = 20;
        this.clearCanvas(graphics);
        Color color = graphics.getColor();
        Color color2 = this.getBackground();
        Color color3 = new Color(~color2.getRGB() & 0xFFFFFF);
        graphics.setColor(color3);
        if (this.msg != null) {
            graphics.drawString(this.msg, n, n2);
        }
        graphics.setColor(color);
    }

    private void clearCanvas(Graphics graphics) {
        if (graphics == null) {
            return;
        }
        Color color = graphics.getColor();
        Color color2 = this.getBackground();
        graphics.setColor(color2);
        graphics.fillRect(0, 0, this.size().width, this.size().height);
        graphics.setColor(color);
    }

    public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        return super.imageUpdate(image, n, n2, n3, n4, n5);
    }
}

