<?xml version="1.0" encoding='ISO-8859-1' ?>

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="html" indent="yes" doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN" encoding="ISO-8859-1"/>

<!-- feuille de style  utiliser sur toutlecours.xml -->
<!-- sortie: fichier HTML avec la liste des liens non rsolus -->

<xsl:template match="IUFMDOC|UELDOC|DEADOC|MAITRISE|COURS">
    <html>
    <head>
        <title>Liste des liens non rsolus</title>
    </head>
    <body>
        <div align="center"><h1>Liste des liens non rsolus</h1></div>
        <ul>
	        <xsl:apply-templates select=".//LIEN|.//SUITE"/>
        </ul>
        <p></p>
        <div align="center"><h1>Mots du glossaire non dfinis</h1></div>
        <ul>
	        <xsl:apply-templates select=".//GLOSSAIRE">
                <xsl:sort select="@ref|@mot"/>
            </xsl:apply-templates>
        </ul>
        <p></p>
        <div align="center"><h1>Mots du glossaire dfinis plus d'une fois</h1></div>
        <ul>
	        <xsl:apply-templates select=".//GLOSSAIRE" mode="doublons">
                <xsl:sort select="@ref|@mot"/>
            </xsl:apply-templates>
        </ul>
    </body>
    </html>
</xsl:template>

<xsl:template match="LIEN|SUITE">
	<xsl:variable name="nlabel1"><xsl:value-of select="normalize-space(@label)"/></xsl:variable> 
	<xsl:variable name="partieuel"><xsl:value-of select="translate(substring-after($nlabel1,'.'),'abcdefghijklmnopqrstuvwxyz','ABCDEFGHIJKLMNOPQRSTUVWXYZ')"/></xsl:variable> 
	<xsl:variable name="nlabel"><xsl:choose>
        <xsl:when test="$partieuel!=''"><xsl:value-of select="substring-before($nlabel1,'.')"/></xsl:when>
        <xsl:otherwise><xsl:value-of select="$nlabel1"/></xsl:otherwise>
    </xsl:choose></xsl:variable> 
	<xsl:variable name="ntype"><xsl:value-of select="normalize-space(@type)"/></xsl:variable>
    <!--
    <xsl:variable name="ntypemaj" select="translate($ntype,'abcdefghijklmnopqrstuvwxyz','ABCDEFGHIJKLMNOPQRSTUVWXYZ')"/>
    <xsl:if test="$ntype!='http' and count(//*[name()=$ntypemaj and @label=$nlabel]) != 1">
        <xsl:call-template name="afficher_lien"/>
    </xsl:if>
    optimis:
    -->
    <xsl:choose>
        <xsl:when test="$ntype='chapitre'">
            <xsl:if test="count(/*/CHAPITRE[@label=$nlabel]) != 1">
                <xsl:call-template name="afficher_lien"/>
            </xsl:if>
        </xsl:when>
        <xsl:when test="$ntype='souschapitre' or $ntype='tp'">
            <xsl:if test="count(/*/CHAPITRE/SOUSCHAPITRE[@label=$nlabel]) != 1">
                <xsl:call-template name="afficher_lien"/>
            </xsl:if>
        </xsl:when>
        <xsl:when test="$ntype='section'">
            <xsl:if test="count(/*/CHAPITRE/SOUSCHAPITRE/SECTION[@label=$nlabel]) != 1">
                <xsl:call-template name="afficher_lien"/>
            </xsl:if>
        </xsl:when>
        <xsl:when test="$ntype='page'">
            <xsl:if test="count(/*/CHAPITRE/SOUSCHAPITRE/SECTION/PAGE[@label=$nlabel]) != 1">
                <xsl:call-template name="afficher_lien"/>
            </xsl:if>
        </xsl:when>
        <xsl:when test="$ntype='paragraphe'">
            <xsl:if test="count(/*/CHAPITRE//PARAGRAPHE[@label=$nlabel]) != 1">
                <xsl:call-template name="afficher_lien"/>
            </xsl:if>
        </xsl:when>
        <xsl:when test="$ntype='figure'">
            <xsl:if test="count(/*/CHAPITRE//FIGURE[@label=$nlabel]) != 1">
                <xsl:call-template name="afficher_lien"/>
            </xsl:if>
        </xsl:when>
        <xsl:when test="$ntype='tableau'">
            <xsl:if test="count(/*/CHAPITRE//TABLEAU[@label=$nlabel]) != 1">
                <xsl:call-template name="afficher_lien"/>
            </xsl:if>
        </xsl:when>
        <xsl:when test="$ntype='exercice'">
            <xsl:if test="count(/*/CHAPITRE/SOUSCHAPITRE/SECTION/PAGE//EXERCICE[@label=$nlabel]) != 1">
                <xsl:call-template name="afficher_lien"/>
            </xsl:if>
        </xsl:when>
        <xsl:when test="$ntype='equation'">
            <xsl:if test="count(/*/CHAPITRE//EQUATION[@label=$nlabel]) != 1">
                <xsl:call-template name="afficher_lien"/>
            </xsl:if>
        </xsl:when>
        <xsl:when test="$ntype='definition'">
            <xsl:if test="count(/*/CHAPITRE/SOUSCHAPITRE/SECTION/PAGE//DEFINITION[@label=$nlabel]) != 1">
                <xsl:call-template name="afficher_lien"/>
            </xsl:if>
        </xsl:when>
        <xsl:when test="$ntype='demonstration'">
            <xsl:if test="count(/*/CHAPITRE/SOUSCHAPITRE/SECTION/PAGE//DEMONSTRATION[@label=$nlabel]) != 1">
                <xsl:call-template name="afficher_lien"/>
            </xsl:if>
        </xsl:when>
        <xsl:when test="$ntype='applet'">
            <xsl:if test="count(/*/CHAPITRE/SOUSCHAPITRE/SECTION/PAGE//APPLET[@label=$nlabel]) != 1">
                <xsl:call-template name="afficher_lien"/>
            </xsl:if>
        </xsl:when>
        <xsl:when test="$ntype='http'">
        </xsl:when>
        <xsl:otherwise>
            <xsl:call-template name="afficher_lien"/>
        </xsl:otherwise>
    </xsl:choose>
</xsl:template>

<xsl:template name="afficher_lien">
    <li>
        Page: <xsl:call-template name="numeropage"/><br/>
        Type:<xsl:value-of select="@type"/><br/>
        Label: <xsl:value-of select="@label"/><br/>
        <br/>
    </li>
</xsl:template>

<xsl:template name="numerotation">
	<xsl:choose>
		<xsl:when test="ancestor-or-self::CHAPITRE and not(ancestor-or-self::SOUSCHAPITRE)"><xsl:value-of select="ancestor-or-self::CHAPITRE/@label"/>/index.html</xsl:when>
        
		<xsl:when test="ancestor-or-self::SOUSCHAPITRE and not(ancestor-or-self::SECTION)"><xsl:value-of select="ancestor-or-self::CHAPITRE/@label"/>/<xsl:value-of select="ancestor-or-self::SOUSCHAPITRE/@label"/>/index.html</xsl:when>
        
		<xsl:when test="ancestor-or-self::SECTION and not(ancestor-or-self::PAGE)"><xsl:choose>
            <xsl:when test="ancestor-or-self::INTRODUCTION"><xsl:value-of select="ancestor::CHAPITRE/@label"/>/<xsl:value-of select="ancestor::SOUSCHAPITRE/@label"/>/<xsl:value-of select="ancestor-or-self::SECTION/@label"/>/INTRODUCTION/index.html</xsl:when>
            <xsl:otherwise><xsl:choose>
				<xsl:when test="/UELDOC">
					<xsl:for-each select="PAGE[1]/*[self::OBSERVER or self::APPRENDRE or self::SIMULER or self::SEXERCER or self::SEVALUER]">
					   <xsl:if test="position()=1"><xsl:value-of select="ancestor::CHAPITRE/@label"/>/<xsl:value-of select="ancestor::SOUSCHAPITRE/@label"/>/<xsl:value-of select="ancestor::SECTION/@label"/>/<xsl:value-of select="ancestor::PAGE/@label"/>/<xsl:value-of select="name()"/>.html</xsl:if>
					</xsl:for-each>
				</xsl:when>
				<xsl:otherwise><xsl:value-of select="ancestor::CHAPITRE/@label"/>/<xsl:value-of select="ancestor::SOUSCHAPITRE/@label"/>/<xsl:value-of select="ancestor-or-self::SECTION/@label"/>/<xsl:value-of select="PAGE[1]/@label"/>/index.html</xsl:otherwise>
			</xsl:choose></xsl:otherwise>
        </xsl:choose></xsl:when>
		<xsl:otherwise><xsl:value-of select="ancestor::CHAPITRE/@label"/>/<xsl:value-of select="ancestor::SOUSCHAPITRE/@label"/>/<xsl:value-of select="ancestor::SECTION/@label"/>/<xsl:value-of select="ancestor-or-self::PAGE/@label"/>/<xsl:if test="not((self::FIGURE or self::TABLEAU) and (@localisation='icne')) and not(/UELDOC)">index</xsl:if><xsl:choose>
			<xsl:when test="(self::FIGURE or self::TABLEAU) and (@localisation='page')">
				<xsl:variable name="ntype" select="name()"/>
				
				<xsl:variable name="numfig"><xsl:choose><xsl:when test="/UELDOC"><xsl:number level="any" from="OBSERVER|APPRENDRE|SIMULER|SEXERCER|SEVALUER" count="FIGURE[@localisation='page'] | TABLEAU[@localisation='page']"/></xsl:when><xsl:otherwise><xsl:number level="any" from="PAGE" count="FIGURE[@localisation='page'] | TABLEAU[@localisation='page']"/></xsl:otherwise></xsl:choose></xsl:variable>
				
				<xsl:variable name="countfig"><xsl:choose>
				<xsl:when test="/UELDOC"><xsl:value-of select="count(ancestor::*[contains('|OBSERVER|APPRENDRE|SIMULER|SEXERCER|SEVALUER|',concat('|',name(),'|'))]//*[(self::FIGURE or self::TABLEAU) and @localisation='page'])"/></xsl:when>
				<xsl:otherwise><xsl:value-of select="count(ancestor::PAGE//*[(self::FIGURE or self::TABLEAU) and @localisation='page'])"/></xsl:otherwise>
				</xsl:choose></xsl:variable>
				
				<xsl:if test="/UELDOC"><xsl:value-of select="name(ancestor::OBSERVER | ancestor::APPRENDRE | ancestor::SIMULER | ancestor::SEXERCER | ancestor::SEVALUER)"/></xsl:if>
				<xsl:if test="$countfig>1 and $numfig>1">_<xsl:value-of select="$numfig"/></xsl:if>
			</xsl:when>
            <xsl:when test="self::FIGURE and @localisation='icne'">figure_<xsl:choose>
                    <xsl:when test="@label!=''"><xsl:value-of select="@label"/></xsl:when>
                    <xsl:otherwise><xsl:value-of select="translate(substring-before(FICHIER[1]/@nom,'.'),'/','_')"/></xsl:otherwise>
            </xsl:choose><xsl:if test="/UELDOC">_<xsl:value-of select="name(ancestor::OBSERVER | ancestor::APPRENDRE | ancestor::SIMULER | ancestor::SEXERCER | ancestor::SEVALUER)"/></xsl:if></xsl:when>
            <xsl:when test="self::TABLEAU and @localisation='icne'">tableau_<xsl:choose>
                    <xsl:when test="@label!=''"><xsl:value-of select="@label"/></xsl:when>
                    <xsl:otherwise>sanslabel</xsl:otherwise>
            </xsl:choose><xsl:if test="/UELDOC">_<xsl:value-of select="name(ancestor::OBSERVER | ancestor::APPRENDRE | ancestor::SIMULER | ancestor::SEXERCER | ancestor::SEVALUER)"/></xsl:if></xsl:when>
			<xsl:when test="not(self::FIGURE or self::TABLEAU) and parent::PAGE"><xsl:value-of select="name()"/></xsl:when>
			<xsl:otherwise>
				<xsl:if test="/UELDOC"><xsl:value-of select="name(ancestor::OBSERVER | ancestor::APPRENDRE | ancestor::SIMULER | ancestor::SEXERCER | ancestor::SEVALUER)"/></xsl:if>
			</xsl:otherwise>
		</xsl:choose>.html</xsl:otherwise>
	</xsl:choose>
</xsl:template>

<xsl:template name="numeropage">
    <xsl:variable name="url"><xsl:call-template name="numerotation"/></xsl:variable>
    <a href="{$url}"><xsl:value-of select="ancestor-or-self::CHAPITRE/@label"/>_<xsl:value-of select="ancestor-or-self::SOUSCHAPITRE/@label"/>_<xsl:value-of select="ancestor-or-self::SECTION/@label"/>_<xsl:value-of select="ancestor-or-self::PAGE/@label"/></a>
</xsl:template>

<xsl:template match="GLOSSAIRE">
    <xsl:variable name="motref"><xsl:choose>
        <xsl:when test="@ref!=''"><xsl:value-of select="@ref"/></xsl:when>
        <xsl:otherwise><xsl:value-of select="@mot"/></xsl:otherwise>
    </xsl:choose></xsl:variable>
    <xsl:if test="$motref != ''">
        <xsl:if test="normalize-space(.)=''">
            <xsl:if test="count(//GLOSSAIRE[(@ref=$motref or @mot=$motref) and normalize-space(.)!=''])=0">
                <li><xsl:value-of select="$motref"/> (utilis page <xsl:call-template name="numeropage"/>)</li>
            </xsl:if>
        </xsl:if>
    </xsl:if>
</xsl:template>

<xsl:template match="GLOSSAIRE" mode="doublons">
    <xsl:variable name="motref"><xsl:choose>
        <xsl:when test="@ref!=''"><xsl:value-of select="@ref"/></xsl:when>
        <xsl:otherwise><xsl:value-of select="@mot"/></xsl:otherwise>
    </xsl:choose></xsl:variable>
    <xsl:if test="$motref != ''">
        <xsl:if test="normalize-space(.)!=''">
            <xsl:if test="count(//GLOSSAIRE[(@ref=$motref or (not(@ref) and @mot=$motref)) and normalize-space(.)!=''])&gt;1">
                <li><xsl:value-of select="$motref"/> (utilis page <xsl:call-template name="numeropage"/>, contribution <xsl:value-of select="ancestor::*[@contrib][1]/@contrib"/>)</li>
            </xsl:if>
        </xsl:if>
    </xsl:if>
</xsl:template>

</xsl:stylesheet>

