<?xml version="1.0" encoding='ISO-8859-1' ?>

<!-- feuille de style pour afficher les labels utiliss -->

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xalanredirect="org.apache.xalan.xslt.extensions.Redirect" version="1.0" extension-element-prefixes="xalanredirect">
<xsl:output method="html" indent="yes" doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN" encoding="ISO-8859-1"/>

<xsl:template match = "IUFMDOC|UELDOC|DEADOC|COURS">
	<html>
		<head>
			<title>Labels utiliss</title>
		</head>
		<body>
		    <p>
		    <a href="#doublons">Doublons</a> - 
			<a href="#chapitres">Chapitres</a> - <a href="#souschapitres">Sous-Chapitres</a> -
			<a href="#sections">Sections</a> - <a href="#pages">Pages</a> - <a href="#index">Index</a>
			</p>
			
			<hr/>
			
			<a name="doublons"/>
			<h1>Doublons</h1>
			<p>Un lien utilisant un label avec un doublon ne fonctionnera pas, et apparatra sur la page des mauvais liens.</p>
			<h2>Doublons de chapitres</h2>
			<ul>
				<xsl:for-each select="CHAPITRE">
				    <xsl:if test="count(/*/CHAPITRE[@label=current()/@label])&gt;1">
					   <li>chapitre "<xsl:value-of select="@titre"/>": <tt><xsl:value-of select="@label"/></tt> - <a href="#chapitre{@label}">lien vers le premier avec ce label</a></li>
					</xsl:if>
				</xsl:for-each>
			</ul>
			<h2>Doublons de sous-chapitres</h2>
			<ul>
				<xsl:for-each select="*/SOUSCHAPITRE">
				    <xsl:if test="count(/*/CHAPITRE/SOUSCHAPITRE[@label=current()/@label])&gt;1">
					   <li>sous-chapitre "<xsl:value-of select="@titre"/>": <tt><xsl:value-of select="@label"/></tt> - <a href="#souschapitre{@label}">lien vers le premier avec ce label</a></li>
					</xsl:if>
				</xsl:for-each>
			</ul>
			<h2>Doublons de sections</h2>
			<ul>
				<xsl:for-each select="*/*/SECTION">
				    <xsl:if test="count(/*/CHAPITRE/SOUSCHAPITRE/SECTION[@label=current()/@label])&gt;1">
					   <li>section "<xsl:value-of select="@titre"/>": <tt><xsl:value-of select="@label"/></tt> - <a href="#section{@label}">lien vers la premire avec ce label</a></li>
					</xsl:if>
				</xsl:for-each>
			</ul>
			<h2>Doublons de pages</h2>
			<ul>
				<xsl:for-each select="*/*/*/PAGE">
				    <xsl:if test="count(/*/CHAPITRE/SOUSCHAPITRE/SECTION/PAGE[@label=current()/@label])&gt;1">
					   <li>page "<xsl:value-of select="@titre"/>": <tt><xsl:value-of select="@label"/></tt> - <a href="#page{@label}">lien vers la premire avec ce label</a></li>
					</xsl:if>
				</xsl:for-each>
			</ul>
			
			<hr/>
			
			<a name="chapitres"/>
			<h1>Chapitres</h1>
			<ul>
				<xsl:for-each select="CHAPITRE">
					<li><a name="chapitre{@label}"/>chapitre "<xsl:value-of select="@titre"/>": <tt><xsl:value-of select="@label"/></tt></li>
				</xsl:for-each>
			</ul>
			
			<hr/>
			
			<a name="souschapitres"/>
			<h1>Sous-Chapitres</h1>
			<ul>
				<xsl:for-each select="CHAPITRE">
					<li><h2>Chapitre <xsl:value-of select="@titre"/>:</h2>
						<ul>
							<xsl:for-each select="SOUSCHAPITRE">
								<li><a name="souschapitre{@label}"/>souschapitre "<xsl:value-of select="@titre"/>": <tt><xsl:value-of select="@label"/></tt></li>
							</xsl:for-each>
						</ul>
					</li>
				</xsl:for-each>
			</ul>
			
			<hr/>
			
			<a name="sections"/>
			<h1>Sections</h1>
			<ul>
				<xsl:for-each select="CHAPITRE">
					<li><h2>Chapitre <xsl:value-of select="@titre"/>:</h2>
						<ul>
							<xsl:for-each select="SOUSCHAPITRE">
								<li><h3>Sous-Chapitre <xsl:value-of select="@titre"/>:</h3>
									<ul>
										<xsl:for-each select="SECTION">
											<li><a name="section{@label}"/>section "<xsl:value-of select="@titre"/>": <tt><xsl:value-of select="@label"/></tt></li>
										</xsl:for-each>
									</ul>
								</li>
							</xsl:for-each>
						</ul>
					</li>
				</xsl:for-each>
			</ul>
			
			<hr/>
			
			<a name="pages"/>
			<h1>Pages</h1>
			<ul>
				<xsl:for-each select="CHAPITRE">
					<li><h2>Chapitre <xsl:value-of select="@titre"/>:</h2>
						<ul>
							<xsl:for-each select="SOUSCHAPITRE">
								<li><h3>Sous-Chapitre <xsl:value-of select="@titre"/>:</h3>
									<ul>
										<xsl:for-each select="SECTION">
											<li><h4>Section <xsl:value-of select="@titre"/>:</h4>
												<ul>
													<xsl:for-each select="PAGE">
														<li><a name="page{@label}"/>page "<xsl:value-of select="@titre"/>": <tt><xsl:value-of select="@label"/></tt></li>
													</xsl:for-each>
												</ul>
											</li>
										</xsl:for-each>
									</ul>
								</li>
							</xsl:for-each>
						</ul>
					</li>
				</xsl:for-each>
			</ul>
			
			<hr/>
			
			<a name="index"/>
			<h1>Index</h1>
			<xsl:for-each select="CHAPITRE | CHAPITRE/SOUSCHAPITRE | CHAPITRE/SOUSCHAPITRE/SECTION | CHAPITRE/SOUSCHAPITRE/SECTION/PAGE | CHAPITRE/SOUSCHAPITRE/SECTION/*/PAGE">
				<xsl:sort select="@label"/>
				<xsl:variable name="type" select="translate(name(),'ABCDEFGHIJKLMNOPQRSTUVWXYZ','abcdefghijklmnopqrstuvwxyz')"/>
				&#xA0;&#xA0;&#xA0;&#xA0;
				<xsl:choose>
					<xsl:when test="@label!=''"><a href="#{$type}{@label}"><tt><xsl:value-of select="@label"/></tt></a></xsl:when>
					<xsl:otherwise><i>sans label</i></xsl:otherwise>
				</xsl:choose>
				&#xA0;&#xA0;&#xA0;&#xA0;
				<xsl:value-of select="$type"/> "<xsl:value-of select="@titre"/>"<br/>
			</xsl:for-each>
		</body>
	</html>
</xsl:template>


</xsl:stylesheet>

