<?xml version="1.0" encoding='ISO-8859-1' ?>

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xalanredirect="org.apache.xalan.xslt.extensions.Redirect" version="1.0" extension-element-prefixes="xalanredirect">
<xsl:output method="xml" indent="yes" encoding="ISO-8859-1"/>
<!--Zroime feuille de style XSLT pour les sites ASM Observatoire de Meudon-Paris-->
<!-- cration d'un fichier XML contenant tout le cours,  partir du cours virtuel -->

<xsl:template match = "@*|node()">
	<xsl:choose>
	<xsl:when test="@contrib and @liencontenu">
		<xsl:variable name="contrib" select="@contrib"/>
		<xsl:variable name="liencontenu" select="@liencontenu"/>
		<xsl:if test="not(@activer='faux')">
			<xsl:message><xsl:value-of select="$contrib"/></xsl:message>
		</xsl:if>	
		<xsl:choose>
		<xsl:when test="self::TP and not(@activer='faux')">
			<xsl:for-each select="document(@liencontenu)/*/TP[@label=current()/@label]">
				<xsl:copy>
					<xsl:attribute name="contrib"><xsl:value-of select="$contrib"/></xsl:attribute>
					<xsl:copy-of select="@*|node()"/>
				</xsl:copy>
			</xsl:for-each>
		</xsl:when>
		<xsl:when test="self::CHAPITRE and not(@activer='faux')">
			<xsl:copy>
				<xsl:attribute name="contrib"><xsl:value-of select="$contrib"/></xsl:attribute>
				<xsl:for-each select="document(@liencontenu)/*/CHAPITRE[@label=current()/@label]">
					<xsl:copy-of select="@*|node()"/>
				</xsl:for-each>
				<xsl:apply-templates/>
			</xsl:copy>
		</xsl:when>
		<xsl:when test="self::SOUSCHAPITRE and not(@activer='faux')">
			<xsl:copy>
                <xsl:attribute name="contrib"><xsl:value-of select="$contrib"/></xsl:attribute>
                <xsl:for-each select="document(@liencontenu)/*/CHAPITRE[@label=current()/../@label]/SOUSCHAPITRE[@label=current()/@label]">
                    <xsl:copy-of select="@*|node()"/>
                </xsl:for-each>
                <xsl:apply-templates/>
			</xsl:copy>
		</xsl:when>
		<xsl:when test="self::SECTION and not(@activer='faux')">
			<xsl:copy>
                <xsl:attribute name="contrib"><xsl:value-of select="$contrib"/></xsl:attribute>
                <xsl:for-each select="document(@liencontenu)/*/CHAPITRE[@label=current()/../../@label]/SOUSCHAPITRE[@label=current()/../@label]/SECTION[@label=current()/@label]">
                    <xsl:copy-of select="@*|node()"/>
                </xsl:for-each>
                <xsl:apply-templates/>
			</xsl:copy>
		</xsl:when>
		</xsl:choose>
	</xsl:when>
	<xsl:otherwise>
		<xsl:if test="not(@activer='faux')">
			<xsl:copy>
				<xsl:apply-templates select="@*|node()"/>
			</xsl:copy>
		</xsl:if>
	</xsl:otherwise>
	</xsl:choose>
</xsl:template>
</xsl:stylesheet>
