/*
 * Decompiled with CFR 0.152.
 */
package jaxe.equations;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.color.ColorSpace;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.IOException;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import jaxe.JaxeDocument;
import jaxe.JaxeResourceBundle;
import jaxe.equations.MathBase;
import jaxe.equations.MathComponent;
import jaxe.equations.StringMathBuilder;
import org.apache.log4j.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DialogueEquation
extends JDialog
implements ActionListener,
DocumentListener {
    private static final Logger LOG = Logger.getLogger(DialogueEquation.class);
    JFrame jframe;
    boolean valide = false;
    MathComponent mathcomp;
    JTextArea zoneTexte;
    String texteEquation;
    JPanel epane;
    JaxeDocument doc;
    String nomImage;
    JTextField labelfield = null;
    String valeurLabel;

    public DialogueEquation(JaxeDocument jaxeDocument, String string, String string2) {
        this(jaxeDocument, string, string2, null, null);
    }

    public DialogueEquation(JaxeDocument jaxeDocument, String string, String string2, String string3, String string4) {
        super(jaxeDocument.jframe, JaxeResourceBundle.getRB().getString("equation.Equation"), true);
        JPanel jPanel;
        this.doc = jaxeDocument;
        this.jframe = jaxeDocument.jframe;
        this.texteEquation = string;
        this.nomImage = string2;
        this.valeurLabel = string4;
        JPanel jPanel2 = new JPanel(new BorderLayout());
        this.setContentPane(jPanel2);
        this.epane = new JPanel(new BorderLayout());
        this.mathcomp = new MathComponent(string);
        this.epane.add((Component)this.mathcomp, "Center");
        this.zoneTexte = new JTextArea(string, 2, 80);
        this.zoneTexte.setLineWrap(true);
        this.zoneTexte.setWrapStyleWord(true);
        this.zoneTexte.setBorder(BorderFactory.createBevelBorder(1));
        this.zoneTexte.getDocument().addDocumentListener(this);
        this.epane.add((Component)this.zoneTexte, "South");
        jPanel2.add((Component)this.epane, "Center");
        JPanel jPanel3 = new JPanel(new GridLayout(string3 == null ? 1 : 2, 1));
        if (string3 != null) {
            jPanel = new JPanel(new FlowLayout(0));
            jPanel.add(new JLabel(string3));
            this.labelfield = new JTextField(string4, 30);
            jPanel.add(this.labelfield);
            jPanel3.add(jPanel);
        }
        jPanel = new JPanel(new FlowLayout(2));
        JButton jButton = new JButton(JaxeResourceBundle.getRB().getString("bouton.Annuler"));
        jButton.addActionListener(this);
        jButton.setActionCommand("Annuler");
        jPanel.add(jButton);
        JButton jButton2 = new JButton(JaxeResourceBundle.getRB().getString("bouton.OK"));
        jButton2.addActionListener(this);
        jButton2.setActionCommand("OK");
        jPanel.add(jButton2);
        jPanel3.add(jPanel);
        jPanel2.add((Component)jPanel3, "South");
        this.getRootPane().setDefaultButton(jButton2);
        this.setSize(new Dimension(500, 300));
        this.zoneTexte.requestFocus();
        this.addWindowListener(new WindowAdapter(){

            public void windowActivated(WindowEvent windowEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        DialogueEquation.this.zoneTexte.requestFocus();
                    }
                });
            }
        });
        Rectangle rectangle = this.jframe.getBounds();
        this.setLocation(rectangle.x + rectangle.width / 4, rectangle.y + rectangle.height / 4);
    }

    public boolean afficher() {
        this.setVisible(true);
        return this.valide;
    }

    public String getTexte() {
        return this.texteEquation;
    }

    public String getImage() {
        return this.nomImage;
    }

    public String getLabel() {
        return this.valeurLabel;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if ("OK".equals(string)) {
            this.actionOK();
        } else if ("Annuler".equals(string)) {
            this.valide = false;
            this.setVisible(false);
        }
    }

    protected void actionOK() {
        this.valide = true;
        this.nomImage = DialogueEquation.creerImage(this.texteEquation, this.nomImage, this.doc);
        if (this.labelfield != null) {
            this.valeurLabel = this.labelfield.getText();
        }
        this.setVisible(false);
    }

    protected void changementTexte() {
        if (this.zoneTexte.getText().indexOf(10) != -1) {
            this.actionOK();
        } else {
            this.texteEquation = this.zoneTexte.getText();
            this.majAffichage();
        }
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.changementTexte();
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.changementTexte();
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.changementTexte();
    }

    protected void majAffichage() {
        this.mathcomp.setEquationString(this.texteEquation);
        this.mathcomp.repaint();
    }

    public static String creerImage(String string, String string2, JaxeDocument jaxeDocument) {
        Object object;
        if (string2 != null && !"".equals(string2) && ((File)(object = jaxeDocument.fsave == null ? new File(string2) : new File(jaxeDocument.fsave.getParent() + File.separatorChar + string2))).exists() && ((File)object).isFile()) {
            ((File)object).delete();
        }
        object = new BufferedImage(10, 10, 2);
        Graphics2D graphics2D = ((BufferedImage)object).createGraphics();
        MathBase mathBase = new MathBase(new StringMathBuilder(string).getMathRootElement(), graphics2D);
        Dimension dimension = new Dimension(mathBase.getWidth(), mathBase.getHeight());
        ColorSpace colorSpace = ColorSpace.getInstance(1003);
        ComponentColorModel componentColorModel = new ComponentColorModel(colorSpace, true, true, 3, 0);
        WritableRaster writableRaster = ((ColorModel)componentColorModel).createCompatibleWritableRaster(dimension.width, dimension.height);
        BufferedImage bufferedImage = new BufferedImage(componentColorModel, writableRaster, false, null);
        Graphics2D graphics2D2 = bufferedImage.createGraphics();
        graphics2D2.setColor(Color.black);
        mathBase.paint(graphics2D2);
        if (jaxeDocument.fsave == null) {
            return null;
        }
        File file = null;
        String string3 = null;
        String string4 = jaxeDocument.fsave.getName();
        if (string4.indexOf(46) != -1) {
            string4 = string4.substring(0, string4.lastIndexOf(46));
        }
        String string5 = "equations_" + string4;
        File file2 = new File(jaxeDocument.fsave.getParent() + File.separator + string5);
        if (!file2.exists() && !file2.mkdir()) {
            LOG.error("creerImage(String, String, JaxeDocument) - Erreur \u00e0 la cr\u00e9ation du dossier des \u00e9quations");
            return null;
        }
        int n = 1;
        while (file == null || file.exists()) {
            string3 = "equation" + n + ".png";
            file = new File(file2.getPath() + File.separator + string3);
            ++n;
        }
        ImageWriter imageWriter = ImageIO.getImageWritersByFormatName("PNG").next();
        IIOMetadata iIOMetadata = imageWriter.getDefaultImageMetadata(new ImageTypeSpecifier(bufferedImage), null);
        Element element = (Element)iIOMetadata.getAsTree("javax_imageio_png_1.0");
        NodeList nodeList = element.getElementsByTagName("bKGD");
        if (nodeList.getLength() == 0) {
            Node node = element.getFirstChild();
            String string6 = node.getNodeName();
            if ("IHDR".equals(string6) || "PLTE".equals(string6)) {
                node = node.getNextSibling();
            }
            if (node != null && "PLTE".equals(node.getNodeName())) {
                node = node.getNextSibling();
            }
            IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("bKGD");
            if (node == null) {
                element.appendChild(iIOMetadataNode);
            } else {
                element.insertBefore(iIOMetadataNode, node);
            }
            IIOMetadataNode iIOMetadataNode2 = new IIOMetadataNode("bKGD_Grayscale");
            iIOMetadataNode.appendChild(iIOMetadataNode2);
            iIOMetadataNode2.setAttribute("gray", "255");
            try {
                iIOMetadata.mergeTree("javax_imageio_png_1.0", element);
            }
            catch (IIOInvalidTreeException iIOInvalidTreeException) {
                LOG.error("creerImage(String, String, JaxeDocument)", iIOInvalidTreeException);
            }
        }
        try {
            imageWriter.setOutput(ImageIO.createImageOutputStream(file));
            imageWriter.write(new IIOImage(bufferedImage, null, iIOMetadata));
        }
        catch (IOException iOException) {
            LOG.error("creerImage(String, String, JaxeDocument)", iOException);
            JOptionPane.showMessageDialog(jaxeDocument.jframe, JaxeResourceBundle.getRB().getString("erreur.Enregistrement") + ": " + iOException.getMessage(), JaxeResourceBundle.getRB().getString("erreur.Erreur"), 0);
            return null;
        }
        string2 = string5 + "/" + string3;
        return string2;
    }
}

