/*
 * Decompiled with CFR 0.152.
 */
package jaxe.elements;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import javax.accessibility.Accessible;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import jaxe.JaxeResourceBundle;
import org.apache.log4j.Logger;
import org.w3c.dom.Element;

public class DialogueSymbole
extends JDialog
implements ActionListener {
    private static final Logger LOG = Logger.getLogger(DialogueSymbole.class);
    Element el;
    JFrame jframe;
    boolean valide = false;
    File[] liste;
    JLabel[] labels;
    int ichoix = -1;

    public DialogueSymbole(JFrame jFrame, Element element) {
        super(jFrame, JaxeResourceBundle.getRB().getString("symbole.Insertion"), true);
        JComponent jComponent;
        Accessible accessible;
        this.jframe = jFrame;
        this.el = element;
        File file = new File("symboles");
        if (!file.exists()) {
            JOptionPane.showMessageDialog(jFrame, JaxeResourceBundle.getRB().getString("erreur.SymbolesNonTrouve"), JaxeResourceBundle.getRB().getString("erreur.Erreur"), 0);
            return;
        }
        this.liste = DialogueSymbole.chercherImages(file);
        JPanel jPanel = new JPanel(new BorderLayout());
        this.setContentPane(jPanel);
        GridLayout gridLayout = new GridLayout((int)Math.ceil((double)this.liste.length / 13.0), 13, 10, 10);
        JPanel jPanel2 = new JPanel(gridLayout);
        jPanel.add((Component)jPanel2, "Center");
        MyMouseListener myMouseListener = new MyMouseListener();
        this.labels = new JLabel[this.liste.length];
        for (int i = 0; i < this.liste.length; ++i) {
            accessible = new ImageIcon(this.liste[i].getPath());
            jComponent = new JLabel((Icon)((Object)accessible));
            jComponent.addMouseListener(myMouseListener);
            this.labels[i] = jComponent;
            jPanel2.add(jComponent);
        }
        JPanel jPanel3 = new JPanel(new FlowLayout(2));
        accessible = new JButton(JaxeResourceBundle.getRB().getString("bouton.Annuler"));
        ((AbstractButton)((Object)accessible)).addActionListener(this);
        ((AbstractButton)((Object)accessible)).setActionCommand("Annuler");
        jPanel3.add((Component)((Object)accessible));
        jComponent = new JButton(JaxeResourceBundle.getRB().getString("bouton.OK"));
        ((AbstractButton)jComponent).addActionListener(this);
        ((AbstractButton)jComponent).setActionCommand("OK");
        jPanel3.add(jComponent);
        jPanel.add((Component)jPanel3, "South");
        this.getRootPane().setDefaultButton((JButton)jComponent);
        this.ichoix = -1;
        this.choix(0);
        this.pack();
        if (jFrame != null) {
            Rectangle rectangle = jFrame.getBounds();
            this.setLocation(rectangle.x + rectangle.width / 4, rectangle.y + rectangle.height / 4);
        } else {
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            this.setLocation((dimension.width - this.getSize().width) / 3, (dimension.height - this.getSize().height) / 3);
        }
    }

    public static File[] chercherImages(File file) {
        File[] fileArray = file.listFiles();
        HashSet<File> hashSet = new HashSet<File>();
        for (File file2 : fileArray) {
            String string;
            int n;
            if (file2.isDirectory()) {
                hashSet.addAll(Arrays.asList(DialogueSymbole.chercherImages(file2)));
                continue;
            }
            if (!file2.isFile() || (n = (string = file2.getName()).lastIndexOf(46)) == -1) continue;
            String string2 = string.substring(n + 1).toLowerCase();
            if ("png".equals(string2)) {
                hashSet.add(file2);
                continue;
            }
            if (!"gif".equals(string2)) continue;
            String string3 = string.substring(0, n) + ".png";
            boolean bl = false;
            for (int i = 0; i < fileArray.length && !bl; ++i) {
                if (!string3.equals(fileArray[i].getName())) continue;
                bl = true;
            }
            if (bl) continue;
            hashSet.add(file2);
        }
        return hashSet.toArray(new File[hashSet.size()]);
    }

    public boolean afficher() {
        if (this.ichoix == -1) {
            return false;
        }
        this.setVisible(true);
        return this.valide;
    }

    public String fichierChoisi() {
        String string = this.liste[this.ichoix].getPath();
        if (File.separatorChar != '/') {
            string = string.replace(File.separatorChar, '/');
        }
        return string;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if ("OK".equals(string)) {
            this.valide = true;
            this.setVisible(false);
        } else if ("Annuler".equals(string)) {
            this.valide = false;
            this.setVisible(false);
        }
    }

    protected void choix(int n) {
        JLabel jLabel;
        if (this.ichoix != -1) {
            jLabel = this.labels[this.ichoix];
            jLabel.setBorder(null);
        }
        this.ichoix = n;
        jLabel = this.labels[this.ichoix];
        jLabel.setBorder(BorderFactory.createLineBorder(Color.darkGray));
    }

    class MyMouseListener
    extends MouseAdapter {
        public void mouseClicked(MouseEvent mouseEvent) {
            Component component = mouseEvent.getComponent();
            for (int i = 0; i < DialogueSymbole.this.labels.length; ++i) {
                if (DialogueSymbole.this.labels[i] != component) continue;
                DialogueSymbole.this.choix(i);
            }
        }
    }
}

