/*
 * Decompiled with CFR 0.152.
 */
package jaxe;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.security.AccessControlException;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jaxe.JaxeResourceBundle;
import org.apache.log4j.Logger;

public class Preferences
extends JDialog
implements ActionListener {
    private static final Logger LOG = Logger.getLogger(Preferences.class);
    private static final File fpref = Preferences.trouverFichier();
    private static Properties prefs = Preferences.getPreferencesParDefaut();
    private final JCheckBox caseArbre;
    private final JCheckBox caseInsertion;
    private final JCheckBox caseAttributs;
    private final JLabel labelNav;
    private String prefNav;
    private final JCheckBox caseIndent;
    private final JLabel labelDico;
    private String prefDico;
    private final JCheckBox caseIconeValide;

    public static File trouverFichier() {
        try {
            String string = System.getProperty("user.home");
            String string2 = System.getProperty("os.name");
            File file = string2.indexOf("Windows") != -1 ? new File(string, "jaxepreferences") : (string2.startsWith("Mac") ? new File(string, "Library/Preferences/Jaxe Preferences") : new File(string, ".jaxe"));
            return file;
        }
        catch (AccessControlException accessControlException) {
            LOG.error("Jaxe Preferences.trouverFichier", accessControlException);
            return null;
        }
    }

    public static Properties getPreferencesParDefaut() {
        Properties properties = new Properties();
        properties.setProperty("fenetreArbre", "true");
        properties.setProperty("fenetreInsertion", "true");
        properties.setProperty("fenetreAttributs", "true");
        if (System.getProperty("os.name").startsWith("Mac")) {
            properties.setProperty("navigateur", "/Applications/Safari.app");
        }
        properties.setProperty("consIndent", "false");
        properties.setProperty("iconeValide", "true");
        return properties;
    }

    public static Properties chargerPref() {
        prefs = Preferences.getPreferencesParDefaut();
        try {
            if (fpref != null && fpref.exists()) {
                FileInputStream fileInputStream = new FileInputStream(fpref);
                prefs.load(fileInputStream);
                fileInputStream.close();
            }
        }
        catch (IOException iOException) {
            LOG.error("chargerPref()", iOException);
            return null;
        }
        return prefs;
    }

    public static Properties getPref() {
        return prefs;
    }

    public static void enregistrerPref(Properties properties) {
        if (properties == null) {
            return;
        }
        prefs = properties;
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(fpref);
            prefs.store(fileOutputStream, "Pr\u00e9f\u00e9rences de Jaxe");
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            LOG.error("enregistrerPref(Properties)", iOException);
        }
    }

    public Preferences(JFrame jFrame) {
        super(jFrame, JaxeResourceBundle.getRB().getString("pref.Preferences"), true);
        int n;
        this.getContentPane().setLayout(new BorderLayout());
        Properties properties = Preferences.getPref();
        String string = properties.getProperty("fenetreArbre");
        String string2 = properties.getProperty("fenetreInsertion");
        String string3 = properties.getProperty("fenetreAttributs");
        this.prefNav = properties.getProperty("navigateur");
        String string4 = properties.getProperty("consIndent");
        this.prefDico = properties.getProperty("dictionnaire");
        String string5 = properties.getProperty("iconeValide");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        jPanel2.setBorder(BorderFactory.createTitledBorder(JaxeResourceBundle.getRB().getString("pref.Fenetres")));
        this.caseArbre = new JCheckBox(JaxeResourceBundle.getRB().getString("pref.Arbre"));
        this.caseArbre.setSelected(Boolean.parseBoolean(string));
        jPanel2.add(this.caseArbre);
        this.caseInsertion = new JCheckBox(JaxeResourceBundle.getRB().getString("pref.Insertion"));
        this.caseInsertion.setSelected(Boolean.parseBoolean(string2));
        jPanel2.add(this.caseInsertion);
        this.caseAttributs = new JCheckBox(JaxeResourceBundle.getRB().getString("pref.Attributs"));
        this.caseAttributs.setSelected(Boolean.parseBoolean(string3));
        jPanel2.add(this.caseAttributs);
        jPanel.add(jPanel2);
        jPanel2.setAlignmentX(0.0f);
        jPanel2.setMaximumSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        JPanel jPanel3 = new JPanel(new FlowLayout());
        jPanel3.setBorder(BorderFactory.createTitledBorder(JaxeResourceBundle.getRB().getString("pref.Navigateur")));
        String string6 = null;
        if (this.prefNav != null) {
            string6 = new File(this.prefNav).getName();
        }
        this.labelNav = new JLabel(string6);
        jPanel3.add(this.labelNav);
        JButton jButton = new JButton(JaxeResourceBundle.getRB().getString("pref.Definir"));
        jButton.addActionListener(this);
        jButton.setActionCommand("defNav");
        jPanel3.add(jButton);
        jPanel.add(jPanel3);
        jPanel3.setAlignmentX(0.0f);
        JPanel jPanel4 = new JPanel(new FlowLayout());
        jPanel4.setLayout(new BoxLayout(jPanel4, 1));
        jPanel4.setBorder(BorderFactory.createTitledBorder(JaxeResourceBundle.getRB().getString("pref.Affichage")));
        this.caseIndent = new JCheckBox(JaxeResourceBundle.getRB().getString("pref.consIndent"));
        this.caseIndent.setSelected(Boolean.parseBoolean(string4));
        jPanel4.add(this.caseIndent);
        this.caseIconeValide = new JCheckBox(JaxeResourceBundle.getRB().getString("pref.iconeValide"));
        this.caseIconeValide.setSelected(Boolean.parseBoolean(string5));
        jPanel4.add(this.caseIconeValide);
        jPanel.add(jPanel4);
        jPanel4.setAlignmentX(0.0f);
        JPanel jPanel5 = new JPanel(new FlowLayout());
        jPanel5.setBorder(BorderFactory.createTitledBorder(JaxeResourceBundle.getRB().getString("pref.Dictionnaire")));
        String string7 = null;
        if (this.prefDico != null && (n = (string7 = new File(this.prefDico).getName()).lastIndexOf(46)) != -1) {
            string7 = string7.substring(0, n);
        }
        this.labelDico = new JLabel(string7);
        jPanel5.add(this.labelDico);
        JButton jButton2 = new JButton(JaxeResourceBundle.getRB().getString("pref.Definir"));
        jButton2.addActionListener(this);
        jButton2.setActionCommand("defDico");
        jPanel5.add(jButton2);
        jPanel.add(jPanel5);
        jPanel5.setAlignmentX(0.0f);
        this.getContentPane().add((Component)jPanel, "Center");
        JPanel jPanel6 = new JPanel(new FlowLayout(1, 15, 15));
        JButton jButton3 = new JButton(JaxeResourceBundle.getRB().getString("pref.Annuler"));
        jButton3.addActionListener(this);
        jButton3.setActionCommand("Annuler");
        jPanel6.add(jButton3);
        JButton jButton4 = new JButton(JaxeResourceBundle.getRB().getString("pref.Enregistrer"));
        jButton4.addActionListener(this);
        jButton4.setActionCommand("Enregistrer");
        jPanel6.add(jButton4);
        this.getRootPane().setDefaultButton(jButton4);
        this.getContentPane().add((Component)jPanel6, "South");
        Rectangle rectangle = jFrame.getBounds();
        this.setLocation(rectangle.x + rectangle.width / 4, rectangle.y + rectangle.height / 4);
        this.pack();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if ("Enregistrer".equals(string)) {
            Properties properties = Preferences.getPref();
            properties.setProperty("fenetreArbre", Boolean.toString(this.caseArbre.isSelected()));
            properties.setProperty("fenetreInsertion", Boolean.toString(this.caseInsertion.isSelected()));
            properties.setProperty("fenetreAttributs", Boolean.toString(this.caseAttributs.isSelected()));
            if (this.prefNav != null) {
                properties.setProperty("navigateur", this.prefNav);
            } else {
                properties.setProperty("navigateur", "");
            }
            if (this.prefDico != null) {
                properties.setProperty("dictionnaire", this.prefDico);
            } else {
                properties.setProperty("dictionnaire", "");
            }
            properties.setProperty("consIndent", Boolean.toString(this.caseIndent.isSelected()));
            properties.setProperty("iconeValide", Boolean.toString(this.caseIconeValide.isSelected()));
            Preferences.enregistrerPref(properties);
        } else if ("defNav".equals(string)) {
            this.defNavigateur();
        } else if ("defDico".equals(string)) {
            this.defDictionnaire();
        }
        if ("Enregistrer".equals(string) || "Annuler".equals(string)) {
            this.setVisible(false);
        }
    }

    public void defNavigateur() {
        FileDialog fileDialog = new FileDialog((Frame)((JFrame)this.getOwner()), JaxeResourceBundle.getRB().getString("pref.DefNavigateur"), 0);
        fileDialog.setVisible(true);
        String string = null;
        String string2 = fileDialog.getDirectory();
        if (string2 != null && string2.endsWith(File.separator)) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        String string3 = fileDialog.getFile();
        if (string2 == null) {
            string = string3;
        } else if (string3 != null) {
            string = string2 + File.separator + string3;
        }
        if (string != null) {
            this.prefNav = string;
            this.labelNav.setText(string3);
        }
    }

    public void defDictionnaire() {
        FileDialog fileDialog = new FileDialog((Frame)((JFrame)this.getOwner()), JaxeResourceBundle.getRB().getString("pref.Dictionnaire"), 0);
        fileDialog.setFilenameFilter(new ExtFilter("dico"));
        fileDialog.setDirectory(System.getProperty("user.dir") + File.separator + "dicos");
        fileDialog.setVisible(true);
        String string = null;
        String string2 = fileDialog.getDirectory();
        if (string2 != null && string2.endsWith(File.separator)) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        String string3 = fileDialog.getFile();
        if (string2 == null) {
            string = string3;
        } else if (string3 != null) {
            string = string2 + File.separator + string3;
        }
        if (string != null) {
            int n;
            this.prefDico = string;
            if (string3 != null && (n = string3.lastIndexOf(46)) != -1) {
                string3 = string3.substring(0, n);
            }
            this.labelDico.setText(string3);
        }
    }

    class ExtFilter
    implements FilenameFilter {
        String[] exta;

        public ExtFilter(String string) {
            this.exta = new String[1];
            this.exta[0] = string;
        }

        public ExtFilter(String[] stringArray) {
            this.exta = stringArray;
        }

        public boolean accept(File file, String string) {
            for (String string2 : this.exta) {
                if (!string.endsWith("." + string2)) continue;
                return true;
            }
            return false;
        }
    }
}

