/*
 * Decompiled with CFR 0.152.
 */
package jaxe;

import com.sun.org.apache.xml.internal.utils.SAXSourceLocator;
import com.sun.org.apache.xml.internal.utils.WrappedRuntimeException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.text.html.HTMLDocument;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import jaxe.JaxeDocument;
import jaxe.JaxeResourceBundle;
import jaxe.Preferences;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class HTMLFrame
extends JFrame {
    private static final Logger LOG = Logger.getLogger(HTMLFrame.class);
    JaxeDocument doc;
    HTMLDocument htmldoc;
    JTextPane textPane;
    JButton boutonNav;

    public HTMLFrame(JaxeDocument jaxeDocument) {
        this.newdoc(jaxeDocument);
    }

    public void newdoc(JaxeDocument jaxeDocument) {
        this.doc = jaxeDocument;
        if (jaxeDocument.cfg == null) {
            return;
        }
        this.htmldoc = new HTMLDocument();
        Rectangle rectangle = jaxeDocument.jframe.getBounds();
        this.setLocation(rectangle.x + rectangle.width / 2, rectangle.y + rectangle.height / 2);
        this.setSize(new Dimension(620, 460));
        this.affichage();
        if (jaxeDocument.fsave != null) {
            File file = HTMLFrame.fichierHTML(jaxeDocument.fsave);
            if (file.exists()) {
                try {
                    URL uRL = file.toURI().toURL();
                    this.textPane.setPage(uRL);
                    this.setTitle(file.getName());
                }
                catch (Exception exception) {
                    this.afficherErreur(exception);
                }
                this.setVisible(true);
            } else {
                this.miseAJour();
            }
        } else {
            JOptionPane.showMessageDialog(jaxeDocument.jframe, JaxeResourceBundle.getRB().getString("html.SauverAvant"), JaxeResourceBundle.getRB().getString("erreur.Erreur"), 0);
        }
    }

    protected void affichage() {
        this.textPane = new JTextPane(this.htmldoc);
        this.textPane.setEditable(false);
        JScrollPane jScrollPane = new JScrollPane(this.textPane);
        jScrollPane.setVerticalScrollBarPolicy(22);
        jScrollPane.setPreferredSize(new Dimension(600, 400));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout());
        JButton jButton = new JButton(JaxeResourceBundle.getRB().getString("html.MiseAJour"));
        jButton.addActionListener(new MAJListener());
        jPanel.add(jButton);
        this.boutonNav = new JButton();
        this.boutonNav.setAction(new AbstractAction(JaxeResourceBundle.getRB().getString("html.Navigateur")){

            public void actionPerformed(ActionEvent actionEvent) {
                HTMLFrame.this.lancerNavigateur();
            }
        });
        jPanel.add(this.boutonNav);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)jScrollPane, "Center");
        jPanel2.add((Component)jPanel, "North");
        this.setContentPane(jPanel2);
    }

    public static File fichierHTML(File file) {
        String string = file.getName();
        int n = string.lastIndexOf(46);
        if (n != -1 && !"html".equals(string.substring(n + 1))) {
            string = string.substring(0, n);
        }
        return new File(file.getParent() + File.separatorChar + string + ".html");
    }

    public void miseAJour() {
        if (this.doc.fsave == null) {
            JOptionPane.showMessageDialog(this.doc.jframe, JaxeResourceBundle.getRB().getString("html.SauverAvant"), JaxeResourceBundle.getRB().getString("erreur.Erreur"), 0);
            return;
        }
        File[] fileArray = this.doc.cfg.getXSLFiles();
        if (fileArray == null || fileArray.length == 0) {
            return;
        }
        Document document = this.doc.DOMdoc;
        File file = null;
        for (int i = 0; i < fileArray.length; ++i) {
            Object object;
            Object object2;
            File file2 = fileArray[i];
            if (file2 == null) {
                JOptionPane.showMessageDialog(this.doc.jframe, JaxeResourceBundle.getRB().getString("erreur.XSLNonTrouve"), JaxeResourceBundle.getRB().getString("erreur.Erreur"), 0);
                return;
            }
            try {
                object2 = TransformerFactory.newInstance();
                ((TransformerFactory)object2).setErrorListener(new MyErrorListener());
                object = ((TransformerFactory)object2).newTransformer(new StreamSource(file2));
                ArrayList<String[]> arrayList = this.doc.cfg.getXSLParam(file2);
                for (String[] stringArray : arrayList) {
                    if ("jaxe-fichier-xml".equals(stringArray[0])) {
                        ((Transformer)object).setParameter("jaxe-fichier-xml", this.doc.fsave.getAbsolutePath());
                        continue;
                    }
                    if ("jaxe-fichier-xsl".equals(stringArray[0])) {
                        ((Transformer)object).setParameter("jaxe-fichier-xsl", file2.getAbsolutePath());
                        continue;
                    }
                    ((Transformer)object).setParameter(stringArray[0], stringArray[1]);
                }
                if (i == fileArray.length - 1) {
                    file = HTMLFrame.fichierHTML(this.doc.fsave);
                } else {
                    file = File.createTempFile("tmp", ".xml");
                    file.deleteOnExit();
                }
                DOMSource dOMSource = new DOMSource(document);
                if (this.doc.fsave != null) {
                    dOMSource.setSystemId(this.doc.fsave.toURI().toURL().toExternalForm());
                }
                FileOutputStream object32 = new FileOutputStream(file);
                ((Transformer)object).transform(dOMSource, new StreamResult(object32));
                object32.close();
            }
            catch (Exception exception) {
                this.afficherErreur(exception);
                return;
            }
            if (i >= fileArray.length - 1) continue;
            try {
                object2 = DocumentBuilderFactory.newInstance();
                ((DocumentBuilderFactory)object2).setNamespaceAware(true);
                object = ((DocumentBuilderFactory)object2).newDocumentBuilder();
                document = ((DocumentBuilder)object).parse(file);
                continue;
            }
            catch (Exception exception) {
                LOG.error("miseAJour()", exception);
                return;
            }
        }
        try {
            this.affichage();
            URL uRL = file.toURI().toURL();
            this.textPane.setPage(uRL);
            this.setTitle(file.getName());
        }
        catch (Exception exception) {
            this.afficherErreur(exception);
        }
        this.setVisible(true);
    }

    protected void afficherErreur(Exception exception) {
        String string = exception.getMessage();
        if (exception instanceof TransformerException) {
            SourceLocator sourceLocator = null;
            Throwable throwable = exception;
            do {
                SourceLocator sourceLocator2;
                if (throwable instanceof SAXParseException) {
                    sourceLocator = new SAXSourceLocator((SAXParseException)throwable);
                    continue;
                }
                if (!(throwable instanceof TransformerException) || (sourceLocator2 = ((TransformerException)throwable).getLocator()) == null) continue;
                sourceLocator = sourceLocator2;
            } while ((throwable = throwable instanceof TransformerException ? ((TransformerException)throwable).getCause() : (throwable instanceof WrappedRuntimeException ? ((WrappedRuntimeException)throwable).getException() : (throwable instanceof SAXException ? ((SAXException)throwable).getException() : null))) != null);
            if (sourceLocator != null) {
                string = string + " at line " + sourceLocator.getLineNumber();
            }
        }
        if (string != null) {
            int n = 0;
            for (int i = 0; i < string.length(); ++i) {
                if (i - n <= 40 || string.charAt(i) != ' ') continue;
                n = i;
                string = string.substring(0, i) + "\n" + string.substring(i + 1);
            }
        }
        JOptionPane.showMessageDialog(this.doc.jframe, exception.getClass().getName() + ": " + string, JaxeResourceBundle.getRB().getString("erreur.Erreur"), 0);
    }

    public void lancerNavigateur() {
        Properties properties = Preferences.getPref();
        String string = properties.getProperty("navigateur");
        if (string == null) {
            this.defNavigateur();
            properties = Preferences.getPref();
            string = properties.getProperty("navigateur");
            if (string == null) {
                return;
            }
        }
        File file = HTMLFrame.fichierHTML(this.doc.fsave);
        String[] stringArray = System.getProperty("os.name").startsWith("Mac") ? new String[]{"/usr/bin/open", "-a", string, file.getAbsolutePath()} : new String[]{string, file.getAbsolutePath()};
        try {
            Runtime.getRuntime().exec(stringArray);
        }
        catch (IOException iOException) {
            LOG.error("lancerNavigateur()", iOException);
        }
    }

    public void defNavigateur() {
        FileDialog fileDialog = new FileDialog((Frame)this, JaxeResourceBundle.getRB().getString("html.DefNavigateur"), 0);
        fileDialog.setVisible(true);
        String string = null;
        String string2 = fileDialog.getDirectory();
        if (string2 != null && string2.endsWith(File.separator)) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        String string3 = fileDialog.getFile();
        if (string2 == null) {
            string = string3;
        } else if (string3 != null) {
            string = string2 + File.separator + string3;
        }
        if (string != null) {
            Properties properties = Preferences.getPref();
            properties.setProperty("navigateur", string);
            Preferences.enregistrerPref(properties);
        }
    }

    class MyErrorListener
    implements ErrorListener {
        MyErrorListener() {
        }

        public void warning(TransformerException transformerException) throws TransformerException {
            LOG.warn("XSLT warning", transformerException);
        }

        public void error(TransformerException transformerException) throws TransformerException {
            LOG.error("XSLT error", transformerException);
            HTMLFrame.this.afficherErreur(transformerException);
            throw transformerException;
        }

        public void fatalError(TransformerException transformerException) throws TransformerException {
            LOG.error("XSLT fatal", transformerException);
            throw transformerException;
        }
    }

    class MAJListener
    implements ActionListener {
        MAJListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            HTMLFrame.this.miseAJour();
        }
    }
}

