/*
 * Decompiled with CFR 0.152.
 */
package calcotron;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.MediaTracker;
import java.awt.Menu;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.MemoryImageSource;
import java.io.Serializable;
import java.net.URL;
import java.util.Vector;

class CalcoFrame
extends Frame
implements KeyListener,
ComponentListener {
    private boolean appliquette;
    private Font policeBoutons = new Font("serif", 1, 12);
    private Font policeExp = new Font("serif", 0, 9);
    private Vector trucs;
    private MenuConst mconstantes;
    private Affichage affichage;
    private String valeurAffichee;
    private String expressionCachee;
    private double valeur1;
    private double valeur2;
    private boolean edit;
    private Fonction opCourante;
    private double memoire;
    private boolean modeExpressions;
    private String degrad;
    private Image fond;
    private Image logo;
    private final Color grisclair1 = new Color(127, 127, 127);
    private final Color grisclair2 = new Color(137, 137, 137);
    private final Color grisclair3 = new Color(142, 142, 142);
    private final Color grisclair4 = new Color(240, 240, 240);
    private final Color grisclair5 = new Color(245, 245, 245);
    private final Color grisfonce1 = new Color(50, 50, 50);
    private final Color grisfonce2 = new Color(100, 100, 100);
    static /* synthetic */ Class class$calcotron$CalcoFrame;

    public static void main(String[] stringArray) {
        CalcoFrame calcoFrame = new CalcoFrame(false);
        ((Component)calcoFrame).setVisible(true);
    }

    public CalcoFrame(boolean bl) {
        super("Le Calcotron");
        Serializable serializable;
        Serializable serializable2;
        this.appliquette = bl;
        this.valeur2 = 0.0;
        this.opCourante = null;
        this.valeur1 = 0.0;
        this.valeurAffichee = "0";
        this.expressionCachee = "";
        this.edit = false;
        this.memoire = 0.0;
        this.modeExpressions = false;
        this.degrad = "rad";
        this.trucs = new Vector();
        this.trucs.addElement(new Addition());
        this.trucs.addElement(new Soustraction());
        this.trucs.addElement(new Multiplication());
        this.trucs.addElement(new Division());
        this.trucs.addElement(new Puissance());
        this.trucs.addElement(new Inverse());
        this.trucs.addElement(new PuissanceInverse());
        this.trucs.addElement(new Factorielle());
        this.trucs.addElement(new M());
        this.trucs.addElement(new RM());
        this.trucs.addElement(new Mplus());
        this.trucs.addElement(new Pourcent());
        this.trucs.addElement(new Expressions());
        this.trucs.addElement(new Lettre(','));
        this.trucs.addElement(new DMS());
        this.trucs.addElement(new SigneInverse());
        this.trucs.addElement(new DegRad());
        this.trucs.addElement(new Del());
        this.trucs.addElement(new C());
        this.trucs.addElement(new AC());
        this.trucs.addElement(new Sinus());
        this.trucs.addElement(new ArcSinus());
        this.trucs.addElement(new Cosinus());
        this.trucs.addElement(new ArcCosinus());
        this.trucs.addElement(new Tangente());
        this.trucs.addElement(new ArcTangente());
        this.trucs.addElement(new Exponentielle());
        this.trucs.addElement(new LogarithmeNeperien());
        this.trucs.addElement(new Exp10());
        this.trucs.addElement(new LogarithmeDecimal());
        this.trucs.addElement(new Carre());
        this.trucs.addElement(new RacineCarree());
        this.trucs.addElement(new Lettre('('));
        this.trucs.addElement(new Lettre(')'));
        this.trucs.addElement(new Lettre('0'));
        this.trucs.addElement(new Lettre('1'));
        this.trucs.addElement(new Lettre('2'));
        this.trucs.addElement(new Lettre('3'));
        this.trucs.addElement(new Lettre('4'));
        this.trucs.addElement(new Lettre('5'));
        this.trucs.addElement(new Lettre('6'));
        this.trucs.addElement(new Lettre('7'));
        this.trucs.addElement(new Lettre('8'));
        this.trucs.addElement(new Lettre('9'));
        this.trucs.addElement(new Lettre('.'));
        this.trucs.addElement(new Lettre('E'));
        this.trucs.addElement(new Lettre('='));
        this.mconstantes = new MenuConst("const");
        this.mconstantes.ajouter("\u03c0", "\u03c0", Math.PI);
        this.mconstantes.ajouter("e", "e", Math.E);
        this.mconstantes.ajouter("c", "c (m/s)", 2.99792458E8);
        this.mconstantes.ajouter("G", "G (kg-1 m3 s-2)", 6.67259E-11);
        this.mconstantes.ajouter("h", "h (J s)", 6.6260755E-34);
        this.mconstantes.ajouter("k", "k (J/K)", 1.380622E-23);
        this.mconstantes.ajouter("c_e", "c_e (C)", 1.60217733E-19);
        this.mconstantes.ajouter("m_e", "m_e (kg)", 9.1093897E-31);
        this.mconstantes.ajouter("m_p", "m_p (kg)", 1.6726231E-27);
        this.mconstantes.ajouter("m_n", "m_n (kg)", 1.6749286E-27);
        this.mconstantes.ajouter("UA", "UA (m)", 1.49597870691E11);
        this.mconstantes.ajouter("AL", "AL (m)", 9.463E15);
        this.mconstantes.ajouter("pc", "pc (m)", 3.0856775807E16);
        MenuConst menuConst = new MenuConst("syst\u00e8me solaire");
        MenuConst menuConst2 = new MenuConst("Lune");
        menuConst2.ajouter("alun", "demi-grand axe (m)", 3.83398E8);
        menuConst2.ajouter("elun", "excentricit\u00e9", 0.05555);
        menuConst2.ajouter("Tlun", "p\u00e9riode sid. (j)", 27.3217);
        menuConst2.ajouter("dlun", "diam\u00e8tre eq. (m)", 3444200.0);
        menuConst2.ajouter("mlun", "masse (kg)", 7.34753E22);
        menuConst.ajouter(menuConst2);
        MenuConst menuConst3 = new MenuConst("Soleil");
        menuConst3.ajouter("msol", "masse (kg)", 1.9887973E30);
        menuConst3.ajouter("dsol", "diam\u00e8tre eq. (m)", 1.392E9);
        menuConst3.ajouter("Tsol", "temp\u00e9rature (K)", 5780.0);
        menuConst3.ajouter("Lsol", "luminosit\u00e9 (W)", 3.846E26);
        menuConst.ajouter(menuConst3);
        MenuConst menuConst4 = new MenuConst("Mercure");
        menuConst4.ajouter("amer", "demi-grand axe (UA)", 0.3870983);
        menuConst4.ajouter("emer", "excentricit\u00e9", 0.20563);
        menuConst4.ajouter("Tmer", "p\u00e9riode sid. (j)", 87.9693);
        menuConst4.ajouter("dmer", "diam\u00e8tre eq. (m)", 4879400.0);
        menuConst4.ajouter("mmer", "masse (kg)", 3.3018E23);
        menuConst.ajouter(menuConst4);
        MenuConst menuConst5 = new MenuConst("V\u00e9nus");
        menuConst5.ajouter("aven", "demi-grand axe (UA)", 0.7233298);
        menuConst5.ajouter("even", "excentricit\u00e9", 0.00677);
        menuConst5.ajouter("Tven", "p\u00e9riode sid. (j)", 224.701);
        menuConst5.ajouter("dven", "diam\u00e8tre eq. (m)", 1.21036E7);
        menuConst5.ajouter("mven", "masse (kg)", 4.8685E24);
        menuConst.ajouter(menuConst5);
        MenuConst menuConst6 = new MenuConst("Terre");
        menuConst6.ajouter("ater", "demi-grand axe (UA)", 1.000001);
        menuConst6.ajouter("eter", "excentricit\u00e9", 0.01671);
        menuConst6.ajouter("Tter", "p\u00e9riode sid. (j)", 365.256);
        menuConst6.ajouter("dter", "diam\u00e8tre eq. (m)", 1.275628E7);
        menuConst6.ajouter("mter", "masse (kg)", 5.9736E24);
        menuConst.ajouter(menuConst6);
        MenuConst menuConst7 = new MenuConst("Mars");
        menuConst7.ajouter("amar", "demi-grand axe (UA)", 1.5236793);
        menuConst7.ajouter("emar", "excentricit\u00e9", 0.0934);
        menuConst7.ajouter("Tmar", "p\u00e9riode sid. (j)", 686.986);
        menuConst7.ajouter("dmar", "diam\u00e8tre eq. (m)", 6794000.0);
        menuConst7.ajouter("mmar", "masse (kg)", 6.4185E23);
        menuConst.ajouter(menuConst7);
        MenuConst menuConst8 = new MenuConst("Jupiter");
        menuConst8.ajouter("ajup", "demi-grand axe (UA)", 5.202603);
        menuConst8.ajouter("ejup", "excentricit\u00e9", 0.0485);
        menuConst8.ajouter("Tjup", "p\u00e9riode sid. (j)", 4332.656);
        menuConst8.ajouter("djup", "diam\u00e8tre eq. (m)", 1.42984E8);
        menuConst8.ajouter("mjup", "masse (kg)", 1.8986E27);
        menuConst.ajouter(menuConst8);
        MenuConst menuConst9 = new MenuConst("Saturne");
        menuConst9.ajouter("asat", "demi-grand axe (UA)", 9.554909);
        menuConst9.ajouter("esat", "excentricit\u00e9", 0.05555);
        menuConst9.ajouter("Tsat", "p\u00e9riode sid. (j)", 10759.404);
        menuConst9.ajouter("dsat", "diam\u00e8tre eq. (m)", 1.20536E8);
        menuConst9.ajouter("msat", "masse (kg)", 5.6846E26);
        menuConst.ajouter(menuConst9);
        MenuConst menuConst10 = new MenuConst("Uranus");
        menuConst10.ajouter("aura", "demi-grand axe (UA)", 19.21845);
        menuConst10.ajouter("eura", "excentricit\u00e9", 0.04638);
        menuConst10.ajouter("Tura", "p\u00e9riode sid. (j)", 30688.984);
        menuConst10.ajouter("dura", "diam\u00e8tre eq. (m)", 5.1118E7);
        menuConst10.ajouter("mura", "masse (kg)", 8.6831E25);
        menuConst.ajouter(menuConst10);
        MenuConst menuConst11 = new MenuConst("Neptune");
        menuConst11.ajouter("anep", "demi-grand axe (UA)", 30.11039);
        menuConst11.ajouter("enep", "excentricit\u00e9", 0.00946);
        menuConst11.ajouter("Tnep", "p\u00e9riode sid. (j)", 60183.284);
        menuConst11.ajouter("dnep", "diam\u00e8tre eq. (m)", 4.9528E7);
        menuConst11.ajouter("mnep", "masse (kg)", 1.0243E26);
        menuConst.ajouter(menuConst11);
        MenuConst menuConst12 = new MenuConst("Pluton");
        menuConst12.ajouter("aplu", "demi-grand axe (UA)", 39.5447);
        menuConst12.ajouter("eplu", "excentricit\u00e9", 0.249);
        menuConst12.ajouter("Tplu", "p\u00e9riode sid. (j)", 90580.232);
        menuConst12.ajouter("dplu", "diam\u00e8tre eq. (m)", 2390000.0);
        menuConst12.ajouter("mplu", "masse (kg)", 1.238E22);
        menuConst.ajouter(menuConst12);
        this.mconstantes.ajouter(menuConst);
        this.mconstantes.ajouter("answer", "ultimate answer", 42.0);
        try {
            serializable2 = new MediaTracker(this);
            serializable = (class$calcotron$CalcoFrame == null ? (class$calcotron$CalcoFrame = CalcoFrame.class$("calcotron.CalcoFrame")) : class$calcotron$CalcoFrame).getResource("logo.gif");
            this.logo = Toolkit.getDefaultToolkit().getImage((URL)serializable);
            ((MediaTracker)serializable2).addImage(this.logo, 0);
            ((MediaTracker)serializable2).waitForAll();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        serializable2 = new GridBagLayout();
        serializable = new GridBagConstraints();
        this.setLayout((LayoutManager)((Object)serializable2));
        this.affichage = new Affichage();
        ((GridBagConstraints)serializable).fill = 1;
        ((GridBagConstraints)serializable).insets = new Insets(3, 5, 3, 5);
        ((GridBagConstraints)serializable).weighty = 1.0;
        ((GridBagConstraints)serializable).gridwidth = 0;
        this.ajouterBouton(this.affichage, (GridBagLayout)serializable2, (GridBagConstraints)serializable);
        ((GridBagConstraints)serializable).weightx = 1.0;
        ((GridBagConstraints)serializable).gridwidth = 1;
        ((GridBagConstraints)serializable).insets = new Insets(3, 5, 3, 3);
        this.ajouterBouton(new Bouton("degrad"), (GridBagLayout)serializable2, (GridBagConstraints)serializable);
        ((GridBagConstraints)serializable).insets = new Insets(3, 3, 3, 3);
        this.ajouterBouton(new Bouton("del"), (GridBagLayout)serializable2, (GridBagConstraints)serializable);
        this.ajouterBouton(new Bouton("C"), (GridBagLayout)serializable2, (GridBagConstraints)serializable);
        ((GridBagConstraints)serializable).insets = new Insets(3, 3, 3, 10);
        this.ajouterBouton(new Bouton("AC"), (GridBagLayout)serializable2, (GridBagConstraints)serializable);
        ((GridBagConstraints)serializable).gridwidth = 0;
        ((GridBagConstraints)serializable).insets = new Insets(3, 3, 3, 5);
        this.ajouterBouton(new ImageCanvas(this.logo), (GridBagLayout)serializable2, (GridBagConstraints)serializable);
        ((GridBagConstraints)serializable).gridwidth = 1;
        ((GridBagConstraints)serializable).insets = new Insets(3, 5, 3, 3);
        this.ajouterBouton(new Bouton("expressions"), (GridBagLayout)serializable2, (GridBagConstraints)serializable);
        ((GridBagConstraints)serializable).insets = new Insets(3, 3, 3, 3);
        this.ajouterBouton(new Bouton("("), (GridBagLayout)serializable2, (GridBagConstraints)serializable);
        this.ajouterBouton(new Bouton(")"), (GridBagLayout)serializable2, (GridBagConstraints)serializable);
        ((GridBagConstraints)serializable).insets = new Insets(3, 3, 3, 10);
        this.ajouterBouton(new Bouton(","), (GridBagLayout)serializable2, (GridBagConstraints)serializable);
        ((GridBagConstraints)serializable).gridwidth = 0;
        ((GridBagConstraints)serializable).insets = new Insets(3, 3, 3, 5);
        this.ajouterBouton(new ChoixConstantes(this.mconstantes), (GridBagLayout)serializable2, (GridBagConstraints)serializable);
        ((GridBagConstraints)serializable).gridwidth = 1;
        ((GridBagConstraints)serializable).insets = new Insets(3, 5, 3, 3);
        this.ajouterBouton(new Bouton("RM"), (GridBagLayout)serializable2, (GridBagConstraints)serializable);
        ((GridBagConstraints)serializable).insets = new Insets(3, 3, 3, 3);
        this.ajouterBouton(new Bouton("M"), (GridBagLayout)serializable2, (GridBagConstraints)serializable);
        this.ajouterBouton(new Bouton("Mplus"), (GridBagLayout)serializable2, (GridBagConstraints)serializable);
        ((GridBagConstraints)serializable).insets = new Insets(3, 3, 3, 10);
        ((GridBagConstraints)serializable).gridx = 3;
        ((GridBagConstraints)serializable).gridy = 3;
        this.ajouterBouton(new Bouton("%"), (GridBagLayout)serializable2, (GridBagConstraints)serializable);
        ((GridBagConstraints)serializable).gridx = 0;
        ((GridBagConstraints)serializable).gridy = 4;
        ((GridBagConstraints)serializable).gridwidth = 1;
        ((GridBagConstraints)serializable).insets = new Insets(3, 5, 10, 3);
        this.ajouterBouton(new Bouton("puissanceInverse"), (GridBagLayout)serializable2, (GridBagConstraints)serializable);
        ((GridBagConstraints)serializable).gridx = -1;
        ((GridBagConstraints)serializable).insets = new Insets(3, 3, 10, 3);
        this.ajouterBouton(new Bouton("fact"), (GridBagLayout)serializable2, (GridBagConstraints)serializable);
        this.ajouterBouton(new Bouton("dms"), (GridBagLayout)serializable2, (GridBagConstraints)serializable);
        ((GridBagConstraints)serializable).insets = new Insets(3, 3, 10, 10);
        this.ajouterBouton(new Bouton("signeInverse"), (GridBagLayout)serializable2, (GridBagConstraints)serializable);
        ((GridBagConstraints)serializable).insets = new Insets(8, 3, 5, 3);
        this.ajouterBouton(new Bouton("sin"), (GridBagLayout)serializable2, (GridBagConstraints)serializable);
        ((GridBagConstraints)serializable).gridwidth = 0;
        ((GridBagConstraints)serializable).insets = new Insets(8, 3, 5, 5);
        this.ajouterBouton(new Bouton("asin"), (GridBagLayout)serializable2, (GridBagConstraints)serializable);
        ((GridBagConstraints)serializable).gridy = -1;
        ((GridBagConstraints)serializable).gridwidth = 1;
        ((GridBagConstraints)serializable).insets = new Insets(3, 5, 3, 3);
        this.ajouterBouton(new Bouton("^"), (GridBagLayout)serializable2, (GridBagConstraints)serializable);
        ((GridBagConstraints)serializable).insets = new Insets(3, 3, 3, 3);
        this.ajouterBouton(new Bouton("inverse"), (GridBagLayout)serializable2, (GridBagConstraints)serializable);
        this.ajouterBouton(new Bouton("/"), (GridBagLayout)serializable2, (GridBagConstraints)serializable);
        ((GridBagConstraints)serializable).insets = new Insets(3, 3, 3, 10);
        this.ajouterBouton(new Bouton("*"), (GridBagLayout)serializable2, (GridBagConstraints)serializable);
        ((GridBagConstraints)serializable).insets = new Insets(3, 3, 3, 3);
        this.ajouterBouton(new Bouton("cos"), (GridBagLayout)serializable2, (GridBagConstraints)serializable);
        ((GridBagConstraints)serializable).gridwidth = 0;
        ((GridBagConstraints)serializable).insets = new Insets(3, 3, 3, 5);
        this.ajouterBouton(new Bouton("acos"), (GridBagLayout)serializable2, (GridBagConstraints)serializable);
        ((GridBagConstraints)serializable).gridwidth = 1;
        ((GridBagConstraints)serializable).insets = new Insets(3, 5, 3, 3);
        this.ajouterBouton(new Bouton("7"), (GridBagLayout)serializable2, (GridBagConstraints)serializable);
        ((GridBagConstraints)serializable).insets = new Insets(3, 3, 3, 3);
        this.ajouterBouton(new Bouton("8"), (GridBagLayout)serializable2, (GridBagConstraints)serializable);
        this.ajouterBouton(new Bouton("9"), (GridBagLayout)serializable2, (GridBagConstraints)serializable);
        ((GridBagConstraints)serializable).insets = new Insets(3, 3, 3, 10);
        this.ajouterBouton(new Bouton("-"), (GridBagLayout)serializable2, (GridBagConstraints)serializable);
        ((GridBagConstraints)serializable).insets = new Insets(3, 3, 3, 3);
        this.ajouterBouton(new Bouton("tan"), (GridBagLayout)serializable2, (GridBagConstraints)serializable);
        ((GridBagConstraints)serializable).gridwidth = 0;
        ((GridBagConstraints)serializable).insets = new Insets(3, 3, 3, 5);
        this.ajouterBouton(new Bouton("atan"), (GridBagLayout)serializable2, (GridBagConstraints)serializable);
        ((GridBagConstraints)serializable).gridwidth = 1;
        ((GridBagConstraints)serializable).insets = new Insets(3, 5, 3, 3);
        this.ajouterBouton(new Bouton("4"), (GridBagLayout)serializable2, (GridBagConstraints)serializable);
        ((GridBagConstraints)serializable).insets = new Insets(3, 3, 3, 3);
        this.ajouterBouton(new Bouton("5"), (GridBagLayout)serializable2, (GridBagConstraints)serializable);
        this.ajouterBouton(new Bouton("6"), (GridBagLayout)serializable2, (GridBagConstraints)serializable);
        ((GridBagConstraints)serializable).insets = new Insets(3, 3, 3, 10);
        this.ajouterBouton(new Bouton("+"), (GridBagLayout)serializable2, (GridBagConstraints)serializable);
        ((GridBagConstraints)serializable).insets = new Insets(3, 3, 3, 3);
        this.ajouterBouton(new Bouton("exp"), (GridBagLayout)serializable2, (GridBagConstraints)serializable);
        ((GridBagConstraints)serializable).gridwidth = 0;
        ((GridBagConstraints)serializable).insets = new Insets(3, 3, 3, 5);
        this.ajouterBouton(new Bouton("ln"), (GridBagLayout)serializable2, (GridBagConstraints)serializable);
        ((GridBagConstraints)serializable).gridwidth = 1;
        ((GridBagConstraints)serializable).insets = new Insets(3, 5, 3, 3);
        this.ajouterBouton(new Bouton("1"), (GridBagLayout)serializable2, (GridBagConstraints)serializable);
        ((GridBagConstraints)serializable).insets = new Insets(3, 3, 3, 3);
        this.ajouterBouton(new Bouton("2"), (GridBagLayout)serializable2, (GridBagConstraints)serializable);
        this.ajouterBouton(new Bouton("3"), (GridBagLayout)serializable2, (GridBagConstraints)serializable);
        ((GridBagConstraints)serializable).gridheight = 2;
        ((GridBagConstraints)serializable).gridx = 3;
        ((GridBagConstraints)serializable).gridy = 8;
        ((GridBagConstraints)serializable).insets = new Insets(3, 3, 5, 10);
        this.ajouterBouton(new Bouton("="), (GridBagLayout)serializable2, (GridBagConstraints)serializable);
        ((GridBagConstraints)serializable).gridheight = 1;
        ((GridBagConstraints)serializable).gridx = -1;
        ((GridBagConstraints)serializable).gridy = -1;
        ((GridBagConstraints)serializable).insets = new Insets(3, 3, 3, 3);
        this.ajouterBouton(new Bouton("exp10"), (GridBagLayout)serializable2, (GridBagConstraints)serializable);
        ((GridBagConstraints)serializable).gridwidth = 0;
        ((GridBagConstraints)serializable).insets = new Insets(3, 3, 3, 5);
        this.ajouterBouton(new Bouton("log"), (GridBagLayout)serializable2, (GridBagConstraints)serializable);
        ((GridBagConstraints)serializable).gridx = 0;
        ((GridBagConstraints)serializable).gridy = 9;
        ((GridBagConstraints)serializable).gridwidth = 1;
        ((GridBagConstraints)serializable).insets = new Insets(3, 5, 5, 3);
        this.ajouterBouton(new Bouton("0"), (GridBagLayout)serializable2, (GridBagConstraints)serializable);
        ((GridBagConstraints)serializable).insets = new Insets(3, 3, 5, 3);
        ((GridBagConstraints)serializable).gridx = -1;
        this.ajouterBouton(new Bouton("."), (GridBagLayout)serializable2, (GridBagConstraints)serializable);
        ((GridBagConstraints)serializable).insets = new Insets(3, 3, 5, 5);
        this.ajouterBouton(new Bouton("E"), (GridBagLayout)serializable2, (GridBagConstraints)serializable);
        ((GridBagConstraints)serializable).gridx = 4;
        ((GridBagConstraints)serializable).insets = new Insets(3, 3, 5, 3);
        this.ajouterBouton(new Bouton("sqr"), (GridBagLayout)serializable2, (GridBagConstraints)serializable);
        ((GridBagConstraints)serializable).gridx = -1;
        ((GridBagConstraints)serializable).gridwidth = 0;
        ((GridBagConstraints)serializable).insets = new Insets(3, 3, 5, 5);
        this.ajouterBouton(new Bouton("sqrt"), (GridBagLayout)serializable2, (GridBagConstraints)serializable);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                if (CalcoFrame.this.appliquette) {
                    CalcoFrame.this.dispose();
                } else {
                    System.exit(0);
                }
            }
        });
        this.addKeyListener(this);
        this.addComponentListener(this);
        this.pack();
        Dimension dimension = this.getSize();
        Dimension dimension2 = this.getToolkit().getScreenSize();
        ((Component)this).setLocation((dimension2.width - dimension.width) / 2, (dimension2.height - dimension.height) / 2);
        this.fond = this.creerFond(dimension.width, dimension.height);
        this.validate();
    }

    public void ajouterBouton(Component component, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints) {
        gridBagLayout.setConstraints(component, gridBagConstraints);
        component.addKeyListener(this);
        this.add(component);
    }

    public String versString(double d) {
        int n;
        String string;
        int n2 = 10;
        int n3 = 3;
        if (d == 0.0) {
            return "0";
        }
        String string2 = "" + d;
        if ("Infinity".equals(string2) || "-Infinity".equals(string2) || "NaN".equals(string2)) {
            return "" + d;
        }
        if (d >= 0.0) {
            string = "";
        } else {
            d = -d;
            string = "-";
        }
        int n4 = (int)Math.floor(Math.log(d) / Math.log(10.0));
        double d2 = Math.pow(10.0, n2);
        double d3 = d / Math.pow(10.0, n4);
        d3 = Math.rint(d3 * d2) / d2;
        if (d3 >= 10.0) {
            d3 = d / Math.pow(10.0, ++n4);
            d3 = Math.rint(d3 * d2) / d2;
        }
        String string3 = "";
        int n5 = (int)Math.floor(d3);
        string3 = string3 + n5 + ".";
        for (n = 0; n < n2 - 1; ++n) {
            d3 = (d3 - (double)n5) * 10.0;
            double d4 = Math.pow(10.0, n2 - n);
            d3 = Math.rint(d3 * d2) / d2;
            n5 = (int)Math.floor(d3);
            string3 = string3 + n5;
        }
        d3 = (d3 - (double)n5) * 10.0;
        n5 = (int)Math.round(d3);
        string3 = string3 + n5;
        n = string3.charAt(string3.length() - 1);
        while (n == 48) {
            string3 = string3.substring(0, string3.length() - 1);
            n = string3.charAt(string3.length() - 1);
        }
        if (n4 != 0) {
            if (n4 > 0 && n4 < n3) {
                String string4 = string3.substring(0, 1);
                if (string3.length() - 2 < n4) {
                    if (string3.length() > 2) {
                        string4 = string4 + string3.substring(2, string3.length());
                    }
                    for (int i = 0; i < n4 - (string3.length() - 2); ++i) {
                        string4 = string4 + '0';
                    }
                } else {
                    string4 = string3.length() < n4 + 2 ? string4 + string3.substring(2) : string4 + string3.substring(2, n4 + 2) + "." + string3.substring(n4 + 2);
                }
                string3 = string4;
            } else if (n4 < 0 && n4 > -n3) {
                String string5 = "0.";
                for (int i = 0; i < -n4 - 1; ++i) {
                    string5 = string5 + '0';
                }
                string3 = string5 + string3.charAt(0) + string3.substring(2);
            } else {
                string3 = string3 + "E" + n4;
            }
        }
        if (string3.charAt(string3.length() - 1) == '.') {
            string3 = string3.substring(0, string3.length() - 1);
        }
        string3 = string + string3;
        return string3;
    }

    public void operation(Truc truc) {
        if (truc instanceof Lettre && "=".equals(((Lettre)truc).getNom())) {
            if (this.modeExpressions) {
                Double d = this.calculer(this.valeurAffichee);
                if (d == null) {
                    this.valeurAffichee = "erreur";
                } else {
                    this.valeur1 = d;
                    this.valeurAffichee = this.versString(this.valeur1);
                    this.expressionCachee = "" + this.valeur1;
                }
                this.valeur2 = 0.0;
                this.opCourante = null;
                this.edit = false;
            } else {
                try {
                    if (this.edit) {
                        this.valeur1 = new Double(this.valeurAffichee);
                        this.expressionCachee = this.expressionCachee + this.valeur1;
                        if (this.opCourante != null && !this.opCourante.estOperateur()) {
                            this.expressionCachee = this.expressionCachee + ')';
                        }
                    }
                    if (this.opCourante != null) {
                        Double d = this.calculer(this.expressionCachee);
                        if (d == null) {
                            this.valeurAffichee = "erreur";
                        } else {
                            this.valeur1 = d;
                            this.valeurAffichee = this.versString(this.valeur1);
                        }
                    }
                    this.expressionCachee = "" + this.valeur1;
                    this.valeur2 = 0.0;
                    this.opCourante = null;
                    this.edit = false;
                }
                catch (NumberFormatException numberFormatException) {
                    Toolkit.getDefaultToolkit().beep();
                    System.err.println("NumberFormatException: " + numberFormatException.getMessage());
                }
            }
        } else if (truc instanceof Lettre) {
            String string = ((Lettre)truc).getNom();
            if (!this.modeExpressions && ")".equals(string) && this.edit) {
                try {
                    this.valeur1 = new Double(this.valeurAffichee);
                    this.expressionCachee = this.expressionCachee + this.valeur1;
                }
                catch (NumberFormatException numberFormatException) {
                    Toolkit.getDefaultToolkit().beep();
                    System.err.println("NumberFormatException: " + numberFormatException.getMessage());
                }
            }
            if (!this.edit) {
                this.valeurAffichee = "";
                if (this.opCourante == null) {
                    this.expressionCachee = "";
                }
                this.edit = true;
            }
            if (!this.modeExpressions && ("(".equals(string) || ")".equals(string))) {
                if (")".equals(string)) {
                    this.valeurAffichee = "";
                    this.edit = false;
                }
                this.expressionCachee = this.expressionCachee + string;
            }
            if (this.modeExpressions || !"(".equals(string) && !")".equals(string)) {
                this.valeurAffichee = this.valeurAffichee + string;
            }
        } else if (truc instanceof Special) {
            ((Special)truc).executer();
        } else if (truc instanceof Fonction) {
            Fonction fonction = (Fonction)truc;
            if (this.modeExpressions) {
                if (!this.edit && !fonction.estOperateur()) {
                    this.valeurAffichee = "";
                }
                this.valeurAffichee = this.valeurAffichee + fonction.getNom();
                if (!fonction.estOperateur()) {
                    this.valeurAffichee = this.valeurAffichee + "(";
                }
                this.edit = true;
            } else if (("-".equals(fonction.getNom()) || "signeInverse".equals(fonction.getNom())) && this.valeurAffichee.endsWith("E") && this.edit) {
                this.valeurAffichee = this.valeurAffichee + "-";
            } else {
                try {
                    if (this.edit) {
                        try {
                            this.valeur1 = new Double(this.valeurAffichee);
                        }
                        catch (NumberFormatException numberFormatException) {
                            Toolkit.getDefaultToolkit().beep();
                            System.err.println("NumberFormatException: " + numberFormatException.getMessage());
                        }
                    }
                    if (fonction.getNbParams() == 0) {
                        this.valeur1 = fonction.evaluer(0.0, 0.0);
                        this.valeurAffichee = this.versString(this.valeur1);
                        if (!this.edit && this.opCourante == null) {
                            this.expressionCachee = "";
                        }
                        this.edit = true;
                    } else if (fonction.getNbParams() == 1) {
                        this.valeur1 = fonction.evaluer(this.valeur1, 0.0);
                        this.valeurAffichee = this.versString(this.valeur1);
                        if (!this.edit) {
                            this.expressionCachee = "" + this.valeur1;
                        }
                    } else {
                        this.expressionCachee = fonction.estOperateur() ? (this.edit ? this.expressionCachee + this.valeur1 + fonction.getNom() : this.expressionCachee + fonction.getNom()) : (this.edit ? this.expressionCachee + fonction.getNom() + '(' + this.valeur1 + ',' : fonction.getNom() + '(' + this.expressionCachee + ',');
                        this.valeur2 = this.valeur1;
                        this.opCourante = fonction;
                        this.edit = false;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    System.err.println("NumberFormatException: " + numberFormatException.getMessage());
                }
            }
        }
        this.affichage.repaint();
    }

    public Dimension getMinimumSize() {
        Dimension dimension = super.getMinimumSize();
        if (dimension.width < 227) {
            dimension.width = 227;
        }
        if (dimension.height < 341) {
            dimension.height = 341;
        }
        return dimension;
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public void paint(Graphics graphics) {
        graphics.drawImage(this.fond, 0, 0, null);
        super.paint(graphics);
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public Image creerFond(int n, int n2) {
        int n3;
        int[] nArray = new int[n * n2];
        int n4 = 50;
        double[] dArray = new double[n4];
        double[] dArray2 = new double[n4];
        double[] dArray3 = new double[n];
        double d = 0.0;
        int n5 = 20;
        for (n3 = 0; n3 < n4; ++n3) {
            dArray[n3] = Math.random() / 3.0;
        }
        for (n3 = 0; n3 < n4; ++n3) {
            dArray2[n3] = n4 / 2 - Math.abs(n3 - n4 / 2);
            d += dArray2[n3];
        }
        for (n3 = 0; n3 < n; ++n3) {
            dArray3[n3] = (double)(n / 2 - Math.abs(n3 - n / 2)) / (1.0 * (double)n / 2.0) / 4.0 + 0.75;
        }
        n3 = 0;
        for (int i = 0; i < n2; ++i) {
            int n6;
            if (i < n5) {
                for (n6 = 0; n6 < n; ++n6) {
                    int n7;
                    double d2 = 0.0;
                    for (n7 = 0; n7 < n4; ++n7) {
                        d2 += dArray[n7] * dArray2[n7];
                    }
                    n7 = (int)Math.round(255.0 * (1.0 - d2 / d) * dArray3[n6]);
                    nArray[n3++] = 0xFF000000 | n7 << 16 | n7 << 8 | n7;
                    for (int j = 0; j < n4 - 1; ++j) {
                        dArray[j] = dArray[j + 1];
                    }
                    dArray[n4 - 1] = Math.random() / 3.0;
                }
                continue;
            }
            for (n6 = 0; n6 < n; ++n6) {
                int n8 = (int)Math.floor(((double)i / (1.0 * (double)n5) - (double)(i / n5)) * (double)n5);
                nArray[n3++] = nArray[n6 + n8 * n];
            }
        }
        return this.createImage(new MemoryImageSource(n, n2, nArray, 0, n));
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentResized(ComponentEvent componentEvent) {
        Dimension dimension = this.getSize();
        this.fond = this.creerFond(dimension.width, dimension.height);
        this.repaint();
    }

    public void componentShown(ComponentEvent componentEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
        if (keyEvent.getKeyChar() == ',') {
            this.touche('.');
        } else {
            this.touche(keyEvent.getKeyChar());
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        if (n == 10 || n == 0) {
            this.touche('=');
        }
    }

    public void touche(char c) {
        String string = "" + c;
        Truc truc = null;
        for (int i = 0; i < this.trucs.size(); ++i) {
            if (!((Truc)this.trucs.elementAt(i)).getNom().equals(string)) continue;
            truc = (Truc)this.trucs.elementAt(i);
            break;
        }
        if (truc != null) {
            this.operation(truc);
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public Fonction obtenirFonction(String string) {
        Truc truc = null;
        for (int i = 0; i < this.trucs.size(); ++i) {
            if (!((Truc)this.trucs.elementAt(i)).getNom().equals(string)) continue;
            truc = (Truc)this.trucs.elementAt(i);
            break;
        }
        if (truc == null) {
            System.err.println("op\u00e9ration non trouv\u00e9e: " + string);
            return null;
        }
        if (!(truc instanceof Fonction)) {
            System.err.println("op\u00e9ration de mauvais type: " + string);
            return null;
        }
        return (Fonction)truc;
    }

    public Double calculer(String string) {
        if ("".equals(string)) {
            return null;
        }
        string = this.ajParentheses(string);
        Parametre parametre = this.parser(string);
        Double d = parametre.evaluer();
        return d;
    }

    public String ajParentheses(String string) {
        String string2 = "^/*-+";
        for (int i = 0; i < string2.length(); ++i) {
            char c = string2.charAt(i);
            int n = string.indexOf(c);
            if (n > 0 && "^*/-+E".indexOf(string.charAt(n - 1)) != -1) {
                n = -1;
            }
            int n2 = n;
            int n3 = 32;
            int n4 = 32;
            while (n2 != -1) {
                int n5;
                boolean bl = false;
                int n6 = n - 1;
                if (n6 >= 0) {
                    n3 = string.charAt(n6);
                }
                int n7 = 0;
                while (n6 >= 0 && (n7 != 0 || n3 != 40) && (n7 != 0 || string2.indexOf(n3) == -1 || n6 > 0 && "^*/-+E".indexOf(string.charAt(n6 - 1)) != -1)) {
                    if (n3 == 41) {
                        ++n7;
                    } else if (n3 == 40) {
                        --n7;
                    }
                    if (--n6 < 0) continue;
                    n3 = string.charAt(n6);
                }
                if (n6 < 0 || string2.indexOf(n3) != -1) {
                    bl = true;
                }
                if ((n5 = n + 1) >= 0) {
                    n4 = string.charAt(n5);
                }
                n7 = 0;
                while (n5 < string.length() && (n7 != 0 || n4 != 41) && (n7 != 0 || string2.indexOf(n4) == -1 || n5 > 0 && "^*/-+E".indexOf(string.charAt(n5 - 1)) != -1)) {
                    if (n4 == 40) {
                        ++n7;
                    } else if (n4 == 41) {
                        --n7;
                    }
                    if (++n5 >= string.length()) continue;
                    n4 = string.charAt(n5);
                }
                if (n5 >= string.length() || string2.indexOf(n4) != -1) {
                    bl = true;
                }
                if (bl) {
                    string = string.substring(0, n6 + 1) + "(" + string.substring(n6 + 1, n5) + ")" + string.substring(n5);
                    ++n;
                }
                n2 = string.substring(n + 1).indexOf(c);
                n = n2 + n + 1;
            }
        }
        return string;
    }

    public Parametre parser(String string) {
        int n;
        String string2 = "^/*-+";
        if (string.charAt(0) == '(' && string.charAt(string.length() - 1) == ')') {
            string = string.substring(1, string.length() - 1);
        }
        int n2 = -1;
        int n3 = 0;
        for (n = 0; n < string.length(); ++n) {
            if (n3 == 0 && string2.indexOf(string.charAt(n)) != -1 && (n == 0 || "^*/-+E".indexOf(string.charAt(n - 1)) == -1)) {
                n2 = n;
                break;
            }
            if (string.charAt(n) == '(') {
                ++n3;
                continue;
            }
            if (string.charAt(n) != ')') continue;
            --n3;
        }
        if (n2 == -1) {
            int n4;
            n = 1;
            for (n4 = 0; n4 < string.length(); ++n4) {
                if ("0123456789.,E-+ ".indexOf(string.charAt(n4)) != -1) continue;
                n = 0;
                break;
            }
            if (n != 0) {
                double d;
                try {
                    d = new Double(string);
                }
                catch (NumberFormatException numberFormatException) {
                    d = 0.0;
                }
                return new Nombre(d);
            }
            n4 = string.indexOf(40);
            if (n4 != -1 && string.charAt(string.length() - 1) == ')') {
                Fonction fonction = this.obtenirFonction(string.substring(0, n4));
                int n5 = 0;
                Parametre parametre = null;
                Parametre parametre2 = null;
                n5 = (string = string.substring(n4 + 1, string.length() - 1)).indexOf(44);
                if (n5 != -1) {
                    parametre = this.parser(string.substring(0, n5).trim());
                    string = string.substring(n5 + 1);
                    parametre2 = this.parser(string.trim());
                } else {
                    parametre = this.parser(string.trim());
                }
                return new Expression(fonction, parametre, parametre2);
            }
            return new Variable(string);
        }
        Fonction fonction = this.obtenirFonction("" + string.charAt(n2));
        String string3 = string.substring(0, n2).trim();
        if ("".equals(string3)) {
            string3 = "0";
        }
        Parametre parametre = this.parser(string3);
        String string4 = string.substring(n2 + 1).trim();
        Parametre parametre3 = this.parser(string4);
        return new Expression(fonction, parametre, parametre3);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static interface Parametre {
        public Double evaluer();
    }

    class Nombre
    implements Parametre {
        double valeur;

        public Nombre(double d) {
            this.valeur = d;
        }

        public Double evaluer() {
            return new Double(this.valeur);
        }
    }

    class Variable
    implements Parametre {
        String nom;

        public Variable(String string) {
            this.nom = string;
        }

        public Double evaluer() {
            Constante constante = CalcoFrame.this.mconstantes.getConstante(this.nom);
            if (constante != null) {
                return new Double(constante.getValeur());
            }
            return null;
        }
    }

    class Expression
    implements Parametre {
        Fonction fct;
        Parametre p1;
        Parametre p2;

        public Expression(Fonction fonction, Parametre parametre, Parametre parametre2) {
            this.fct = fonction;
            this.p1 = parametre;
            this.p2 = parametre2;
        }

        public Double evaluer() {
            if (this.fct == null) {
                return null;
            }
            if (this.p2 == null) {
                Double d = this.p1.evaluer();
                if (d == null) {
                    return null;
                }
                return new Double(this.fct.evaluer(d, 0.0));
            }
            Double d = this.p1.evaluer();
            Double d2 = this.p2.evaluer();
            if (d == null || d2 == null) {
                return null;
            }
            return new Double(this.fct.evaluer(d, d2));
        }
    }

    class ChoixConstantes
    extends Canvas
    implements ActionListener {
        PopupMenu popup;
        boolean appui = false;
        MenuConst menuconst;

        public ChoixConstantes(MenuConst menuConst) {
            this.menuconst = menuConst;
            this.popup = new PopupMenu();
            menuConst.creerMenu(this.popup, this);
            this.enableEvents(16L);
            this.add(this.popup);
        }

        public void paint(Graphics graphics) {
            String string = this.menuconst.getTitre();
            Dimension dimension = this.getSize();
            Rectangle rectangle = new Rectangle(dimension.width, dimension.height);
            graphics.setColor(CalcoFrame.this.grisfonce2);
            graphics.drawRect(rectangle.x + 1, rectangle.y + 1, rectangle.width - 2, rectangle.height - 2);
            if (this.appui) {
                graphics.setColor(Color.black);
            } else {
                graphics.setColor(Color.white);
            }
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width - 2, rectangle.height - 2);
            if (this.appui) {
                graphics.setColor(Color.white);
            } else {
                graphics.setColor(Color.black);
            }
            graphics.setFont(CalcoFrame.this.policeBoutons);
            FontMetrics fontMetrics = graphics.getFontMetrics();
            int n = fontMetrics.getHeight();
            int n2 = fontMetrics.stringWidth(string);
            graphics.drawString(string, (rectangle.width - n2) / 2 - 5, (rectangle.height + n) / 2);
            graphics.setColor(CalcoFrame.this.grisfonce1);
            graphics.drawRect(rectangle.x, rectangle.y, rectangle.width - 2, rectangle.height - 2);
        }

        public void processMouseEvent(MouseEvent mouseEvent) {
            if (mouseEvent.getID() == 501) {
                this.popup.show(this, mouseEvent.getX(), mouseEvent.getY());
            } else {
                super.processMouseEvent(mouseEvent);
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            Constante constante = this.menuconst.getConstante(string);
            if (constante == null) {
                return;
            }
            if (CalcoFrame.this.modeExpressions) {
                if (CalcoFrame.this.edit) {
                    CalcoFrame.this.valeurAffichee = CalcoFrame.this.valeurAffichee + string;
                } else {
                    CalcoFrame.this.valeurAffichee = string;
                    CalcoFrame.this.edit = true;
                }
            } else {
                CalcoFrame.this.valeur1 = constante.getValeur();
                CalcoFrame.this.valeurAffichee = CalcoFrame.this.versString(CalcoFrame.this.valeur1);
                CalcoFrame.this.edit = true;
            }
            CalcoFrame.this.requestFocus();
            CalcoFrame.this.affichage.repaint();
            Component[] componentArray = CalcoFrame.this.getComponents();
            for (int i = 0; i < componentArray.length; ++i) {
                if (!(componentArray[i] instanceof Canvas)) continue;
                ((Canvas)componentArray[i]).repaint();
            }
        }

        public Dimension getMinimumSize() {
            return new Dimension(60, 30);
        }

        public Dimension getPreferredSize() {
            return this.getMinimumSize();
        }
    }

    class MenuConst {
        String titre;
        Vector constantes;

        public MenuConst(String string) {
            this.titre = string;
            this.constantes = new Vector();
        }

        public String getTitre() {
            return this.titre;
        }

        public void ajouter(String string, String string2, double d) {
            this.constantes.addElement(new Constante(string, string2, d));
        }

        public void ajouter(MenuConst menuConst) {
            this.constantes.addElement(menuConst);
        }

        public void creerMenu(Menu menu, ActionListener actionListener) {
            for (int i = 0; i < this.constantes.size(); ++i) {
                MenuItem menuItem;
                Object object;
                if (this.constantes.elementAt(i) instanceof Constante) {
                    object = (Constante)this.constantes.elementAt(i);
                    menuItem = new MenuItem(((Constante)object).getTitre());
                    menuItem.addActionListener(actionListener);
                    menuItem.setActionCommand(((Constante)object).getNom());
                    menu.add(menuItem);
                    continue;
                }
                if (!(this.constantes.elementAt(i) instanceof MenuConst)) continue;
                object = (MenuConst)this.constantes.elementAt(i);
                menuItem = new Menu(((MenuConst)object).getTitre());
                ((MenuConst)object).creerMenu((Menu)menuItem, actionListener);
                menu.add(menuItem);
            }
        }

        public Constante getConstante(String string) {
            for (int i = 0; i < this.constantes.size(); ++i) {
                Constante constante;
                Object object;
                if (this.constantes.elementAt(i) instanceof Constante) {
                    object = (Constante)this.constantes.elementAt(i);
                    if (!string.equals(((Constante)object).getNom())) continue;
                    return object;
                }
                if (!(this.constantes.elementAt(i) instanceof MenuConst) || (constante = ((MenuConst)(object = (MenuConst)this.constantes.elementAt(i))).getConstante(string)) == null) continue;
                return constante;
            }
            return null;
        }
    }

    class Constante {
        String nom;
        String titre;
        double valeur;

        public Constante(String string, String string2, double d) {
            this.nom = string;
            this.titre = string2;
            this.valeur = d;
        }

        public String getNom() {
            return this.nom;
        }

        public String getTitre() {
            return this.titre;
        }

        public double getValeur() {
            return this.valeur;
        }
    }

    class RacineCarree
    extends Fonction {
        public RacineCarree() {
            super("sqrt", "\u221a", false, 1);
        }

        public double evaluer(double d, double d2) {
            return Math.sqrt(d);
        }
    }

    class Carre
    extends Fonction {
        public Carre() {
            super("sqr", "x<sup>2</sup>", false, 1);
        }

        public double evaluer(double d, double d2) {
            return d * d;
        }
    }

    class LogarithmeDecimal
    extends Fonction {
        public LogarithmeDecimal() {
            super("log", "log", false, 1);
        }

        public double evaluer(double d, double d2) {
            return Math.log(d) / Math.log(10.0);
        }
    }

    class Exp10
    extends Fonction {
        public Exp10() {
            super("exp10", "10<sup>x</sup>", false, 1);
        }

        public double evaluer(double d, double d2) {
            return Math.pow(10.0, d);
        }
    }

    class LogarithmeNeperien
    extends Fonction {
        public LogarithmeNeperien() {
            super("ln", "ln", false, 1);
        }

        public double evaluer(double d, double d2) {
            return Math.log(d);
        }
    }

    class Exponentielle
    extends Fonction {
        public Exponentielle() {
            super("exp", "e<sup>x</sup>", false, 1);
        }

        public double evaluer(double d, double d2) {
            return Math.exp(d);
        }
    }

    class ArcTangente
    extends Fonction {
        public ArcTangente() {
            super("atan", "tan<sup>-1</sup>", false, 1);
        }

        public double evaluer(double d, double d2) {
            if (CalcoFrame.this.degrad.equals("rad")) {
                return Math.atan(d);
            }
            return Math.atan(d) * 180.0 / Math.PI;
        }
    }

    class Tangente
    extends Fonction {
        public Tangente() {
            super("tan", "tan", false, 1);
        }

        public double evaluer(double d, double d2) {
            if (CalcoFrame.this.degrad.equals("rad")) {
                return Math.tan(d);
            }
            return Math.tan(d / 180.0 * Math.PI);
        }
    }

    class ArcCosinus
    extends Fonction {
        public ArcCosinus() {
            super("acos", "cos<sup>-1</sup>", false, 1);
        }

        public double evaluer(double d, double d2) {
            if (CalcoFrame.this.degrad.equals("rad")) {
                return Math.acos(d);
            }
            return Math.acos(d) * 180.0 / Math.PI;
        }
    }

    class Cosinus
    extends Fonction {
        public Cosinus() {
            super("cos", "cos", false, 1);
        }

        public double evaluer(double d, double d2) {
            if (CalcoFrame.this.degrad.equals("rad")) {
                return Math.cos(d);
            }
            return Math.cos(d / 180.0 * Math.PI);
        }
    }

    class ArcSinus
    extends Fonction {
        public ArcSinus() {
            super("asin", "sin<sup>-1</sup>", false, 1);
        }

        public double evaluer(double d, double d2) {
            if (CalcoFrame.this.degrad.equals("rad")) {
                return Math.asin(d);
            }
            return Math.asin(d) * 180.0 / Math.PI;
        }
    }

    class Sinus
    extends Fonction {
        public Sinus() {
            super("sin", "sin", false, 1);
        }

        public double evaluer(double d, double d2) {
            if (CalcoFrame.this.degrad.equals("rad")) {
                return Math.sin(d);
            }
            return Math.sin(d / 180.0 * Math.PI);
        }
    }

    class AC
    extends Special {
        public AC() {
            super("AC", "AC");
        }

        public void executer() {
            CalcoFrame.this.valeur1 = 0.0;
            CalcoFrame.this.valeurAffichee = "0";
            CalcoFrame.this.valeur2 = 0.0;
            CalcoFrame.this.opCourante = null;
            CalcoFrame.this.edit = false;
            CalcoFrame.this.expressionCachee = "";
        }
    }

    class C
    extends Special {
        public C() {
            super("C", "C");
        }

        public void executer() {
            CalcoFrame.this.valeur1 = 0.0;
            CalcoFrame.this.valeurAffichee = "0";
            CalcoFrame.this.edit = false;
        }
    }

    class Del
    extends Special {
        public Del() {
            super("del", "del");
        }

        public void executer() {
            if (CalcoFrame.this.valeurAffichee.length() > 0) {
                CalcoFrame.this.valeurAffichee = CalcoFrame.this.valeurAffichee.substring(0, CalcoFrame.this.valeurAffichee.length() - 1);
            }
        }
    }

    class DegRad
    extends Special {
        public DegRad() {
            super("degrad", "deg");
        }

        public void executer() {
            this.titre = CalcoFrame.this.degrad;
            if ("rad".equals(CalcoFrame.this.degrad)) {
                CalcoFrame.this.degrad = "deg";
            } else {
                CalcoFrame.this.degrad = "rad";
            }
        }
    }

    class DMS
    extends Special {
        public DMS() {
            super("dms", "\u00b0 ' \"");
        }

        public void executer() {
            if (CalcoFrame.this.valeurAffichee.indexOf(176) != -1) {
                CalcoFrame.this.valeurAffichee = CalcoFrame.this.versString(CalcoFrame.this.valeur1);
            } else {
                try {
                    if (CalcoFrame.this.edit) {
                        CalcoFrame.this.valeur1 = new Double(CalcoFrame.this.valeurAffichee);
                    }
                    String string = "+";
                    if (CalcoFrame.this.valeur1 < 0.0) {
                        string = "-";
                        CalcoFrame.this.valeur1 = -CalcoFrame.this.valeur1;
                    }
                    int n = (int)Math.floor(CalcoFrame.this.valeur1);
                    double d = (CalcoFrame.this.valeur1 - (double)n) * 60.0;
                    int n2 = (int)Math.floor(d);
                    double d2 = Math.rint((d - (double)n2) * 60.0 * 100.0) / 100.0;
                    CalcoFrame.this.valeurAffichee = string + n + "\u00b0 " + n2 + "' " + d2 + "\"";
                    CalcoFrame.this.edit = false;
                    if ("-".equals(string)) {
                        CalcoFrame.this.valeur1 = -CalcoFrame.this.valeur1;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    System.err.println("NumberFormatException: " + numberFormatException.getMessage());
                }
            }
        }
    }

    class SigneInverse
    extends Fonction {
        public SigneInverse() {
            super("signeInverse", "\u00b1", false, 1);
        }

        public double evaluer(double d, double d2) {
            return -d;
        }
    }

    class Expressions
    extends Special {
        public Expressions() {
            super("expressions", "expr");
        }

        public void executer() {
            CalcoFrame.this.modeExpressions = !CalcoFrame.this.modeExpressions;
        }
    }

    class Pourcent
    extends Special {
        public Pourcent() {
            super("%", "%");
        }

        public void executer() {
            try {
                if (CalcoFrame.this.edit) {
                    CalcoFrame.this.valeur1 = new Double(CalcoFrame.this.valeurAffichee);
                }
                if (CalcoFrame.this.opCourante != null) {
                    CalcoFrame.this.valeur1 = CalcoFrame.this.opCourante.evaluer(CalcoFrame.this.valeur2, CalcoFrame.this.valeur1 * CalcoFrame.this.valeur2 / 100.0);
                } else {
                    CalcoFrame.this.valeur1 = CalcoFrame.this.valeur1 / 100.0;
                }
                CalcoFrame.this.valeurAffichee = CalcoFrame.this.versString(CalcoFrame.this.valeur1);
                CalcoFrame.this.expressionCachee = "" + CalcoFrame.this.valeur1;
                CalcoFrame.this.valeur2 = 0.0;
                CalcoFrame.this.opCourante = null;
                CalcoFrame.this.edit = false;
            }
            catch (NumberFormatException numberFormatException) {
                System.err.println("NumberFormatException: " + numberFormatException.getMessage());
            }
        }
    }

    class RM
    extends Fonction {
        public RM() {
            super("RM", "RM", false, 0);
        }

        public double evaluer(double d, double d2) {
            return CalcoFrame.this.memoire;
        }
    }

    class Mplus
    extends Fonction {
        public Mplus() {
            super("Mplus", "M+", false, 1);
        }

        public double evaluer(double d, double d2) {
            CalcoFrame.this.memoire += d;
            return d;
        }
    }

    class M
    extends Fonction {
        public M() {
            super("M", "M", false, 1);
        }

        public double evaluer(double d, double d2) {
            CalcoFrame.this.memoire = d;
            return d;
        }
    }

    class Factorielle
    extends Fonction {
        public Factorielle() {
            super("fact", "x!", false, 1);
        }

        public double evaluer(double d, double d2) {
            if (Math.floor(d) == d) {
                double d3;
                for (d3 = d; d > 2.0 && d3 != Double.POSITIVE_INFINITY; d3 *= d - 1.0, d -= 1.0) {
                }
                return d3;
            }
            return d;
        }
    }

    class PuissanceInverse
    extends Fonction {
        public PuissanceInverse() {
            super("puissanceInverse", "x<sup>1/n</sup>", false, 2);
        }

        public double evaluer(double d, double d2) {
            return Math.pow(d, 1.0 / d2);
        }
    }

    class Inverse
    extends Fonction {
        public Inverse() {
            super("inverse", "1/x", false, 1);
        }

        public double evaluer(double d, double d2) {
            return 1.0 / d;
        }
    }

    class Puissance
    extends Fonction {
        public Puissance() {
            super("^", "^", true, 2);
        }

        public double evaluer(double d, double d2) {
            return Math.pow(d, d2);
        }
    }

    class Division
    extends Fonction {
        public Division() {
            super("/", "/", true, 2);
        }

        public double evaluer(double d, double d2) {
            return d / d2;
        }
    }

    class Multiplication
    extends Fonction {
        public Multiplication() {
            super("*", "*", true, 2);
        }

        public double evaluer(double d, double d2) {
            return d * d2;
        }
    }

    class Soustraction
    extends Fonction {
        public Soustraction() {
            super("-", "-", true, 2);
        }

        public double evaluer(double d, double d2) {
            return d - d2;
        }
    }

    class Addition
    extends Fonction {
        public Addition() {
            super("+", "+", true, 2);
        }

        public double evaluer(double d, double d2) {
            return d + d2;
        }
    }

    class Lettre
    extends Truc {
        public Lettre(char c) {
            super("" + c, "" + c);
        }
    }

    abstract class Special
    extends Truc {
        public Special(String string, String string2) {
            super(string, string2);
        }

        public abstract void executer();
    }

    abstract class Fonction
    extends Truc {
        boolean operateur;
        int nbparams;

        public Fonction(String string, String string2, boolean bl, int n) {
            super(string, string2);
            this.operateur = bl;
            this.nbparams = n;
        }

        public boolean estOperateur() {
            return this.operateur;
        }

        public int getNbParams() {
            return this.nbparams;
        }

        public abstract double evaluer(double var1, double var3);
    }

    abstract class Truc {
        String nom;
        String titre;

        public Truc(String string, String string2) {
            this.nom = string;
            this.titre = string2;
        }

        public String getNom() {
            return this.nom;
        }

        public String getTitre() {
            return this.titre;
        }
    }

    class ImageCanvas
    extends Canvas {
        Image img;

        public ImageCanvas(Image image) {
            this.img = image;
        }

        public void paint(Graphics graphics) {
            Dimension dimension = this.getSize();
            graphics.drawImage(this.img, 0, 0, dimension.width, dimension.height, null);
        }

        public Dimension getMinimumSize() {
            return new Dimension(60, 30);
        }

        public Dimension getPreferredSize() {
            return this.getMinimumSize();
        }
    }

    class Bouton
    extends Canvas
    implements MouseListener {
        Truc truc = null;
        boolean appui = false;
        final int esp = 0;
        final int rr = 7;

        public Bouton(String string) {
            for (int i = 0; i < CalcoFrame.this.trucs.size(); ++i) {
                if (!((Truc)CalcoFrame.this.trucs.elementAt(i)).getNom().equals(string)) continue;
                this.truc = (Truc)CalcoFrame.this.trucs.elementAt(i);
                break;
            }
            if (this.truc == null) {
                System.err.println("op\u00e9ration non trouv\u00e9e: " + string);
            }
            this.addMouseListener(this);
        }

        public void paint(Graphics graphics) {
            if (this.truc == null) {
                return;
            }
            if (this.truc.getTitre() == null) {
                System.err.println("Le titre est null pour " + this.truc.getNom() + " !");
            }
            Dimension dimension = this.getSize();
            Rectangle rectangle = new Rectangle(dimension.width, dimension.height);
            graphics.setColor(Color.lightGray);
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            graphics.setColor(CalcoFrame.this.grisfonce2);
            graphics.drawRoundRect(rectangle.x + 1 + 0, rectangle.y + 1 + 0, rectangle.width - 2 - 0, rectangle.height - 2 - 0, 7, 7);
            if (this.appui) {
                graphics.setColor(CalcoFrame.this.grisclair3);
            } else {
                graphics.setColor(Color.white);
            }
            graphics.fillRoundRect(rectangle.x + 0, rectangle.y + 0, rectangle.width - 2 - 0, rectangle.height - 2 - 0, 7, 7);
            if (this.appui) {
                graphics.setColor(CalcoFrame.this.grisclair1);
            } else {
                graphics.setColor(CalcoFrame.this.grisclair4);
            }
            graphics.fillRoundRect(rectangle.x + 0, rectangle.y + 0 + 5, rectangle.width - 2 - 0, rectangle.height - 2 - 0 - 10, 7, 7);
            if (this.appui) {
                graphics.setColor(CalcoFrame.this.grisclair2);
            } else {
                graphics.setColor(CalcoFrame.this.grisclair5);
            }
            graphics.fillRoundRect(rectangle.x + 0, rectangle.y + 0, rectangle.width - 2 - 0, rectangle.y + 0 + 5, 7, 7);
            graphics.setColor(Color.black);
            String string = this.truc.getTitre();
            if ("\u221a".equals(string)) {
                int n = (rectangle.x + rectangle.width) / 2;
                int n2 = (rectangle.y + rectangle.height) / 2;
                graphics.drawLine(n - 9, n2, n - 8, n2);
                graphics.drawLine(n - 8, n2, n - 4, n2 + 8);
                graphics.drawLine(n - 4, n2 + 8, n, n2 - 8);
                graphics.drawLine(n, n2 - 8, n + 8, n2 - 8);
                graphics.drawLine(n + 8, n2 - 8, n + 8, n2 - 7);
            } else {
                graphics.setFont(CalcoFrame.this.policeBoutons);
                FontMetrics fontMetrics = graphics.getFontMetrics();
                int n = fontMetrics.getHeight();
                int n3 = string.indexOf("<sup>");
                if (n3 == -1) {
                    int n4 = fontMetrics.stringWidth(string);
                    graphics.drawString(string, (rectangle.width - n4) / 2, (rectangle.height + n) / 2);
                } else {
                    int n5 = string.indexOf("</sup>");
                    int n6 = 0;
                    String string2 = string.substring(n3 + 5, n5);
                    graphics.setFont(CalcoFrame.this.policeExp);
                    fontMetrics = graphics.getFontMetrics();
                    n6 += fontMetrics.stringWidth(string2);
                    String string3 = n3 == 0 ? string.substring(n5 + 6) : string.substring(0, n3);
                    if ("".equals(string3)) {
                        string3 = null;
                    }
                    graphics.setFont(CalcoFrame.this.policeBoutons);
                    fontMetrics = graphics.getFontMetrics();
                    if (string3 != null) {
                        n6 += fontMetrics.stringWidth(string3);
                    }
                    int n7 = 0;
                    if (n3 == 0) {
                        graphics.setFont(CalcoFrame.this.policeExp);
                        fontMetrics = graphics.getFontMetrics();
                        n7 += fontMetrics.stringWidth(string2);
                        graphics.drawString(string2, (rectangle.width - n6) / 2, rectangle.height / 2);
                        if (string3 != null) {
                            graphics.setFont(CalcoFrame.this.policeBoutons);
                            graphics.drawString(string3, (rectangle.width - n6) / 2 + n7, (rectangle.height + n) / 2);
                        }
                    } else {
                        graphics.setFont(CalcoFrame.this.policeBoutons);
                        fontMetrics = graphics.getFontMetrics();
                        graphics.drawString(string3, (rectangle.width - n6) / 2, (rectangle.height + n) / 2);
                        graphics.setFont(CalcoFrame.this.policeExp);
                        graphics.drawString(string2, (rectangle.width - n6) / 2 + (n7 += fontMetrics.stringWidth(string3)), rectangle.height / 2);
                    }
                }
            }
            graphics.setColor(CalcoFrame.this.grisfonce1);
            graphics.drawRoundRect(rectangle.x + 0, rectangle.y + 0, rectangle.width - 2 - 0, rectangle.height - 2 - 0, 7, 7);
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.appui = true;
            this.repaint();
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            CalcoFrame.this.operation(this.truc);
            this.appui = false;
            this.repaint();
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public Dimension getMinimumSize() {
            return new Dimension(30, 30);
        }

        public Dimension getPreferredSize() {
            return this.getMinimumSize();
        }
    }

    class Affichage
    extends Canvas {
        Affichage() {
        }

        public void paint(Graphics graphics) {
            Dimension dimension = this.getSize();
            Rectangle rectangle = new Rectangle(dimension.width, dimension.height);
            graphics.setColor(Color.white);
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            graphics.setColor(Color.black);
            graphics.setFont(CalcoFrame.this.policeBoutons);
            FontMetrics fontMetrics = graphics.getFontMetrics();
            int n = fontMetrics.getHeight();
            int n2 = fontMetrics.stringWidth(CalcoFrame.this.valeurAffichee);
            graphics.drawString(CalcoFrame.this.valeurAffichee, rectangle.width - n2 - 5, (rectangle.height + n) / 2);
            graphics.setFont(CalcoFrame.this.policeExp);
            n = graphics.getFontMetrics().getHeight();
            String string = CalcoFrame.this.degrad;
            if (CalcoFrame.this.modeExpressions) {
                string = string + " expr";
            }
            graphics.drawString(string, 5, rectangle.height - 1);
            if (CalcoFrame.this.memoire != 0.0) {
                graphics.drawString("M", 5, n + 1);
            }
            graphics.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }

        public Dimension getMinimumSize() {
            return new Dimension(180, 30);
        }

        public Dimension getPreferredSize() {
            return this.getMinimumSize();
        }
    }
}

