/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;

abstract class PNGFamily {
    private final boolean debug_flag = false;
    protected static final int LOOP_CONTINUE = 0;
    protected static final int LOOP_BREAK_EOS = 1;
    protected static final int LOOP_BREAK_FOUND = 2;
    protected static final int LOOP_BREAK_ERROR = 3;
    private URL src_url;
    private File src_file;
    private byte[] sig;
    private InputStream in;
    private boolean flag_eos;
    private int c_len;
    private byte[] c_type;
    private byte[] c_crc;
    private int c_remain;
    private boolean flag_find;
    private PNGFamily host;
    private PNGFamily embed;
    private byte[] src_data;
    private boolean flag_cache;

    protected PNGFamily(URL uRL, byte[] byArray) {
        this.initialize();
        this.src_url = uRL;
        this.sig = byArray;
    }

    protected PNGFamily(File file, byte[] byArray) {
        this.initialize();
        this.src_file = file;
        this.sig = byArray;
    }

    protected PNGFamily(PNGFamily pNGFamily, byte[] byArray) {
        this.initialize();
        pNGFamily.setEmbeded(this);
        this.sig = byArray;
    }

    protected void finalize() throws Throwable {
        if (this.host == this) {
            this.closeStream();
            if (this.embed != this) {
                this.embed.finalize();
            }
        } else if (this.embed == this) {
            this.host.unsetEmbeded();
        }
        super.finalize();
    }

    private void initialize() {
        this.src_url = null;
        this.src_file = null;
        this.sig = null;
        this.in = null;
        this.flag_eos = false;
        this.c_len = 0;
        this.c_type = new byte[4];
        this.c_crc = new byte[4];
        this.c_remain = 0;
        this.flag_find = false;
        this.host = this;
        this.embed = this;
        this.src_data = null;
        this.flag_cache = false;
    }

    protected void setEmbeded(PNGFamily pNGFamily) {
        if (this.host != this) {
            return;
        }
        if (this.embed != this) {
            this.unsetEmbeded();
        }
        pNGFamily.host = this;
        this.embed = pNGFamily;
    }

    protected void unsetEmbeded() {
        if (this.host != this) {
            return;
        }
        this.embed.host = this.embed;
        this.embed = this;
    }

    protected boolean isEmbeded() {
        return this.host != this;
    }

    public abstract int encounterChunk() throws IOException;

    public boolean readChunkLoop() throws IOException {
        block10: {
            int n;
            if (this.host != this) {
                return this.host.readChunkLoop();
            }
            do {
                if (this.flag_find) {
                    if (this.c_remain != this.c_len || this.c_len == 0) {
                        if (this.c_remain > 0) {
                            this.in.skip(this.c_remain);
                            this.c_remain = 0;
                        }
                        this.in.skip(this.c_crc.length);
                    }
                    this.flag_find = false;
                }
                if (this.c_remain != this.c_len || this.c_len == 0) {
                    byte[] byArray = new byte[8];
                    int n2 = this.in.read(byArray, 0, 8);
                    if (n2 < 8) {
                        return false;
                    }
                    this.c_len = PNGFamily.byte2int(byArray, 0);
                    System.arraycopy(byArray, 4, this.c_type, 0, this.c_type.length);
                    this.c_remain = this.c_len;
                }
                if ((n = this.embed.encounterChunk()) == 0 || n == 1) {
                    this.in.skip(this.c_remain);
                    this.c_remain = 0;
                    this.in.skip(this.c_crc.length);
                }
                if (n == 1) {
                    this.embed.flag_eos = true;
                }
                if (n == 2) {
                    this.flag_find = true;
                }
                if (n == 3) break block10;
            } while (n == 0);
            return true;
        }
        return false;
    }

    protected InputStream cacheStream(URL uRL) throws IOException {
        int n = uRL.openConnection().getContentLength();
        if (n <= 0) {
            n = (int)this.getURLLength(uRL);
        }
        return this.cacheStream(this.openStream(uRL), n);
    }

    protected InputStream cacheStream(File file) throws IOException {
        return this.cacheStream(this.openStream(file), (int)file.length());
    }

    protected InputStream cacheStream(InputStream inputStream, int n) throws IOException {
        if (inputStream == null || n <= 0) {
            return null;
        }
        this.src_data = new byte[n];
        int n2 = inputStream.read(this.src_data, 0, n);
        inputStream.close();
        if (n2 < n) {
            return null;
        }
        return new ByteArrayInputStream(this.src_data, 0, n);
    }

    protected long getURLLength(URL uRL) throws IOException {
        InputStream inputStream = this.openStream(uRL);
        long l = inputStream.skip(Long.MAX_VALUE);
        inputStream.close();
        return l;
    }

    public void setCaching(boolean bl) {
        this.flag_cache = bl;
    }

    protected InputStream openStream(URL uRL) throws IOException {
        URLConnection uRLConnection = uRL.openConnection();
        uRLConnection.setUseCaches(true);
        return new FullyInputStream(uRLConnection.getInputStream());
    }

    protected InputStream openStream(File file) throws IOException {
        return new FileInputStream(file);
    }

    public void openStream() throws IOException {
        if (this.in != null || this.host != this) {
            return;
        }
        if (this.flag_cache) {
            if (this.src_data != null) {
                this.in = new ByteArrayInputStream(this.src_data, 0, this.src_data.length);
            } else if (this.src_url != null) {
                this.in = this.cacheStream(this.src_url);
            } else if (this.src_file != null) {
                this.in = this.cacheStream(this.src_file);
            }
        }
        if (this.in == null) {
            if (this.src_url != null) {
                this.in = this.openStream(this.src_url);
            } else if (this.src_file != null) {
                this.in = this.openStream(this.src_file);
            }
        }
        if (!this.checkSignature(this.in)) {
            this.closeStream();
        }
    }

    public void closeStream() throws IOException {
        if (this.in == null || this.host != this) {
            return;
        }
        this.in.close();
        this.in = null;
        this.flag_eos = false;
        this.c_len = 0;
        this.c_type = new byte[4];
        this.c_crc = new byte[4];
        this.c_remain = 0;
        this.flag_find = false;
    }

    public void reopenStream() throws IOException {
        this.closeStream();
        this.openStream();
    }

    public boolean existsStream() {
        return this.in != null;
    }

    public boolean isEOS() throws IOException {
        return this.flag_eos;
    }

    protected int getChunkLength() {
        return this.host.c_len;
    }

    protected byte[] getChunkType() {
        return this.host.c_type;
    }

    protected int getChunkRemain() {
        return this.host.c_remain;
    }

    protected int readChunkData(byte[] byArray, int n, int n2) throws IOException {
        if (this.host.c_remain <= 0) {
            return 0;
        }
        int n3 = 0;
        n3 = n2 < this.host.c_remain ? this.host.in.read(byArray, n, n2) : this.host.in.read(byArray, n, this.host.c_remain);
        if (n3 > 0) {
            this.host.c_remain -= n3;
        }
        return n3;
    }

    protected long skipChunkData(long l) throws IOException {
        if (this.host.c_remain <= 0) {
            return 0L;
        }
        long l2 = 0L;
        l2 = l < (long)this.host.c_remain ? this.host.in.skip(l) : this.host.in.skip(this.host.c_remain);
        if (l2 > 0L) {
            this.host.c_remain = (int)((long)this.host.c_remain - l2);
        }
        return l2;
    }

    public boolean checkSignature() {
        try {
            if (this.src_url != null) {
                return this.checkSignature(this.openStream(this.src_url));
            }
            if (this.src_file != null) {
                return this.checkSignature(this.openStream(this.src_file));
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return false;
        }
        return false;
    }

    protected boolean checkSignature(InputStream inputStream) {
        byte[] byArray = new byte[this.sig.length];
        try {
            int n = inputStream.read(byArray, 0, this.sig.length);
            if (n < this.sig.length) {
                return false;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        return PNGFamily.bytecmp(byArray, 0, this.sig, 0, this.sig.length);
    }

    protected boolean checkSignature(byte[] byArray, byte[] byArray2, int n) {
        return PNGFamily.bytecmp(byArray2, n, byArray, 0, byArray.length);
    }

    protected boolean compareChunkType(String string, byte[] byArray, int n) {
        return PNGFamily.bytecmp(byArray, n, string.getBytes(), 0, 4);
    }

    public static boolean bytecmp(byte[] byArray, int n, byte[] byArray2, int n2, int n3) {
        for (int i = 0; i < n3; ++i) {
            if (byArray[i + n] == byArray2[i + n2]) continue;
            return false;
        }
        return true;
    }

    public static int byte2int(byte[] byArray, int n) {
        int n2 = 0;
        for (int i = 0; i < 4; ++i) {
            n2 <<= 8;
            n2 |= byArray[i + n] & 0xFF;
        }
        return n2;
    }

    public static short byte2short(byte[] byArray, int n) {
        short s = 0;
        for (int i = 0; i < 2; ++i) {
            s = (short)(s << 8);
            s = (short)(s | (short)(byArray[i + n] & 0xFF));
        }
        return s;
    }
}

