/*
 * Decompiled with CFR 0.152.
 */
package moulinette;

import com.keypoint.PngEncoder;
import com.sixlegs.image.png.PngImage;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.AreaAveragingScaleFilter;
import java.awt.image.BufferedImage;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageObserver;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import moulinette.ImAnim;

public class PNGImage
implements ImAnim {
    Image img = null;

    public static void main(String[] stringArray) {
        int n;
        int n2;
        if (stringArray.length != 4) {
            System.err.println("il faut 4 arguments (forig fdest largeur hauteur)");
            return;
        }
        File file = new File(stringArray[0]);
        if (!file.exists()) {
            System.err.println("le fichier n'existe pas");
            return;
        }
        File file2 = new File(stringArray[1]);
        try {
            n2 = new Integer(stringArray[2]);
            n = new Integer(stringArray[3]);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
        PNGImage pNGImage = new PNGImage();
        try {
            pNGImage.open(file);
            pNGImage.rescale(file2, n2, n);
        }
        catch (IOException iOException) {
            System.err.println("IOException : " + iOException.getMessage());
            return;
        }
    }

    public void open(File file) throws IOException {
        PngImage pngImage = new PngImage(file.getPath());
        this.img = Toolkit.getDefaultToolkit().createImage(pngImage);
        WaitingObserver waitingObserver = new WaitingObserver();
        if (this.img.getWidth(waitingObserver) == -1) {
            waitingObserver.attendre();
        }
        if (this.img.getHeight(waitingObserver = new WaitingObserver()) == -1) {
            waitingObserver.attendre();
        }
        if (this.img.getWidth(null) == -1 || this.img.getHeight(null) == -1) {
            throw new IOException("Erreur \u00e0 la lecture de " + file.getPath());
        }
    }

    public int getWidth() {
        if (this.img == null) {
            return -1;
        }
        return this.img.getWidth(null);
    }

    public int getHeight() {
        if (this.img == null) {
            return -1;
        }
        return this.img.getHeight(null);
    }

    public int getImageCount() {
        if (this.img == null) {
            return 0;
        }
        return 1;
    }

    public Image getImage(int n) {
        if (n != 0) {
            return null;
        }
        return this.img;
    }

    public void rescale(File file, int n, int n2) throws IOException {
        int n3 = this.img.getWidth(null);
        int n4 = this.img.getHeight(null);
        System.out.println("rescale " + file.getName() + " " + n3 + " " + n4 + " -> " + n + " " + n2);
        Image image = Toolkit.getDefaultToolkit().createImage(new FilteredImageSource(this.img.getSource(), new AreaAveragingScaleFilter(n, n2)));
        BufferedImage bufferedImage = new BufferedImage(n, n2, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        WaitingObserver waitingObserver = new WaitingObserver();
        if (!graphics2D.drawImage(image, 0, 0, waitingObserver)) {
            waitingObserver.attendre();
            graphics2D.drawImage(image, 0, 0, null);
        }
        graphics2D.dispose();
        PngEncoder pngEncoder = new PngEncoder(bufferedImage, true, 0, 9);
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        byte[] byArray = pngEncoder.pngEncode();
        if (byArray == null) {
            throw new IOException("PNG encoding " + file.getPath());
        }
        fileOutputStream.write(byArray);
        fileOutputStream.flush();
        fileOutputStream.close();
    }

    class WaitingObserver
    implements ImageObserver {
        boolean stillwaiting = true;

        WaitingObserver() {
        }

        public void attendre() {
            while (this.stillwaiting) {
                try {
                    Thread.currentThread();
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    System.err.println("InterruptedException: " + interruptedException.getMessage());
                }
            }
        }

        public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
            if ((n & 0x20) != 0) {
                this.stillwaiting = false;
                return false;
            }
            if ((n & 0x40) != 0) {
                System.err.println("imageUpdate: ERROR");
                this.stillwaiting = false;
                return false;
            }
            if ((n & 0x80) != 0) {
                System.err.println("ABORT");
                this.stillwaiting = false;
                return false;
            }
            return true;
        }
    }
}

