/*
 * Decompiled with CFR 0.152.
 */
package moulinette;

import com.keypoint.PngEncoder;
import com.keypoint.PngEncoderB;
import gif.GifDecoder;
import java.awt.Color;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.zip.CRC32;

public class AMortLesGIFs {
    static final boolean compression = true;
    protected byte[] pngBytes;
    protected int bytePos;

    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            new AMortLesGIFs().ouvrir();
        } else if (stringArray.length > 1 && "PNG".equals(stringArray[1])) {
            new AMortLesGIFs().ouvrir(stringArray[0], true);
        } else {
            new AMortLesGIFs().ouvrir(stringArray[0], false);
        }
    }

    public void ouvrir(String string, boolean bl) {
        File file = new File(string);
        if (!file.exists()) {
            System.err.println("Le fichier " + string + " n'existe pas");
            System.exit(1);
        }
        if (this.amort(file, bl) == null) {
            System.exit(1);
        }
        System.exit(0);
    }

    public void ouvrir() {
        FileDialog fileDialog = new FileDialog(new Frame(), "Convertir un fichier gif");
        fileDialog.setFilenameFilter(new ExtFilter("gif"));
        fileDialog.show();
        String string = fileDialog.getFile();
        if (string == null) {
            System.exit(1);
        }
        if (fileDialog.getDirectory() != null) {
            string = fileDialog.getDirectory() + File.separatorChar + string;
        }
        this.ouvrir(string, false);
    }

    public File amort(File file, boolean bl) {
        System.out.println("Conversion du fichier: " + file.getPath() + "...");
        GifDecoder gifDecoder = AMortLesGIFs.decoderGIF(file, true);
        if (gifDecoder == null) {
            System.err.println("Erreur au d\u00e9codage du GIF");
            return null;
        }
        int n = gifDecoder.getFrameCount();
        if (n == 0) {
            System.err.println("Erreur au d\u00e9codage de " + file.getPath() + " (nb frames = 0)");
            return null;
        }
        if (n == 1 || bl) {
            System.out.println("PNG");
            gifDecoder = AMortLesGIFs.decoderGIF(file, false);
            File file2 = new File(AMortLesGIFs.sansExtension(file.getPath()) + ".png");
            BufferedImage bufferedImage = gifDecoder.getFrame(0);
            AMortLesGIFs.enregistrerPNG(file2, bufferedImage);
            return file2;
        }
        System.out.println("MNG-LC");
        File file3 = new File(AMortLesGIFs.sansExtension(file.getPath()) + ".mng");
        this.enregistrerMNG(file3, gifDecoder);
        return file3;
    }

    public static GifDecoder decoderGIF(File file, boolean bl) {
        GifDecoder gifDecoder = new GifDecoder();
        gifDecoder.setIndexation(bl);
        int n = gifDecoder.read(file.getPath());
        if (n != 0) {
            if (n == 1) {
                System.err.println("GifDecoder: format error");
            } else if (n == 2) {
                System.err.println("GifDecoder: open error");
            }
        }
        return gifDecoder;
    }

    public static void enregistrerPNG(File file, BufferedImage bufferedImage) {
        PngEncoderB pngEncoderB = new PngEncoderB(bufferedImage, true, 0, 9);
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            byte[] byArray = ((PngEncoder)pngEncoderB).pngEncode();
            if (byArray == null) {
                System.out.println("image vide");
            } else {
                fileOutputStream.write(byArray);
            }
            fileOutputStream.flush();
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    protected void writePalette(DataOutputStream dataOutputStream, IndexColorModel indexColorModel) throws IOException {
        byte[] byArray = new byte[256];
        byte[] byArray2 = new byte[256];
        byte[] byArray3 = new byte[256];
        byte[] byArray4 = new byte[768];
        indexColorModel.getReds(byArray);
        indexColorModel.getGreens(byArray2);
        indexColorModel.getBlues(byArray3);
        for (int i = 0; i < 256; ++i) {
            byArray4[i * 3] = byArray[i];
            byArray4[i * 3 + 1] = byArray2[i];
            byArray4[i * 3 + 2] = byArray3[i];
        }
        this.bytePos = 0;
        this.writeInt4(768);
        this.writeString("PLTE");
        CRC32 cRC32 = new CRC32();
        cRC32.update("PLTE".getBytes());
        this.writeBytes(byArray4);
        cRC32.update(byArray4);
        this.writeInt4((int)cRC32.getValue());
        dataOutputStream.write(this.pngBytes, 0, this.bytePos);
        if (indexColorModel.getTransparentPixel() != -1) {
            int n = indexColorModel.getTransparentPixel();
            this.bytePos = 0;
            this.writeInt4(n + 1);
            this.writeString("tRNS");
            cRC32.reset();
            cRC32.update("tRNS".getBytes());
            for (int i = 0; i < n; ++i) {
                this.writeByte(255);
                cRC32.update(255);
            }
            this.writeByte(0);
            cRC32.update(0);
            this.writeInt4((int)cRC32.getValue());
            dataOutputStream.write(this.pngBytes, 0, this.bytePos);
        }
    }

    protected void writeDEFI(DataOutputStream dataOutputStream, int n, int n2) throws IOException {
        dataOutputStream.writeInt(12);
        this.bytePos = 0;
        this.writeString("DEFI");
        this.writeInt2(0);
        this.writeByte(0);
        this.writeByte(0);
        this.writeInt4(n);
        this.writeInt4(n2);
        CRC32 cRC32 = new CRC32();
        cRC32.reset();
        cRC32.update(this.pngBytes, 0, this.bytePos);
        this.writeInt4((int)cRC32.getValue());
        dataOutputStream.write(this.pngBytes, 0, this.bytePos);
    }

    protected void writeFRAMmode(DataOutputStream dataOutputStream, int n) throws IOException {
        this.bytePos = 0;
        dataOutputStream.writeInt(1);
        this.writeString("FRAM");
        this.writeByte(n);
        dataOutputStream.write(this.pngBytes, 0, this.bytePos);
        CRC32 cRC32 = new CRC32();
        cRC32.reset();
        cRC32.update(this.pngBytes, 0, this.bytePos);
        dataOutputStream.writeInt((int)cRC32.getValue());
    }

    protected void writeFRAMdelay(DataOutputStream dataOutputStream, int n, int n2) throws IOException {
        this.bytePos = 0;
        dataOutputStream.writeInt(10);
        this.writeString("FRAM");
        this.writeByte(n);
        this.writeByte(0);
        this.writeByte(2);
        this.writeByte(0);
        this.writeByte(0);
        this.writeByte(0);
        this.writeInt4(n2);
        dataOutputStream.write(this.pngBytes, 0, this.bytePos);
        CRC32 cRC32 = new CRC32();
        cRC32.reset();
        cRC32.update(this.pngBytes, 0, this.bytePos);
        dataOutputStream.writeInt((int)cRC32.getValue());
    }

    public IndexColorModel icmTrans(IndexColorModel indexColorModel) {
        IndexColorModel indexColorModel2;
        if (indexColorModel.getMapSize() < 256) {
            int n = indexColorModel.getMapSize() + 1;
            System.out.print("ajout couleur (count=" + n + ")");
            byte[] byArray = new byte[n];
            byte[] byArray2 = new byte[n];
            byte[] byArray3 = new byte[n];
            indexColorModel.getReds(byArray);
            indexColorModel.getGreens(byArray2);
            indexColorModel.getBlues(byArray3);
            for (int i = n - 1; i > 0; --i) {
                byArray[i] = byArray[i - 1];
                byArray2[i] = byArray2[i - 1];
                byArray3[i] = byArray3[i - 1];
            }
            byArray[0] = -1;
            byArray2[0] = -1;
            byArray3[0] = -1;
            indexColorModel2 = new IndexColorModel(8, n, byArray, byArray2, byArray3, 0);
        } else {
            int n = indexColorModel.getMapSize();
            int n2 = -1;
            long l = -1L;
            for (int i = 0; i < n; ++i) {
                int n3 = indexColorModel.getRGB(i);
                int n4 = n3 >> 16 & 0xFF;
                int n5 = n3 >> 8 & 0xFF;
                int n6 = n3 & 0xFF;
                for (int j = i + 1; j < n; ++j) {
                    int n7 = indexColorModel.getRGB(j);
                    int n8 = n7 >> 16 & 0xFF;
                    int n9 = n7 >> 8 & 0xFF;
                    int n10 = n7 & 0xFF;
                    long l2 = (n4 - n8) * (n4 - n8) + (n5 - n9) * (n5 - n9) + (n6 - n10) * (n6 - n10);
                    if (l != -1L && l2 >= l) continue;
                    l = l2;
                    n2 = i;
                }
            }
            byte[] byArray = new byte[n];
            byte[] byArray4 = new byte[n];
            byte[] byArray5 = new byte[n];
            indexColorModel.getReds(byArray);
            indexColorModel.getGreens(byArray4);
            indexColorModel.getBlues(byArray5);
            indexColorModel2 = new IndexColorModel(indexColorModel.getPixelSize(), n, byArray, byArray4, byArray5, n2);
        }
        return indexColorModel2;
    }

    public BufferedImage optimiser(BufferedImage bufferedImage, BufferedImage bufferedImage2, int n, IndexColorModel indexColorModel, boolean bl, DataOutputStream dataOutputStream) throws IOException {
        BufferedImage bufferedImage3;
        int n2 = bufferedImage.getWidth();
        int n3 = bufferedImage.getHeight();
        IndexColorModel indexColorModel2 = null;
        if (bufferedImage.getColorModel() instanceof IndexColorModel) {
            indexColorModel2 = (IndexColorModel)bufferedImage.getColorModel();
        }
        if (bufferedImage2 != null) {
            BufferedImage bufferedImage4;
            int n4;
            int n5;
            int n6;
            int n7 = -1;
            int n8 = -1;
            int n9 = -1;
            int n10 = -1;
            for (n6 = 0; n6 < n2; ++n6) {
                for (n5 = 0; n5 < n3; ++n5) {
                    if (bufferedImage.getRGB(n6, n5) == bufferedImage2.getRGB(n6, n5)) continue;
                    if (n7 == -1 || n7 > n6) {
                        n7 = n6;
                    }
                    if (n8 == -1 || n8 > n5) {
                        n8 = n5;
                    }
                    if (n9 == -1 || n9 < n6) {
                        n9 = n6;
                    }
                    if (n10 != -1 && n10 >= n5) continue;
                    n10 = n5;
                }
            }
            if (n7 == -1) {
                n7 = 0;
                n8 = 0;
                n9 = 0;
                n10 = 0;
            }
            n6 = n9 - n7 + 1;
            n5 = n10 - n8 + 1;
            int n11 = -1;
            if (indexColorModel == null) {
                if (indexColorModel2 != null) {
                    n4 = indexColorModel2.getTransparentPixel();
                    if (n4 != -1) {
                        n11 = indexColorModel2.getRGB(n4);
                        indexColorModel = indexColorModel2;
                    } else {
                        indexColorModel = this.icmTrans(indexColorModel2);
                        n4 = indexColorModel.getTransparentPixel();
                        n11 = indexColorModel.getRGB(n4);
                    }
                }
                bufferedImage4 = indexColorModel == null ? new BufferedImage(n6, n5, 2) : new BufferedImage(n6, n5, 13, indexColorModel);
            } else {
                n4 = indexColorModel.getTransparentPixel();
                if (n4 != -1) {
                    n11 = indexColorModel.getRGB(n4);
                }
                bufferedImage4 = new BufferedImage(n6, n5, 13, indexColorModel);
            }
            int[] nArray = bufferedImage.getRGB(n7, n8, n6, n5, null, 0, n6);
            for (int i = 0; i < n6; ++i) {
                for (int j = 0; j < n5; ++j) {
                    int n12 = nArray[j * n6 + i];
                    int n13 = bufferedImage2.getRGB(i + n7, j + n8);
                    if (n12 == n13) {
                        if (n11 == -1) {
                            nArray[j * n6 + i] = n12 & 0xFFFFFF;
                            continue;
                        }
                        nArray[j * n6 + i] = n11;
                        continue;
                    }
                    if (!bl || (n12 & 0xFF000000) != 0) continue;
                    nArray[j * n6 + i] = n12 | 0xFF000000;
                }
            }
            bufferedImage4.setRGB(0, 0, n6, n5, nArray, 0, n6);
            this.writeDEFI(dataOutputStream, n7, n8);
            return bufferedImage4;
        }
        if (indexColorModel == null && indexColorModel2 == null) {
            bufferedImage3 = new BufferedImage(n2, n3, 2);
        } else if (indexColorModel == null) {
            indexColorModel = indexColorModel2;
            bufferedImage3 = new BufferedImage(n2, n3, 13, indexColorModel);
        } else {
            bufferedImage3 = new BufferedImage(n2, n3, 13, indexColorModel);
        }
        Graphics2D graphics2D = bufferedImage3.createGraphics();
        graphics2D.setColor(new Color(n | 0xFF000000));
        graphics2D.fillRect(0, 0, n2, n3);
        graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
        if (System.getProperty("os.name").startsWith("Windows")) {
            int[] nArray = bufferedImage3.getRGB(0, 0, n2, n3, null, 0, n2);
            for (int i = 0; i < n2; ++i) {
                for (int j = 0; j < n3; ++j) {
                    int n14 = nArray[j * n2 + i];
                    if ((n14 & 0xFF000000) != 0) continue;
                    nArray[j * n2 + i] = n14 | 0xFF000000;
                }
            }
            bufferedImage3.setRGB(0, 0, n2, n3, nArray, 0, n2);
        }
        return bufferedImage3;
    }

    public void enregistrerMNG(File file, GifDecoder gifDecoder) {
        CRC32 cRC32 = new CRC32();
        try {
            DataOutputStream dataOutputStream = new DataOutputStream(new FileOutputStream(file));
            dataOutputStream.writeByte(138);
            dataOutputStream.writeBytes("MNG\r\n");
            dataOutputStream.writeByte(26);
            dataOutputStream.writeByte(10);
            int n = gifDecoder.getFrameCount();
            System.out.println(n + " images");
            BufferedImage bufferedImage = gifDecoder.getFrame(0);
            int n2 = bufferedImage.getWidth();
            int n3 = bufferedImage.getHeight();
            boolean bl = false;
            if (gifDecoder.getDispose() == 2) {
                bl = true;
            }
            boolean bl2 = gifDecoder.getPaletteGlobale();
            System.out.println("palette globale: " + bl2);
            int n4 = gifDecoder.getLoopCount();
            if (n4 == 0) {
                n4 = Integer.MAX_VALUE;
                System.out.println("boucle infinie");
            } else {
                System.out.println(n + " boucles");
            }
            this.pngBytes = new byte[1000];
            this.bytePos = 0;
            dataOutputStream.writeInt(28);
            this.writeString("MHDR");
            this.writeInt4(n2);
            this.writeInt4(n3);
            this.writeInt4(1000);
            this.writeInt4(0);
            this.writeInt4(n);
            this.writeInt4(0);
            this.writeInt4(459);
            dataOutputStream.write(this.pngBytes, 0, this.bytePos);
            cRC32.reset();
            cRC32.update(this.pngBytes, 0, this.bytePos);
            dataOutputStream.writeInt((int)cRC32.getValue());
            this.bytePos = 0;
            dataOutputStream.writeInt(10);
            this.writeString("TERM");
            this.writeByte(3);
            this.writeByte(0);
            this.writeInt4(gifDecoder.getDelay(n - 1));
            this.writeInt4(n4);
            dataOutputStream.write(this.pngBytes, 0, this.bytePos);
            cRC32.reset();
            cRC32.update(this.pngBytes, 0, this.bytePos);
            dataOutputStream.writeInt((int)cRC32.getValue());
            IndexColorModel indexColorModel = null;
            if (bl2) {
                if (((IndexColorModel)bufferedImage.getColorModel()).getTransparentPixel() == -1) {
                    indexColorModel = this.icmTrans((IndexColorModel)bufferedImage.getColorModel());
                    this.writePalette(dataOutputStream, indexColorModel);
                } else {
                    this.writePalette(dataOutputStream, (IndexColorModel)bufferedImage.getColorModel());
                }
            }
            if (bl) {
                // empty if block
            }
            boolean bl3 = gifDecoder.getTransparency(0);
            System.out.println("alpha: " + bl3);
            bl3 = true;
            boolean bl4 = bl3;
            BufferedImage bufferedImage2 = null;
            int n5 = gifDecoder.getBgIndex();
            int n6 = ((IndexColorModel)bufferedImage.getColorModel()).getRGB(n5);
            int n7 = 1;
            for (int i = 0; i < n; ++i) {
                System.out.print(".");
                BufferedImage bufferedImage3 = gifDecoder.getFrame(i);
                int n8 = gifDecoder.getDelay(i);
                if (n8 != n7) {
                    if (bl) {
                        // empty if block
                    }
                    this.writeFRAMdelay(dataOutputStream, 1, n8);
                    n7 = n8;
                }
                Object object = this.optimiser(bufferedImage3, bufferedImage2, n6, indexColorModel, bl, dataOutputStream);
                bufferedImage2 = bufferedImage3;
                bufferedImage3 = object;
                PngEncoderB pngEncoderB = new PngEncoderB(bufferedImage3, bl4, 0, 9);
                pngEncoderB.setPasDePalette(bl2);
                object = pngEncoderB.pngEncode();
                if (object == null) {
                    System.out.println("image vide");
                    continue;
                }
                dataOutputStream.write((byte[])object, 8, ((Object)object).length - 8);
            }
            System.out.println();
            dataOutputStream.writeInt(0);
            this.bytePos = 0;
            this.writeString("MEND");
            dataOutputStream.write(this.pngBytes, 0, this.bytePos);
            cRC32.reset();
            cRC32.update(this.pngBytes, 0, this.bytePos);
            dataOutputStream.writeInt((int)cRC32.getValue());
            dataOutputStream.flush();
            dataOutputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static String sansExtension(String string) {
        int n = string.lastIndexOf(46);
        if (n == -1) {
            return string;
        }
        return string.substring(0, n);
    }

    protected byte[] resizeByteArray(byte[] byArray, int n) {
        byte[] byArray2 = new byte[n];
        int n2 = byArray.length;
        System.arraycopy(byArray, 0, byArray2, 0, Math.min(n2, n));
        return byArray2;
    }

    protected void writeBytes(byte[] byArray) {
        int n = this.bytePos;
        if (byArray.length + n > this.pngBytes.length) {
            this.pngBytes = this.resizeByteArray(this.pngBytes, this.pngBytes.length + Math.max(1000, byArray.length));
        }
        System.arraycopy(byArray, 0, this.pngBytes, n, byArray.length);
        this.bytePos = n + byArray.length;
    }

    protected void writeBytes(byte[] byArray, int n) {
        int n2 = this.bytePos;
        if (n + n2 > this.pngBytes.length) {
            this.pngBytes = this.resizeByteArray(this.pngBytes, this.pngBytes.length + Math.max(1000, n));
        }
        System.arraycopy(byArray, 0, this.pngBytes, n2, n);
        this.bytePos = n2 + n;
    }

    protected void writeInt2(int n) {
        byte[] byArray = new byte[]{(byte)(n >> 8 & 0xFF), (byte)(n & 0xFF)};
        this.writeBytes(byArray);
    }

    protected void writeInt4(int n) {
        byte[] byArray = new byte[]{(byte)(n >> 24 & 0xFF), (byte)(n >> 16 & 0xFF), (byte)(n >> 8 & 0xFF), (byte)(n & 0xFF)};
        this.writeBytes(byArray);
    }

    protected void writeByte(int n) {
        byte[] byArray = new byte[]{(byte)n};
        this.writeBytes(byArray);
    }

    protected void writeString(String string) {
        this.writeBytes(string.getBytes());
    }

    class ExtFilter
    implements FilenameFilter {
        String ext;

        public ExtFilter(String string) {
            this.ext = string;
        }

        public boolean accept(File file, String string) {
            return string.endsWith("." + this.ext);
        }
    }
}

