/*
 * Decompiled with CFR 0.152.
 */
package MNGDecoder;

import MNGDecoder.ImageConsumerGroup;
import MNGDecoder.PNGLib;
import MNGDecoder.PNGParam;
import MNGDecoder.TransDirectColorModel;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageProducer;
import java.awt.image.IndexColorModel;
import java.io.IOException;
import java.util.zip.DataFormatException;

public class PNGImageProducer
implements ImageProducer {
    private final boolean debug_flag = false;
    private final int debug_lv = 0;
    private ImageConsumerGroup icg = new ImageConsumerGroup();
    private PNGLib png;
    private PNGParam param;

    public PNGImageProducer(PNGLib pNGLib) {
        this.png = pNGLib;
        this.param = null;
    }

    public void addConsumer(ImageConsumer imageConsumer) {
        this.icg.addConsumer(imageConsumer);
    }

    public boolean isConsumer(ImageConsumer imageConsumer) {
        return this.icg.isConsumer(imageConsumer);
    }

    public void removeConsumer(ImageConsumer imageConsumer) {
        this.icg.removeConsumer(imageConsumer);
    }

    public void startProduction(ImageConsumer imageConsumer) {
        this.icg.addConsumer(imageConsumer);
        if (this.sendImage()) {
            this.icg.imageComplete(3);
        } else {
            this.icg.imageComplete(1);
        }
    }

    public void requestTopDownLeftRightResend(ImageConsumer imageConsumer) {
    }

    private boolean sendImage() {
        try {
            if (!this.png.existsStream() && !this.png.isEmbeded()) {
                this.png.openStream();
                if (!this.png.existsStream()) {
                    return false;
                }
            }
            if (!this.png.readInfo() || !this.png.isSupported()) {
                this.png.closeStream();
                return false;
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return false;
        }
        this.param = this.png.getInfo();
        this.icg.setDimensions(this.param.width, this.param.height);
        ColorModel colorModel = this.getColorModel(this.param.color, this.param.depth);
        if (colorModel == null) {
            try {
                this.png.closeStream();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            return false;
        }
        this.icg.setColorModel(colorModel);
        if (this.param.interace == 0) {
            this.icg.setHints(2);
        }
        try {
            byte[] byArray;
            for (int i = 0; i < this.param.height && !this.png.isEOS() && (byArray = this.png.readLine()) != null; ++i) {
                if (this.sendLine(0, i, colorModel, byArray)) continue;
                this.png.closeStream();
                return false;
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return false;
        }
        catch (DataFormatException dataFormatException) {
            dataFormatException.printStackTrace();
            return false;
        }
        try {
            this.png.closeStream();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return true;
    }

    private boolean sendLine(int n, int n2, ColorModel colorModel, byte[] byArray) {
        int n3 = this.param.depth * this.png.getSamplePerPixel();
        if (n3 == 8) {
            this.icg.setPixels(n, n2, this.param.width, 1, colorModel, byArray, 0, this.param.width);
        } else if (n3 < 8) {
            int n4 = -128;
            byte[] byArray2 = new byte[this.param.width];
            for (int i = 0; i < this.param.width; ++i) {
                byArray2[i] = 0;
                for (int j = 0; j < n3; ++j) {
                    int n5 = (i * n3 + j) / 8;
                    int n6 = i;
                    byArray2[n6] = (byte)(byArray2[n6] << 1);
                    int n7 = i;
                    byArray2[n7] = (byte)(byArray2[n7] | ((byArray[n5] & n4) == 0 ? (byte)0 : 1));
                    if ((n4 = (int)((byte)((n4 & 0xFF) >>> 1))) != 0) continue;
                    n4 = -128;
                }
            }
            this.icg.setPixels(n, n2, this.param.width, 1, colorModel, byArray2, 0, this.param.width);
        } else if (n3 % 8 == 0) {
            int n8 = n3 / 8;
            int[] nArray = new int[this.param.width];
            for (int i = 0; i < this.param.width; ++i) {
                nArray[i] = this.toPixel(byArray, i * n8, n8);
            }
            this.icg.setPixels(n, n2, this.param.width, 1, colorModel, nArray, 0, this.param.width);
        } else {
            return false;
        }
        return true;
    }

    private ColorModel getColorModel(int n, int n2) {
        ColorModel colorModel;
        switch (n) {
            case 0: {
                switch (n2) {
                    case 1: {
                        colorModel = new DirectColorModel(1, 1, 1, 1);
                        break;
                    }
                    case 2: {
                        colorModel = new DirectColorModel(2, 3, 3, 3);
                        break;
                    }
                    case 4: {
                        colorModel = new DirectColorModel(4, 15, 15, 15);
                        break;
                    }
                    case 8: {
                        colorModel = new DirectColorModel(8, 255, 255, 255);
                        break;
                    }
                    default: {
                        return null;
                    }
                }
                if (this.param.t_len != 2) break;
                colorModel = new TransDirectColorModel((DirectColorModel)colorModel, this.param.trans[1] & 0xFF);
                break;
            }
            case 2: {
                colorModel = new DirectColorModel(24, 0xFF0000, 65280, 255);
                if (this.param.t_len != 6) break;
                int n3 = (this.param.trans[1] & 0xFF) << 16 | (this.param.trans[3] & 0xFF) << 8 | this.param.trans[5] & 0xFF;
                colorModel = new TransDirectColorModel((DirectColorModel)colorModel, n3);
                break;
            }
            case 3: {
                if (this.param.p_len <= 0) {
                    return null;
                }
                if (this.param.t_len > 0) {
                    colorModel = new IndexColorModel(8, this.param.p_len, this.param.pallet[0], this.param.pallet[1], this.param.pallet[2], this.param.trans);
                    break;
                }
                colorModel = new IndexColorModel(n2, this.param.p_len, this.param.pallet[0], this.param.pallet[1], this.param.pallet[2]);
                break;
            }
            case 4: {
                colorModel = new DirectColorModel(16, 255, 255, 255, 65280);
                break;
            }
            case 6: {
                colorModel = new DirectColorModel(32, -16777216, 0xFF0000, 65280, 255);
                break;
            }
            default: {
                return null;
            }
        }
        return colorModel;
    }

    private int toPixel(byte[] byArray, int n, int n2) {
        int n3 = 0;
        if (n2 <= 4) {
            for (int i = 0; i < n2; ++i) {
                n3 <<= 8;
                n3 |= byArray[i + n] & 0xFF;
            }
        } else {
            for (int i = 0; i < n2; i += n2 / 3) {
                n3 <<= 8;
                n3 |= byArray[i + n] & 0xFF;
            }
        }
        return n3;
    }
}

