/*
 * Decompiled with CFR 0.152.
 */
package MNGDecoder;

import MNGDecoder.JNGLib;
import MNGDecoder.JNGParam;
import java.awt.Canvas;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.image.ColorModel;
import java.awt.image.PixelGrabber;
import java.io.IOException;

abstract class JNGImageDecoder {
    private static final boolean debug_flag = false;
    private static final int debug_lv = 0;
    private static int debug_jng_no = 0;
    private static int debug_no_max = 0;

    JNGImageDecoder() {
    }

    public static Image getImage(JNGLib jNGLib) {
        Object object;
        try {
            if (!jNGLib.existsStream() && !jNGLib.isEmbeded()) {
                jNGLib.openStream();
                if (!jNGLib.existsStream()) {
                    return null;
                }
            }
            if (!jNGLib.readInfo() || !jNGLib.isSupported()) {
                if (!jNGLib.isEmbeded()) {
                    jNGLib.closeStream();
                }
                return null;
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
        byte[] byArray = new byte[]{};
        try {
            int n;
            while (!jNGLib.isEOS() && (n = jNGLib.readJDAT((byte[])(object = new byte[1024]), 0, ((byte[])object).length)) >= 0) {
                if (n <= 0) continue;
                byArray = JNGImageDecoder.bytecat(byArray, 0, byArray.length, (byte[])object, 0, n);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
        try {
            if (!jNGLib.isEmbeded()) {
                jNGLib.closeStream();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        object = Toolkit.getDefaultToolkit();
        Image image = ((Toolkit)object).createImage(byArray, 0, byArray.length);
        JNGParam jNGParam = jNGLib.getInfo();
        MediaTracker mediaTracker = new MediaTracker(new Canvas());
        mediaTracker.addImage(image, 0);
        ((Toolkit)object).prepareImage(image, jNGParam.width, jNGParam.height, null);
        try {
            mediaTracker.waitForID(0);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return image;
    }

    protected static byte[] bytecat(byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4) {
        byte[] byArray3 = new byte[n2 + n4];
        System.arraycopy(byArray, n, byArray3, 0, n2);
        System.arraycopy(byArray2, n3, byArray3, n2, n4);
        return byArray3;
    }

    private static void debug_printPixels(Image image, int n, int n2) {
        PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, n, n2, false);
        try {
            pixelGrabber.grabPixels();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        System.out.println("status:" + pixelGrabber.getStatus());
        Object object = pixelGrabber.getPixels();
        int n3 = pixelGrabber.getWidth();
        int n4 = pixelGrabber.getHeight();
        ColorModel colorModel = pixelGrabber.getColorModel();
        if (object instanceof byte[]) {
            JNGImageDecoder.debug_printBytePixels((byte[])object, n3, colorModel);
        } else if (object instanceof int[]) {
            JNGImageDecoder.debug_printIntPixels((int[])object, n3, colorModel);
        }
    }

    private static void debug_printBytePixels(byte[] byArray, int n, ColorModel colorModel) {
        for (int i = 0; i < byArray.length; ++i) {
            long l = (long)colorModel.getRGB(byArray[i] & 0xFF) & 0xFFFFFFFFL;
            System.out.print(Long.toString(l, 16));
            if ((i + 1) % n == 0) {
                System.out.println();
                continue;
            }
            System.out.print(" ");
        }
    }

    private static void debug_printIntPixels(int[] nArray, int n, ColorModel colorModel) {
        for (int i = 0; i < nArray.length; ++i) {
            long l = (long)colorModel.getRGB(nArray[i]) & 0xFFFFFFFFL;
            System.out.print(Long.toString(l, 16));
            if ((i + 1) % n == 0) {
                System.out.println();
                continue;
            }
            System.out.print(" ");
        }
    }
}

