/*
Copyright (C) 2009 Observatoire de Paris

Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier conformment aux dispositions de la Licence Publique Gnrale GNU, telle que publie par la Free Software Foundation ; version 2 de la licence, ou encore ( votre choix) toute version ultrieure.

Ce programme est distribu dans l'espoir qu'il sera utile, mais SANS AUCUNE GARANTIE ; sans mme la garantie implicite de COMMERCIALISATION ou D'ADAPTATION A UN OBJET PARTICULIER. Pour plus de dtail, voir la Licence Publique Gnrale GNU .

Vous devez avoir reu un exemplaire de la Licence Publique Gnrale GNU en mme temps que ce programme ; si ce n'est pas le cas, crivez  la Free Software Foundation Inc., 675 Mass Ave, Cambridge, MA 02139, Etats-Unis.
*/

package serveurmica;

import java.io.*;
import java.util.*;

import org.w3c.dom.Document;
import org.w3c.dom.Element;


/**
 * Gestion des utilisateurs
 *
 * Srialisation XML:
 *
 *  UTILISATEURS
 *      UTILISATEUR
 *          @username
 *          @password (crypt)
 *          @type (apprenant|administrateur)
 *          @nom
 *          @prenom
 *          @email
 *          @valide (boolen)
 *          @ferme (boolen)
 *          @date_inscription
 *          @date_fermeture
 *          SUIVI_EDC*
 *              @label_edc (nom du dossier et du fichier XML)
 *              @label_etape
 *              @label_section
 *              @terminee (boolen)
 *              VARIABLE (y compris variables d'tapes visites et de questions)
 *                  @nom
 *                  @valeur
 */
public class Utilisateurs {
    private ArrayList<Utilisateur> liste;
    private File f_xml;
    
    /**
     * Charge les utilsateurs en mmoire  partir du fichier XML en paramtre.
     */
    public Utilisateurs(final File f) throws ExceptionMICA {
        f_xml = f;
        liste = new ArrayList<Utilisateur>();
        if (f.exists()) {
            final Document doc = OutilsXML.lectureDocumentXML(f_xml);
            if (doc == null)
                throw new ExceptionMICA("Erreur  l'ouverture du fichier d'utilisateurs");
            final Element racine = doc.getDocumentElement();
            if (!"UTILISATEURS".equals(racine.getLocalName()))
                throw new ExceptionMICA("Mauvais lment racine pour les utilisateurs: " + racine.getLocalName());
            final ArrayList<Element> elements_utilisateurs = OutilsXML.enfants(racine, "UTILISATEUR");
            for (Element eu : elements_utilisateurs)
                liste.add(new Utilisateur(eu));
        } else {
            // la cration du nouveau fichier se fera  l'enregistrement
        }
    }
    
    /**
     * Renvoie true s'il n'y a encore aucun utilisateur
     */
    public boolean aucunUtilisateur() {
        return(liste.size() == 0);
    }
    
    public void enregistrer() throws ExceptionMICA {
        final Document doc = OutilsXML.nouveauDocumentDOM();
        final Element racine = doc.createElementNS(null, "UTILISATEURS");
        for (Utilisateur u : liste)
            u.ajouterDOM(racine);
        doc.appendChild(racine);
        OutilsXML.ecrireDocumentXML(doc, f_xml);
    }
    
    public Utilisateur nouvelUtilisateur(final String username, final String password, final String type, final String nom,
            final String prenom, final String email, final String salt) throws ExceptionMICA {
        final Utilisateur u = new Utilisateur(username, password, type, nom, prenom, email, "378614");
        liste.add(u);
        enregistrer();
        return(u);
    }
    
    /**
     * Renvoie l'utilisateur avec le nom d'utilisateur donn en paramtre, ou null si aucun n'est trouv.
     */
    public Utilisateur getUtilisateur(final String username) {
        if (username == null)
            return(null);
        for (Utilisateur u : liste)
            if (username.equals(u.getUsername()))
                return(u);
        return(null);
    }
    
    public ArrayList<Utilisateur> selectionUtilisateurs(final Boolean bValide, final Boolean bFerme) {
        ArrayList<Utilisateur> l = new ArrayList<Utilisateur>();
        for (Utilisateur u : liste)
            if ((bValide == null || u.valide() == bValide.booleanValue()) && (bFerme == null || u.ferme() == bFerme.booleanValue()))
                l.add(u);
        return(l);
    }
    
    public void valider(Utilisateur u) throws ExceptionMICA {
        u.setValide(true);
        enregistrer();
    }
    
    public void fermer(Utilisateur u) throws ExceptionMICA {
        u.setFerme(true);
        enregistrer();
    }
    
    public void rouvrir(Utilisateur u) throws ExceptionMICA {
        u.setFerme(false);
        enregistrer();
    }
    
    public void supprimer(Utilisateur u) throws ExceptionMICA {
        liste.remove(u);
        enregistrer();
    }
}

