/*
Copyright (C) 2009 Observatoire de Paris

Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier conformment aux dispositions de la Licence Publique Gnrale GNU, telle que publie par la Free Software Foundation ; version 2 de la licence, ou encore ( votre choix) toute version ultrieure.

Ce programme est distribu dans l'espoir qu'il sera utile, mais SANS AUCUNE GARANTIE ; sans mme la garantie implicite de COMMERCIALISATION ou D'ADAPTATION A UN OBJET PARTICULIER. Pour plus de dtail, voir la Licence Publique Gnrale GNU .

Vous devez avoir reu un exemplaire de la Licence Publique Gnrale GNU en mme temps que ce programme ; si ce n'est pas le cas, crivez  la Free Software Foundation Inc., 675 Mass Ave, Cambridge, MA 02139, Etats-Unis.
*/

package serveurmica;

import java.io.*;
import java.text.SimpleDateFormat;
import java.util.*;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

import org.w3c.dom.Document;
import org.w3c.dom.Element;


/**
 * Un utilisateur
 */
public class Utilisateur {
    private String username;
    private String password; // encod
    private String type;
    private String nom;
    private String prenom;
    private String email;
    private boolean valide;
    private boolean ferme;
    private String date_inscription;
    private String date_fermeture; // String vide si ferme==false
    private ArrayList<SuiviEDC> suivis;
    
    /**
     * Construit un utilisateur  partir de l'lment DOM correspondant.
     */
    public Utilisateur(final Element el) throws ExceptionMICA {
        if (!"UTILISATEUR".equals(el.getLocalName()))
            throw new ExceptionMICA("Mauvais lment pour un utilisateur: " + el.getLocalName());
        username = el.getAttribute("username");
        password = el.getAttribute("password");
        type = el.getAttribute("type");
        nom = el.getAttribute("nom");
        prenom = el.getAttribute("prenom");
        email = el.getAttribute("email");
        valide = "oui".equals(el.getAttribute("valide"));
        ferme = "oui".equals(el.getAttribute("ferme"));
        date_inscription = el.getAttribute("date_inscription");
        date_fermeture = el.getAttribute("date_fermeture");
        suivis = new ArrayList<SuiviEDC>();
        final ArrayList<Element> elements_suivi = OutilsXML.enfants(el, "SUIVI_EDC");
        for (Element elsuivi : elements_suivi)
            suivis.add(new SuiviEDC(elsuivi));
    }
    
    /**
     * Construit un nouvel utilisateur, avec le mot de passe non encod
     */
    public Utilisateur(final String username, final String password, final String type, final String nom,
            final String prenom, final String email, final String salt) throws ExceptionMICA {
        this.username = username;
        byte[] bSalt;
        try {
            bSalt = salt.getBytes("UTF-8");
        } catch (IOException ex) {
            throw new ExceptionMICA(ex);
        }
        try {
            final MessageDigest digest = MessageDigest.getInstance("SHA-1");
            digest.reset();
            digest.update(bSalt);
            final byte[] ba = digest.digest(password.getBytes("UTF-8"));
            this.password = byteArrayToBase64(ba);
            this.type = type;
            this.nom = nom;
            this.prenom = prenom;
            this.email = email;
            valide = false;
            ferme = false;
            Date now = new Date();
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm");
            date_inscription = formatter.format(now);
            date_fermeture = "";
            suivis = new ArrayList<SuiviEDC>();
        } catch (NoSuchAlgorithmException ex) {
            throw new ExceptionMICA(ex);
        } catch (UnsupportedEncodingException ex) {
            throw new ExceptionMICA(ex);
        } catch (IOException ex) {
            throw new ExceptionMICA(ex);
        }
    }
    
    /**
     * Ajoute cet utilisateur  l'lment DOM parent
     */
    public void ajouterDOM(final Element parent) {
        final Document doc = parent.getOwnerDocument();
        final Element el_u = doc.createElementNS(null, "UTILISATEUR");
        el_u.setAttributeNS(null, "username", username);
        el_u.setAttributeNS(null, "password", password);
        el_u.setAttributeNS(null, "type", type);
        el_u.setAttributeNS(null, "nom", nom);
        el_u.setAttributeNS(null, "prenom", prenom);
        el_u.setAttributeNS(null, "email", email);
        el_u.setAttributeNS(null, "valide", valide ? "oui" : "non");
        el_u.setAttributeNS(null, "ferme", ferme ? "oui" : "non");
        el_u.setAttributeNS(null, "date_inscription", date_inscription);
        el_u.setAttributeNS(null, "date_fermeture", date_fermeture);
        for (SuiviEDC s : suivis)
            s.ajouterDOM(el_u);
        parent.appendChild(el_u);
    }
    
    /**
     * Renvoie le nom d'utilisateur de l'utilisateur
     */
    public String getUsername() {
        return(username);
    }
    
    public String getNom() {
        return(nom);
    }
    
    public String getPrenom() {
        return(prenom);
    }
    
    public String getEmail() {
        return(email);
    }
    
    public String getType() {
        return(type);
    }
    
    public boolean estAdministrateur() {
        return("administrateur".equals(type));
    }
    
    public boolean valide() {
        return(valide);
    }
    
    public void setValide(final boolean valide) {
        this.valide = valide;
    }
    
    public boolean ferme() {
        return(ferme);
    }
    
    public void setFerme(final boolean ferme) {
        this.ferme = ferme;
    }
    
    /**
     * Renvoie la liste des suivis des tudes de cas.
     */
    public ArrayList<SuiviEDC> getSuivis() {
        return(suivis);
    }
    
    public SuiviEDC nouveauSuivi(final String label_edc) throws ExceptionMICA {
        final SuiviEDC suivi = new SuiviEDC(label_edc);
        suivis.add(suivi);
        return(suivi);
    }
    
    /**
     * Vrifie que le mot de passe donn correspond  celui de l'utilisateur.
     * Renvoie false si cela ne correspond pas ou s'il un erreur se produit.
     */
    public boolean verifierPassord(final String password_test, final String salt) throws ExceptionMICA {
        try {
            byte[] bDigest = base64ToByteArray(password);
            if (bDigest == null)
                return(false);
            byte[] bSalt = salt.getBytes("UTF-8");
            if (bSalt == null)
                return(false);
            final MessageDigest digest = MessageDigest.getInstance("SHA-1");
            digest.reset();
            digest.update(bSalt);
            final byte[] digest_test = digest.digest(password_test.getBytes("UTF-8"));
            return(Arrays.equals(digest_test, bDigest));
        } catch (IOException ex) {
            return(false);
        } catch (NoSuchAlgorithmException ex) {
            throw new ExceptionMICA(ex);
        }
    }
    
    private byte[] base64ToByteArray(final String s) throws IOException {
        DecodeurBase64 decodeur = new DecodeurBase64(new StringReader(s));
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int c;
        while ((c=decodeur.read()) != -1)
            baos.write(c);
        decodeur.close();
        baos.close();
        return(baos.toByteArray());
    }
    
    private String byteArrayToBase64(final byte[] ba) throws IOException {
        final StringWriter sw = new StringWriter();
        EncodeurBase64 encodeur = new EncodeurBase64(sw);
        ByteArrayInputStream bais = new ByteArrayInputStream(ba);
        int c;
        while ((c=bais.read()) != -1)
            encodeur.write(c);
        bais.close();
        encodeur.close();
        return(sw.toString());
    }
}

