/*
Copyright (C) 2009 Observatoire de Paris

Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier conformment aux dispositions de la Licence Publique Gnrale GNU, telle que publie par la Free Software Foundation ; version 2 de la licence, ou encore ( votre choix) toute version ultrieure.

Ce programme est distribu dans l'espoir qu'il sera utile, mais SANS AUCUNE GARANTIE ; sans mme la garantie implicite de COMMERCIALISATION ou D'ADAPTATION A UN OBJET PARTICULIER. Pour plus de dtail, voir la Licence Publique Gnrale GNU .

Vous devez avoir reu un exemplaire de la Licence Publique Gnrale GNU en mme temps que ce programme ; si ce n'est pas le cas, crivez  la Free Software Foundation Inc., 675 Mass Ave, Cambridge, MA 02139, Etats-Unis.
*/

package serveurmica;

import java.util.*;

import org.w3c.dom.Document;
import org.w3c.dom.Element;


/**
 * Suivi d'une tude de cas
 */
public class SuiviEDC {
    private String label_edc;
    private String label_etape;
    private String label_section;
    private boolean terminee;
    private Hashtable<String, Double> variables; // nom -> valeur
    
    /**
     * Constructeur pour un suivi existant.
     */
    public SuiviEDC(final Element el) throws ExceptionMICA {
        if (!"SUIVI_EDC".equals(el.getLocalName()))
            throw new ExceptionMICA("Mauvais lment pour le suivi des EDC: " + el.getLocalName());
        label_edc = el.getAttribute("label_edc");
        label_etape = el.getAttribute("label_etape");
        if ("".equals(label_etape))
            label_etape = null;
        label_section = el.getAttribute("label_section");
        if ("".equals(label_section))
            label_section = null;
        terminee = "oui".equals(el.getAttribute("terminee"));
        variables = new Hashtable<String, Double>();
        final ArrayList<Element> elements_variables = OutilsXML.enfants(el, "VARIABLE");
        for (Element elvar : elements_variables) {
            try {
                variables.put(elvar.getAttribute("nom"), Double.valueOf(elvar.getAttribute("valeur")));
            } catch (NumberFormatException ex) {
            }
        }
    }
    
    /**
     * Constructeur pour un nouveau suivi.
     */
    public SuiviEDC(final String label_edc) throws ExceptionMICA {
        this.label_edc = label_edc;
        label_etape = null;
        label_section = null;
        terminee = false;
        variables = new Hashtable<String, Double>();
    }
    
    /**
     * Ajoute ce suivi  l'lment DOM parent
     */
    public void ajouterDOM(final Element parent) {
        final Document doc = parent.getOwnerDocument();
        final Element el_s = doc.createElementNS(null, "SUIVI_EDC");
        el_s.setAttributeNS(null, "label_edc", label_edc);
        el_s.setAttributeNS(null, "label_etape", label_etape);
        el_s.setAttributeNS(null, "label_section", label_section);
        el_s.setAttributeNS(null, "terminee", terminee ? "oui" : "non");
        for (Map.Entry<String, Double> v : variables.entrySet()) {
            final Element el_v = doc.createElementNS(null, "VARIABLE");
            el_v.setAttributeNS(null, "nom", v.getKey());
            el_v.setAttributeNS(null, "valeur", v.getValue().toString());
            el_s.appendChild(el_v);
        }
        parent.appendChild(el_s);
    }
    
    public String getLabelEDC() {
        return(label_edc);
    }
    
    public String getLabelEtape() {
        return(label_etape);
    }
    
    public void setLabelEtape(final String label_etape) {
        this.label_etape = label_etape;
    }
    
    public String getLabelSection() {
        return(label_section);
    }
    
    public void setLabelSection(final String label_section) {
        this.label_section = label_section;
    }
    
    public boolean terminee() {
        return(terminee);
    }
    
    public void setTerminee() {
        terminee = true;
    }
    
    public double getValeurVariable(final String nom) {
        if (nom == null)
            return(0);
        Double d = variables.get(nom);
        if (d == null)
            return(0);
        return(d.doubleValue());
    }
    
    public boolean variableDefinie(final String nom) {
        return(variables.get(nom) != null);
    }
    
    public void setValeurVariable(final String nom, final Double valeur) {
        variables.put(nom, valeur);
    }
    
    public void etapeTerminee() {
        if (label_etape == null)
            return;
        setValeurVariable(label_etape, new Double(1));
    }
    
    public boolean etapeAutorisee(final String label_etape) {
        if (label_etape == null)
            return(false);
        return(label_etape.equals(this.label_etape) || getValeurVariable(label_etape) == 1);
    }
}

