/*
Copyright (C) 2009 Observatoire de Paris

Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier conformment aux dispositions de la Licence Publique Gnrale GNU, telle que publie par la Free Software Foundation ; version 2 de la licence, ou encore ( votre choix) toute version ultrieure.

Ce programme est distribu dans l'espoir qu'il sera utile, mais SANS AUCUNE GARANTIE ; sans mme la garantie implicite de COMMERCIALISATION ou D'ADAPTATION A UN OBJET PARTICULIER. Pour plus de dtail, voir la Licence Publique Gnrale GNU .

Vous devez avoir reu un exemplaire de la Licence Publique Gnrale GNU en mme temps que ce programme ; si ce n'est pas le cas, crivez  la Free Software Foundation Inc., 675 Mass Ave, Cambridge, MA 02139, Etats-Unis.
*/

package serveurmica;

import java.io.*;
import java.util.*;

import javax.servlet.*;
import javax.servlet.http.*;

import org.w3c.dom.Document;
import org.w3c.dom.Element;


/**
 * Servlet Java du serveur MICA
 */

public class ServletMICA extends HttpServlet {
    private static ArrayList<EtudeDeCas> etudes_de_cas = null;
    private static Utilisateurs utilisateurs = null;
    
    
    
    private void erreurInterne(final String methode, final Exception ex) {
        erreurInterne(methode + ": " + ex.getClass().getName() + ": " + ex.getMessage());
    }
    
    private void erreurInterne(final Exception ex) {
        erreurInterne(ex.getClass().getName() + ": " + ex.getMessage());
    }
    
    private void erreurInterne(final String message) {
        log("Erreur interne: " + message);
    }
    
    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        initialisation();
    }
    
    public void initialisation() {
        log("ServletMICA: initialisation...");
        try {
            File dossier_etudes_de_cas = new File(getServletContext().getRealPath("/WEB-INF/etudes_de_cas"));
            if (!dossier_etudes_de_cas.isDirectory())
                erreurInterne("Le dossier etudes_de_cas n'existe pas.");
            final File fichier_xsl = new File(getServletContext().getRealPath("/WEB-INF/affichage_MICA.xsl"));
            etudes_de_cas = new ArrayList<EtudeDeCas>();
            for (File dossier_edc: dossier_etudes_de_cas.listFiles()) {
                if (dossier_edc.isDirectory()) {
                    final File dossier_contrib_edc = new File(dossier_edc, dossier_edc.getName());
                    if (dossier_contrib_edc.isDirectory()) {
                        final File fichier_xml = new File(dossier_contrib_edc, dossier_edc.getName() + ".xml");
                        if (fichier_xml.exists()) {
                            try {
                                etudes_de_cas.add(new EtudeDeCas(fichier_xml, fichier_xsl));
                            } catch (ExceptionMICA ex) {
                                erreurInterne(ex);
                            }
                        }
                    }
                }
            }
            utilisateurs = new Utilisateurs(new File(getServletContext().getRealPath("/WEB-INF/utilisateurs.xml")));
        } catch (ExceptionMICA ex) {
            erreurInterne(ex);
        }
        log("ServletMICA: fin de l'initialisation");
    }
    
    
    /**
     * Paramtres possibles pour une requte POST :
     * POUR UNE INSCRIPTION :
     * - username
     * - motdepasse
     * - motdepasse2
     * - nom
     * - prenom
     * - email
     *
     * POUR UNE CONNEXION AU SITE :
     * - login : login pour la connexion au site
     * - motdepasse : mot de passe pour la connexion au site
     *
     * POUR UN CHANGEMENT DE PAGE :
     * - enchainement_etape_{label de l'tape} : enchanement vers l'tape
     * - section_precedente : demande de passage  la section prcdente
     * - section_suivante : demande de passage  la section suivante
     * - exercice{numro exo dans la page}_question{numro question dans l'exo} : valeur de la rponse  la question
     * - ou ??? nom_variable : variables lies aux questions pour lesquelles une rponse est envoye
     *
     * POUR UN CHANGEMENT DE MOT DE PASSE :
     * - nouveaumdp : nouveau mot de passe, pour changer de mot de passe
     * - ancienmdp : ancien mot de passe
     * - nouveaumdpbis : recopie du nouveau mot de passe par l'utilisateur (doit tre gal  nouveaumdp)
     *
     * POUR UN CHOIX D'ETUDE DE CAS  commencer :
     * - operation : Commencer
     * - edc : label de l'tude de cas
     *
     * POUR UN CHOIX D'ETUDE DE CAS  continuer :
     * - operation : Continuer
     * - noedc : numro de l'tude de cas  continuer
     */
    public void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (utilisateurs == null) {
            envoyerErreur(resp, "La servlet n'est pas encore initialise");
            return;
        }
        if (req.getParameter("username") != null && req.getParameter("administration") == null) {
            final HttpSession session = req.getSession(true);
            final String username = req.getParameter("username");
            final String motdepasse = req.getParameter("motdepasse");
            final String motdepasse2 = req.getParameter("motdepasse2");
            final String nom = req.getParameter("nom");
            final String prenom = req.getParameter("prenom");
            final String email = req.getParameter("email");
            if (username == null) {
                envoyerErreur(resp, "Il manque le nom d'utilisateur.");
                return;
            }
            if (username.indexOf(' ') != -1) {
                envoyerErreur(resp, "Les espaces ne sont pas autoriss dans les noms d'utilisateur.");
                return;
            }
            final String accents = "";
            for (int i=0; i<accents.length(); i++)
                if (username.indexOf(accents.charAt(i)) != -1) {
                    envoyerErreur(resp, "Les accents ne sont pas autoriss dans les noms d'utilisateur.");
                    return;
                }
            final String majuscules = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
            for (int i=0; i<majuscules.length(); i++)
                if (username.indexOf(majuscules.charAt(i)) != -1) {
                    envoyerErreur(resp, "Les majuscules ne sont pas autoriss dans les noms d'utilisateur.");
                    return;
                }
            if (username.length() > 20) {
                envoyerErreur(resp, "Le nom d'utilisateur est trop long.");
                return;
            }
            final Utilisateur u_test = utilisateurs.getUtilisateur(username);
            if (u_test != null) {
                envoyerErreur(resp, "Un utilisateur existe dj avec ce nom d'utilisateur");
                return;
            }
            if (motdepasse == null || "".equals(motdepasse)) {
                envoyerErreur(resp, "Il manque le mot de passe.");
                return;
            }
            if (motdepasse.length() < 5) {
                envoyerErreur(resp, "Le mot de passe est trop court.");
                return;
            }
            if (motdepasse.length() > 30) {
                envoyerErreur(resp, "Le mot de passe est trop long.");
                return;
            }
            if (!motdepasse.equals(motdepasse2)) {
                envoyerErreur(resp, "Le deuxime champ pour le mot de passe n'est pas identique au premier.");
                return;
            }
            if (nom == null) {
                envoyerErreur(resp, "Il manque le nom de famille.");
                return;
            }
            if (prenom == null) {
                envoyerErreur(resp, "Il manque le prnom.");
                return;
            }
            if (email == null || email.indexOf('@') == -1 || email.indexOf('.') == -1) {
                envoyerErreur(resp, "Adresse mail non valide. Veuillez recommencer.");
                return;
            }
            inscription(resp, username, motdepasse, nom, prenom, email);
            return;
            
        } else if (req.getParameter("login") != null) {
            final HttpSession session = req.getSession(true);
            final String login = req.getParameter("login");
            final String motdepasse = req.getParameter("motdepasse");
            if (motdepasse == null) {
                envoyerErreur(resp, "Il manque des paramtres  la requte");
                return;
            }
            final Utilisateur u = utilisateurs.getUtilisateur(login);
            try {
                if (u == null || !u.verifierPassord(motdepasse, "378614")) {
                    envoyerErreur(resp, "Identification incorrecte");
                    return;
                }
            } catch (ExceptionMICA ex) {
                erreurInterne("doPost", ex);
                envoyerErreur(resp, "Erreur interne !");
                return;
            }
            if (!u.valide()) {
                envoyerErreur(resp, "Votre inscription n'a pas encore t valide par l'administrateur.");
                return;
            }
            if (u.ferme()) {
                envoyerErreur(resp, "Votre compte est ferm.");
                return;
            }
            session.setAttribute("utilisateur", u);
            accueil(resp, u);
            return;
            
        } else if (req.getParameter("administration") != null) {
            final HttpSession session = req.getSession(false);
            if (session == null) {
                envoyerErreur(resp, "Vous n'tes pas authentifi. Revenez  la page d'identification.");
                return;
            }
            final Utilisateur u_admin = (Utilisateur)session.getAttribute("utilisateur");
            if (u_admin == null) {
                envoyerErreur(resp, "Erreur  l'authentification. Revenez  la page d'identification.");
                return;
            }
            if (!u_admin.estAdministrateur()) {
                envoyerErreur(resp, "Vous n'tes pas administrateur.");
                return;
            }
            final String operation = req.getParameter("administration");
            if ("valider".equals(operation) || "fermer".equals(operation) || "rouvrir".equals(operation) || "supprimer".equals(operation)) {
                final String un_utilisateur = req.getParameter("username");
                final Utilisateur u = utilisateurs.getUtilisateur(un_utilisateur);
                if (u == null) {
                    envoyerErreur(resp, "Impossible de trouver l'utilisateur !");
                    return;
                }
                try {
                    if ("valider".equals(operation))
                        utilisateurs.valider(u);
                    else if ("fermer".equals(operation))
                        utilisateurs.fermer(u);
                    else if ("rouvrir".equals(operation))
                        utilisateurs.rouvrir(u);
                    else if ("supprimer".equals(operation))
                        utilisateurs.supprimer(u);
                } catch (ExceptionMICA ex) {
                    erreurInterne("doPost", ex);
                    envoyerErreur(resp, "Erreur interne !");
                    return;
                }
                gestion(resp);
                return;
            } else if ("gestion".equals(operation)) {
                gestion(resp);
                return;
            } else if ("initialisation".equals(operation)) {
                final String login = u_admin.getUsername();
                initialisation();
                final Utilisateur u = utilisateurs.getUtilisateur(login);
                session.setAttribute("utilisateur", u);
                accueil(resp, u);
                return;
            } else {
                envoyerErreur(resp, "requte POST non comprise (administration)");
                return;
            }
            
        } else if ("Commencer".equals(req.getParameter("operation")) && req.getParameter("edc") != null) {
            final HttpSession session = req.getSession(false);
            if (session == null) {
                envoyerErreur(resp, "Vous n'tes pas authentifi. Revenez  la page d'identification.");
                return;
            }
            final Utilisateur apprenant = (Utilisateur)session.getAttribute("utilisateur");
            if (apprenant == null) {
                envoyerErreur(resp, "Erreur  l'authentification. Revenez  la page d'identification.");
                return;
            }
            final String label_edc = req.getParameter("edc");
            final EtudeDeCas edc = trouverEDC(label_edc);
            if (edc == null) {
                envoyerErreur(resp, "Etude de cas introuvable !");
                return;
            }
            try {
                final SuiviEDC suivi = apprenant.nouveauSuivi(label_edc);
                suivi.setLabelEtape(edc.labelPremiereEtape());
                session.setAttribute("suivi", suivi);
                utilisateurs.enregistrer();
                edc.afficherPage(resp, suivi);
                return;
            } catch (ExceptionMICA ex) {
                erreurInterne("doPost", ex);
                envoyerErreur(resp, "Erreur interne !");
                return;
            }
            
        } else if ("Continuer".equals(req.getParameter("operation")) && req.getParameter("noedc") != null) {
            final HttpSession session = req.getSession(false);
            if (session == null) {
                envoyerErreur(resp, "Vous n'tes pas authentifi. Revenez  la page d'identification.");
                return;
            }
            final Utilisateur apprenant = (Utilisateur)session.getAttribute("utilisateur");
            if (apprenant == null) {
                envoyerErreur(resp, "Erreur  l'authentification. Revenez  la page d'identification.");
                return;
            }
            EtudeDeCas edc = null;
            SuiviEDC suivi = null;
            final String snoedc = req.getParameter("noedc");
            int noedc;
            try {
                noedc = Integer.valueOf(snoedc).intValue();
            } catch (NumberFormatException ex) {
                envoyerErreur(resp, "le numro d'tude de cas n'est pas un entier: " + edc);
                return;
            }
            int no = 0;
            for (SuiviEDC s : apprenant.getSuivis()) {
                if (!s.terminee()) {
                    final EtudeDeCas e = trouverEDC(s.getLabelEDC());
                    if (e != null) {
                        no++;
                        if (no == noedc) {
                            suivi = s;
                            edc = e;
                            break;
                        }
                    }
                }
            }
            if (edc == null) {
                envoyerErreur(resp, "Etude de cas introuvable !");
                return;
            }
            final String label_edc = edc.getLabel();
            session.setAttribute("suivi", suivi);
            try {
                edc.afficherPage(resp, suivi);
                return;
            } catch (ExceptionMICA ex) {
                erreurInterne("doPost", ex);
                envoyerErreur(resp, "Erreur interne !");
                return;
            }
            
        } else if (req.getParameter("section_suivante") != null || req.getParameter("section_suivante.x") != null ||
                req.getParameter("section_precedente") != null || req.getParameter("section_precedente.x") != null) {
            // ".x"  cause d'un bug de IE
            final HttpSession session = req.getSession(false);
            if (session == null) {
                envoyerErreur(resp, "Vous n'tes pas authentifi. Revenez  la page d'identification.");
                return;
            }
            final SuiviEDC suivi = (SuiviEDC)session.getAttribute("suivi");
            if (suivi == null) {
                envoyerErreur(resp, "Suivi introuvable !");
                return;
            }
            final String label_edc = suivi.getLabelEDC();
            final EtudeDeCas edc = trouverEDC(label_edc);
            if (edc == null) {
                envoyerErreur(resp, "Etude de cas '" + label_edc + "' introuvable !");
                return;
            }
            final String label_etape = suivi.getLabelEtape();
            final String label_section = suivi.getLabelSection();
            final String label_autre_section;
            if (req.getParameter("section_suivante") != null || req.getParameter("section_suivante.x") != null)
                label_autre_section = edc.labelSectionSuivante(label_etape, label_section);
            else
                label_autre_section = edc.labelSectionPrecedente(label_etape, label_section);
            try {
                edc.majSuivi(suivi, label_etape, label_autre_section);
                utilisateurs.enregistrer();
                edc.afficherPage(resp, suivi);
            } catch (ExceptionMICA ex) {
                erreurInterne("section_suivante/precedente", ex);
                envoyerErreur(resp, "Erreur interne !");
                return;
            }
            return;
        }
        for (Enumeration e = req.getParameterNames(); e.hasMoreElements(); ) {
            final String nom_parametre = (String)e.nextElement();
            if (nom_parametre.startsWith("enchainement_etape_")) {
                // passage  une autre tape via un enchanement
                final HttpSession session = req.getSession(false);
                if (session == null) {
                    envoyerErreur(resp, "Vous n'tes pas authentifi. Revenez  la page d'identification.");
                    return;
                }
                final String label_etape = nom_parametre.substring("enchainement_etape_".length());
                final SuiviEDC suivi = (SuiviEDC)session.getAttribute("suivi");
                if (suivi == null) {
                    envoyerErreur(resp, "Suivi introuvable !");
                    return;
                }
                final String label_edc = suivi.getLabelEDC();
                final EtudeDeCas edc = trouverEDC(label_edc);
                if (edc == null) {
                    envoyerErreur(resp, "Etude de cas '" + label_edc + "' introuvable !");
                    return;
                }
                try {
                    // test si enchanement autoris: (avant ou aprs intgration ?)
                    if (!edc.enchainementPossible(suivi.getLabelEtape(), label_etape, suivi)) {
                        envoyerErreur(resp, "Enchanement interdit !");
                        return;
                    }
                    // intgration des nouvelles variables dans le suivi
                    final Hashtable<String, ArrayList<String>> parametres = new Hashtable<String, ArrayList<String>>();
                    for (Enumeration e2 = req.getParameterNames(); e2.hasMoreElements(); ) {
                        final String nom = (String)e2.nextElement();
                        if (nom.startsWith("exercice")) {
                            final ArrayList<String> valeurs = new ArrayList<String>(Arrays.asList(req.getParameterValues(nom)));
                            parametres.put(nom, valeurs);
                        }
                    }
                    edc.verifierParametres(parametres, suivi);
                    edc.majVariables(parametres, suivi);
                    // mise  jour du suivi avec le changement d'tape
                    edc.majSuivi(suivi, label_etape, null);
                    utilisateurs.enregistrer();
                    // affichage de la nouvelle page
                    edc.afficherPage(resp, suivi);
                    return;
                } catch (ExceptionMICA ex) {
                    if (ex.erreurUtilisateur())
                        envoyerErreur(resp, ex.getMessage());
                    else {
                        erreurInterne("doPost", ex);
                        envoyerErreur(resp, "Erreur interne !");
                    }
                    return;
                }
            }
        }
        envoyerErreur(resp, "requte POST non comprise");
        return;
    }
    
    /**
     * Paramtres possibles pour une requte GET :
     * autre_section: changement de section; valeurs: suivante|precedente
     * fichier: envoi d'un fichier en binaire; valeur: chemin d'un fichier associ  l'tape et la section courante
     * page: affichage d'une page spciale; valeurs: accueil|sommaire|glossaire|bibliographie|bibliotheque
     * label_etape: passage  une autre tape via un lien interne ou le sommaire; valeurs: label de l'tape
     * label_section: passage  une autre section via un lien interne; valeurs: label de la section
     * equation: image d'une quation; valeurs: numro de l'quation dans la page
     *
     * Avec le chemin: (comme l'interface change rarement il est prfrable qu'elle soit mise dans le cache des navigateurs)
     * MICA/interface/... : fichier de l'interface
     */
    public void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (utilisateurs == null) {
            envoyerErreur(resp, "La servlet n'est pas encore initialise");
            return;
        }
        // fichier de l'interface (l'authentification n'est pas requise)
        if (req.getPathInfo() != null) {
            String chemin = req.getPathInfo();
            if (!chemin.startsWith("/interface/")) {
                envoyerErreur(resp, "Chemin impossible.");
                log("Chemin impossible: " + chemin);
                return;
            }
            final File fichier = new File(getServletContext().getRealPath(chemin));
            if (!fichier.getCanonicalPath().startsWith((new File(getServletContext().getRealPath("/"))).getCanonicalPath())) {
                envoyerErreur(resp, "Accs interdit !");
                log("Accs interdit: " + chemin);
                return;
            }
            final String mime = getServletContext().getMimeType(fichier.getName().toLowerCase());
            if (mime == null)
                throw new IOException("MIME inconnu pour " + fichier.getName());
            resp.setContentType(mime);
            resp.setContentLength((int)fichier.length());
            envoyerFichier(resp.getOutputStream(), fichier);
            return;
        }
        // l'authentification est ncessaire au pralable
        final HttpSession session = req.getSession(false);
        if (session == null) {
            envoyerErreur(resp, "Vous n'tes pas authentifi. Revenez  la page d'identification.");
            return;
        }
        final Utilisateur apprenant = (Utilisateur)session.getAttribute("utilisateur");
        if (apprenant == null) {
            envoyerErreur(resp, "Erreur  l'authentification. Revenez  la page d'identification.");
            return;
        }
        if (req.getParameter("autre_section") != null) {
            final String autre_section = req.getParameter("autre_section");
            final SuiviEDC suivi = (SuiviEDC)session.getAttribute("suivi");
            if (suivi == null) {
                envoyerErreur(resp, "Suivi introuvable !");
                return;
            }
            final String label_edc = suivi.getLabelEDC();
            final EtudeDeCas edc = trouverEDC(label_edc);
            if (edc == null) {
                envoyerErreur(resp, "Etude de cas '" + label_edc + "' introuvable !");
                return;
            }
            if ("suivante".equals(autre_section) || "precedente".equals(autre_section)) {
                final String label_etape = suivi.getLabelEtape();
                final String label_section = suivi.getLabelSection();
                final String label_autre_section;
                if ("suivante".equals(autre_section))
                    label_autre_section = edc.labelSectionSuivante(label_etape, label_section);
                else
                    label_autre_section = edc.labelSectionPrecedente(label_etape, label_section);
                try {
                    edc.majSuivi(suivi, label_etape, label_autre_section);
                    utilisateurs.enregistrer();
                    edc.afficherPage(resp, suivi);
                } catch (ExceptionMICA ex) {
                    erreurInterne("autre_section", ex);
                    envoyerErreur(resp, "Erreur interne !");
                    return;
                }
                return;
            } else {
                envoyerErreur(resp, "Mauvaise valeur pour le paramtre autre_section.");
                return;
            }
        } else if (req.getParameter("fichier") != null) {
            final String chemin_fichier = req.getParameter("fichier");
            final SuiviEDC suivi = (SuiviEDC)session.getAttribute("suivi");
            if (suivi == null) {
                envoyerErreur(resp, "Suivi introuvable !");
                return;
            }
            final String label_edc = suivi.getLabelEDC();
            final EtudeDeCas edc = trouverEDC(label_edc);
            if (edc == null) {
                envoyerErreur(resp, "Etude de cas '" + label_edc + "' introuvable !");
                return;
            }
            final File fichier_contrib = edc.getFichierContrib(suivi);
            if (fichier_contrib == null) {
                envoyerErreur(resp, "Etape '" + suivi.getLabelEtape() + "' introuvable !");
                return;
            }
            final String nom_contrib = fichier_contrib.getParentFile().getName();
            final String chemin = "/WEB-INF/etudes_de_cas/" + label_edc + "/" + nom_contrib + "/" + chemin_fichier;
            final File fichier = new File(getServletContext().getRealPath(chemin));
            if (!fichier.getCanonicalPath().startsWith((new File(getServletContext().getRealPath("/"))).getCanonicalPath())) {
                envoyerErreur(resp, "Accs interdit !");
                log("Accs interdit: " + chemin);
                return;
            }
            final String mime = getServletContext().getMimeType(fichier.getName().toLowerCase());
            if (mime == null)
                throw new IOException("MIME inconnu pour " + fichier.getName());
            resp.setContentType(mime);
            resp.setContentLength((int)fichier.length());
            envoyerFichier(resp.getOutputStream(), fichier);
            return;
        } else if (req.getParameter("page") != null) {
            final String page = req.getParameter("page");
            if ("accueil".equals(page)) {
                accueil(resp, apprenant);
                return;
            } else if ("sommaire".equals(page) || "glossaire".equals(page) || "bibliographie".equals(page) || "bibliotheque".equals(page)) {
                final SuiviEDC suivi = (SuiviEDC)session.getAttribute("suivi");
                if (suivi == null) {
                    envoyerErreur(resp, "Suivi introuvable !");
                    return;
                }
                final String label_edc = suivi.getLabelEDC();
                final EtudeDeCas edc = trouverEDC(label_edc);
                if (edc == null) {
                    envoyerErreur(resp, "Etude de cas '" + label_edc + "' introuvable !");
                    return;
                }
                resp.setHeader("Pragma", "no-cache");
                resp.setHeader("Cache-Control", "no-cache");
                resp.setHeader("Expires", "0");
                resp.setContentType("text/html; charset=ISO-8859-1");
                try {
                    if ("sommaire".equals(page))
                        edc.afficherSommaire(resp.getWriter(), suivi);
                    else if ("glossaire".equals(page))
                        edc.afficherGlossaire(resp.getWriter());
                    else if ("bibliographie".equals(page))
                        edc.afficherBibliographie(resp.getWriter());
                    else
                        edc.afficherBibliotheque(resp);
                } catch (ExceptionMICA ex) {
                    erreurInterne("page " + page, ex);
                    envoyerErreur(resp, "Erreur interne !");
                    return;
                }
                return;
            }
            envoyerErreur(resp, "requte non comprise");
            return;
        } else if (req.getParameter("label_etape") != null) {
            final String label_etape = req.getParameter("label_etape");
            final SuiviEDC suivi = (SuiviEDC)session.getAttribute("suivi");
            if (suivi == null) {
                envoyerErreur(resp, "Suivi introuvable !");
                return;
            }
            if (!suivi.etapeAutorisee(label_etape)) {
                envoyerErreur(resp, "Vous n'tes pas autoris  aller directement vers cette tape.");
                return;
            }
            final String label_edc = suivi.getLabelEDC();
            final EtudeDeCas edc = trouverEDC(label_edc);
            if (edc == null) {
                envoyerErreur(resp, "Etude de cas '" + label_edc + "' introuvable !");
                return;
            }
            try {
                edc.majSuivi(suivi, label_etape, null);
                utilisateurs.enregistrer();
                edc.afficherPage(resp, suivi);
            } catch (ExceptionMICA ex) {
                erreurInterne("doPost", ex);
                envoyerErreur(resp, "Erreur interne !");
                return;
            }
            return;
        } else if (req.getParameter("label_section") != null) {
            final String label_section = req.getParameter("label_section");
            final SuiviEDC suivi = (SuiviEDC)session.getAttribute("suivi");
            if (suivi == null) {
                envoyerErreur(resp, "Suivi introuvable !");
                return;
            }
            final String label_edc = suivi.getLabelEDC();
            final EtudeDeCas edc = trouverEDC(label_edc);
            if (edc == null) {
                envoyerErreur(resp, "Etude de cas '" + label_edc + "' introuvable !");
                return;
            }
            try {
                edc.majSuivi(suivi, edc.labelEtapeSection(label_section), label_section);
                utilisateurs.enregistrer();
                edc.afficherPage(resp, suivi);
            } catch (ExceptionMICA ex) {
                erreurInterne("doPost", ex);
                envoyerErreur(resp, "Erreur interne !");
                return;
            }
            return;
        } else if (req.getParameter("equation") != null) {
            final SuiviEDC suivi = (SuiviEDC)session.getAttribute("suivi");
            if (suivi == null) {
                envoyerErreur(resp, "Suivi introuvable !");
                return;
            }
            final int numero;
            try {
                numero = Integer.valueOf(req.getParameter("equation")).intValue();
            } catch (NumberFormatException ex) {
                envoyerErreur(resp, "le numro d'quation n'est pas un entier: " + req.getParameter("equation"));
                return;
            }
            final String label_edc = suivi.getLabelEDC();
            final EtudeDeCas edc = trouverEDC(label_edc);
            if (edc == null) {
                envoyerErreur(resp, "Etude de cas '" + label_edc + "' introuvable !");
                return;
            }
            try {
                edc.envoyerEquation(resp, numero,  suivi);
                return;
            } catch (ExceptionMICA ex) {
                erreurInterne("equation", ex);
                envoyerErreur(resp, "Erreur interne !");
                return;
            }
        }
        envoyerErreur(resp, "requte GET non comprise");
        return;
    }
    
    /**
     * Inscription et page de confirmation
     */
    public void inscription(final HttpServletResponse resp, final String username, final String motdepasse,
            final String nom, final String prenom, final String email) {
        final boolean premier = utilisateurs.aucunUtilisateur();
        final String type;
        if (premier)
            type = "administrateur";
        else
            type = "apprenant";
        try {
            Utilisateur u = utilisateurs.nouvelUtilisateur(username, motdepasse, type, nom, prenom, email, "378614");
            if (premier)
                utilisateurs.valider(u);
        } catch (ExceptionMICA ex) {
            erreurInterne("inscription", ex);
            envoyerErreur(resp, "Erreur interne  l'inscription.");
            return;
        }
        try {
            resp.setHeader("Pragma", "no-cache");
            resp.setHeader("Cache-Control", "no-cache");
            resp.setHeader("Expires", "0");
            resp.setContentType("text/html; charset=ISO-8859-1");
            final PrintWriter pw = resp.getWriter();
            entete(pw, null, "Inscription");
            pw.println("<p>L'inscription a bien t enregistre.</p>");
            if (premier) {
                pw.println("<p>Comme vous tes le premier utilisateur, votre inscription a automatiquement t valide comme administrateur.</p>");
                pw.println("<p><a href=\"index.html\">Revenir  la page de connexion</a></p>");
            } else
                pw.println("<p>Vous devez maintenant attendre la validation de l'administrateur.</p>");
            pied(pw);
        } catch (IOException ex) {
            erreurInterne("inscription", ex);
        }
    }
    
    /**
     * Page d'accueil affiche aprs l'identification
     */
    public void accueil(final HttpServletResponse resp, Utilisateur u) {
        try {
            resp.setHeader("Pragma", "no-cache");
            resp.setHeader("Cache-Control", "no-cache");
            resp.setHeader("Expires", "0");
            resp.setContentType("text/html; charset=ISO-8859-1");
            final PrintWriter pw = resp.getWriter();
            entete(pw, null, "MICA - Accueil");
            if (u.estAdministrateur()) {
                pw.println("<h2>Administration</h2>");
                pw.println("<form action=\"MICA\" method=\"post\">");
                pw.println("<input name=\"administration\" type=\"hidden\" value=\"gestion\">");
                pw.println("<p><input type=\"submit\" value=\"Gestion des utilisateurs\"></p>");
                pw.println("</form>");
                pw.println("<form action=\"MICA\" method=\"post\">");
                pw.println("<input name=\"administration\" type=\"hidden\" value=\"initialisation\">");
                pw.println("<p><input type=\"submit\" value=\"Rinitialiser MICA\"></p>");
                pw.println("</form>");
                pw.println("<hr>");
                pw.println("<h2>Etudes de cas</h2>");
            }
            pw.println("<p>Vos tudes de cas en cours:</p>");
            pw.println("<form action=\"MICA\" method=\"post\">");
            pw.println("<p><select name=\"noedc\">");
            int no = 0;
            for (SuiviEDC suivi : u.getSuivis()) {
                if (!suivi.terminee()) {
                    final EtudeDeCas edc = trouverEDC(suivi.getLabelEDC());
                    if (edc != null) {
                        no++;
                        pw.println("<option value=\"" + no + "\">" + OutilsXML.encoder(edc.getTitre()) + "</option>");
                    }
                }
            }
            pw.println("</select></p>");
            pw.println("<p><input type=\"submit\" name=\"operation\" value=\"Continuer\"></p>");
            pw.println("</form>");
            pw.println("<hr>");
            pw.println("<p>Commencer une nouvelle tude de cas:</p>");
            pw.println("<form action=\"MICA\" method=\"post\">");
            pw.println("<p><select name=\"edc\">");
            for (EtudeDeCas edc : etudes_de_cas)
                pw.println("<option value=\"" + edc.getLabel() + "\">" + OutilsXML.encoder(edc.getTitre()) + "</option>");
            pw.println("</select></p>");
            pw.println("<p><input type=\"submit\" name=\"operation\" value=\"Commencer\"></p>");
            pw.println("</form>");
            pied(pw);
        } catch (IOException ex) {
            erreurInterne("accueil", ex);
        }
    }
    
    /**
     * Administration: gestion des utilisateurs
     */
    public void gestion(final HttpServletResponse resp) {
        /*
           valide | ferm | tat
           -------|-------|--------------------
            non   |  non  | nouvel inscrit
            non   |  oui  |inscription refuse
            oui   |  non  | utilisateur valide
            oui   |  oui  | compte ferm
        */
        try {
            resp.setHeader("Pragma", "no-cache");
            resp.setHeader("Cache-Control", "no-cache");
            resp.setHeader("Expires", "0");
            resp.setContentType("text/html; charset=ISO-8859-1");
            final PrintWriter pw = resp.getWriter();
            entete(pw, null, "Administration");
            ArrayList<Utilisateur> liste_utilisateurs_a_valider = utilisateurs.selectionUtilisateurs(Boolean.FALSE, Boolean.FALSE);
            if (liste_utilisateurs_a_valider.size() > 0) {
                pw.println("<h2>Inscriptions  valider</h2>");
                pw.println("<table cellpadding=\"2\" cellspacing=\"0\" border=\"1\">");
                pw.println("<tr><th>Login</th><th>Type</th><th>Nom</th><th>Prnom</th><th>Email</th><th>Operations</th></tr>");
                for (Utilisateur u : liste_utilisateurs_a_valider) {
                    pw.println("<tr>");
                    pw.println("<td>" + u.getUsername() + "</td>");
                    pw.println("<td>" + u.getType() + "</td>");
                    pw.println("<td>" + u.getNom() + "</td>");
                    pw.println("<td>" + u.getPrenom() + "</td>");
                    pw.println("<td>" + u.getEmail() + "</td>");
                    pw.println("<td>");
                    pw.println("<form action=\"MICA\" method=\"post\">");
                    pw.println("<input name=\"administration\" type=\"hidden\" value=\"valider\">");
                    pw.println("<input name=\"username\" type=\"hidden\" value=\"" + u.getUsername() + "\">");
                    pw.println("<input type=\"submit\" value=\"Valider\">");
                    pw.println("</form>");
                    pw.println("<form action=\"MICA\" method=\"post\">");
                    pw.println("<input name=\"administration\" type=\"hidden\" value=\"fermer\">");
                    pw.println("<input name=\"username\" type=\"hidden\" value=\"" + u.getUsername() + "\">");
                    pw.println("<input type=\"submit\" value=\"Fermer le compte\">");
                    pw.println("</form>");
                    pw.println("</td>");
                    pw.println("</tr>");
                }
                pw.println("</table>");
                pw.println("<br><hr>");
            }
            ArrayList<Utilisateur> liste_utilisateurs_ouvert = utilisateurs.selectionUtilisateurs(Boolean.TRUE, Boolean.FALSE);
            if (liste_utilisateurs_ouvert.size() > 0) {
                pw.println("<h2>Utilisateurs avec un compte valide et ouvert</h2>");
                pw.println("<table cellpadding=\"2\" cellspacing=\"0\" border=\"1\">");
                pw.println("<tr><th>Login</th><th>Type</th><th>Nom</th><th>Prnom</th><th>Email</th><th>Operations</th></tr>");
                int nb_admin = 0;
                for (Utilisateur u : liste_utilisateurs_ouvert)
                    if (u.estAdministrateur())
                        nb_admin++;
                for (Utilisateur u : liste_utilisateurs_ouvert) {
                    pw.println("<tr>");
                    pw.println("<td>" + u.getUsername() + "</td>");
                    pw.println("<td>" + u.getType() + "</td>");
                    pw.println("<td>" + u.getNom() + "</td>");
                    pw.println("<td>" + u.getPrenom() + "</td>");
                    pw.println("<td>" + u.getEmail() + "</td>");
                    pw.println("<td>");
                    if (!u.estAdministrateur() || nb_admin > 1) {
                        pw.println("<form action=\"MICA\" method=\"post\">");
                        pw.println("<input name=\"administration\" type=\"hidden\" value=\"fermer\">");
                        pw.println("<input name=\"username\" type=\"hidden\" value=\"" + u.getUsername() + "\">");
                        pw.println("<input type=\"submit\" value=\"Fermer le compte\">");
                        pw.println("</form>");
                    }
                    pw.println("</td>");
                    pw.println("</tr>");
                }
                pw.println("</table>");
                pw.println("<br><hr>");
            }
            ArrayList<Utilisateur> liste_utilisateurs_ferme = utilisateurs.selectionUtilisateurs(null, Boolean.TRUE);
            if (liste_utilisateurs_ferme.size() > 0) {
                pw.println("<h2>Utilisateurs avec un compte ferm</h2>");
                pw.println("<table cellpadding=\"2\" cellspacing=\"0\" border=\"1\">");
                pw.println("<tr><th>Login</th><th>Type</th><th>Nom</th><th>Prnom</th><th>Email</th><th>Valide</th><th>Operations</th></tr>");
                for (Utilisateur u : liste_utilisateurs_ferme) {
                    pw.println("<tr>");
                    pw.println("<td>" + u.getUsername() + "</td>");
                    pw.println("<td>" + u.getType() + "</td>");
                    pw.println("<td>" + u.getNom() + "</td>");
                    pw.println("<td>" + u.getPrenom() + "</td>");
                    pw.println("<td>" + u.getEmail() + "</td>");
                    pw.println("<td>" + (u.valide() ? "oui" : "non") + "</td>");
                    pw.println("<td>");
                    pw.println("<form action=\"MICA\" method=\"post\">");
                    pw.println("<input name=\"administration\" type=\"hidden\" value=\"rouvrir\">");
                    pw.println("<input name=\"username\" type=\"hidden\" value=\"" + u.getUsername() + "\">");
                    pw.println("<input type=\"submit\" value=\"Rouvrir le compte\">");
                    pw.println("</form>");
                    pw.println("<form action=\"MICA\" method=\"post\">");
                    pw.println("<input name=\"administration\" type=\"hidden\" value=\"supprimer\">");
                    pw.println("<input name=\"username\" type=\"hidden\" value=\"" + u.getUsername() + "\">");
                    pw.println("<input type=\"submit\" value=\"Supprimer\">");
                    pw.println("</form>");
                    pw.println("</td>");
                    pw.println("</tr>");
                }
                pw.println("</table>");
            }
            pw.println("<p><a href=\"MICA?page=accueil\">Revenir  l'accueil</a></p>");
            pied(pw);
        } catch (IOException ex) {
            erreurInterne("gestion", ex);
        }
    }
    
    public EtudeDeCas trouverEDC(final String label) {
        if (label == null)
            return(null);
        for (EtudeDeCas edc : etudes_de_cas)
            if (label.equals(edc.getLabel()))
                return(edc);
        return(null);
    }
    
    public static void entete(final PrintWriter pw, final String titre_site, final String titre_page) {
        pw.println("<!DOCTYPE html PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">");
        pw.println("<html>");
        pw.println("<head>");
        pw.println("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=iso-8859-1\">");
        pw.println("<title>" + titre_page + "</title>");
        pw.println("<link href=\"MICA/interface/style.css\" rel=\"stylesheet\" type=\"text/css\">");
        pw.println("</head>");
        pw.println("<body class=\"page\">");
        pw.println("<div class=\"zone_logo\">");
        pw.println("<img src=\"MICA/interface/logo.png\" alt=\"logo\">");
        pw.println("</div>");
        if (titre_site != null) {
            pw.println("<div class=\"titre_site_1\">" + titre_site + "</div>");
            pw.println("<div class=\"titre_site_2\">" + titre_site + "</div>");
        }
        pw.println("<div class=\"zone_titre\">");
        pw.println("<table cellpadding=\"0\" cellspacing=\"0\"><tr><td>");
        pw.println("<h1>" + titre_page + "</h1>");
        pw.println("</td></tr></table>");
        pw.println("</div>");
        pw.println("<div class=\"zone_contenu\">");
        pw.println("<div class=\"zone_texte\">");
    }
    
    public static void pied(final PrintWriter pw) {
        pw.println("</div>");
        pw.println("</div>");
        pw.println("</body>");
        pw.println("</html>");
        pw.flush();
    }
    
    protected void envoyerErreur(final HttpServletResponse resp, final String errmsg) {
        try {
            resp.setHeader("Pragma", "no-cache");
            resp.setHeader("Cache-Control", "no-cache");
            resp.setHeader("Expires", "0");
            resp.setContentType("text/html; charset=ISO-8859-1");
            final PrintWriter pw = resp.getWriter();
            entete(pw, null, "Erreur");
            pw.println("<p>Une erreur s'est produite lors du traitement de votre requte: " + OutilsXML.encoder(errmsg) + "</p>");
            pw.println("<p>Utiliser le bouton retour du navigateur pour revenir en arrire.</p>");
            pied(pw);
        } catch (IOException ex) {
            erreurInterne("envoyerErreur", ex);
        }
    }
    
    protected void envoyerFichier(OutputStream outs, File inputFile) {
        try {
            final BufferedInputStream bin = new BufferedInputStream(new FileInputStream(inputFile));
            final BufferedOutputStream bout = new BufferedOutputStream(outs);
            
            int length = 32;
            final byte[] ch = new byte[length]; 
            while((length = bin.read(ch)) != -1)
                bout.write(ch, 0, length); 
            
            bin.close();
            bout.flush();
        } catch (IOException ex) {
            erreurInterne("envoyerFichier '" + inputFile.getName() + "'", ex);
        }
    }
}
