/*
Copyright (C) 2009 Observatoire de Paris

Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier conformment aux dispositions de la Licence Publique Gnrale GNU, telle que publie par la Free Software Foundation ; version 2 de la licence, ou encore ( votre choix) toute version ultrieure.

Ce programme est distribu dans l'espoir qu'il sera utile, mais SANS AUCUNE GARANTIE ; sans mme la garantie implicite de COMMERCIALISATION ou D'ADAPTATION A UN OBJET PARTICULIER. Pour plus de dtail, voir la Licence Publique Gnrale GNU .

Vous devez avoir reu un exemplaire de la Licence Publique Gnrale GNU en mme temps que ce programme ; si ce n'est pas le cas, crivez  la Free Software Foundation Inc., 675 Mass Ave, Cambridge, MA 02139, Etats-Unis.
*/

package serveurmica;

import java.io.PrintWriter;
import java.util.ArrayList;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

/**
 * Plan de l'tude de cas
 */
public class Plan {
    
    private ArrayList<ElementDuPlan> elements;
    
    public Plan(final Element el) {
        elements = new ArrayList<ElementDuPlan>();
        final ArrayList<Element> enfants = OutilsXML.enfants(el);
        for (Element enfant : enfants) {
            if ("DOSSIER".equals(enfant.getLocalName()))
                elements.add(new DossierDuPlan(enfant));
            else if ("REF_ETAPE".equals(enfant.getLocalName()))
                elements.add(new EtapeDuPlan(enfant));
        }
    }
    
    public String labelPremiereEtape() {
        if (elements.size() < 1)
            return(null);
        ElementDuPlan premierElement = elements.get(0);
        if (premierElement instanceof EtapeDuPlan)
            return(((EtapeDuPlan)premierElement).getLabel());
        else
            return(((DossierDuPlan)premierElement).labelPremiereEtape());
    }
    
    public void setTitreEtape(final String label, final String titre) {
        for (ElementDuPlan elplan : elements)
            elplan.setTitreEtape(label, titre);
    }
    
    public Element elementInter(final Document doc_inter, final SuiviEDC suivi) {
        final Element plan_edc = doc_inter.createElementNS(null, "PLAN_EDC");
        for (ElementDuPlan elplan : elements)
            plan_edc.appendChild(elplan.elementInter(doc_inter, suivi));
        return(plan_edc);
    }
    
    public void afficherSommaire(final PrintWriter pw, final SuiviEDC suivi) {
        pw.println("<ul>");
        for (ElementDuPlan elplan : elements)
            elplan.afficherSommaire(pw, suivi);
        pw.println("</ul>");
    }
    
    
    interface ElementDuPlan {
        public String getTitre();
        public void setTitreEtape(final String label, final String titre);
        public Element elementInter(final Document doc_inter, final SuiviEDC suivi);
        public void afficherSommaire(final PrintWriter pw, final SuiviEDC suivi);
    }
    
    class DossierDuPlan implements ElementDuPlan {
        private String titre;
        private ArrayList<ElementDuPlan> elements;
        DossierDuPlan(final Element el) {
            elements = new ArrayList<ElementDuPlan>();
            titre = el.getAttribute("titre");
            final ArrayList<Element> enfants = OutilsXML.enfants(el);
            for (Element enfant : enfants) {
                if ("DOSSIER".equals(enfant.getLocalName()))
                    elements.add(new DossierDuPlan(enfant));
                else if ("REF_ETAPE".equals(enfant.getLocalName()))
                    elements.add(new EtapeDuPlan(enfant));
            }
        }
        public String getTitre() {
            return(titre);
        }
        String labelPremiereEtape() {
            if (elements.size() < 1)
                return(null);
            ElementDuPlan premierElement = elements.get(0);
            if (premierElement instanceof EtapeDuPlan)
                return(((EtapeDuPlan)premierElement).getLabel());
            else
                return(((DossierDuPlan)premierElement).labelPremiereEtape());
        }
        public void setTitreEtape(final String label, final String titre) {
            for (ElementDuPlan elplan : elements)
                elplan.setTitreEtape(label, titre);
        }
        public Element elementInter(final Document doc_inter, final SuiviEDC suivi) {
            final Element el_dossier = doc_inter.createElementNS(null, "DOSSIER");
            el_dossier.setAttributeNS(null, "titre", titre);
            for (ElementDuPlan elplan : elements)
                el_dossier.appendChild(elplan.elementInter(doc_inter, suivi));
            return(el_dossier);
        }
        public void afficherSommaire(final PrintWriter pw, final SuiviEDC suivi) {
            pw.println("<ul>");
            for (ElementDuPlan elplan : elements)
                elplan.afficherSommaire(pw, suivi);
            pw.println("</ul>");
        }
    }
    
    class EtapeDuPlan implements ElementDuPlan {
        private String label;
        private String titre;
        EtapeDuPlan(final Element el) {
            label = el.getAttribute("label");
            titre = null;
        }
        public String getTitre() {
            return(titre);
        }
        String getLabel() {
            return(label);
        }
        public void setTitreEtape(final String label, final String titre) {
            if (label != null && label.equals(this.label))
                this.titre = titre;
        }
        public Element elementInter(final Document doc_inter, final SuiviEDC suivi) {
            final Element el_etape = doc_inter.createElementNS(null, "ETAPE");
            el_etape.setAttributeNS(null, "label", label);
            el_etape.setAttributeNS(null, "titre", titre);
            el_etape.setAttributeNS(null, "active", label.equals(suivi.getLabelEtape()) ? "oui" : "non");
            el_etape.setAttributeNS(null, "lien", suivi.etapeAutorisee(label) ? "oui" : "non");
            return(el_etape);
        }
        public void afficherSommaire(final PrintWriter pw, final SuiviEDC suivi) {
            if (suivi.etapeAutorisee(label))
                pw.println("<li><a href=\"MICA?label_etape=" + label + "\">" + OutilsXML.encoder(titre) + "</a></li>");
            else
                pw.println("<li>" + OutilsXML.encoder(titre) + "</li>");
        }
    }
}
