/*
Copyright (C) 2009 Observatoire de Paris

Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier conformment aux dispositions de la Licence Publique Gnrale GNU, telle que publie par la Free Software Foundation ; version 2 de la licence, ou encore ( votre choix) toute version ultrieure.

Ce programme est distribu dans l'espoir qu'il sera utile, mais SANS AUCUNE GARANTIE ; sans mme la garantie implicite de COMMERCIALISATION ou D'ADAPTATION A UN OBJET PARTICULIER. Pour plus de dtail, voir la Licence Publique Gnrale GNU .

Vous devez avoir reu un exemplaire de la Licence Publique Gnrale GNU en mme temps que ce programme ; si ce n'est pas le cas, crivez  la Free Software Foundation Inc., 675 Mass Ave, Cambridge, MA 02139, Etats-Unis.
*/

package serveurmica;

import java.io.*;
import java.util.*;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.*;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

import com.sun.org.apache.xml.internal.utils.SAXSourceLocator;
import com.sun.org.apache.xml.internal.utils.WrappedRuntimeException;


/**
 * Outils pour manipuler des arbres DOM
 */
public class OutilsXML {
    static final String encodage = "ISO-8859-1";
    static Transformer serializer = null;
    static final Hashtable<File,Transformer> cache_transformers = new Hashtable<File,Transformer>();
    
    public static Document nouveauDocumentDOM() throws ExceptionMICA {
        Document doc = null;
        try {
            final DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            final DocumentBuilder docbuilder = dbf.newDocumentBuilder();
            doc = docbuilder.newDocument();
        } catch (final ParserConfigurationException ex) {
            throw new ExceptionMICA("nouveauDocumentDOM", ex);
        }
        return(doc);
    }
    
    /**
     * Lecture de l'arbre DOM d'un document XML
     */
    public static Document lectureDocumentXML(final File f) throws ExceptionMICA {
        Document doc = null;
        try {
            final DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            final DocumentBuilder docbuilder = dbf.newDocumentBuilder();
            doc = docbuilder.parse(f);
        } catch (final SAXException ex) {
            String infos = "lectureDocumentXML " + f.getPath() + ": SAXException: " + ex.getMessage();
            if (ex instanceof SAXParseException)
                infos += " at line " + ((SAXParseException)ex).getLineNumber();
            throw new ExceptionMICA(infos);
        } catch (final IOException ex) {
            throw new ExceptionMICA("lectureDocumentXML", ex);
        } catch (final ParserConfigurationException ex) {
            throw new ExceptionMICA("lectureDocumentXML", ex);
        }
        return(doc);
    }
    
    public static void ecrireDocumentXML(final Document doc, final File f) throws ExceptionMICA {
        try {
            final FileOutputStream fos = new FileOutputStream(f);
            final Writer fw = new OutputStreamWriter(fos, encodage);
            final DOMSource domSource = new DOMSource(doc);
            final StreamResult streamResult = new StreamResult(fw);
            if (serializer == null) {
                final TransformerFactory tf = TransformerFactory.newInstance();
                serializer = tf.newTransformer();
                serializer.setOutputProperty(OutputKeys.ENCODING, encodage);
                serializer.setOutputProperty(OutputKeys.INDENT, "yes");
            }
            serializer.transform(domSource, streamResult);
            fw.close();
            fos.close();
        } catch (IOException ex) {
            throw new ExceptionMICA("ecrireDocumentXML", ex);
        } catch (final TransformerConfigurationException ex) {
            throw new ExceptionMICA("ecrireDocumentXML", ex);
        } catch (final TransformerException ex) {
            throw new ExceptionMICA("ecrireDocumentXML", ex);
        }
    }
    
    /**
     * Renvoie la valeur du premier noeud dans un lment XML.
     */
    public static String valeurElement(final Element el) {
        final Node enfant = el.getFirstChild();
        if (enfant == null)
            return(null);
        return(enfant.getNodeValue());
    }
    
    /**
     * Renvoie le premier enfant d'un lment donn ayant un nom local donn, ou null si aucun ne correspond.
     */
    public static Element premierEnfant(final Element parent, final String tag) {
        for (Node n=parent.getFirstChild(); n != null; n = n.getNextSibling()) {
            if (n instanceof Element) {
                final Element sousel = (Element)n;
                if (tag.equals(sousel.getLocalName()))
                    return(sousel);
            }
        }
        return(null);
    }
    
    /**
     * Renvoie la liste des lments enfants d'un lment donn ayant un nom donn
     * (getElementsByTagName renvoit tous les descendants, alors qu'ici on cherche juste les enfants de premier niveau)
     */
    public static ArrayList<Element> enfants(final Element parent, final String tag) {
        final ArrayList<Element> liste = new ArrayList<Element>();
        Node item = parent.getFirstChild();
        while (item != null) {
            if (item instanceof Element) {
                final Element sousb = (Element)item;
                if (tag.equals(sousb.getLocalName()))
                    liste.add(sousb);
            }
            item = item.getNextSibling();
        }
        return(liste);
    }
    
    /**
     * Renvoie la liste des lments enfants d'un lment donn
     * (getElementsByTagName renvoit tous les descendants, alors qu'ici on cherche juste les enfants de premier niveau)
     */
    public static ArrayList<Element> enfants(final Element parent) {
        final ArrayList<Element> liste = new ArrayList<Element>();
        Node item = parent.getFirstChild();
        while (item != null) {
            if (item instanceof Element)
                liste.add((Element)item);
            item = item.getNextSibling();
        }
        return(liste);
    }
    
    /**
     * Transforme un document DOM vers une sortie OutputStream en utilisant un fichier XSL.
     */
    public static void transformationXSLT(final OutputStream out, final Document doc, final File fichier_xsl) throws ExceptionMICA {
        try {
            Transformer transformer = cache_transformers.get(fichier_xsl);
            if (transformer == null) {
                final TransformerFactory tFactory = TransformerFactory.newInstance() ;
                transformer = tFactory.newTransformer(new StreamSource(fichier_xsl));
                cache_transformers.put(fichier_xsl, transformer);
            }
            final DOMSource ds = new DOMSource(doc);
            final Result res = new StreamResult(out);
            transformer.transform(ds, res);
            out.close();
        } catch (final TransformerException ex) {
            SourceLocator loc = null;
            Throwable cause = ex;
            do {
                if (cause instanceof SAXParseException)
                    loc = new SAXSourceLocator((SAXParseException)cause);
                else if (cause instanceof TransformerException) {
                    final SourceLocator loc2 = ((TransformerException)cause).getLocator();
                    if (loc2 != null)
                        loc = loc2;
                }
                if (cause instanceof TransformerException)
                    cause = ((TransformerException)cause).getCause();
                else if (cause instanceof WrappedRuntimeException)
                    cause = ((WrappedRuntimeException)cause).getException();
                else if (cause instanceof SAXException)
                    cause = ((SAXException)cause).getException();
                else
                    cause = null;
            } while (cause != null);
            String infos = "transformationXSLT: " + ex.getClass().getName() + ": " + ex.getMessage();
            if (loc != null)
                infos += " at line " + loc.getLineNumber();
            throw new ExceptionMICA(infos);
        } catch (Exception ex) {
            throw new ExceptionMICA("transformationXSLT", ex);
        }
    }
    
    /**
     * Encodage d'entits HTML et XML pour & < > ' "
     */
    public static String encoder(final String s) {
        if (s == null)
            return(null);
        String s2 = s.replace("&", "&amp;");
        s2 = s2.replace("<", "&lt;");
        s2 = s2.replace(">", "&gt;");
        //s2 = s2.replace("'", "&apos;"); IE ne reconnait pas &apos;
        s2 = s2.replace("\"", "&quot;");
        return(s2);
    }
    
}
