/*
Copyright (C) 2009 Observatoire de Paris

Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier conformment aux dispositions de la Licence Publique Gnrale GNU, telle que publie par la Free Software Foundation ; version 2 de la licence, ou encore ( votre choix) toute version ultrieure.

Ce programme est distribu dans l'espoir qu'il sera utile, mais SANS AUCUNE GARANTIE ; sans mme la garantie implicite de COMMERCIALISATION ou D'ADAPTATION A UN OBJET PARTICULIER. Pour plus de dtail, voir la Licence Publique Gnrale GNU .

Vous devez avoir reu un exemplaire de la Licence Publique Gnrale GNU en mme temps que ce programme ; si ce n'est pas le cas, crivez  la Free Software Foundation Inc., 675 Mass Ave, Cambridge, MA 02139, Etats-Unis.
*/

package serveurmica;

public class ExceptionMICA extends Exception {
    
    private String methode;
    private boolean erreur_utilisateur;
    
    public ExceptionMICA(final String message) {
        super(message);
        methode = null;
        erreur_utilisateur = false;
    }
    
    public ExceptionMICA(final String message, final boolean erreur_utilisateur) {
        super(message);
        methode = null;
        this.erreur_utilisateur = erreur_utilisateur;
    }
    
    public ExceptionMICA(final Exception ex) {
        super(ex);
        this.methode = null;
        erreur_utilisateur = false;
    }
    
    public ExceptionMICA(final String methode, final Exception ex) {
        super(ex);
        this.methode = methode;
        erreur_utilisateur = false;
    }
    
    public ExceptionMICA(final String methode, final Exception ex, final boolean erreur_utilisateur) {
        super(ex);
        this.methode = methode;
        this.erreur_utilisateur = erreur_utilisateur;
    }
    
    public String getMessage() {
        if (methode == null)
            return(super.getMessage());
        else
            return(methode + ": " + super.getMessage());
    }
    
    public String getLocalizedMessage() {
        if (methode == null)
            return(super.getLocalizedMessage());
        else
            return(methode + ": " + super.getLocalizedMessage());
    }
    
    public boolean erreurUtilisateur() {
        return(erreur_utilisateur);
    }
    
}
