/*
Copyright (C) 2009 Observatoire de Paris

Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier conformment aux dispositions de la Licence Publique Gnrale GNU, telle que publie par la Free Software Foundation ; version 2 de la licence, ou encore ( votre choix) toute version ultrieure.

Ce programme est distribu dans l'espoir qu'il sera utile, mais SANS AUCUNE GARANTIE ; sans mme la garantie implicite de COMMERCIALISATION ou D'ADAPTATION A UN OBJET PARTICULIER. Pour plus de dtail, voir la Licence Publique Gnrale GNU .

Vous devez avoir reu un exemplaire de la Licence Publique Gnrale GNU en mme temps que ce programme ; si ce n'est pas le cas, crivez  la Free Software Foundation Inc., 675 Mass Ave, Cambridge, MA 02139, Etats-Unis.
*/

package serveurmica;

import java.awt.image.BufferedImage;
import java.io.*;

import javax.imageio.ImageIO;


/**
 * Classe permettant de dterminer les dimensions d'une image ou d'une animation.
 * Formats reconnus : PNG GIF JPEG MPEG Ogg Theora
 */
public class Dimensions {
    private int largeur;
    private int hauteur;
    
    public Dimensions(final File f) throws ExceptionMICA {
        final String nomf = f.getName();
        final int posp = nomf.lastIndexOf('.');
        if (posp == -1)
            throw new ExceptionMICA("Erreur: acune extension au fichier " + f.getName() + ". Impossible de dterminer ses dimensions.");
        final String extension = nomf.substring(posp+1).toLowerCase();
        if ("gif".equals(extension) || "png".equals(extension) || "jpg".equals(extension) || "jpeg".equals(extension)) {
            final BufferedImage image;
            try {
                image = ImageIO.read(f);
            } catch (IOException ex) {
                throw new ExceptionMICA("Dimensions " + nomf, ex);
            }
            largeur = image.getWidth();
            hauteur = image.getHeight();
        } else if ("mpg".equals(extension) || "mpeg".equals(extension)) {
            try {
                final FileInputStream in = new FileInputStream(f);
                final long signature = 0x000001B3;
                int b1, b2, b3, b4;
                int bi = 0;
                b1 = in.read();
                b2 = in.read();
                b3 = in.read();
                b4 = in.read();
                long v = ((b1 & 0xFF) << 24) | ((b2 & 0xFF) << 16) | ((b3 & 0xFF) << 8) | (b4 & 0xFF);
                while (bi != -1 && v != signature) {
                    bi = in.read();
                    if (bi != -1) {
                        b1 = b2; b2 = b3; b3 = b4;
                        b4 = bi;
                        v = ((b1 & 0xFF) << 24) | ((b2 & 0xFF) << 16) | ((b3 & 0xFF) << 8) | (b4 & 0xFF);
                    }
                }
                if (v == signature) {
                    b1 = in.read();
                    b2 = in.read();
                    b3 = in.read();
                    largeur = ((b1 & 0xFF) << 4) | ((b2 & 0xF0) >> 4);
                    hauteur = ((b2 & 0x0F) << 8) | (b3 & 0xFF);
                } else
                    throw new ExceptionMICA("Erreur: Dimensions non trouves pour " + nomf);
                in.close();
            } catch (FileNotFoundException ex) {
                throw new ExceptionMICA("Dimensions " + nomf, ex);
            } catch (IOException ex) {
                throw new ExceptionMICA("Dimensions " + nomf, ex);
            }
        } else if ("ogg".equals(extension) || "ogv".equals(extension)) {
            try {
                final FileInputStream in = new FileInputStream(f);
                long signature = 0x4F676753; // OggS
                int b1,b2,b3,b4;
                int bi = 0;
                b1 = in.read();
                b2 = in.read();
                b3 = in.read();
                b4 = in.read();
                long v = ((b1 & 0xFF) << 24) | ((b2 & 0xFF) << 16) | ((b3 & 0xFF) << 8) | (b4 & 0xFF);
                if (v != signature) {
                    in.close();
                    throw new IOException("Erreur: Le fichier " + f.getPath() + " n'a pas la signature du format Ogg");
                }
                signature = 0x80746865; // identification header
                v = ((b1 & 0xFF) << 24) | ((b2 & 0xFF) << 16) | ((b3 & 0xFF) << 8) | (b4 & 0xFF);
                while (bi != -1 && v != signature) {
                    bi = in.read();
                    if (bi != -1) {
                        b1 = b2; b2 = b3; b3 = b4;
                        b4 = bi;
                        v = ((b1 & 0xFF) << 24) | ((b2 & 0xFF) << 16) | ((b3 & 0xFF) << 8) | (b4 & 0xFF);
                    }
                }
                if (v == signature) {
                    for (int i=0; i<10; i++)
                        b1 = in.read(); // on saute 10 octets aprs 'the'
                    b1 = in.read();
                    b2 = in.read();
                    b3 = in.read();
                    largeur = ((b1 & 0xFF) << 16) | ((b2 & 0xFF) << 8) | (b3 & 0xFF); // PICW
                    b1 = in.read();
                    b2 = in.read();
                    b3 = in.read();
                    hauteur = ((b1 & 0xFF) << 16) | ((b2 & 0xFF) << 8) | (b3 & 0xFF); // PICH
                } else
                    throw new ExceptionMICA("Erreur: Dimensions non trouves pour " + nomf);
                in.close();
            } catch (FileNotFoundException ex) {
                throw new ExceptionMICA("Dimensions " + nomf, ex);
            } catch (IOException ex) {
                throw new ExceptionMICA("Dimensions " + nomf, ex);
            }
        }
    }
    
    public int getLargeur() {
        return(largeur);
    }
    
    public int getHauteur() {
        return(hauteur);
    }
}
