/*
Copyright (C) 2009 Observatoire de Paris

Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier conformment aux dispositions de la Licence Publique Gnrale GNU, telle que publie par la Free Software Foundation ; version 2 de la licence, ou encore ( votre choix) toute version ultrieure.

Ce programme est distribu dans l'espoir qu'il sera utile, mais SANS AUCUNE GARANTIE ; sans mme la garantie implicite de COMMERCIALISATION ou D'ADAPTATION A UN OBJET PARTICULIER. Pour plus de dtail, voir la Licence Publique Gnrale GNU .

Vous devez avoir reu un exemplaire de la Licence Publique Gnrale GNU en mme temps que ce programme ; si ce n'est pas le cas, crivez  la Free Software Foundation Inc., 675 Mass Ave, Cambridge, MA 02139, Etats-Unis.
*/

package serveurmica;

import java.io.PrintWriter;
import java.util.ArrayList;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

/**
 * Bibliographie de l'tude de cas
 */
public class Bibliographie {
    
    private ArrayList<ReferenceBibliographique> references;
    
    public Bibliographie() {
        references = new ArrayList<ReferenceBibliographique>();
    }
    
    public void ajouterReference(final Element el) {
        references.add(new ReferenceBibliographique(el));
    }
    
    public boolean vide() {
        return(references.isEmpty());
    }
    
    public void afficher(final PrintWriter pw) {
        pw.println("<ul>");
        for (ReferenceBibliographique reference : references)
            reference.afficher(pw);
        pw.println("</ul>");
    }
    
    
    class ReferenceBibliographique {
        private String label;
        private Reference ref;
        
        public ReferenceBibliographique(final Element el) {
            label = el.getAttribute("label");
            Element el_ref = OutilsXML.premierEnfant(el, "REFERENCE_OUVRAGE");
            if (el_ref != null)
                ref = new ReferenceOuvrage(el_ref);
            else {
                el_ref = OutilsXML.premierEnfant(el, "REFERENCE_ARTICLE");
                if (el_ref != null)
                    ref = new ReferenceArticle(el_ref);
                else {
                    el_ref = OutilsXML.premierEnfant(el, "REFERENCE_WEB");
                    if (el_ref != null)
                        ref = new ReferenceWeb(el_ref);
                    else
                        ref = null;
                }
            }
        }
        
        public void afficher(final PrintWriter pw) {
            pw.println("<li><a name=\"" + label + "\">");
            if (ref != null)
                ref.afficher(pw);
            pw.println("</li>");
        }
    }
    
    interface Reference {
        public void afficher(final PrintWriter pw);
    }
    
    class ReferenceOuvrage implements Reference {
        String titre; // required
        String sous_titre;
        String premier_auteur; // required
        String autres_auteurs;
        String volume;
        String lieu;
        String editeur; // required
        String annee; // required
        String pagination;
        String collection;
        String isbn;
        String url;
        String autre;
        
        public ReferenceOuvrage(final Element el) {
            titre = el.getAttribute("titre");
            sous_titre = el.getAttribute("sous-titre");
            if ("".equals(sous_titre))
                sous_titre = null;
            premier_auteur = el.getAttribute("premierAuteur");
            autres_auteurs = el.getAttribute("autresAuteurs");
            if ("".equals(autres_auteurs))
                autres_auteurs = null;
            volume = el.getAttribute("volume");
            if ("".equals(volume))
                volume = null;
            lieu = el.getAttribute("lieu");
            if ("".equals(lieu))
                lieu = null;
            editeur = el.getAttribute("editeur");
            annee = el.getAttribute("annee");
            pagination = el.getAttribute("pagination");
            if ("".equals(pagination))
                pagination = null;
            collection = el.getAttribute("collection");
            if ("".equals(collection))
                collection = null;
            isbn = el.getAttribute("isbn");
            if ("".equals(isbn))
                isbn = null;
            url = el.getAttribute("url");
            if ("".equals(url))
                url = null;
            autre = el.getAttribute("autre");
            if ("".equals(autre))
                autre = null;
        }
        
        public void afficher(final PrintWriter pw) {
            pw.print("<b>");
            pw.print(OutilsXML.encoder(premier_auteur));
            if (autres_auteurs != null)
                pw.print("; " + OutilsXML.encoder(autres_auteurs));
            pw.print("</b>.");
            pw.print(" <b><i>" + OutilsXML.encoder(titre) + "</i></b>.");
            if (sous_titre != null)
                pw.print(" " + OutilsXML.encoder(sous_titre) + ".");
            if (volume != null)
                pw.print(" " + OutilsXML.encoder(volume) + ".");
            if (lieu != null)
                pw.print(", " + OutilsXML.encoder(lieu) + " :");
            pw.print(" " + OutilsXML.encoder(editeur));
            pw.print(", " + OutilsXML.encoder(annee));
            pw.print(".");
            if (pagination != null)
                pw.print(" " + OutilsXML.encoder(pagination) + ".");
            if (collection != null)
                pw.print(" coll. " + OutilsXML.encoder(collection) + ".");
            if (isbn != null)
                pw.print(" ISBN " + OutilsXML.encoder(isbn) + ".");
            if (url != null)
                pw.print(" <a href=\"" + OutilsXML.encoder(url) + "\">" + OutilsXML.encoder(url) + "</a>.");
            if (autre != null)
                pw.print(" " + OutilsXML.encoder(autre) + ".");
        }
    }
    
    class ReferenceArticle implements Reference {
        String titre_article; // required
        String titre_periodique; // required
        String premier_auteur; // required
        String autres_auteurs;
        String annee; // required
        String volume;
        String numero; // required
        String pagination; // required
        String url;
        String autre;
        
        public ReferenceArticle(final Element el) {
            titre_article = el.getAttribute("titreArticle");
            titre_periodique = el.getAttribute("titrePeriodique");
            premier_auteur = el.getAttribute("premierAuteur");
            autres_auteurs = el.getAttribute("autresAuteurs");
            if ("".equals(autres_auteurs))
                autres_auteurs = null;
            annee = el.getAttribute("annee");
            volume = el.getAttribute("volume");
            if ("".equals(volume))
                volume = null;
            numero = el.getAttribute("numero");
            pagination = el.getAttribute("pagination");
            url = el.getAttribute("url");
            if ("".equals(url))
                url = null;
            autre = el.getAttribute("autre");
            if ("".equals(autre))
                autre = null;
        }
        
        public void afficher(final PrintWriter pw) {
            pw.print("<b>");
            pw.print(OutilsXML.encoder(premier_auteur));
            if (autres_auteurs != null)
                pw.print("; " + OutilsXML.encoder(autres_auteurs));
            pw.print("</b>.");
            pw.print(" " + OutilsXML.encoder(titre_article) + ".");
            pw.print(" <b><i>" + OutilsXML.encoder(titre_periodique) + "</i></b>,");
            pw.print(" " + OutilsXML.encoder(annee));
            if (volume != null)
                pw.print(", " + OutilsXML.encoder(volume));
            pw.print(", n" + OutilsXML.encoder(numero));
            pw.print(", " + OutilsXML.encoder(pagination) + ".");
            if (url != null)
                pw.print(" <a href=\"" + OutilsXML.encoder(url) + "\">" + OutilsXML.encoder(url) + "</a>.");
            if (autre != null)
                pw.print(" " + OutilsXML.encoder(autre) + ".");
        }
    }
    
    class ReferenceWeb implements Reference {
        String description;
        String url; // required
        String auteurs; // required
        String titre; // required
        String titre_site;
        String date_consultation; // required
        
        public ReferenceWeb(final Element el) {
            Element el_description = OutilsXML.premierEnfant(el, "DESCRIPTION");
            if (el_description == null)
                description = null;
            else
                description = OutilsXML.valeurElement(el_description);
            url = el.getAttribute("url");
            auteurs = el.getAttribute("auteurs");
            titre = el.getAttribute("titre");
            titre_site = el.getAttribute("titreSite");
            if ("".equals(titre_site))
                titre_site = null;
            date_consultation = el.getAttribute("dateConsultation");
        }
        
        public void afficher(final PrintWriter pw) {
            pw.print("<b>" + OutilsXML.encoder(auteurs) + "</b>.");
            pw.print(" <b><i>" + OutilsXML.encoder(titre) + "</i></b>.");
            if (titre_site != null)
                pw.print(" In <b><i>" + OutilsXML.encoder(titre_site) + "</i></b>.");
            pw.print(" [consult le " + OutilsXML.encoder(date_consultation) + "]");
            pw.print(" <a href=\"" + OutilsXML.encoder(url) + "\">" + OutilsXML.encoder(url) + "</a>.");
            if (description != null)
                pw.print(" " + OutilsXML.encoder(description));
        }
    }
    
}
