<?xml version="1.0" encoding="ISO-8859-1"?>

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
    
    <xsl:output method="html" indent="yes" doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN" doctype-system="http://www.w3.org/TR/html4/loose.dtd" encoding="UTF-8"/>
    
    <xsl:variable name="feuille-de-style">style.css</xsl:variable>
    
    
    <xsl:template match="PAGE_MICA">
        <html>
            <head>
                <title><xsl:choose>
                    <xsl:when test="@titre_section!=''"><xsl:value-of select="@titre_section"/></xsl:when>
                    <xsl:otherwise><xsl:value-of select="@titre_etape"/></xsl:otherwise>
                </xsl:choose></title>
                <link type="text/css" rel="stylesheet" href="MICA/interface/{$feuille-de-style}"/>
                <link rel="Contents"  href="index.html"/>
                <!--
                <xsl:if test="LIENS_SECTION/@page_precedente='oui'">
                    <link rel="Prev"  href="MICA?autre_section=precedente"/>
                </xsl:if>
                <xsl:if test="LIENS_SECTION/@page_suivante='oui'">
                    <link rel="Next"  href="MICA?autre_section=suivante"/>
                </xsl:if>
                -->
                <!-- ce meta est ajout automatiquement -->
                <!--<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1"/>-->
                <xsl:if test="count(CONTENU/ZONE_IMAGE[@localisation='page']) &gt; 1">
                    <xsl:call-template name="script-imagettes"/>
                </xsl:if>
            </head>
            <body class="page">
                <xsl:call-template name="contenu-body"/>
            </body>
        </html>
    </xsl:template>
    
    
    <xsl:template name="contenu-body">

    <!--
    Organisation des divs:
    
         _________________________
        |    titre site    |      |
        |__________________| logo |
        |outils |  titre   |      |
        |       |__________|______|
        |       |       figure |en|
        |  som  |              |ch|
        | maire |              |ai|
        |       |   contenu    |ne|
        |       |              |me|
        |       |              |nt|
        |_______|______________|__|
    
    -->
    
        <xsl:call-template name="zone_logo"/>
        
        <xsl:call-template name="zone_bandeau"/>
        
        <xsl:call-template name="zone_sommaire"/>
        
        <xsl:call-template name="zone_titre"/>
        
        <form action="MICA" method="POST">
            
            <div class="zone_contenu">
                
                <xsl:call-template name="enchainements"/>
                
                <xsl:if test="CONTENU/ZONE_IMAGE[@localisation='page']">
                    <xsl:call-template name="figures-page"/>
                </xsl:if>
                
                <div class="zone_texte">
                    <xsl:apply-templates select="CONTENU"/>
                </div>
                
                <div class="spacer"></div>
                
                <xsl:if test="LIENS_SECTION">
                    <div class="zone_liens">
                        <table width="100%"><tr>
                            <td>
                                <xsl:if test="LIENS_SECTION/@page_precedente='oui'">
                                    <!--<a href="MICA?autre_section=precedente" title="Page prcdente"><img src="MICA/interface/flechegauche.gif" width="48" height="31" alt="Page prcdente" border="0"/></a>-->
                                    <input type="image" name="section_precedente" value="Page prcdente" src="MICA/interface/flechegauche.gif" title="Page prcdente"/>
                                </xsl:if>
                            </td>
                            <td align="right">
                                <xsl:if test="LIENS_SECTION/@page_suivante='oui'">
                                    <!--<a href="MICA?autre_section=suivante" title="Page suivante"><img src="MICA/interface/flechedroite.gif" width="48" height="31" alt="Page suivante" border="0"/></a>-->
                                    <input type="image" name="section_suivante" value="Page suivante" src="MICA/interface/flechedroite.gif" title="Page suivante"/>
                                </xsl:if>
                            </td>
                        </tr></table>
                    </div>
                </xsl:if>
            </div>
            
        </form>
        
    </xsl:template>
    
    <xsl:template name="zone_logo">
        <div class="zone_logo">
            <img src="MICA/interface/logo.png" alt="logo"/>
        </div>
    </xsl:template>
    
    <xsl:template name="zone_bandeau">
        <div class="titre_site_1"><xsl:value-of select="@titre_edc"/></div>
        <div class="titre_site_2"><xsl:value-of select="@titre_edc"/></div>
    </xsl:template>
    
    <xsl:template name="zone_sommaire">
        <div class="zone_sommaire">
            <div class="zone_mininav">
                <table width="100%"><tr>
                    <xsl:variable name="nb" select="count(ancestor-or-self::XPAGES)"/>
                    <td align="center">
                        <a href="MICA?page=accueil" title="Entre du site"><img src="MICA/interface/home.gif" width="25" height="25" alt="Entre du site" border="0"/></a>
                    </td>
                    <td align="center">
                        <a href="MICA?page=sommaire" title="Sommaire"><img src="MICA/interface/sommaire_petit.gif" width="25" height="25" border="0" alt="Sommaire"/></a>
                    </td>
                    <xsl:if test="@glossaire='oui'">
                        <td align="center">
                            <a href="MICA?page=glossaire" title="Glossaire" target="_blank"><img src="MICA/interface/glossaire_petit.gif" width="25" height="25" border="0" alt="Glossaire"/></a>
                        </td>
                    </xsl:if>
                    <xsl:if test="LIENS_SECTION/@page_precedente='oui'">
                        <td align="center">
                            <a href="MICA?autre_section=precedente" accesskey="j" title="Page prcdente"><img src="MICA/interface/petiteflechegauche.gif" width="25" height="16" alt="&lt;-" border="0"/></a>
                        </td>
                    </xsl:if>
                    <xsl:if test="LIENS_SECTION/@page_suivante='oui'">
                        <td align="center">
                            <a href="MICA?autre_section=suivante" accesskey="l" title="Page suivante"><img src="MICA/interface/petiteflechedroite.gif" width="25" height="16" alt="-&gt;" border="0"/></a>
                        </td>
                    </xsl:if>
                </tr></table>
            </div>
            
            <xsl:call-template name="plan-edc"/>
            
            <xsl:if test="not(.//ETAPE[@active='oui'])">
                <xsl:apply-templates select="PLAN_ETAPE"/>
            </xsl:if>
            
            <xsl:if test="@progression!=''">
                <img src="MICA/interface/progression.png" width="{@progression*2}" height="16" title="{@progression} %"/>
            </xsl:if>
        </div>
    </xsl:template>
    
    <xsl:template name="zone_titre">
        <div class="zone_titre">
            <table cellspacing="0" cellpadding="0"><tr>
            <td><h1><xsl:value-of select="@titre_etape"/></h1></td>
            </tr></table>
        </div>
    </xsl:template>
    
    <xsl:template name="enchainements">
        <xsl:if test="ENCHAINEMENTS">
            <div class="zone_enchainements">
                <h2>Enchanements</h2>
                <ul>
                    <xsl:for-each select="ENCHAINEMENTS/ENCHAINEMENT">
                        <!--<li><a href="MICA?etape={@label_etape}"><xsl:value-of select="@titre"/></a></li>-->
                        <li><input type="submit" name="enchainement_etape_{@label_etape}" value="{@titre}"/></li>
                    </xsl:for-each>
                </ul>
            </div>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="plan-edc">
        <div class="sommaire_edc">
            <xsl:for-each select="PLAN_EDC">
                <xsl:apply-templates/>
            </xsl:for-each>
        </div>
    </xsl:template>
    
    <xsl:template match="DOSSIER">
        <div class="fondsel1sommaire">
            <img height="11" width="11" alt="-" border="0" src="MICA/interface/listeactive.gif"/>&#xA0;<span class="sommaire2select"><xsl:value-of select="@titre"/></span>
            <div class="divsommaire">
                <xsl:apply-templates/>
            </div>
        </div>
    </xsl:template>
    
    <xsl:template match="ETAPE">
        <xsl:choose>
            <xsl:when test="@active='oui'">
                <div class="fondsel2sommaire">
                    <span class="sommairepage">&#x2022; <xsl:value-of select="@titre"/></span>
                    <div class="divsommaire">
                        <xsl:apply-templates select="ancestor::PAGE_MICA/PLAN_ETAPE/*"/>
                    </div>
                </div>
            </xsl:when>
            <xsl:otherwise>
                <div class="fondsel1sommaire">
                    <xsl:choose>
                        <xsl:when test="@lien='oui'">
                            <a href="MICA?label_etape={@label}" class="sommairepage">&#x2022; <xsl:value-of select="@titre"/></a>
                        </xsl:when>
                        <xsl:otherwise>
                            <span class="sommairepage">&#x2022; <xsl:value-of select="@titre"/></span>
                        </xsl:otherwise>
                    </xsl:choose>
                </div>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    <xsl:template match="PLAN_ETAPE">
        <div class="sommaire_etape">
            <xsl:apply-templates/>
        </div>
    </xsl:template>
    
    <xsl:template match="SECTION">
        <xsl:choose>
            <xsl:when test="SECTION">
                <div class="fondsel1section">
                    <img height="11" width="11" alt="-" border="0" src="MICA/interface/listeactive.gif"/>&#xA0;<span class="sommaire2select"><xsl:value-of select="@titre"/></span>
                    <div class="divsommaire">
                        <xsl:apply-templates/>
                    </div>
                </div>
            </xsl:when>
            <xsl:otherwise>
                <xsl:choose>
                    <xsl:when test="@active='oui'">
                        <div class="fondsel2section">
                            <span class="sommairepage">&#x2022; <xsl:value-of select="@titre"/></span>
                        </div>
                    </xsl:when>
                    <xsl:otherwise>
                        <div class="fondsel1section">
                            <a href="MICA?label_section={@label}" class="sommairepage">&#x2022; <xsl:value-of select="@titre"/></a>
                        </div>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    
    <xsl:template match="CONTENU">
        <xsl:if test="ancestor::PAGE_MICA/@titre_section!=''">
            <h2><xsl:value-of select="ancestor::PAGE_MICA/@titre_section"/></h2>
        </xsl:if>
        <xsl:apply-templates/>
    </xsl:template>
    
    
    <!-- Elments de bloc -->
    
    <xsl:template match="BLOC">
        <xsl:variable name="classe"><xsl:choose>
            <xsl:when test="(@role='introduction' or @role='conclusion' or @role='exercice') and @importance='grande'"><xsl:value-of select="@role"/></xsl:when>
            <xsl:when test="@importance='grande'">section_cadre</xsl:when>
            <xsl:otherwise>section_normale</xsl:otherwise>
        </xsl:choose></xsl:variable>
        <div class="{$classe}">
            <xsl:if test="@titre!=''">
                <xsl:element name="h{count(ancestor::BLOC)+3}">
                    <xsl:if test="@role='introduction' or @role='conclusion' or @role='prerequis' or @role='objectifs' or @role='rappel' or @role='definition' or @role='demonstration' or @role='exemple' or @role='conseil' or @role='remarque' or @role='attention' or @role='complement' or @role='methode' or @role='activite' or @role='exercice' or @role='bibliographie'">
                        <img src="MICA/interface/icones_sections/{@role}.png" width="40" height="40" alt="{@role}" class="icone_section"/>
                    </xsl:if>
                    <xsl:value-of select="@titre"/>
                </xsl:element>
            </xsl:if>
            <xsl:apply-templates/>
        </div>
    </xsl:template>
    
    
    <xsl:template match="PARAGRAPHE">
        <p><xsl:apply-templates/></p>
    </xsl:template>
    
    
    <xsl:template match="LISTE">
        <ul>
            <xsl:apply-templates select="ITEM"/>
        </ul>
    </xsl:template>
    
    
    <xsl:template match="ITEM">
        <li><xsl:apply-templates/></li>
    </xsl:template>
    
    
    <xsl:template match="TABLEAU">
         <table border="1" cellspacing="0" cellpadding="2" class="tableau">
            <xsl:if test="@titre!=''">
                <caption><xsl:value-of select="@titre"/></caption>
            </xsl:if>
            <xsl:apply-templates/>
        </table>
    </xsl:template>
    
    
    <xsl:template match="TR">
        <tr><xsl:apply-templates/></tr>
    </xsl:template>
    
    
    <xsl:template match="TH">
        <th>
        <xsl:if test="@colspan"><xsl:attribute name="colspan"><xsl:value-of select="@colspan"/></xsl:attribute></xsl:if>
        <xsl:if test="@rowspan"><xsl:attribute name="rowspan"><xsl:value-of select="@rowspan"/></xsl:attribute></xsl:if>
        <xsl:if test="@align"><xsl:attribute name="align"><xsl:value-of select="@align"/></xsl:attribute></xsl:if>
        <xsl:apply-templates/>
        </th>
    </xsl:template>
    
    
    <xsl:template match="TD">
        <xsl:variable name="trpos"><xsl:number from="TABLEAU" count="TR"/></xsl:variable>
        <td class="tableaux{1+($trpos mod 2)}">
        <xsl:if test="@colspan"><xsl:attribute name="colspan"><xsl:value-of select="@colspan"/></xsl:attribute></xsl:if>
        <xsl:if test="@rowspan"><xsl:attribute name="rowspan"><xsl:value-of select="@rowspan"/></xsl:attribute></xsl:if>
        <xsl:if test="@align"><xsl:attribute name="align"><xsl:value-of select="@align"/></xsl:attribute></xsl:if>
        <xsl:apply-templates/></td>
    </xsl:template>
    
    
    <xsl:template match="ZONE_IMAGE">
        <xsl:choose>
            <xsl:when test="@localisation='icne'">
                <xsl:for-each select="FICHIER[1]">
                    <xsl:variable name="label-fichiers" select="ancestor::XPAGES[1]/@labelfichiers"/>
                    <xsl:variable name="format"><xsl:call-template name="format-fichier">
                        <xsl:with-param name="nom" select="@nom"/>
                    </xsl:call-template></xsl:variable>
                    <xsl:choose>
                        <xsl:when test="$format='PNG' or $format='GIF' or $format='JPEG'">
                            <a href="#" target="_blank" onclick="document.getElementById('{translate(@nom, ' ', '_')}').style.display='block'; return false"><img alt="{@nom}" src="MICA?fichier={@nom}" width="{@largeur2}" height="{@hauteur2}" align="right" border="0" class="iconeimage"/></a>
                            <xsl:call-template name="div-image"/>
                        </xsl:when>
                        <xsl:when test="$format='MPEG' or $format='OGG'">
                            <a href="#" target="_blank" onclick="document.getElementById('{translate(@nom, ' ', '_')}').style.display='block'; return false"><img src="MICA/interface/video.gif" width="50" height="50" alt="vido" align="right" border="0"/></a>
                            <xsl:call-template name="div-image"/>
                        </xsl:when>
                        <xsl:otherwise>format inconnu (vrifier l'extension du nom du fichier)</xsl:otherwise>
                    </xsl:choose>
                </xsl:for-each>
            </xsl:when>
            <xsl:when test="@localisation!='page'">
                <xsl:call-template name="contenu-envimage"/>
            </xsl:when>
        </xsl:choose>
    </xsl:template>
    
    
    <xsl:template name="script-imagettes">
        <script type="text/javascript" language="JavaScript">
            <xsl:comment>
    function imagette(n) {
        var imagettes = document.getElementById('imagettes');
        if (imagettes != null) {
            var liste = imagettes.getElementsByTagName('a');
            for (var i=0; i &lt; liste.length; i++) {
                if (i+1 == n) {
                    var img = liste[i].getElementsByTagName('img')[0];
                    img.src = '../MICA/interface/imagesel.gif';
                    var div = document.getElementById('figure'+(i+1));
                    div.style.display = 'block';
                } else {
                    var img = liste[i].getElementsByTagName('img')[0];
                    img.src = '../MICA/interface/image.gif';
                    var div = document.getElementById('figure'+(i+1));
                    div.style.display='none';
                }
            }
        }
    }
            //</xsl:comment>
        </script>
    </xsl:template>
    
    
    <!-- cration de l'encart pour la figure en page, appel par contenu-body -->
    <xsl:template name="figures-page">
        <div class="zone_figure">
            <xsl:if test="count(.//ZONE_IMAGE[@localisation='page']) &gt; 1">
                <div id="imagettes">
                    <xsl:for-each select=".//ZONE_IMAGE[@localisation='page']">
                        <a href="#" onclick="imagette({position()}); return false;"><xsl:choose>
                            <xsl:when test="position()=1">
                                <img src="MICA/interface/imagesel.gif" width="59" height="52" alt="image {position()}" border="0"/>
                            </xsl:when>
                            <xsl:otherwise>
                                <img src="MICA/interface/image.gif" width="59" height="52" alt="image {position()}" border="0"/>
                            </xsl:otherwise>
                        </xsl:choose></a>
                    </xsl:for-each>
                </div>
            </xsl:if>
            <xsl:for-each select=".//ZONE_IMAGE[@localisation='page']">
                <xsl:call-template name="contenu-envimage"/>
            </xsl:for-each>
        </div>
    </xsl:template>
    
    <xsl:template name="contenu-envimage">
        <xsl:variable name="classe-div"><xsl:choose>
            <xsl:when test="@localisation='page'">cadre_zone_figure</xsl:when>
            <xsl:otherwise>cadre_figure_texte</xsl:otherwise>
        </xsl:choose></xsl:variable>
        <xsl:if test="$classe-div='cadre_figure_texte' and @label!=''">
            <a name="{@label}"/>
        </xsl:if>
        <div class="{$classe-div}">
            <xsl:if test="@localisation='page'">
                <xsl:attribute name="id">figure<xsl:value-of select="count(preceding-sibling::ZONE_IMAGE[@localisation='page'])+1"/></xsl:attribute>
                <xsl:if test="count(preceding-sibling::ZONE_IMAGE[@localisation='page']) &gt; 0">
                    <xsl:attribute name="style">display:none;</xsl:attribute>
                </xsl:if>
            </xsl:if>
            <xsl:if test="@titre!=''">
                <div class="titrefigure"><xsl:value-of select="@titre"/></div>
            </xsl:if>
        
            <xsl:variable name="label-fichiers" select="ancestor::XPAGES[1]/@labelfichiers"/>
            <xsl:for-each select="FICHIER">
                <xsl:variable name="nomfichier" select="@nom"/>
                <xsl:variable name="localisation"><xsl:value-of select="../@localisation"/></xsl:variable>
                <xsl:variable name="largeur1" select="@largeur1"/>
                <xsl:variable name="hauteur1" select="@hauteur1"/>
                <xsl:variable name="redim" select="@redim"/>
                <xsl:variable name="format"><xsl:call-template name="format-fichier">
                    <xsl:with-param name="nom" select="@nom"/>
                </xsl:call-template></xsl:variable>
                <xsl:choose>
                    <xsl:when test="$redim='oui'">
                        <xsl:variable name="largeur2" select="@largeur2"/>
                        <xsl:variable name="hauteur2" select="@hauteur2"/>
                        <xsl:choose>
                            <xsl:when test="$format='PNG' or $format='GIF' or $format='JPEG'">
                                <a href="#" onclick="document.getElementById('{translate(@nom, ' ', '_')}').style.display='block'; return false"><img alt="{$nomfichier}" src="MICA?fichier={$nomfichier}" width="{$largeur2}" height="{$hauteur2}" border="0"/></a>
                            </xsl:when>
                            <xsl:when test="$format='MPEG' or $format='OGG'">
                                le redimensionnement n'est pas possible pour le format <xsl:value-of select="$format"/>
                            </xsl:when>
                            <xsl:otherwise>format inconnu (vrifier l'extension du nom du fichier)</xsl:otherwise>
                        </xsl:choose>
                        <xsl:call-template name="div-image"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:choose>
                            <xsl:when test="$format='PNG' or $format='GIF' or $format='JPEG'">
                                <img alt="{$nomfichier}" src="MICA?fichier={$nomfichier}" width="{$largeur1}" height="{$hauteur1}"/>
                            </xsl:when>
                            <xsl:when test="$format='MPEG'">
                                <embed src="MICA?fichier={$nomfichier}" width="{$largeur1}" height="{$hauteur1}">
                                    <noembed>Erreur: ce navigateur ne gre pas EMBED</noembed>
                                </embed>
                            </xsl:when>
                            <xsl:when test="$format='OGG'">
                                <applet code="com.fluendo.player.Cortado.class" width="{$largeur1}" height="{$hauteur1 + 16}" archive="interface/applets/cortado.jar">
                                    <param name="url" value="MICA?fichier={$nomfichier}"/>
                                    <param name="seekable" value="false"/>
                                    <param name="autoPlay" value="false"/>
                                    <param name="showStatus" value="show"/>
                                    <param name="statusHeight" value="16"/>
                                    Java n'est pas activ.
                                </applet>
                            </xsl:when>
                            <xsl:otherwise>format inconnu (vrifier l'extension du nom du fichier)</xsl:otherwise>
                        </xsl:choose>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:for-each>
            <xsl:apply-templates select="LEGENDE|CREDIT"/>
        </div>
    </xsl:template>
    
    <xsl:template name="div-image">
        <xsl:variable name="format"><xsl:call-template name="format-fichier">
            <xsl:with-param name="nom" select="@nom"/>
        </xsl:call-template></xsl:variable>
        <xsl:variable name="hl" select="16*(ceiling(string-length(../LEGENDE) div ((@largeur1+100) div 8))+5)"/>
        <div class="zone_image" id="{translate(@nom, ' ', '_')}" style="display: none; width: {@largeur1+100}px; height: {@hauteur1+$hl}px">
            <xsl:if test="../@titre!=''">
                <div class="titrefigure"><xsl:value-of select="../@titre"/></div>
            </xsl:if>
            <xsl:choose>
                <xsl:when test="$format='PNG' or $format='GIF' or $format='JPEG'">
                    <img src="MICA?fichier={@nom}" width="{@largeur1}" height="{@hauteur1}" alt="{@nom}"/>
                </xsl:when>
                <xsl:when test="$format='MPEG'">
                    <embed src="MICA?fichier={@nom}" width="{@largeur1}" height="{@hauteur1}">
                        <noembed>Erreur: ce navigateur ne gre pas EMBED</noembed>
                    </embed>
                </xsl:when>
                <xsl:when test="$format='OGG'">
                    <applet code="com.fluendo.player.Cortado.class" width="{@largeur1}" height="{@hauteur1 + 16}" archive="interface/applets/cortado.jar">
                        <param name="url" value="MICA?fichier={@nom}"/>
                        <param name="seekable" value="false"/>
                        <param name="autoPlay" value="false"/>
                        <param name="showStatus" value="show"/>
                        <param name="statusHeight" value="16"/>
                        Java n'est pas activ.
                    </applet>
                </xsl:when>
                <xsl:otherwise>format inconnu (vrifier l&apos;extension du nom du fichier)</xsl:otherwise>
            </xsl:choose>
            <xsl:apply-templates select="../LEGENDE"/>
            <xsl:apply-templates select="../CREDIT"/>
            <p><a href="#" onclick="document.getElementById('{translate(@nom, ' ', '_')}').style.display='none'; return false">Fermer</a></p>
        </div>
    </xsl:template>
    
    <xsl:template match="FICHIER">
        <img alt="{@nom}" src="MICA?fichier={@nom}"/>
    </xsl:template>
    
    
    <xsl:template match="LEGENDE">
        <div class="legende">
            <xsl:apply-templates/>
        </div>
    </xsl:template>
    
    
    <xsl:template match="CREDIT">
        <div class="credit"><em>Crdit : </em><xsl:apply-templates/></div>
    </xsl:template>
    
    
    <xsl:template match="APPLET|FLASH">
        
        <xsl:choose>
            <xsl:when test="@localisation='icne'">
                <xsl:variable name="rep" select="'MICA?fichier='"/>
                <xsl:variable name="numero"><xsl:number level="any" from="XPAGES" count="APPLET|FLASH"/></xsl:variable>
                <xsl:variable name="nomfichiermedia"><xsl:value-of select="concat('media',$numero)"/>.html</xsl:variable>
                <xsl:variable name="fichiermedia"><xsl:value-of select="concat($rep,$nomfichiermedia)"/></xsl:variable>
                <xsl:variable name="icone"><xsl:choose>
                    <xsl:when test="self::APPLET">applet.gif</xsl:when>
                    <xsl:when test="self::FLASH">flash.gif</xsl:when>
                </xsl:choose></xsl:variable>
                <br/><a href="{$nomfichiermedia}" target="_blank"><img src="MICA/interface/{$icone}" width="45" height="45" border="0" alt="{$icone}"/></a>
                <xsl:call-template name="ecrire-fichier">
                    <xsl:with-param name="fichier" select="$fichiermedia"/>
                    <xsl:with-param name="contenu">
                        <html>
                        <head>
                            <title><xsl:value-of select="concat('applet ',$numero)"/></title>
                            <link type="text/css" rel="stylesheet" href="MICA/interface/{$feuille-de-style}"/>
                        </head>
                        <body>
                            <xsl:call-template name="contenu-media"/>
                        </body>
                        </html>
                    </xsl:with-param>
                </xsl:call-template>
            </xsl:when>
            <xsl:when test="@localisation='page'">
                <div class="zone_figure">
                    <xsl:call-template name="contenu-media"/>
                </div>
            </xsl:when>
            <xsl:otherwise>
                <xsl:call-template name="contenu-media"/>
            </xsl:otherwise>
        </xsl:choose>
        <br/>
    </xsl:template>
    
    <xsl:template name="contenu-media">
        <xsl:variable name="classe-div"><xsl:choose>
            <xsl:when test="@localisation='page'">cadre_zone_figure</xsl:when>
            <xsl:otherwise>cadre_applet_texte</xsl:otherwise>
        </xsl:choose></xsl:variable>
        <div class="{$classe-div}">
            <xsl:if test="@localisation!='page'">
                <xsl:attribute name="style">width: <xsl:value-of select="@largeur + 12"/>px;</xsl:attribute>
            </xsl:if>
            <xsl:if test="@titre!=''">
                <div class="titrefigure"><xsl:value-of select="@titre"/></div>
            </xsl:if>
            <xsl:choose>
                <xsl:when test="self::APPLET">
                    <applet code="{@classe}" archive="{@archive}" width="{@largeur}" height="{@hauteur}">
                        <xsl:apply-templates select="PARAM"/>
                        Java n'est pas activ.
                    </applet>
                </xsl:when>
                <xsl:when test="self::FLASH">
                    <object type="application/x-shockwave-flash" data="{@fichier}" width="{@largeur}" height="{@hauteur}" title="{@titre}">
                        <param name="movie" value="{@fichier}"/>
                        <xsl:variable name="parametres"><xsl:for-each select="PARAM">
                            <xsl:value-of select="concat(@nom,'=',@valeur,'&#38;')" />
                        </xsl:for-each></xsl:variable>
                        <xsl:if test="$parametres != ''">
                            <param name="flashvars" value="{$parametres}"/>
                        </xsl:if>
                        Erreur: plugin Flash absent ou dsactiv ?
                    </object>
                </xsl:when>
            </xsl:choose>
            <xsl:apply-templates select="LEGENDE"/>
            <xsl:apply-templates select="CREDIT"/>
        </div>
    </xsl:template>
    
    
    <xsl:template match="PARAM">
        <param name="{@nom}" value="{@valeur}"/>
    </xsl:template>
    
    
    <!-- Exercices -->
    
    <xsl:template match="EXERCICE">
        <xsl:variable name="type-exo"><xsl:choose>
            <xsl:when test="count(QUESTION_LIBRE)=0">qcm</xsl:when>
            <xsl:otherwise>exercice</xsl:otherwise>
        </xsl:choose></xsl:variable>
        <div class="{$type-exo}">
            <xsl:element name="h{count(ancestor::BLOC)+3}">
                <img src="MICA/interface/icones_sections/{$type-exo}.png" width="40" height="40" alt="{$type-exo}" class="icone_section"/>
                <xsl:choose>
                    <xsl:when test="@titre!=''"><xsl:value-of select="@titre"/></xsl:when>
                    <xsl:otherwise>Exercice</xsl:otherwise>
                </xsl:choose>
            </xsl:element>
            <xsl:apply-templates select="ENONCE"/>
            <!--<xsl:variable name="numero-exo"><xsl:number level="any" from="CONTENU" count="EXERCICE" /></xsl:variable>-->
            <!--<form name="exo{$numero-exo}" action="MICA" method="post">-->
                <xsl:apply-templates select="QUESTION_LIBRE|QUESTION_QUESTIONNAIRE"/>
            <!--</form>-->
        </div>
    </xsl:template>
    
    <xsl:template match="ENONCE">
        <xsl:apply-templates/>
    </xsl:template>
    
    <xsl:template match="QUESTION_LIBRE">
        <xsl:variable name="numero-exo"><xsl:number level="any" from="CONTENU" count="EXERCICE" /></xsl:variable>
        <xsl:variable name="numquestion"><xsl:number level="any" from="EXERCICE" count="QUESTION_LIBRE|QUESTION_QUESTIONNAIRE"/></xsl:variable>
        <div class="question">
            <b><xsl:value-of select="concat('Question', ' ', $numquestion)"/>)</b>
            <xsl:apply-templates select="ENONCE"/>
            <xsl:choose>
                <xsl:when test="@valeur!=''">
                    <p><xsl:value-of select="@valeur"/></p>
                </xsl:when>
                <xsl:otherwise>
                    <p><input name="exercice{$numero-exo}_question{$numquestion}"/></p>
                </xsl:otherwise>
            </xsl:choose>
            <p><xsl:apply-templates select="AIDE" mode="lien"/></p>
        </div>
    </xsl:template>
    
    <xsl:template match="AIDE" mode="lien">
        <xsl:variable name="numaide"><xsl:number level="any" from="CONTENU" count="AIDE"/></xsl:variable>
        <a href="#" class="lienaide" onclick="document.getElementById('aide{$numaide}').style.display='block'; return false">Aide</a>&#xA0;&#xA0;
        <xsl:call-template name="div-aide"/>
    </xsl:template>
    
    <xsl:template name="div-aide">
        <xsl:variable name="numaide"><xsl:number level="any" from="CONTENU" count="AIDE"/></xsl:variable>
        <div class="zone_aide" id="aide{$numaide}" style="display: none;">
            <xsl:apply-templates/>
            <p><a href="#" onclick="document.getElementById('aide{$numaide}').style.display='none'; return false">Fermer</a></p>
        </div>
    </xsl:template>
    
    <xsl:template match="AIDE">
        <xsl:apply-templates/>
    </xsl:template>
    
    <xsl:template match="QUESTION_QUESTIONNAIRE">
        <xsl:variable name="numquestion"><xsl:number level="any" from="EXERCICE" count="QUESTION_LIBRE|QUESTION_QUESTIONNAIRE"/></xsl:variable>
        <div class="questionqcm">
            <xsl:value-of select="$numquestion"/>)
            <xsl:apply-templates select="ENONCE"/>
            <xsl:choose>
                <xsl:when test="@points!=''">
                    <p>Points obtenus : <xsl:value-of select="@points"/></p>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:apply-templates select="REPONSE_QUESTIONNAIRE"/>
                </xsl:otherwise>
            </xsl:choose>
            <br/>
            <xsl:apply-templates select="AIDE" mode="lien"/>
        </div>
    </xsl:template>
    
    <xsl:template match="REPONSE_QUESTIONNAIRE">
        <p>
            <xsl:variable name="numero-exo"><xsl:number level="any" from="CONTENU" count="EXERCICE" /></xsl:variable>
            <xsl:variable name="numquestion"><xsl:number level="any" from="EXERCICE" count="QUESTION_LIBRE|QUESTION_QUESTIONNAIRE" /></xsl:variable>
            <xsl:variable name="numreponse"><xsl:number level="any" from="QUESTION_QUESTIONNAIRE" count="REPONSE_QUESTIONNAIRE" /></xsl:variable>
            <xsl:variable name="type-bouton"><xsl:choose>
                <xsl:when test="../@type='QCU'">radio</xsl:when>
                <xsl:otherwise>checkbox</xsl:otherwise>
            </xsl:choose></xsl:variable>
            <input type="{$type-bouton}" name="exercice{$numero-exo}_question{$numquestion}" value="{$numreponse}"/>
            <xsl:apply-templates/>
        </p>
    </xsl:template>
    
    <xsl:template match="TEXTE_REPONSE">
        <span class="reptexte">
            <xsl:apply-templates/>
        </span>
    </xsl:template>
    
    
    <!-- Elments mlangs  du texte  -->
    
    <xsl:template match="LIEN_INTERNE">
        <xsl:choose>
            <xsl:when test="@type='tape'">
                <a href="MICA?label_etape={@label}" class="lien"><xsl:apply-templates/></a>
            </xsl:when>
            <xsl:when test="@type='section'">
                <a href="MICA?label_section={@label}" class="lien"><xsl:apply-templates/></a>
            </xsl:when>
            <xsl:when test="@type='bibliothque'">
                <a href="MICA?page=bibliotheque#{@label}" class="lien"><xsl:apply-templates/></a>
            </xsl:when>
            <xsl:when test="@type='bibliographie'">
                <a href="MICA?page=bibliographie#{@label}" class="lien" target="_blank"><xsl:apply-templates/></a>
            </xsl:when>
            <xsl:otherwise>
                <xsl:apply-templates/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    
    <xsl:template match="LIEN_WEB">
        <a href="{@url}" class="lien" target="_blank"><xsl:apply-templates/></a>
    </xsl:template>
    
    
    <xsl:template match="LIEN_GLOSSAIRE">
        <xsl:variable name="motref"><xsl:choose>
            <xsl:when test="@mot!=''"><xsl:value-of select="@mot"/></xsl:when>
            <xsl:otherwise><xsl:value-of select="."/></xsl:otherwise>
        </xsl:choose></xsl:variable>
        <xsl:variable name="motreftrans" select="translate($motref,' ','_aaeeeiioouu')"/>
        <a href="MICA?page=glossaire#{$motreftrans}" class="glossaire" target="_blank"><xsl:value-of select="."/></a>
    </xsl:template>
    
    
    <xsl:template name="sortie-symbole">
        <xsl:param name="nomlettre"/>
        
        <xsl:variable name="nomsansext" select="substring-before($nomlettre,'.')"/>
        <xsl:choose>
            <!-- pour chaque symbole on donne l'quivalent sous forme de caractre UNICODE,
                ou d'une image pour les caractres qui ne s'affichent pas bien partout -->
            <xsl:when test="$nomsansext='Alpha'">&#x391;</xsl:when>
            <xsl:when test="$nomsansext='Beta'">&#x392;</xsl:when>
            <xsl:when test="$nomsansext='Gamma'">&#x393;</xsl:when>
            <xsl:when test="$nomsansext='Delta'">&#x394;</xsl:when>
            <xsl:when test="$nomsansext='Epsilon'">&#x395;</xsl:when>
            <xsl:when test="$nomsansext='Zeta'">&#x396;</xsl:when>
            <xsl:when test="$nomsansext='Eta'">&#x397;</xsl:when>
            <xsl:when test="$nomsansext='Theta'">&#x398;</xsl:when>
            <xsl:when test="$nomsansext='Iota'">&#x399;</xsl:when>
            <xsl:when test="$nomsansext='Kappa'">&#x39A;</xsl:when>
            <xsl:when test="$nomsansext='Lambda'">&#x39B;</xsl:when>
            <xsl:when test="$nomsansext='Mu'">&#x39C;</xsl:when>
            <xsl:when test="$nomsansext='Nu'">&#x39D;</xsl:when>
            <xsl:when test="$nomsansext='Xi'">&#x39E;</xsl:when>
            <xsl:when test="$nomsansext='Omicron'">&#x39F;</xsl:when>
            <xsl:when test="$nomsansext='Pi'">&#x3A0;</xsl:when>
            <xsl:when test="$nomsansext='Rho'">&#x3A1;</xsl:when>
            <xsl:when test="$nomsansext='Sigma'">&#x3A3;</xsl:when>
            <xsl:when test="$nomsansext='Tau'">&#x3A4;</xsl:when>
            <xsl:when test="$nomsansext='Upsilon'">&#x3A5;</xsl:when>
            <xsl:when test="$nomsansext='Phi'">&#x3A6;</xsl:when>
            <xsl:when test="$nomsansext='Chi'">&#x3A7;</xsl:when>
            <xsl:when test="$nomsansext='Psi'">&#x3A8;</xsl:when>
            <xsl:when test="$nomsansext='Omega'">&#x3A9;</xsl:when>
            <xsl:when test="$nomsansext='alpha'">&#x3B1;</xsl:when>
            <xsl:when test="$nomsansext='beta'">&#x3B2;</xsl:when>
            <xsl:when test="$nomsansext='gamma'">&#x3B3;</xsl:when>
            <xsl:when test="$nomsansext='delta'">&#x3B4;</xsl:when>
            <xsl:when test="$nomsansext='epsilon'">&#x3B5;</xsl:when>
            <xsl:when test="$nomsansext='zeta'">&#x3B6;</xsl:when>
            <xsl:when test="$nomsansext='eta'">&#x3B7;</xsl:when>
            <xsl:when test="$nomsansext='theta'">&#x3B8;</xsl:when>
            <xsl:when test="$nomsansext='iota'">&#x3B9;</xsl:when>
            <!--<xsl:when test="$nomsansext='kappa'">&#x3BA;</xsl:when>  03BA confondu avec 03F0 sur MacOS  cause de la police Times -->
            <xsl:when test="$nomsansext='lambda'">&#x3BB;</xsl:when>
            <xsl:when test="$nomsansext='mu'">&#x3BC;</xsl:when>
            <xsl:when test="$nomsansext='nu'">&#x3BD;</xsl:when>
            <xsl:when test="$nomsansext='xi'">&#x3BE;</xsl:when>
            <xsl:when test="$nomsansext='omicron'">&#x3BF;</xsl:when>
            <xsl:when test="$nomsansext='pi'">&#x3C0;</xsl:when>
            <xsl:when test="$nomsansext='rho'">&#x3C1;</xsl:when>
            <!--<xsl:when test="$nomsansext='sigmaf'">&#x3C2;</xsl:when> pas bien affich sur Firefox Mac -->
            <xsl:when test="$nomsansext='sigma'">&#x3C3;</xsl:when>
            <xsl:when test="$nomsansext='tau'">&#x3C4;</xsl:when>
            <xsl:when test="$nomsansext='upsilon'">&#x3C5;</xsl:when>
            <!--<xsl:when test="$nomsansext='phi'">&#x3D5;</xsl:when> phi = unicode 03C6 != 03D5, invers sur MacOS  cause de la police Times, 03D5 ne s'affiche pas sur IE6 XP -->
            <!--<xsl:when test="$nomsansext='phi2'">&#x3C6;</xsl:when> unicode 03C6 != 03D5, invers sur MacOS -->
            <xsl:when test="$nomsansext='chi'">&#x3C7;</xsl:when>
            <xsl:when test="$nomsansext='psi'">&#x3C8;</xsl:when>
            <xsl:when test="$nomsansext='omega'">&#x3C9;</xsl:when>
            <!--<xsl:when test="$nomsansext='thetasym'">&#x3D1;</xsl:when> pas bien affich sur IE6 Windows et Firefox Mac -->
            <!--<xsl:when test="$nomsansext='upsih'">&#x3D2;</xsl:when> pas bien affich sur IE6 Windows -->
            <!--<xsl:when test="$nomsansext='piv'">&#x3D6;</xsl:when> pas bien affich sur IE6 Windows et Firefox Mac -->
            
            <xsl:when test="$nomsansext='asymp'">&#x2248;</xsl:when>
            <xsl:when test="$nomsansext='cap'">&#x2229;</xsl:when>
            <!-- <xsl:when test="$nomsansext='cup'">&#x222A;</xsl:when> ne s'affiche pas sur IE6 et IE7 XP -->
            <!-- <xsl:when test="$nomsansext='exist'">&#x2203;</xsl:when> ne s'affiche pas sur IE6 et IE7 XP -->
            <!-- <xsl:when test="$nomsansext='forall'">&#x2200;</xsl:when> ne s'affiche pas sur IE6 et IE7 XP -->
            <xsl:when test="$nomsansext='ge'">&#x2265;</xsl:when>
            <xsl:when test="$nomsansext='harr'">&#x2194;</xsl:when>
            <!-- <xsl:when test="$nomsansext='hdarr'">&#x21D4;</xsl:when> ne s'affiche pas sur IE6 et IE7 XP -->
            <xsl:when test="$nomsansext='infin'">&#x221E;</xsl:when>
            <!-- <xsl:when test="$nomsansext='isin'">&#x2208;</xsl:when> ne s'affiche pas sur IE6 et IE7 XP -->
            <xsl:when test="$nomsansext='larr'">&#x2190;</xsl:when>
            <!-- ldarr = symbole HTML lArr ne s'affiche pas avec IE 6 -->
            <xsl:when test="$nomsansext='le'">&#x2264;</xsl:when>
            <!-- <xsl:when test="$nomsansext='nabla'">&#x2207;</xsl:when> ne s'affiche pas sur IE6 et IE7 XP -->
            <xsl:when test="$nomsansext='ne'">&#x2260;</xsl:when>
            <xsl:when test="$nomsansext='not'">&#xAC;</xsl:when>
            <xsl:when test="$nomsansext='part'">&#x2202;</xsl:when>
            <xsl:when test="$nomsansext='plusmn'">&#xB1;</xsl:when>
            <xsl:when test="$nomsansext='rarr'">&#x2192;</xsl:when>
            <!-- <xsl:when test="$nomsansext='rdarr'">&#x21D2;</xsl:when> ne s'affiche pas sur IE6 et IE7 XP -->
            <!-- sim ne s'affiche pas sur IE6 et IE7 XP-->
            <!-- <xsl:when test="$nomsansext='sub'">&#x2282;</xsl:when> ne s'affiche pas sur IE6 et IE7 XP -->
            
            <xsl:otherwise>
                <img src="interface/{@nom}" border="0" alt="{$nomlettre}" class="maths"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    <xsl:template match="SYMBOLE">
        <xsl:variable name="nomlettre"><xsl:call-template name="nom-fichier"><xsl:with-param name="chemin" select="@nom"/></xsl:call-template></xsl:variable>
        <xsl:call-template name="sortie-symbole">
            <xsl:with-param name="nomlettre" select="$nomlettre"/>
        </xsl:call-template>
    </xsl:template>
    
    
    <xsl:template match="EQUATION">
        <xsl:variable name="numero"><xsl:number from="CONTENU" count="EQUATION" level="any"/></xsl:variable>
        <img alt="{@texte}" src="MICA?equation={$numero}" class="maths"/>
    </xsl:template>
    
    
    <xsl:template match="EMPHASE">
        <em><xsl:apply-templates/></em>
    </xsl:template>
    
    
    <xsl:template match="INDICE">
        <sub><xsl:apply-templates/></sub>
    </xsl:template>
    
    
    <xsl:template match="EXPOSANT">
        <sup><xsl:apply-templates/></sup>
    </xsl:template>
    
    
    <xsl:template match="CODE">
        <tt><xsl:apply-templates/></tt>
    </xsl:template>
    
    
    <xsl:template match="ESPACE">&#xA0;</xsl:template>
    
    
    <!-- Bibliothque -->
    
    <xsl:template match="BIBLIOTHEQUE">
        <html>
            <head>
                <title>Bibliothque</title>
                <link type="text/css" rel="stylesheet" href="MICA/interface/{$feuille-de-style}"/>
            </head>
            <body class="page">
                <div class="zone_logo">
                    <img src="MICA/interface/logo.png" alt="logo"/>
                </div>
                <div class="titre_site_1"><xsl:value-of select="@titre_edc"/></div>
                <div class="titre_site_2"><xsl:value-of select="@titre_edc"/></div>
                <div class="zone_titre">
                    <table cellspacing="0" cellpadding="0"><tr>
                    <td><h1>Bibliothque</h1></td>
                    </tr></table>
                </div>
                <ul>
                    <xsl:apply-templates/>
                </ul>
            </body>
        </html>
    </xsl:template>
    
    <xsl:template match="ELEMENT_BIBLIOTHEQUE">
        <li>
            <a name="{@label}"/>
            <xsl:apply-templates/>
        </li>
    </xsl:template>
    
    
    <!-- Outils -->
    
    <xsl:template name="format-fichier">
    <!-- renvoit le format suppos d'un fichier d'image/animation  partir de son nom, en utilisant l'extension -->
    <!-- formats reconnus: PNG, JPEG, GIF, MPEG, OGG -->
    <!-- renvoit '?' si le format n'est pas reconnu -->
        <xsl:param name="nom"/>
        <xsl:variable name="ext"><xsl:call-template name="extension-fichier"><xsl:with-param name="nom" select="$nom"/></xsl:call-template></xsl:variable>
        <xsl:variable name="extmin" select="translate($ext, 'ABCDEFGHIJKLMNOPQRSTUVWXYZ', 'abcdefghijklmnopqrstuvwxyz')"/>
        <xsl:choose>
            <xsl:when test="$extmin='png'">PNG</xsl:when>
            <xsl:when test="$extmin='jpg' or $extmin='jpeg'">JPEG</xsl:when>
            <xsl:when test="$extmin='gif'">GIF</xsl:when>
            <xsl:when test="$extmin='mpg' or $extmin='mpeg'">MPEG</xsl:when>
            <xsl:when test="$extmin='ogg' or $extmin='ogv'">OGG</xsl:when>
            <xsl:otherwise>?</xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    <xsl:template name="extension-fichier">
    <!-- renvoit l'extension d'un fichier  partir de son nom -->
        <xsl:param name="nom"/>
        <xsl:choose>
            <xsl:when test="contains($nom,'.')">
                <xsl:call-template name="extension-fichier"><xsl:with-param name="nom" select="substring-after($nom,'.')"/></xsl:call-template>
            </xsl:when>
            <xsl:otherwise><xsl:value-of select="$nom"/></xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
</xsl:stylesheet>
