/*
 * Decompiled with CFR 0.152.
 */
package serveurmica;

import java.io.File;
import java.util.ArrayList;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import serveurmica.ExceptionMICA;
import serveurmica.OutilsXML;
import serveurmica.Utilisateur;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Utilisateurs {
    private ArrayList<Utilisateur> liste;
    private File f_xml;

    public Utilisateurs(File f) throws ExceptionMICA {
        this.f_xml = f;
        this.liste = new ArrayList();
        if (f.exists()) {
            Document doc = OutilsXML.lectureDocumentXML(this.f_xml);
            if (doc == null) {
                throw new ExceptionMICA("Erreur \u00e0 l'ouverture du fichier d'utilisateurs");
            }
            Element racine = doc.getDocumentElement();
            if (!"UTILISATEURS".equals(racine.getLocalName())) {
                throw new ExceptionMICA("Mauvais \u00e9l\u00e9ment racine pour les utilisateurs: " + racine.getLocalName());
            }
            ArrayList<Element> elements_utilisateurs = OutilsXML.enfants(racine, "UTILISATEUR");
            for (Element eu : elements_utilisateurs) {
                this.liste.add(new Utilisateur(eu));
            }
        }
    }

    public boolean aucunUtilisateur() {
        return this.liste.size() == 0;
    }

    public void enregistrer() throws ExceptionMICA {
        Document doc = OutilsXML.nouveauDocumentDOM();
        Element racine = doc.createElementNS(null, "UTILISATEURS");
        for (Utilisateur u : this.liste) {
            u.ajouterDOM(racine);
        }
        doc.appendChild(racine);
        OutilsXML.ecrireDocumentXML(doc, this.f_xml);
    }

    public Utilisateur nouvelUtilisateur(String username, String password, String type, String nom, String prenom, String email, String salt) throws ExceptionMICA {
        Utilisateur u = new Utilisateur(username, password, type, nom, prenom, email, "378614");
        this.liste.add(u);
        this.enregistrer();
        return u;
    }

    public Utilisateur getUtilisateur(String username) {
        if (username == null) {
            return null;
        }
        for (Utilisateur u : this.liste) {
            if (!username.equals(u.getUsername())) continue;
            return u;
        }
        return null;
    }

    public ArrayList<Utilisateur> selectionUtilisateurs(Boolean bValide, Boolean bFerme) {
        ArrayList<Utilisateur> l = new ArrayList<Utilisateur>();
        for (Utilisateur u : this.liste) {
            if (bValide != null && u.valide() != bValide.booleanValue() || bFerme != null && u.ferme() != bFerme.booleanValue()) continue;
            l.add(u);
        }
        return l;
    }

    public void valider(Utilisateur u) throws ExceptionMICA {
        u.setValide(true);
        this.enregistrer();
    }

    public void fermer(Utilisateur u) throws ExceptionMICA {
        u.setFerme(true);
        this.enregistrer();
    }

    public void rouvrir(Utilisateur u) throws ExceptionMICA {
        u.setFerme(false);
        this.enregistrer();
    }

    public void supprimer(Utilisateur u) throws ExceptionMICA {
        this.liste.remove(u);
        this.enregistrer();
    }
}

