/*
 * Decompiled with CFR 0.152.
 */
package serveurmica;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import serveurmica.DecodeurBase64;
import serveurmica.EncodeurBase64;
import serveurmica.ExceptionMICA;
import serveurmica.OutilsXML;
import serveurmica.SuiviEDC;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Utilisateur {
    private String username;
    private String password;
    private String type;
    private String nom;
    private String prenom;
    private String email;
    private boolean valide;
    private boolean ferme;
    private String date_inscription;
    private String date_fermeture;
    private ArrayList<SuiviEDC> suivis;

    public Utilisateur(Element el) throws ExceptionMICA {
        if (!"UTILISATEUR".equals(el.getLocalName())) {
            throw new ExceptionMICA("Mauvais \u00e9l\u00e9ment pour un utilisateur: " + el.getLocalName());
        }
        this.username = el.getAttribute("username");
        this.password = el.getAttribute("password");
        this.type = el.getAttribute("type");
        this.nom = el.getAttribute("nom");
        this.prenom = el.getAttribute("prenom");
        this.email = el.getAttribute("email");
        this.valide = "oui".equals(el.getAttribute("valide"));
        this.ferme = "oui".equals(el.getAttribute("ferme"));
        this.date_inscription = el.getAttribute("date_inscription");
        this.date_fermeture = el.getAttribute("date_fermeture");
        this.suivis = new ArrayList();
        ArrayList<Element> elements_suivi = OutilsXML.enfants(el, "SUIVI_EDC");
        for (Element elsuivi : elements_suivi) {
            this.suivis.add(new SuiviEDC(elsuivi));
        }
    }

    public Utilisateur(String username, String password, String type, String nom, String prenom, String email, String salt) throws ExceptionMICA {
        byte[] bSalt;
        this.username = username;
        try {
            bSalt = salt.getBytes("UTF-8");
        }
        catch (IOException ex) {
            throw new ExceptionMICA(ex);
        }
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-1");
            digest.reset();
            digest.update(bSalt);
            byte[] ba = digest.digest(password.getBytes("UTF-8"));
            this.password = this.byteArrayToBase64(ba);
            this.type = type;
            this.nom = nom;
            this.prenom = prenom;
            this.email = email;
            this.valide = false;
            this.ferme = false;
            Date now = new Date();
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm");
            this.date_inscription = formatter.format(now);
            this.date_fermeture = "";
            this.suivis = new ArrayList();
        }
        catch (NoSuchAlgorithmException ex) {
            throw new ExceptionMICA(ex);
        }
        catch (UnsupportedEncodingException ex) {
            throw new ExceptionMICA(ex);
        }
        catch (IOException ex) {
            throw new ExceptionMICA(ex);
        }
    }

    public void ajouterDOM(Element parent) {
        Document doc = parent.getOwnerDocument();
        Element el_u = doc.createElementNS(null, "UTILISATEUR");
        el_u.setAttributeNS(null, "username", this.username);
        el_u.setAttributeNS(null, "password", this.password);
        el_u.setAttributeNS(null, "type", this.type);
        el_u.setAttributeNS(null, "nom", this.nom);
        el_u.setAttributeNS(null, "prenom", this.prenom);
        el_u.setAttributeNS(null, "email", this.email);
        el_u.setAttributeNS(null, "valide", this.valide ? "oui" : "non");
        el_u.setAttributeNS(null, "ferme", this.ferme ? "oui" : "non");
        el_u.setAttributeNS(null, "date_inscription", this.date_inscription);
        el_u.setAttributeNS(null, "date_fermeture", this.date_fermeture);
        for (SuiviEDC s : this.suivis) {
            s.ajouterDOM(el_u);
        }
        parent.appendChild(el_u);
    }

    public String getUsername() {
        return this.username;
    }

    public String getNom() {
        return this.nom;
    }

    public String getPrenom() {
        return this.prenom;
    }

    public String getEmail() {
        return this.email;
    }

    public String getType() {
        return this.type;
    }

    public boolean estAdministrateur() {
        return "administrateur".equals(this.type);
    }

    public boolean valide() {
        return this.valide;
    }

    public void setValide(boolean valide) {
        this.valide = valide;
    }

    public boolean ferme() {
        return this.ferme;
    }

    public void setFerme(boolean ferme) {
        this.ferme = ferme;
    }

    public ArrayList<SuiviEDC> getSuivis() {
        return this.suivis;
    }

    public SuiviEDC nouveauSuivi(String label_edc) throws ExceptionMICA {
        SuiviEDC suivi = new SuiviEDC(label_edc);
        this.suivis.add(suivi);
        return suivi;
    }

    public boolean verifierPassord(String password_test, String salt) throws ExceptionMICA {
        try {
            byte[] bDigest = this.base64ToByteArray(this.password);
            if (bDigest == null) {
                return false;
            }
            byte[] bSalt = salt.getBytes("UTF-8");
            if (bSalt == null) {
                return false;
            }
            MessageDigest digest = MessageDigest.getInstance("SHA-1");
            digest.reset();
            digest.update(bSalt);
            byte[] digest_test = digest.digest(password_test.getBytes("UTF-8"));
            return Arrays.equals(digest_test, bDigest);
        }
        catch (IOException ex) {
            return false;
        }
        catch (NoSuchAlgorithmException ex) {
            throw new ExceptionMICA(ex);
        }
    }

    private byte[] base64ToByteArray(String s) throws IOException {
        int c;
        DecodeurBase64 decodeur = new DecodeurBase64(new StringReader(s));
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        while ((c = decodeur.read()) != -1) {
            baos.write(c);
        }
        decodeur.close();
        baos.close();
        return baos.toByteArray();
    }

    private String byteArrayToBase64(byte[] ba) throws IOException {
        int c;
        StringWriter sw = new StringWriter();
        EncodeurBase64 encodeur = new EncodeurBase64(sw);
        ByteArrayInputStream bais = new ByteArrayInputStream(ba);
        while ((c = bais.read()) != -1) {
            encodeur.write(c);
        }
        bais.close();
        encodeur.close();
        return sw.toString();
    }
}

