/*
 * Decompiled with CFR 0.152.
 */
package serveurmica;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import serveurmica.ExceptionMICA;
import serveurmica.OutilsXML;

public class SuiviEDC {
    private String label_edc;
    private String label_etape;
    private String label_section;
    private boolean terminee;
    private Hashtable<String, Double> variables;

    public SuiviEDC(Element el) throws ExceptionMICA {
        if (!"SUIVI_EDC".equals(el.getLocalName())) {
            throw new ExceptionMICA("Mauvais \u00e9l\u00e9ment pour le suivi des EDC: " + el.getLocalName());
        }
        this.label_edc = el.getAttribute("label_edc");
        this.label_etape = el.getAttribute("label_etape");
        if ("".equals(this.label_etape)) {
            this.label_etape = null;
        }
        this.label_section = el.getAttribute("label_section");
        if ("".equals(this.label_section)) {
            this.label_section = null;
        }
        this.terminee = "oui".equals(el.getAttribute("terminee"));
        this.variables = new Hashtable();
        ArrayList<Element> elements_variables = OutilsXML.enfants(el, "VARIABLE");
        for (Element elvar : elements_variables) {
            try {
                this.variables.put(elvar.getAttribute("nom"), Double.valueOf(elvar.getAttribute("valeur")));
            }
            catch (NumberFormatException ex) {}
        }
    }

    public SuiviEDC(String label_edc) throws ExceptionMICA {
        this.label_edc = label_edc;
        this.label_etape = null;
        this.label_section = null;
        this.terminee = false;
        this.variables = new Hashtable();
    }

    public void ajouterDOM(Element parent) {
        Document doc = parent.getOwnerDocument();
        Element el_s = doc.createElementNS(null, "SUIVI_EDC");
        el_s.setAttributeNS(null, "label_edc", this.label_edc);
        el_s.setAttributeNS(null, "label_etape", this.label_etape);
        el_s.setAttributeNS(null, "label_section", this.label_section);
        el_s.setAttributeNS(null, "terminee", this.terminee ? "oui" : "non");
        for (Map.Entry<String, Double> v : this.variables.entrySet()) {
            Element el_v = doc.createElementNS(null, "VARIABLE");
            el_v.setAttributeNS(null, "nom", v.getKey());
            el_v.setAttributeNS(null, "valeur", v.getValue().toString());
            el_s.appendChild(el_v);
        }
        parent.appendChild(el_s);
    }

    public String getLabelEDC() {
        return this.label_edc;
    }

    public String getLabelEtape() {
        return this.label_etape;
    }

    public void setLabelEtape(String label_etape) {
        this.label_etape = label_etape;
    }

    public String getLabelSection() {
        return this.label_section;
    }

    public void setLabelSection(String label_section) {
        this.label_section = label_section;
    }

    public boolean terminee() {
        return this.terminee;
    }

    public void setTerminee() {
        this.terminee = true;
    }

    public double getValeurVariable(String nom) {
        if (nom == null) {
            return 0.0;
        }
        Double d = this.variables.get(nom);
        if (d == null) {
            return 0.0;
        }
        return d;
    }

    public boolean variableDefinie(String nom) {
        return this.variables.get(nom) != null;
    }

    public void setValeurVariable(String nom, Double valeur) {
        this.variables.put(nom, valeur);
    }

    public void etapeTerminee() {
        if (this.label_etape == null) {
            return;
        }
        this.setValeurVariable(this.label_etape, new Double(1.0));
    }

    public boolean etapeAutorisee(String label_etape) {
        if (label_etape == null) {
            return false;
        }
        return label_etape.equals(this.label_etape) || this.getValeurVariable(label_etape) == 1.0;
    }
}

