/*
 * Decompiled with CFR 0.152.
 */
package serveurmica;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import serveurmica.EtudeDeCas;
import serveurmica.ExceptionMICA;
import serveurmica.OutilsXML;
import serveurmica.SuiviEDC;
import serveurmica.Utilisateur;
import serveurmica.Utilisateurs;

public class ServletMICA
extends HttpServlet {
    private static ArrayList<EtudeDeCas> etudes_de_cas = null;
    private static Utilisateurs utilisateurs = null;

    private void erreurInterne(String methode, Exception ex) {
        this.erreurInterne(methode + ": " + ex.getClass().getName() + ": " + ex.getMessage());
    }

    private void erreurInterne(Exception ex) {
        this.erreurInterne(ex.getClass().getName() + ": " + ex.getMessage());
    }

    private void erreurInterne(String message) {
        this.log("Erreur interne: " + message);
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.initialisation();
    }

    public void initialisation() {
        this.log("ServletMICA: initialisation...");
        try {
            File dossier_etudes_de_cas = new File(this.getServletContext().getRealPath("/WEB-INF/etudes_de_cas"));
            if (!dossier_etudes_de_cas.isDirectory()) {
                this.erreurInterne("Le dossier etudes_de_cas n'existe pas.");
            }
            File fichier_xsl = new File(this.getServletContext().getRealPath("/WEB-INF/affichage_MICA.xsl"));
            etudes_de_cas = new ArrayList();
            for (File dossier_edc : dossier_etudes_de_cas.listFiles()) {
                File fichier_xml;
                File dossier_contrib_edc;
                if (!dossier_edc.isDirectory() || !(dossier_contrib_edc = new File(dossier_edc, dossier_edc.getName())).isDirectory() || !(fichier_xml = new File(dossier_contrib_edc, dossier_edc.getName() + ".xml")).exists()) continue;
                try {
                    etudes_de_cas.add(new EtudeDeCas(fichier_xml, fichier_xsl));
                }
                catch (ExceptionMICA ex) {
                    this.erreurInterne(ex);
                }
            }
            utilisateurs = new Utilisateurs(new File(this.getServletContext().getRealPath("/WEB-INF/utilisateurs.xml")));
        }
        catch (ExceptionMICA ex) {
            this.erreurInterne(ex);
        }
        this.log("ServletMICA: fin de l'initialisation");
    }

    public void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (utilisateurs == null) {
            this.envoyerErreur(resp, "La servlet n'est pas encore initialis\u00e9e");
            return;
        }
        if (req.getParameter("username") != null && req.getParameter("administration") == null) {
            HttpSession session = req.getSession(true);
            String username = req.getParameter("username");
            String motdepasse = req.getParameter("motdepasse");
            String motdepasse2 = req.getParameter("motdepasse2");
            String nom = req.getParameter("nom");
            String prenom = req.getParameter("prenom");
            String email = req.getParameter("email");
            if (username == null) {
                this.envoyerErreur(resp, "Il manque le nom d'utilisateur.");
                return;
            }
            if (username.indexOf(32) != -1) {
                this.envoyerErreur(resp, "Les espaces ne sont pas autoris\u00e9s dans les noms d'utilisateur.");
                return;
            }
            String accents = "\u00e0\u00e2\u00e9\u00e8\u00ea\u00eb\u00ee\u00ef\u00f4\u00f6\u00f9\u00fb\u00fc\u00e7\u00c0\u00c2\u00c9\u00c8\u00ca\u00cb\u00ce\u00cf\u00d4\u00d9\u00db\u00dc\u00c7";
            for (int i = 0; i < "\u00e0\u00e2\u00e9\u00e8\u00ea\u00eb\u00ee\u00ef\u00f4\u00f6\u00f9\u00fb\u00fc\u00e7\u00c0\u00c2\u00c9\u00c8\u00ca\u00cb\u00ce\u00cf\u00d4\u00d9\u00db\u00dc\u00c7".length(); ++i) {
                if (username.indexOf("\u00e0\u00e2\u00e9\u00e8\u00ea\u00eb\u00ee\u00ef\u00f4\u00f6\u00f9\u00fb\u00fc\u00e7\u00c0\u00c2\u00c9\u00c8\u00ca\u00cb\u00ce\u00cf\u00d4\u00d9\u00db\u00dc\u00c7".charAt(i)) == -1) continue;
                this.envoyerErreur(resp, "Les accents ne sont pas autoris\u00e9s dans les noms d'utilisateur.");
                return;
            }
            String majuscules = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
            for (int i = 0; i < "ABCDEFGHIJKLMNOPQRSTUVWXYZ".length(); ++i) {
                if (username.indexOf("ABCDEFGHIJKLMNOPQRSTUVWXYZ".charAt(i)) == -1) continue;
                this.envoyerErreur(resp, "Les majuscules ne sont pas autoris\u00e9s dans les noms d'utilisateur.");
                return;
            }
            if (username.length() > 20) {
                this.envoyerErreur(resp, "Le nom d'utilisateur est trop long.");
                return;
            }
            Utilisateur u_test = utilisateurs.getUtilisateur(username);
            if (u_test != null) {
                this.envoyerErreur(resp, "Un utilisateur existe d\u00e9j\u00e0 avec ce nom d'utilisateur");
                return;
            }
            if (motdepasse == null || "".equals(motdepasse)) {
                this.envoyerErreur(resp, "Il manque le mot de passe.");
                return;
            }
            if (motdepasse.length() < 5) {
                this.envoyerErreur(resp, "Le mot de passe est trop court.");
                return;
            }
            if (motdepasse.length() > 30) {
                this.envoyerErreur(resp, "Le mot de passe est trop long.");
                return;
            }
            if (!motdepasse.equals(motdepasse2)) {
                this.envoyerErreur(resp, "Le deuxi\u00e8me champ pour le mot de passe n'est pas identique au premier.");
                return;
            }
            if (nom == null) {
                this.envoyerErreur(resp, "Il manque le nom de famille.");
                return;
            }
            if (prenom == null) {
                this.envoyerErreur(resp, "Il manque le pr\u00e9nom.");
                return;
            }
            if (email == null || email.indexOf(64) == -1 || email.indexOf(46) == -1) {
                this.envoyerErreur(resp, "Adresse mail non valide. Veuillez recommencer.");
                return;
            }
            this.inscription(resp, username, motdepasse, nom, prenom, email);
            return;
        }
        if (req.getParameter("login") != null) {
            HttpSession session = req.getSession(true);
            String login = req.getParameter("login");
            String motdepasse = req.getParameter("motdepasse");
            if (motdepasse == null) {
                this.envoyerErreur(resp, "Il manque des param\u00e8tres \u00e0 la requ\u00eate");
                return;
            }
            Utilisateur u = utilisateurs.getUtilisateur(login);
            try {
                if (u == null || !u.verifierPassord(motdepasse, "378614")) {
                    this.envoyerErreur(resp, "Identification incorrecte");
                    return;
                }
            }
            catch (ExceptionMICA ex) {
                this.erreurInterne("doPost", ex);
                this.envoyerErreur(resp, "Erreur interne !");
                return;
            }
            if (!u.valide()) {
                this.envoyerErreur(resp, "Votre inscription n'a pas encore \u00e9t\u00e9 valid\u00e9e par l'administrateur.");
                return;
            }
            if (u.ferme()) {
                this.envoyerErreur(resp, "Votre compte est ferm\u00e9.");
                return;
            }
            session.setAttribute("utilisateur", (Object)u);
            this.accueil(resp, u);
            return;
        }
        if (req.getParameter("administration") != null) {
            HttpSession session = req.getSession(false);
            if (session == null) {
                this.envoyerErreur(resp, "Vous n'\u00eates pas authentifi\u00e9. Revenez \u00e0 la page d'identification.");
                return;
            }
            Utilisateur u_admin = (Utilisateur)session.getAttribute("utilisateur");
            if (u_admin == null) {
                this.envoyerErreur(resp, "Erreur \u00e0 l'authentification. Revenez \u00e0 la page d'identification.");
                return;
            }
            if (!u_admin.estAdministrateur()) {
                this.envoyerErreur(resp, "Vous n'\u00eates pas administrateur.");
                return;
            }
            String operation = req.getParameter("administration");
            if ("valider".equals(operation) || "fermer".equals(operation) || "rouvrir".equals(operation) || "supprimer".equals(operation)) {
                String un_utilisateur = req.getParameter("username");
                Utilisateur u = utilisateurs.getUtilisateur(un_utilisateur);
                if (u == null) {
                    this.envoyerErreur(resp, "Impossible de trouver l'utilisateur !");
                    return;
                }
                try {
                    if ("valider".equals(operation)) {
                        utilisateurs.valider(u);
                    } else if ("fermer".equals(operation)) {
                        utilisateurs.fermer(u);
                    } else if ("rouvrir".equals(operation)) {
                        utilisateurs.rouvrir(u);
                    } else if ("supprimer".equals(operation)) {
                        utilisateurs.supprimer(u);
                    }
                }
                catch (ExceptionMICA ex) {
                    this.erreurInterne("doPost", ex);
                    this.envoyerErreur(resp, "Erreur interne !");
                    return;
                }
                this.gestion(resp);
                return;
            }
            if ("gestion".equals(operation)) {
                this.gestion(resp);
                return;
            }
            if ("initialisation".equals(operation)) {
                String login = u_admin.getUsername();
                this.initialisation();
                Utilisateur u = utilisateurs.getUtilisateur(login);
                session.setAttribute("utilisateur", (Object)u);
                this.accueil(resp, u);
                return;
            }
            this.envoyerErreur(resp, "requ\u00eate POST non comprise (administration)");
            return;
        }
        if ("Commencer".equals(req.getParameter("operation")) && req.getParameter("edc") != null) {
            HttpSession session = req.getSession(false);
            if (session == null) {
                this.envoyerErreur(resp, "Vous n'\u00eates pas authentifi\u00e9. Revenez \u00e0 la page d'identification.");
                return;
            }
            Utilisateur apprenant = (Utilisateur)session.getAttribute("utilisateur");
            if (apprenant == null) {
                this.envoyerErreur(resp, "Erreur \u00e0 l'authentification. Revenez \u00e0 la page d'identification.");
                return;
            }
            String label_edc = req.getParameter("edc");
            EtudeDeCas edc = this.trouverEDC(label_edc);
            if (edc == null) {
                this.envoyerErreur(resp, "Etude de cas introuvable !");
                return;
            }
            try {
                SuiviEDC suivi = apprenant.nouveauSuivi(label_edc);
                suivi.setLabelEtape(edc.labelPremiereEtape());
                session.setAttribute("suivi", (Object)suivi);
                utilisateurs.enregistrer();
                edc.afficherPage(resp, suivi);
                return;
            }
            catch (ExceptionMICA ex) {
                this.erreurInterne("doPost", ex);
                this.envoyerErreur(resp, "Erreur interne !");
                return;
            }
        }
        if ("Continuer".equals(req.getParameter("operation")) && req.getParameter("noedc") != null) {
            int noedc;
            HttpSession session = req.getSession(false);
            if (session == null) {
                this.envoyerErreur(resp, "Vous n'\u00eates pas authentifi\u00e9. Revenez \u00e0 la page d'identification.");
                return;
            }
            Utilisateur apprenant = (Utilisateur)session.getAttribute("utilisateur");
            if (apprenant == null) {
                this.envoyerErreur(resp, "Erreur \u00e0 l'authentification. Revenez \u00e0 la page d'identification.");
                return;
            }
            EtudeDeCas edc = null;
            SuiviEDC suivi = null;
            String snoedc = req.getParameter("noedc");
            try {
                noedc = Integer.valueOf(snoedc);
            }
            catch (NumberFormatException ex) {
                this.envoyerErreur(resp, "le num\u00e9ro d'\u00e9tude de cas n'est pas un entier: " + edc);
                return;
            }
            int no = 0;
            for (SuiviEDC s : apprenant.getSuivis()) {
                EtudeDeCas e;
                if (s.terminee() || (e = this.trouverEDC(s.getLabelEDC())) == null || ++no != noedc) continue;
                suivi = s;
                edc = e;
                break;
            }
            if (edc == null) {
                this.envoyerErreur(resp, "Etude de cas introuvable !");
                return;
            }
            String label_edc = edc.getLabel();
            session.setAttribute("suivi", suivi);
            try {
                edc.afficherPage(resp, suivi);
                return;
            }
            catch (ExceptionMICA ex) {
                this.erreurInterne("doPost", ex);
                this.envoyerErreur(resp, "Erreur interne !");
                return;
            }
        }
        if (req.getParameter("section_suivante") != null || req.getParameter("section_suivante.x") != null || req.getParameter("section_precedente") != null || req.getParameter("section_precedente.x") != null) {
            HttpSession session = req.getSession(false);
            if (session == null) {
                this.envoyerErreur(resp, "Vous n'\u00eates pas authentifi\u00e9. Revenez \u00e0 la page d'identification.");
                return;
            }
            SuiviEDC suivi = (SuiviEDC)session.getAttribute("suivi");
            if (suivi == null) {
                this.envoyerErreur(resp, "Suivi introuvable !");
                return;
            }
            String label_edc = suivi.getLabelEDC();
            EtudeDeCas edc = this.trouverEDC(label_edc);
            if (edc == null) {
                this.envoyerErreur(resp, "Etude de cas '" + label_edc + "' introuvable !");
                return;
            }
            String label_etape = suivi.getLabelEtape();
            String label_section = suivi.getLabelSection();
            String label_autre_section = req.getParameter("section_suivante") != null || req.getParameter("section_suivante.x") != null ? edc.labelSectionSuivante(label_etape, label_section) : edc.labelSectionPrecedente(label_etape, label_section);
            try {
                edc.majSuivi(suivi, label_etape, label_autre_section);
                utilisateurs.enregistrer();
                edc.afficherPage(resp, suivi);
            }
            catch (ExceptionMICA ex) {
                this.erreurInterne("section_suivante/precedente", ex);
                this.envoyerErreur(resp, "Erreur interne !");
                return;
            }
            return;
        }
        Enumeration e = req.getParameterNames();
        while (e.hasMoreElements()) {
            String nom_parametre = (String)e.nextElement();
            if (!nom_parametre.startsWith("enchainement_etape_")) continue;
            HttpSession session = req.getSession(false);
            if (session == null) {
                this.envoyerErreur(resp, "Vous n'\u00eates pas authentifi\u00e9. Revenez \u00e0 la page d'identification.");
                return;
            }
            String label_etape = nom_parametre.substring("enchainement_etape_".length());
            SuiviEDC suivi = (SuiviEDC)session.getAttribute("suivi");
            if (suivi == null) {
                this.envoyerErreur(resp, "Suivi introuvable !");
                return;
            }
            String label_edc = suivi.getLabelEDC();
            EtudeDeCas edc = this.trouverEDC(label_edc);
            if (edc == null) {
                this.envoyerErreur(resp, "Etude de cas '" + label_edc + "' introuvable !");
                return;
            }
            try {
                if (!edc.enchainementPossible(suivi.getLabelEtape(), label_etape, suivi)) {
                    this.envoyerErreur(resp, "Encha\u00eenement interdit !");
                    return;
                }
                Hashtable<String, ArrayList<String>> parametres = new Hashtable<String, ArrayList<String>>();
                Enumeration e2 = req.getParameterNames();
                while (e2.hasMoreElements()) {
                    String nom = (String)e2.nextElement();
                    if (!nom.startsWith("exercice")) continue;
                    ArrayList<String> valeurs = new ArrayList<String>(Arrays.asList(req.getParameterValues(nom)));
                    parametres.put(nom, valeurs);
                }
                edc.verifierParametres(parametres, suivi);
                edc.majVariables(parametres, suivi);
                edc.majSuivi(suivi, label_etape, null);
                utilisateurs.enregistrer();
                edc.afficherPage(resp, suivi);
                return;
            }
            catch (ExceptionMICA ex) {
                if (ex.erreurUtilisateur()) {
                    this.envoyerErreur(resp, ex.getMessage());
                } else {
                    this.erreurInterne("doPost", ex);
                    this.envoyerErreur(resp, "Erreur interne !");
                }
                return;
            }
        }
        this.envoyerErreur(resp, "requ\u00eate POST non comprise");
    }

    public void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (utilisateurs == null) {
            this.envoyerErreur(resp, "La servlet n'est pas encore initialis\u00e9e");
            return;
        }
        if (req.getPathInfo() != null) {
            String chemin = req.getPathInfo();
            if (!chemin.startsWith("/interface/")) {
                this.envoyerErreur(resp, "Chemin impossible.");
                this.log("Chemin impossible: " + chemin);
                return;
            }
            File fichier = new File(this.getServletContext().getRealPath(chemin));
            if (!fichier.getCanonicalPath().startsWith(new File(this.getServletContext().getRealPath("/")).getCanonicalPath())) {
                this.envoyerErreur(resp, "Acc\u00e8s interdit !");
                this.log("Acc\u00e8s interdit: " + chemin);
                return;
            }
            String mime = this.getServletContext().getMimeType(fichier.getName().toLowerCase());
            if (mime == null) {
                throw new IOException("MIME inconnu pour " + fichier.getName());
            }
            resp.setContentType(mime);
            resp.setContentLength((int)fichier.length());
            this.envoyerFichier((OutputStream)resp.getOutputStream(), fichier);
            return;
        }
        HttpSession session = req.getSession(false);
        if (session == null) {
            this.envoyerErreur(resp, "Vous n'\u00eates pas authentifi\u00e9. Revenez \u00e0 la page d'identification.");
            return;
        }
        Utilisateur apprenant = (Utilisateur)session.getAttribute("utilisateur");
        if (apprenant == null) {
            this.envoyerErreur(resp, "Erreur \u00e0 l'authentification. Revenez \u00e0 la page d'identification.");
            return;
        }
        if (req.getParameter("autre_section") != null) {
            String autre_section = req.getParameter("autre_section");
            SuiviEDC suivi = (SuiviEDC)session.getAttribute("suivi");
            if (suivi == null) {
                this.envoyerErreur(resp, "Suivi introuvable !");
                return;
            }
            String label_edc = suivi.getLabelEDC();
            EtudeDeCas edc = this.trouverEDC(label_edc);
            if (edc == null) {
                this.envoyerErreur(resp, "Etude de cas '" + label_edc + "' introuvable !");
                return;
            }
            if ("suivante".equals(autre_section) || "precedente".equals(autre_section)) {
                String label_etape = suivi.getLabelEtape();
                String label_section = suivi.getLabelSection();
                String label_autre_section = "suivante".equals(autre_section) ? edc.labelSectionSuivante(label_etape, label_section) : edc.labelSectionPrecedente(label_etape, label_section);
                try {
                    edc.majSuivi(suivi, label_etape, label_autre_section);
                    utilisateurs.enregistrer();
                    edc.afficherPage(resp, suivi);
                }
                catch (ExceptionMICA ex) {
                    this.erreurInterne("autre_section", ex);
                    this.envoyerErreur(resp, "Erreur interne !");
                    return;
                }
                return;
            }
            this.envoyerErreur(resp, "Mauvaise valeur pour le param\u00e8tre autre_section.");
            return;
        }
        if (req.getParameter("fichier") != null) {
            String chemin_fichier = req.getParameter("fichier");
            SuiviEDC suivi = (SuiviEDC)session.getAttribute("suivi");
            if (suivi == null) {
                this.envoyerErreur(resp, "Suivi introuvable !");
                return;
            }
            String label_edc = suivi.getLabelEDC();
            EtudeDeCas edc = this.trouverEDC(label_edc);
            if (edc == null) {
                this.envoyerErreur(resp, "Etude de cas '" + label_edc + "' introuvable !");
                return;
            }
            File fichier_contrib = edc.getFichierContrib(suivi);
            if (fichier_contrib == null) {
                this.envoyerErreur(resp, "Etape '" + suivi.getLabelEtape() + "' introuvable !");
                return;
            }
            String nom_contrib = fichier_contrib.getParentFile().getName();
            String chemin = "/WEB-INF/etudes_de_cas/" + label_edc + "/" + nom_contrib + "/" + chemin_fichier;
            File fichier = new File(this.getServletContext().getRealPath(chemin));
            if (!fichier.getCanonicalPath().startsWith(new File(this.getServletContext().getRealPath("/")).getCanonicalPath())) {
                this.envoyerErreur(resp, "Acc\u00e8s interdit !");
                this.log("Acc\u00e8s interdit: " + chemin);
                return;
            }
            String mime = this.getServletContext().getMimeType(fichier.getName().toLowerCase());
            if (mime == null) {
                throw new IOException("MIME inconnu pour " + fichier.getName());
            }
            resp.setContentType(mime);
            resp.setContentLength((int)fichier.length());
            this.envoyerFichier((OutputStream)resp.getOutputStream(), fichier);
            return;
        }
        if (req.getParameter("page") != null) {
            String page = req.getParameter("page");
            if ("accueil".equals(page)) {
                this.accueil(resp, apprenant);
                return;
            }
            if ("sommaire".equals(page) || "glossaire".equals(page) || "bibliographie".equals(page) || "bibliotheque".equals(page)) {
                SuiviEDC suivi = (SuiviEDC)session.getAttribute("suivi");
                if (suivi == null) {
                    this.envoyerErreur(resp, "Suivi introuvable !");
                    return;
                }
                String label_edc = suivi.getLabelEDC();
                EtudeDeCas edc = this.trouverEDC(label_edc);
                if (edc == null) {
                    this.envoyerErreur(resp, "Etude de cas '" + label_edc + "' introuvable !");
                    return;
                }
                resp.setHeader("Pragma", "no-cache");
                resp.setHeader("Cache-Control", "no-cache");
                resp.setHeader("Expires", "0");
                resp.setContentType("text/html; charset=ISO-8859-1");
                try {
                    if ("sommaire".equals(page)) {
                        edc.afficherSommaire(resp.getWriter(), suivi);
                    } else if ("glossaire".equals(page)) {
                        edc.afficherGlossaire(resp.getWriter());
                    } else if ("bibliographie".equals(page)) {
                        edc.afficherBibliographie(resp.getWriter());
                    } else {
                        edc.afficherBibliotheque(resp);
                    }
                }
                catch (ExceptionMICA ex) {
                    this.erreurInterne("page " + page, ex);
                    this.envoyerErreur(resp, "Erreur interne !");
                    return;
                }
                return;
            }
            this.envoyerErreur(resp, "requ\u00eate non comprise");
            return;
        }
        if (req.getParameter("label_etape") != null) {
            String label_etape = req.getParameter("label_etape");
            SuiviEDC suivi = (SuiviEDC)session.getAttribute("suivi");
            if (suivi == null) {
                this.envoyerErreur(resp, "Suivi introuvable !");
                return;
            }
            if (!suivi.etapeAutorisee(label_etape)) {
                this.envoyerErreur(resp, "Vous n'\u00eates pas autoris\u00e9 \u00e0 aller directement vers cette \u00e9tape.");
                return;
            }
            String label_edc = suivi.getLabelEDC();
            EtudeDeCas edc = this.trouverEDC(label_edc);
            if (edc == null) {
                this.envoyerErreur(resp, "Etude de cas '" + label_edc + "' introuvable !");
                return;
            }
            try {
                edc.majSuivi(suivi, label_etape, null);
                utilisateurs.enregistrer();
                edc.afficherPage(resp, suivi);
            }
            catch (ExceptionMICA ex) {
                this.erreurInterne("doPost", ex);
                this.envoyerErreur(resp, "Erreur interne !");
                return;
            }
            return;
        }
        if (req.getParameter("label_section") != null) {
            String label_section = req.getParameter("label_section");
            SuiviEDC suivi = (SuiviEDC)session.getAttribute("suivi");
            if (suivi == null) {
                this.envoyerErreur(resp, "Suivi introuvable !");
                return;
            }
            String label_edc = suivi.getLabelEDC();
            EtudeDeCas edc = this.trouverEDC(label_edc);
            if (edc == null) {
                this.envoyerErreur(resp, "Etude de cas '" + label_edc + "' introuvable !");
                return;
            }
            try {
                edc.majSuivi(suivi, edc.labelEtapeSection(label_section), label_section);
                utilisateurs.enregistrer();
                edc.afficherPage(resp, suivi);
            }
            catch (ExceptionMICA ex) {
                this.erreurInterne("doPost", ex);
                this.envoyerErreur(resp, "Erreur interne !");
                return;
            }
            return;
        }
        if (req.getParameter("equation") != null) {
            int numero;
            SuiviEDC suivi = (SuiviEDC)session.getAttribute("suivi");
            if (suivi == null) {
                this.envoyerErreur(resp, "Suivi introuvable !");
                return;
            }
            try {
                numero = Integer.valueOf(req.getParameter("equation"));
            }
            catch (NumberFormatException ex) {
                this.envoyerErreur(resp, "le num\u00e9ro d'\u00e9quation n'est pas un entier: " + req.getParameter("equation"));
                return;
            }
            String label_edc = suivi.getLabelEDC();
            EtudeDeCas edc = this.trouverEDC(label_edc);
            if (edc == null) {
                this.envoyerErreur(resp, "Etude de cas '" + label_edc + "' introuvable !");
                return;
            }
            try {
                edc.envoyerEquation(resp, numero, suivi);
                return;
            }
            catch (ExceptionMICA ex) {
                this.erreurInterne("equation", ex);
                this.envoyerErreur(resp, "Erreur interne !");
                return;
            }
        }
        this.envoyerErreur(resp, "requ\u00eate GET non comprise");
    }

    public void inscription(HttpServletResponse resp, String username, String motdepasse, String nom, String prenom, String email) {
        boolean premier = utilisateurs.aucunUtilisateur();
        String type = premier ? "administrateur" : "apprenant";
        try {
            Utilisateur u = utilisateurs.nouvelUtilisateur(username, motdepasse, type, nom, prenom, email, "378614");
            if (premier) {
                utilisateurs.valider(u);
            }
        }
        catch (ExceptionMICA ex) {
            this.erreurInterne("inscription", ex);
            this.envoyerErreur(resp, "Erreur interne \u00e0 l'inscription.");
            return;
        }
        try {
            resp.setHeader("Pragma", "no-cache");
            resp.setHeader("Cache-Control", "no-cache");
            resp.setHeader("Expires", "0");
            resp.setContentType("text/html; charset=ISO-8859-1");
            PrintWriter pw = resp.getWriter();
            ServletMICA.entete(pw, null, "Inscription");
            pw.println("<p>L'inscription a bien \u00e9t\u00e9 enregistr\u00e9e.</p>");
            if (premier) {
                pw.println("<p>Comme vous \u00eates le premier utilisateur, votre inscription a automatiquement \u00e9t\u00e9 valid\u00e9e comme administrateur.</p>");
                pw.println("<p><a href=\"index.html\">Revenir \u00e0 la page de connexion</a></p>");
            } else {
                pw.println("<p>Vous devez maintenant attendre la validation de l'administrateur.</p>");
            }
            ServletMICA.pied(pw);
        }
        catch (IOException ex) {
            this.erreurInterne("inscription", ex);
        }
    }

    public void accueil(HttpServletResponse resp, Utilisateur u) {
        try {
            resp.setHeader("Pragma", "no-cache");
            resp.setHeader("Cache-Control", "no-cache");
            resp.setHeader("Expires", "0");
            resp.setContentType("text/html; charset=ISO-8859-1");
            PrintWriter pw = resp.getWriter();
            ServletMICA.entete(pw, null, "MICA - Accueil");
            if (u.estAdministrateur()) {
                pw.println("<h2>Administration</h2>");
                pw.println("<form action=\"MICA\" method=\"post\">");
                pw.println("<input name=\"administration\" type=\"hidden\" value=\"gestion\">");
                pw.println("<p><input type=\"submit\" value=\"Gestion des utilisateurs\"></p>");
                pw.println("</form>");
                pw.println("<form action=\"MICA\" method=\"post\">");
                pw.println("<input name=\"administration\" type=\"hidden\" value=\"initialisation\">");
                pw.println("<p><input type=\"submit\" value=\"R\u00e9initialiser MICA\"></p>");
                pw.println("</form>");
                pw.println("<hr>");
                pw.println("<h2>Etudes de cas</h2>");
            }
            pw.println("<p>Vos \u00e9tudes de cas en cours:</p>");
            pw.println("<form action=\"MICA\" method=\"post\">");
            pw.println("<p><select name=\"noedc\">");
            int no = 0;
            for (SuiviEDC suivi : u.getSuivis()) {
                EtudeDeCas edc;
                if (suivi.terminee() || (edc = this.trouverEDC(suivi.getLabelEDC())) == null) continue;
                pw.println("<option value=\"" + ++no + "\">" + OutilsXML.encoder(edc.getTitre()) + "</option>");
            }
            pw.println("</select></p>");
            pw.println("<p><input type=\"submit\" name=\"operation\" value=\"Continuer\"></p>");
            pw.println("</form>");
            pw.println("<hr>");
            pw.println("<p>Commencer une nouvelle \u00e9tude de cas:</p>");
            pw.println("<form action=\"MICA\" method=\"post\">");
            pw.println("<p><select name=\"edc\">");
            for (EtudeDeCas edc : etudes_de_cas) {
                pw.println("<option value=\"" + edc.getLabel() + "\">" + OutilsXML.encoder(edc.getTitre()) + "</option>");
            }
            pw.println("</select></p>");
            pw.println("<p><input type=\"submit\" name=\"operation\" value=\"Commencer\"></p>");
            pw.println("</form>");
            ServletMICA.pied(pw);
        }
        catch (IOException ex) {
            this.erreurInterne("accueil", ex);
        }
    }

    public void gestion(HttpServletResponse resp) {
        try {
            ArrayList<Utilisateur> liste_utilisateurs_ferme;
            ArrayList<Utilisateur> liste_utilisateurs_ouvert;
            resp.setHeader("Pragma", "no-cache");
            resp.setHeader("Cache-Control", "no-cache");
            resp.setHeader("Expires", "0");
            resp.setContentType("text/html; charset=ISO-8859-1");
            PrintWriter pw = resp.getWriter();
            ServletMICA.entete(pw, null, "Administration");
            ArrayList<Utilisateur> liste_utilisateurs_a_valider = utilisateurs.selectionUtilisateurs(Boolean.FALSE, Boolean.FALSE);
            if (liste_utilisateurs_a_valider.size() > 0) {
                pw.println("<h2>Inscriptions \u00e0 valider</h2>");
                pw.println("<table cellpadding=\"2\" cellspacing=\"0\" border=\"1\">");
                pw.println("<tr><th>Login</th><th>Type</th><th>Nom</th><th>Pr\u00e9nom</th><th>Email</th><th>Operations</th></tr>");
                for (Utilisateur u : liste_utilisateurs_a_valider) {
                    pw.println("<tr>");
                    pw.println("<td>" + u.getUsername() + "</td>");
                    pw.println("<td>" + u.getType() + "</td>");
                    pw.println("<td>" + u.getNom() + "</td>");
                    pw.println("<td>" + u.getPrenom() + "</td>");
                    pw.println("<td>" + u.getEmail() + "</td>");
                    pw.println("<td>");
                    pw.println("<form action=\"MICA\" method=\"post\">");
                    pw.println("<input name=\"administration\" type=\"hidden\" value=\"valider\">");
                    pw.println("<input name=\"username\" type=\"hidden\" value=\"" + u.getUsername() + "\">");
                    pw.println("<input type=\"submit\" value=\"Valider\">");
                    pw.println("</form>");
                    pw.println("<form action=\"MICA\" method=\"post\">");
                    pw.println("<input name=\"administration\" type=\"hidden\" value=\"fermer\">");
                    pw.println("<input name=\"username\" type=\"hidden\" value=\"" + u.getUsername() + "\">");
                    pw.println("<input type=\"submit\" value=\"Fermer le compte\">");
                    pw.println("</form>");
                    pw.println("</td>");
                    pw.println("</tr>");
                }
                pw.println("</table>");
                pw.println("<br><hr>");
            }
            if ((liste_utilisateurs_ouvert = utilisateurs.selectionUtilisateurs(Boolean.TRUE, Boolean.FALSE)).size() > 0) {
                pw.println("<h2>Utilisateurs avec un compte valide et ouvert</h2>");
                pw.println("<table cellpadding=\"2\" cellspacing=\"0\" border=\"1\">");
                pw.println("<tr><th>Login</th><th>Type</th><th>Nom</th><th>Pr\u00e9nom</th><th>Email</th><th>Operations</th></tr>");
                int nb_admin = 0;
                for (Utilisateur u : liste_utilisateurs_ouvert) {
                    if (!u.estAdministrateur()) continue;
                    ++nb_admin;
                }
                for (Utilisateur u : liste_utilisateurs_ouvert) {
                    pw.println("<tr>");
                    pw.println("<td>" + u.getUsername() + "</td>");
                    pw.println("<td>" + u.getType() + "</td>");
                    pw.println("<td>" + u.getNom() + "</td>");
                    pw.println("<td>" + u.getPrenom() + "</td>");
                    pw.println("<td>" + u.getEmail() + "</td>");
                    pw.println("<td>");
                    if (!u.estAdministrateur() || nb_admin > 1) {
                        pw.println("<form action=\"MICA\" method=\"post\">");
                        pw.println("<input name=\"administration\" type=\"hidden\" value=\"fermer\">");
                        pw.println("<input name=\"username\" type=\"hidden\" value=\"" + u.getUsername() + "\">");
                        pw.println("<input type=\"submit\" value=\"Fermer le compte\">");
                        pw.println("</form>");
                    }
                    pw.println("</td>");
                    pw.println("</tr>");
                }
                pw.println("</table>");
                pw.println("<br><hr>");
            }
            if ((liste_utilisateurs_ferme = utilisateurs.selectionUtilisateurs(null, Boolean.TRUE)).size() > 0) {
                pw.println("<h2>Utilisateurs avec un compte ferm\u00e9</h2>");
                pw.println("<table cellpadding=\"2\" cellspacing=\"0\" border=\"1\">");
                pw.println("<tr><th>Login</th><th>Type</th><th>Nom</th><th>Pr\u00e9nom</th><th>Email</th><th>Valide</th><th>Operations</th></tr>");
                for (Utilisateur u : liste_utilisateurs_ferme) {
                    pw.println("<tr>");
                    pw.println("<td>" + u.getUsername() + "</td>");
                    pw.println("<td>" + u.getType() + "</td>");
                    pw.println("<td>" + u.getNom() + "</td>");
                    pw.println("<td>" + u.getPrenom() + "</td>");
                    pw.println("<td>" + u.getEmail() + "</td>");
                    pw.println("<td>" + (u.valide() ? "oui" : "non") + "</td>");
                    pw.println("<td>");
                    pw.println("<form action=\"MICA\" method=\"post\">");
                    pw.println("<input name=\"administration\" type=\"hidden\" value=\"rouvrir\">");
                    pw.println("<input name=\"username\" type=\"hidden\" value=\"" + u.getUsername() + "\">");
                    pw.println("<input type=\"submit\" value=\"Rouvrir le compte\">");
                    pw.println("</form>");
                    pw.println("<form action=\"MICA\" method=\"post\">");
                    pw.println("<input name=\"administration\" type=\"hidden\" value=\"supprimer\">");
                    pw.println("<input name=\"username\" type=\"hidden\" value=\"" + u.getUsername() + "\">");
                    pw.println("<input type=\"submit\" value=\"Supprimer\">");
                    pw.println("</form>");
                    pw.println("</td>");
                    pw.println("</tr>");
                }
                pw.println("</table>");
            }
            pw.println("<p><a href=\"MICA?page=accueil\">Revenir \u00e0 l'accueil</a></p>");
            ServletMICA.pied(pw);
        }
        catch (IOException ex) {
            this.erreurInterne("gestion", ex);
        }
    }

    public EtudeDeCas trouverEDC(String label) {
        if (label == null) {
            return null;
        }
        for (EtudeDeCas edc : etudes_de_cas) {
            if (!label.equals(edc.getLabel())) continue;
            return edc;
        }
        return null;
    }

    public static void entete(PrintWriter pw, String titre_site, String titre_page) {
        pw.println("<!DOCTYPE html PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">");
        pw.println("<html>");
        pw.println("<head>");
        pw.println("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=iso-8859-1\">");
        pw.println("<title>" + titre_page + "</title>");
        pw.println("<link href=\"MICA/interface/style.css\" rel=\"stylesheet\" type=\"text/css\">");
        pw.println("</head>");
        pw.println("<body class=\"page\">");
        pw.println("<div class=\"zone_logo\">");
        pw.println("<img src=\"MICA/interface/logo.png\" alt=\"logo\">");
        pw.println("</div>");
        if (titre_site != null) {
            pw.println("<div class=\"titre_site_1\">" + titre_site + "</div>");
            pw.println("<div class=\"titre_site_2\">" + titre_site + "</div>");
        }
        pw.println("<div class=\"zone_titre\">");
        pw.println("<table cellpadding=\"0\" cellspacing=\"0\"><tr><td>");
        pw.println("<h1>" + titre_page + "</h1>");
        pw.println("</td></tr></table>");
        pw.println("</div>");
        pw.println("<div class=\"zone_contenu\">");
        pw.println("<div class=\"zone_texte\">");
    }

    public static void pied(PrintWriter pw) {
        pw.println("</div>");
        pw.println("</div>");
        pw.println("</body>");
        pw.println("</html>");
        pw.flush();
    }

    protected void envoyerErreur(HttpServletResponse resp, String errmsg) {
        try {
            resp.setHeader("Pragma", "no-cache");
            resp.setHeader("Cache-Control", "no-cache");
            resp.setHeader("Expires", "0");
            resp.setContentType("text/html; charset=ISO-8859-1");
            PrintWriter pw = resp.getWriter();
            ServletMICA.entete(pw, null, "Erreur");
            pw.println("<p>Une erreur s'est produite lors du traitement de votre requ\u00eate: " + OutilsXML.encoder(errmsg) + "</p>");
            pw.println("<p>Utiliser le bouton retour du navigateur pour revenir en arri\u00e8re.</p>");
            ServletMICA.pied(pw);
        }
        catch (IOException ex) {
            this.erreurInterne("envoyerErreur", ex);
        }
    }

    protected void envoyerFichier(OutputStream outs, File inputFile) {
        try {
            BufferedInputStream bin = new BufferedInputStream(new FileInputStream(inputFile));
            BufferedOutputStream bout = new BufferedOutputStream(outs);
            int length = 32;
            byte[] ch = new byte[length];
            while ((length = bin.read(ch)) != -1) {
                bout.write(ch, 0, length);
            }
            bin.close();
            bout.flush();
        }
        catch (IOException ex) {
            this.erreurInterne("envoyerFichier '" + inputFile.getName() + "'", ex);
        }
    }
}

