/*
 * Decompiled with CFR 0.152.
 */
package serveurmica;

import java.io.PrintWriter;
import java.util.ArrayList;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import serveurmica.OutilsXML;
import serveurmica.SuiviEDC;

public class Plan {
    private ArrayList<ElementDuPlan> elements = new ArrayList();

    public Plan(Element el) {
        ArrayList<Element> enfants = OutilsXML.enfants(el);
        for (Element enfant : enfants) {
            if ("DOSSIER".equals(enfant.getLocalName())) {
                this.elements.add(new DossierDuPlan(enfant));
                continue;
            }
            if (!"REF_ETAPE".equals(enfant.getLocalName())) continue;
            this.elements.add(new EtapeDuPlan(enfant));
        }
    }

    public String labelPremiereEtape() {
        if (this.elements.size() < 1) {
            return null;
        }
        ElementDuPlan premierElement = this.elements.get(0);
        if (premierElement instanceof EtapeDuPlan) {
            return ((EtapeDuPlan)premierElement).getLabel();
        }
        return ((DossierDuPlan)premierElement).labelPremiereEtape();
    }

    public void setTitreEtape(String label, String titre) {
        for (ElementDuPlan elplan : this.elements) {
            elplan.setTitreEtape(label, titre);
        }
    }

    public Element elementInter(Document doc_inter, SuiviEDC suivi) {
        Element plan_edc = doc_inter.createElementNS(null, "PLAN_EDC");
        for (ElementDuPlan elplan : this.elements) {
            plan_edc.appendChild(elplan.elementInter(doc_inter, suivi));
        }
        return plan_edc;
    }

    public void afficherSommaire(PrintWriter pw, SuiviEDC suivi) {
        pw.println("<ul>");
        for (ElementDuPlan elplan : this.elements) {
            elplan.afficherSommaire(pw, suivi);
        }
        pw.println("</ul>");
    }

    class EtapeDuPlan
    implements ElementDuPlan {
        private String label;
        private String titre;

        EtapeDuPlan(Element el) {
            this.label = el.getAttribute("label");
            this.titre = null;
        }

        public String getTitre() {
            return this.titre;
        }

        String getLabel() {
            return this.label;
        }

        public void setTitreEtape(String label, String titre) {
            if (label != null && label.equals(this.label)) {
                this.titre = titre;
            }
        }

        public Element elementInter(Document doc_inter, SuiviEDC suivi) {
            Element el_etape = doc_inter.createElementNS(null, "ETAPE");
            el_etape.setAttributeNS(null, "label", this.label);
            el_etape.setAttributeNS(null, "titre", this.titre);
            el_etape.setAttributeNS(null, "active", this.label.equals(suivi.getLabelEtape()) ? "oui" : "non");
            el_etape.setAttributeNS(null, "lien", suivi.etapeAutorisee(this.label) ? "oui" : "non");
            return el_etape;
        }

        public void afficherSommaire(PrintWriter pw, SuiviEDC suivi) {
            if (suivi.etapeAutorisee(this.label)) {
                pw.println("<li><a href=\"MICA?label_etape=" + this.label + "\">" + OutilsXML.encoder(this.titre) + "</a></li>");
            } else {
                pw.println("<li>" + OutilsXML.encoder(this.titre) + "</li>");
            }
        }
    }

    class DossierDuPlan
    implements ElementDuPlan {
        private String titre;
        private ArrayList<ElementDuPlan> elements = new ArrayList();

        DossierDuPlan(Element el) {
            this.titre = el.getAttribute("titre");
            ArrayList<Element> enfants = OutilsXML.enfants(el);
            for (Element enfant : enfants) {
                if ("DOSSIER".equals(enfant.getLocalName())) {
                    this.elements.add(new DossierDuPlan(enfant));
                    continue;
                }
                if (!"REF_ETAPE".equals(enfant.getLocalName())) continue;
                this.elements.add(new EtapeDuPlan(enfant));
            }
        }

        public String getTitre() {
            return this.titre;
        }

        String labelPremiereEtape() {
            if (this.elements.size() < 1) {
                return null;
            }
            ElementDuPlan premierElement = this.elements.get(0);
            if (premierElement instanceof EtapeDuPlan) {
                return ((EtapeDuPlan)premierElement).getLabel();
            }
            return ((DossierDuPlan)premierElement).labelPremiereEtape();
        }

        public void setTitreEtape(String label, String titre) {
            for (ElementDuPlan elplan : this.elements) {
                elplan.setTitreEtape(label, titre);
            }
        }

        public Element elementInter(Document doc_inter, SuiviEDC suivi) {
            Element el_dossier = doc_inter.createElementNS(null, "DOSSIER");
            el_dossier.setAttributeNS(null, "titre", this.titre);
            for (ElementDuPlan elplan : this.elements) {
                el_dossier.appendChild(elplan.elementInter(doc_inter, suivi));
            }
            return el_dossier;
        }

        public void afficherSommaire(PrintWriter pw, SuiviEDC suivi) {
            pw.println("<ul>");
            for (ElementDuPlan elplan : this.elements) {
                elplan.afficherSommaire(pw, suivi);
            }
            pw.println("</ul>");
        }
    }

    static interface ElementDuPlan {
        public String getTitre();

        public void setTitreEtape(String var1, String var2);

        public Element elementInter(Document var1, SuiviEDC var2);

        public void afficherSommaire(PrintWriter var1, SuiviEDC var2);
    }
}

