/*
 * Decompiled with CFR 0.152.
 */
package serveurmica;

import serveurmica.EtudeDeCas;
import serveurmica.SuiviEDC;

public class Formule {
    private Parametre param;
    private EtudeDeCas edc;
    private SuiviEDC suivi;

    public Formule(String formule, EtudeDeCas edc, SuiviEDC suivi) {
        this.edc = edc;
        this.suivi = suivi;
        this.param = this.parser(this.ajParentheses(formule));
    }

    public double evaluer() {
        Double d = this.param.evaluer();
        if (d == null) {
            return 0.0;
        }
        return d;
    }

    private double getValeurVariable(String nom) {
        return this.edc.getValeurVariable(nom, this.suivi);
    }

    private String ajParentheses(String s) {
        String sops = "^/*-+=<>";
        for (int iops = 0; iops < sops.length(); ++iops) {
            char cops = sops.charAt(iops);
            int indop = s.indexOf(cops);
            if (indop > 0 && "^*/-+=<>Ee".indexOf(s.charAt(indop - 1)) != -1) {
                indop = -1;
            }
            int nindop = indop;
            int cm = 32;
            int cp = 32;
            while (nindop != -1) {
                int ip;
                boolean ajp = false;
                int im = indop - 1;
                if (im >= 0) {
                    cm = s.charAt(im);
                }
                int pp = 0;
                while (im >= 0 && (pp != 0 || cm != 40) && (pp != 0 || sops.indexOf(cm) == -1 || im > 0 && "^*/-+=<>Ee".indexOf(s.charAt(im - 1)) != -1)) {
                    if (cm == 41) {
                        ++pp;
                    } else if (cm == 40) {
                        --pp;
                    }
                    if (--im < 0) continue;
                    cm = s.charAt(im);
                }
                if (im < 0 || sops.indexOf(cm) != -1) {
                    ajp = true;
                }
                if ((ip = indop + 1) >= 0) {
                    cp = s.charAt(ip);
                }
                pp = 0;
                while (ip < s.length() && (pp != 0 || cp != 41) && (pp != 0 || sops.indexOf(cp) == -1 || ip > 0 && "^*/-+=<>Ee".indexOf(s.charAt(ip - 1)) != -1)) {
                    if (cp == 40) {
                        ++pp;
                    } else if (cp == 41) {
                        --pp;
                    }
                    if (++ip >= s.length()) continue;
                    cp = s.charAt(ip);
                }
                if (ip >= s.length() || sops.indexOf(cp) != -1) {
                    ajp = true;
                }
                if (ajp) {
                    s = s.substring(0, im + 1) + "(" + s.substring(im + 1, ip) + ")" + s.substring(ip);
                    ++indop;
                }
                nindop = s.substring(indop + 1).indexOf(cops);
                indop = nindop + indop + 1;
            }
        }
        return s;
    }

    private Parametre parser(String s) {
        int i;
        int pp;
        String sops = "^/*-+=<>";
        if (s.charAt(0) == '(' && s.charAt(s.length() - 1) == ')') {
            boolean retparok = true;
            pp = 0;
            for (i = 1; i < s.length() - 1; ++i) {
                if (s.charAt(i) == '(') {
                    ++pp;
                } else if (s.charAt(i) == ')') {
                    --pp;
                }
                if (pp >= 0) continue;
                retparok = false;
                break;
            }
            if (retparok) {
                s = s.substring(1, s.length() - 1);
            }
        }
        int indop = -1;
        pp = 0;
        for (i = 0; i < s.length(); ++i) {
            if (pp == 0 && sops.indexOf(s.charAt(i)) != -1 && (i < 2 || "Ee".indexOf(s.charAt(i - 1)) == -1 || "0123456789".indexOf(s.charAt(i - 2)) == -1)) {
                indop = i;
                break;
            }
            if (s.charAt(i) == '(') {
                ++pp;
                continue;
            }
            if (s.charAt(i) != ')') continue;
            --pp;
        }
        if (indop == -1) {
            boolean nb = true;
            for (int i2 = 0; i2 < s.length(); ++i2) {
                if ("0123456789.,-+ ".indexOf(s.charAt(i2)) != -1 || (s.charAt(i2) == 'E' || s.charAt(i2) == 'e') && i2 != 0 && "0123456789".indexOf(s.charAt(i2 - 1)) != -1) continue;
                nb = false;
                break;
            }
            if (nb) {
                double d;
                try {
                    d = new Double(s);
                }
                catch (NumberFormatException ex) {
                    d = 0.0;
                }
                return new Nombre(d);
            }
            int indf = s.indexOf(40);
            if (indf != -1 && s.charAt(s.length() - 1) == ')') {
                Fonction fct = new Fonction(s.substring(0, indf));
                int indv = 0;
                Parametre p1 = null;
                Parametre p2 = null;
                indv = (s = s.substring(indf + 1, s.length() - 1)).indexOf(44);
                if (indv != -1) {
                    p1 = this.parser(s.substring(0, indv).trim());
                    s = s.substring(indv + 1);
                    p2 = this.parser(s.trim());
                } else {
                    p1 = this.parser(s.trim());
                }
                return new Expression(fct, p1, p2);
            }
            return new Variable(s);
        }
        Fonction op = new Fonction(s.charAt(indop));
        String s1 = s.substring(0, indop).trim();
        if ("".equals(s1)) {
            s1 = "0";
        }
        Parametre p1 = this.parser(s1);
        String s2 = s.substring(indop + 1).trim();
        Parametre p2 = this.parser(s2);
        return new Expression(op, p1, p2);
    }

    class Fonction {
        int type;
        static final int addition = 1;
        static final int soustraction = 2;
        static final int multiplication = 3;
        static final int division = 4;
        static final int puissance = 5;
        static final int logdecimal = 6;
        static final int ln = 7;
        static final int exp = 8;
        static final int sin = 9;
        static final int cos = 10;
        static final int tan = 11;
        static final int asin = 12;
        static final int acos = 13;
        static final int atan = 14;
        static final int abs = 15;
        static final int sqrt = 16;
        static final int partie_entiere = 17;
        static final int partie_frac = 18;
        static final int egalite = 19;
        static final int inferieur = 20;
        static final int superieur = 21;

        public Fonction(char c) {
            switch (c) {
                case '+': {
                    this.type = 1;
                    break;
                }
                case '-': {
                    this.type = 2;
                    break;
                }
                case '*': {
                    this.type = 3;
                    break;
                }
                case '/': {
                    this.type = 4;
                    break;
                }
                case '^': {
                    this.type = 5;
                    break;
                }
                case '=': {
                    this.type = 19;
                    break;
                }
                case '<': {
                    this.type = 20;
                    break;
                }
                case '>': {
                    this.type = 21;
                    break;
                }
                default: {
                    this.type = 0;
                }
            }
        }

        public Fonction(String nom) {
            this.type = "log".equals(nom) ? 6 : ("ln".equals(nom) ? 7 : ("exp".equals(nom) ? 8 : ("sin".equals(nom) ? 9 : ("cos".equals(nom) ? 10 : ("tan".equals(nom) ? 11 : ("asin".equals(nom) ? 12 : ("acos".equals(nom) ? 13 : ("atan".equals(nom) ? 14 : ("abs".equals(nom) ? 15 : ("sqrt".equals(nom) ? 16 : ("pent".equals(nom) || "floor".equals(nom) ? 17 : ("pfrac".equals(nom) || "fpart".equals(nom) ? 18 : 0))))))))))));
        }

        public Double evaluer(double v1, double v2) {
            double d;
            switch (this.type) {
                case 1: {
                    d = v1 + v2;
                    break;
                }
                case 2: {
                    d = v1 - v2;
                    break;
                }
                case 3: {
                    d = v1 * v2;
                    break;
                }
                case 4: {
                    d = v1 / v2;
                    break;
                }
                case 5: {
                    d = Math.pow(v1, v2);
                    break;
                }
                case 6: {
                    d = Math.log(v1) / Math.log(10.0);
                    break;
                }
                case 7: {
                    d = Math.log(v1);
                    break;
                }
                case 8: {
                    d = Math.exp(v1);
                    break;
                }
                case 9: {
                    d = Math.sin(v1);
                    break;
                }
                case 10: {
                    d = Math.cos(v1);
                    break;
                }
                case 11: {
                    d = Math.tan(v1);
                    break;
                }
                case 12: {
                    d = Math.asin(v1);
                    break;
                }
                case 13: {
                    d = Math.acos(v1);
                    break;
                }
                case 14: {
                    d = Math.atan(v1);
                    break;
                }
                case 15: {
                    d = Math.abs(v1);
                    break;
                }
                case 16: {
                    d = Math.sqrt(v1);
                    break;
                }
                case 17: {
                    d = Math.floor(v1);
                    break;
                }
                case 18: {
                    d = v1 - Math.floor(v1);
                    break;
                }
                case 19: {
                    d = v1 == v2 ? 1 : 0;
                    break;
                }
                case 20: {
                    d = v1 < v2 ? 1 : 0;
                    break;
                }
                case 21: {
                    d = v1 > v2 ? 1 : 0;
                    break;
                }
                default: {
                    return null;
                }
            }
            return new Double(d);
        }
    }

    static class Nombre
    implements Parametre {
        double valeur;

        public Nombre(double valeur) {
            this.valeur = valeur;
        }

        public Double evaluer() {
            return new Double(this.valeur);
        }
    }

    class Variable
    implements Parametre {
        String nom;

        public Variable(String nom) {
            this.nom = nom;
        }

        public Double evaluer() {
            if (this.nom == null) {
                return null;
            }
            if ("e".equals(this.nom)) {
                return new Double(Math.E);
            }
            if ("pi".equals(this.nom)) {
                return new Double(Math.PI);
            }
            return new Double(Formule.this.getValeurVariable(this.nom));
        }
    }

    static interface Parametre {
        public Double evaluer();
    }

    class Expression
    implements Parametre {
        Fonction fct;
        Parametre p1;
        Parametre p2;

        public Expression(Fonction fct, Parametre p1, Parametre p2) {
            this.fct = fct;
            this.p1 = p1;
            this.p2 = p2;
        }

        public Double evaluer() {
            if (this.p2 == null) {
                Double d1 = this.p1.evaluer();
                if (d1 == null) {
                    return null;
                }
                return this.fct.evaluer(d1, 0.0);
            }
            Double d1 = this.p1.evaluer();
            Double d2 = this.p2.evaluer();
            if (d1 == null || d2 == null) {
                return null;
            }
            return this.fct.evaluer(d1, d2);
        }
    }
}

