/*
 * Decompiled with CFR 0.152.
 */
package serveurmica;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import serveurmica.Bibliographie;
import serveurmica.DecodeurBase64;
import serveurmica.Dimensions;
import serveurmica.ExceptionMICA;
import serveurmica.Formule;
import serveurmica.OutilsXML;
import serveurmica.Plan;
import serveurmica.ServletMICA;
import serveurmica.SuiviEDC;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EtudeDeCas {
    private File fichier_xml;
    private File fichier_xsl;
    private String label;
    private String titre;
    private File dossier_edc;
    private String description;
    private String nom_variable_progression;
    private HashMap<String, String> formules_variables;
    private ArrayList<File> contributions_xml;
    private Hashtable<String, File> contribs_etapes;
    private Hashtable<String, File> contribs_sections;
    private Hashtable<String, String> titres_etapes;
    private Hashtable<String, String> etape_section;
    private Hashtable<String, ArrayList<String>> labels_sections;
    private ArrayList<String> etapes_bloquantes;
    private Hashtable<String, String> glossaire;
    private Plan plan;
    private Bibliographie bibliographie;
    private Document bibliotheque;

    public EtudeDeCas(File fichier_xml, File fichier_xsl) throws ExceptionMICA {
        Element el_plan;
        this.fichier_xml = fichier_xml;
        this.fichier_xsl = fichier_xsl;
        this.label = fichier_xml.getName();
        if (this.label.indexOf(46) != -1) {
            this.label = this.label.substring(0, this.label.lastIndexOf(46));
        }
        this.dossier_edc = fichier_xml.getParentFile().getParentFile();
        Document doc = OutilsXML.lectureDocumentXML(fichier_xml);
        Element racine = doc.getDocumentElement();
        if (!"MICA".equals(racine.getLocalName())) {
            throw new ExceptionMICA("Mauvais \u00e9l\u00e9ment racine pour " + this.label, true);
        }
        Element edc = OutilsXML.premierEnfant(racine, "ETUDE_DE_CAS");
        if (edc == null) {
            throw new ExceptionMICA("Aucun \u00e9l\u00e9ment ETUDE_DE_CAS pour " + this.label);
        }
        this.titre = edc.getAttribute("titre");
        Element metadonnees = OutilsXML.premierEnfant(edc, "METADONNEES");
        if (metadonnees == null) {
            throw new ExceptionMICA("Aucun \u00e9l\u00e9ment METADONNEES pour " + this.label, true);
        }
        Element el_desc = OutilsXML.premierEnfant(metadonnees, "DESCRIPTION");
        this.description = el_desc == null ? null : OutilsXML.valeurElement(el_desc);
        Element variables = OutilsXML.premierEnfant(edc, "VARIABLES");
        if (variables != null) {
            Element ref_progression = OutilsXML.premierEnfant(variables, "REF_PROGRESSION");
            this.nom_variable_progression = ref_progression != null ? ref_progression.getAttribute("nom") : null;
            ArrayList<Element> elements_variables = OutilsXML.enfants(variables, "VARIABLE");
            this.formules_variables = new HashMap();
            for (Element v : elements_variables) {
                this.formules_variables.put(v.getAttribute("nom"), v.getAttribute("formule"));
            }
        } else {
            this.nom_variable_progression = null;
            this.formules_variables = null;
        }
        this.plan = (el_plan = OutilsXML.premierEnfant(edc, "PLAN")) != null ? new Plan(el_plan) : null;
        this.contributions_xml = new ArrayList();
        Element contributions = OutilsXML.premierEnfant(edc, "CONTRIBUTIONS");
        if (contributions == null) {
            throw new ExceptionMICA("Aucun \u00e9l\u00e9ment CONTRIBUTIONS pour " + this.label, true);
        }
        ArrayList<Element> elements_contributions = OutilsXML.enfants(contributions, "REF_CONTRIBUTION");
        for (Element c : elements_contributions) {
            String label_contribution = c.getAttribute("label");
            File dossier_contrib = new File(this.dossier_edc, label_contribution);
            File fichier_contrib = new File(dossier_contrib, label_contribution + ".xml");
            if (!fichier_contrib.exists()) {
                throw new ExceptionMICA("EtudeDeCas " + this.label + ": la contribution " + label_contribution + " n'existe pas", true);
            }
            this.contributions_xml.add(fichier_contrib);
        }
        this.contribs_etapes = new Hashtable();
        this.contribs_sections = new Hashtable();
        this.titres_etapes = new Hashtable();
        this.etape_section = new Hashtable();
        this.labels_sections = new Hashtable();
        this.etapes_bloquantes = new ArrayList();
        this.glossaire = new Hashtable();
        this.bibliographie = new Bibliographie();
        this.bibliotheque = null;
        for (File fichier_contrib : this.contributions_xml) {
            Document doc_contrib = OutilsXML.lectureDocumentXML(fichier_contrib);
            Element racine_contrib = doc_contrib.getDocumentElement();
            if (!"MICA".equals(racine_contrib.getLocalName())) continue;
            ArrayList<Element> etapes = OutilsXML.enfants(racine_contrib, "ETAPE");
            for (Element etape : etapes) {
                String label_etape = etape.getAttribute("label");
                if (this.plan != null) {
                    this.plan.setTitreEtape(label_etape, etape.getAttribute("titre"));
                }
                this.titres_etapes.put(label_etape, etape.getAttribute("titre"));
                this.contribs_etapes.put(label_etape, fichier_contrib);
                if ("oui".equals(etape.getAttribute("bloquante"))) {
                    this.etapes_bloquantes.add(label_etape);
                }
                ArrayList<Element> sections = OutilsXML.enfants(etape, "SECTION");
                for (Element section : sections) {
                    this.ajouterSection(section, fichier_contrib, label_etape);
                }
                this.ajouterBibliotheque(etape, fichier_contrib);
                this.ajouterBibliographie(etape);
                this.ajouterGlossaire(etape);
            }
        }
    }

    private void ajouterSection(Element section, File fichier_contrib, String label_etape) {
        String label_section = section.getAttribute("label");
        this.contribs_sections.put(label_section, fichier_contrib);
        this.etape_section.put(label_section, label_etape);
        ArrayList<String> sections_etape = this.labels_sections.get(label_etape);
        if (sections_etape == null) {
            sections_etape = new ArrayList();
            this.labels_sections.put(label_etape, sections_etape);
        }
        sections_etape.add(label_section);
        ArrayList<Element> sous_sections = OutilsXML.enfants(section, "SECTION");
        for (Element sous_section : sous_sections) {
            this.ajouterSection(sous_section, fichier_contrib, label_etape);
        }
        this.ajouterBibliographie(section);
        this.ajouterGlossaire(section);
    }

    private void ajouterBibliotheque(Element parent, File fichier_contrib) throws ExceptionMICA {
        Element bibliotheque_locale = OutilsXML.premierEnfant(parent, "BIBLIOTHEQUE");
        if (bibliotheque_locale == null) {
            return;
        }
        if (this.bibliotheque == null) {
            this.bibliotheque = OutilsXML.nouveauDocumentDOM();
            Element racine = this.bibliotheque.createElementNS(null, "BIBLIOTHEQUE");
            racine.setAttributeNS(null, "titre_edc", this.titre);
            this.bibliotheque.appendChild(racine);
        }
        Element racine_bibliotheque = this.bibliotheque.getDocumentElement();
        ArrayList<Element> elts_bibliotheque_locale = OutilsXML.enfants(bibliotheque_locale, "ELEMENT_BIBLIOTHEQUE");
        for (Element elt : elts_bibliotheque_locale) {
            Element elt_importe = (Element)this.bibliotheque.importNode(elt, true);
            Element zone_image = OutilsXML.premierEnfant(elt_importe, "ZONE_IMAGE");
            if (zone_image != null && !"texte".equals(zone_image.getAttribute("localisation"))) {
                zone_image.setAttributeNS(null, "localisation", "texte");
            }
            this.ajouterDimensionsImages(elt_importe, fichier_contrib);
            racine_bibliotheque.appendChild(elt_importe);
        }
    }

    private void ajouterBibliographie(Element parent) {
        Element el_bibliographie = OutilsXML.premierEnfant(parent, "BIBLIOGRAPHIE");
        if (el_bibliographie != null) {
            ArrayList<Element> references = OutilsXML.enfants(el_bibliographie, "REFERENCE_BIBLIOGRAPHIQUE");
            for (Element el_ref : references) {
                this.bibliographie.ajouterReference(el_ref);
            }
        }
    }

    private void ajouterGlossaire(Element parent) {
        Element el_glossaire = OutilsXML.premierEnfant(parent, "GLOSSAIRE");
        if (el_glossaire != null) {
            ArrayList<Element> definitions = OutilsXML.enfants(el_glossaire, "DEFINITION_GLOSSAIRE");
            for (Element el_def : definitions) {
                String mot = el_def.getAttribute("mot");
                String definition = OutilsXML.valeurElement(el_def);
                if ("".equals(mot) || definition == null || "".equals(definition)) continue;
                this.glossaire.put(mot, definition);
            }
        }
    }

    private void ajouterReponsesPassees(Element parent, SuiviEDC suivi) {
        ArrayList<Element> exercices = OutilsXML.enfants(parent, "EXERCICE");
        for (Element exercice : exercices) {
            boolean reconsultable;
            boolean bl = reconsultable = !"non".equals(exercice.getAttribute("reconsultable"));
            if (reconsultable) {
                return;
            }
            ArrayList<Element> enfants = OutilsXML.enfants(exercice);
            for (Element enfant : enfants) {
                Element question;
                String nom_variable;
                if (!"QUESTION_LIBRE".equals(enfant.getLocalName()) && !"QUESTION_QUESTIONNAIRE".equals(enfant.getLocalName()) || !suivi.variableDefinie(nom_variable = (question = enfant).getAttribute("nom_variable"))) continue;
                String valeur_variable = "" + suivi.getValeurVariable(nom_variable);
                if ("QUESTION_LIBRE".equals(question.getLocalName())) {
                    question.setAttributeNS(null, "valeur", valeur_variable);
                    continue;
                }
                if (!"QUESTION_QUESTIONNAIRE".equals(question.getLocalName())) continue;
                question.setAttributeNS(null, "points", valeur_variable);
            }
        }
        ArrayList<Element> blocs = OutilsXML.enfants(parent, "BLOC");
        for (Element bloc : blocs) {
            this.ajouterReponsesPassees(bloc, suivi);
        }
    }

    public String getLabel() {
        return this.label;
    }

    public String getTitre() {
        return this.titre;
    }

    public String labelPremiereEtape() {
        if (this.plan == null) {
            return null;
        }
        return this.plan.labelPremiereEtape();
    }

    public String labelPremiereSection(String label_etape) {
        ArrayList<String> sections_etape = this.labels_sections.get(label_etape);
        if (sections_etape == null || sections_etape.isEmpty()) {
            return null;
        }
        return sections_etape.get(0);
    }

    public String labelSectionSuivante(String label_etape, String label_section) {
        if (label_etape == null || label_section == null) {
            return null;
        }
        ArrayList<String> sections_etape = this.labels_sections.get(label_etape);
        if (sections_etape == null || sections_etape.isEmpty()) {
            return null;
        }
        boolean suivante = false;
        for (String label : sections_etape) {
            if (suivante) {
                return label;
            }
            if (!label_section.equals(label)) continue;
            suivante = true;
        }
        return null;
    }

    public String labelSectionPrecedente(String label_etape, String label_section) {
        if (label_etape == null || label_section == null) {
            return null;
        }
        ArrayList<String> sections_etape = this.labels_sections.get(label_etape);
        if (sections_etape == null || sections_etape.isEmpty()) {
            return null;
        }
        String label_precedent = null;
        for (String label : sections_etape) {
            if (label_section.equals(label)) {
                return label_precedent;
            }
            label_precedent = label;
        }
        return null;
    }

    public File getFichierContrib(SuiviEDC suivi) {
        String label_etape = suivi.getLabelEtape();
        String label_section = suivi.getLabelSection();
        if (label_section != null && this.contribs_sections.get(label_section) != null) {
            return this.contribs_sections.get(label_section);
        }
        return this.contribs_etapes.get(label_etape);
    }

    public boolean etapeBloquante(String label_etape) {
        return this.etapes_bloquantes.contains(label_etape);
    }

    public String labelEtapeSection(String label_section) {
        return this.etape_section.get(label_section);
    }

    private Element lireEtape(String label) throws ExceptionMICA {
        if (label == null) {
            throw new ExceptionMICA("lireEtape: label null");
        }
        File fichier_contrib = this.contribs_etapes.get(label);
        if (fichier_contrib == null) {
            throw new ExceptionMICA("Impossible de trouver l'\u00e9tape " + label, true);
        }
        Document doc_contrib = OutilsXML.lectureDocumentXML(fichier_contrib);
        Element racine = doc_contrib.getDocumentElement();
        ArrayList<Element> etapes = OutilsXML.enfants(racine, "ETAPE");
        for (Element etape : etapes) {
            if (!label.equals(etape.getAttribute("label"))) continue;
            return etape;
        }
        return null;
    }

    private Element lireSection(String label) throws ExceptionMICA {
        if (label == null) {
            throw new ExceptionMICA("lireSection: label null");
        }
        File fichier_contrib = this.contribs_sections.get(label);
        if (fichier_contrib == null) {
            throw new ExceptionMICA("Impossible de trouver la section " + label, true);
        }
        Document doc_contrib = OutilsXML.lectureDocumentXML(fichier_contrib);
        Element racine = doc_contrib.getDocumentElement();
        ArrayList<Element> etapes = OutilsXML.enfants(racine, "ETAPE");
        for (Element etape : etapes) {
            Element section = this.lireSection(etape, label);
            if (section == null) continue;
            return section;
        }
        return null;
    }

    private Element lireSection(Element parent, String label) throws ExceptionMICA {
        ArrayList<Element> sections = OutilsXML.enfants(parent, "SECTION");
        for (Element section : sections) {
            if (label.equals(section.getAttribute("label"))) {
                return section;
            }
            Element ssection = this.lireSection(section, label);
            if (ssection == null) continue;
            return ssection;
        }
        return null;
    }

    public void afficherPage(HttpServletResponse resp, SuiviEDC suivi) throws ExceptionMICA {
        ServletOutputStream out;
        if (suivi.getLabelEtape() == null) {
            throw new ExceptionMICA("afficherPage: aucune \u00e9tape courante ?!?");
        }
        Element etape = this.lireEtape(suivi.getLabelEtape());
        Element section = suivi.getLabelSection() == null ? null : this.lireSection(suivi.getLabelSection());
        Document doc_inter = this.creationDocumentIntermediaire(suivi, etape, section);
        resp.setContentType("text/html; charset=ISO-8859-1");
        try {
            out = resp.getOutputStream();
        }
        catch (IOException ex) {
            throw new ExceptionMICA("afficherPage: HttpServletResponse.getOutputStream", ex);
        }
        OutilsXML.transformationXSLT((OutputStream)out, doc_inter, this.fichier_xsl);
    }

    private Document creationDocumentIntermediaire(SuiviEDC suivi, Element etape, Element section) throws ExceptionMICA {
        Document doc_inter = OutilsXML.nouveauDocumentDOM();
        Element page = doc_inter.createElementNS(null, "PAGE_MICA");
        page.setAttributeNS(null, "titre_edc", this.titre);
        page.setAttributeNS(null, "label_etape", suivi.getLabelEtape());
        page.setAttributeNS(null, "titre_etape", etape.getAttribute("titre"));
        if (section != null) {
            page.setAttributeNS(null, "label_section", suivi.getLabelSection());
            page.setAttributeNS(null, "titre_section", section.getAttribute("titre"));
        }
        page.setAttributeNS(null, "bibliotheque", this.bibliotheque == null ? "non" : "oui");
        page.setAttributeNS(null, "bibliographie", this.bibliographie.vide() ? "non" : "oui");
        page.setAttributeNS(null, "glossaire", this.glossaire.isEmpty() ? "non" : "oui");
        if (this.nom_variable_progression != null) {
            long valeur_progression = Math.round(this.getValeurVariable(this.nom_variable_progression, suivi));
            page.setAttributeNS(null, "progression", "" + valeur_progression);
        }
        if (this.plan != null) {
            Element plan_edc = this.plan.elementInter(doc_inter, suivi);
            page.appendChild(plan_edc);
        }
        if (section != null) {
            Element plan_etape = doc_inter.createElementNS(null, "PLAN_ETAPE");
            this.ajouterSectionsAuPlanEtape(plan_etape, etape, suivi.getLabelSection());
            page.appendChild(plan_etape);
            Element liens_section = doc_inter.createElementNS(null, "LIENS_SECTION");
            boolean page_suivante = this.labelSectionSuivante(suivi.getLabelEtape(), suivi.getLabelSection()) != null;
            liens_section.setAttributeNS(null, "page_suivante", page_suivante ? "oui" : "non");
            boolean page_precedente = this.labelSectionPrecedente(suivi.getLabelEtape(), suivi.getLabelSection()) != null;
            liens_section.setAttributeNS(null, "page_precedente", page_precedente ? "oui" : "non");
            page.appendChild(liens_section);
        }
        Element contenu = doc_inter.createElementNS(null, "CONTENU");
        if (section != null) {
            this.remplacerVariables(contenu, section, suivi);
        } else {
            this.remplacerVariables(contenu, etape, suivi);
        }
        this.ajouterDimensionsImages(contenu, this.getFichierContrib(suivi));
        this.ajouterReponsesPassees(contenu, suivi);
        page.appendChild(contenu);
        ArrayList<Element> enchainements_etape = OutilsXML.enfants(etape, "ENCHAINEMENT");
        if (enchainements_etape.size() > 0) {
            ArrayList<Element> enchainements_possibles = new ArrayList<Element>();
            for (Element enchainement_etape : enchainements_etape) {
                String condition = enchainement_etape.getAttribute("condition");
                if (!"".equals(condition) && !this.testCondition(condition, suivi)) continue;
                Element enchainement_possible = doc_inter.createElementNS(null, "ENCHAINEMENT");
                String label_etape = enchainement_etape.getAttribute("etape");
                enchainement_possible.setAttributeNS(null, "label_etape", label_etape);
                if (!"".equals(enchainement_etape.getAttribute("titre"))) {
                    enchainement_possible.setAttributeNS(null, "titre", enchainement_etape.getAttribute("titre"));
                } else {
                    enchainement_possible.setAttributeNS(null, "titre", this.titres_etapes.get(label_etape));
                }
                enchainements_possibles.add(enchainement_possible);
            }
            if (enchainements_possibles.size() > 0) {
                Element enchainements = doc_inter.createElementNS(null, "ENCHAINEMENTS");
                for (Element enchainement_possible : enchainements_possibles) {
                    enchainements.appendChild(enchainement_possible);
                }
                page.appendChild(enchainements);
            }
        }
        doc_inter.appendChild(page);
        return doc_inter;
    }

    private void ajouterSectionsAuPlanEtape(Element plan_etape, Element parent, String label_section_active) {
        Document doc_inter = plan_etape.getOwnerDocument();
        ArrayList<Element> enfants = OutilsXML.enfants(parent);
        for (Element el : enfants) {
            if (!"SECTION".equals(el.getLocalName())) continue;
            Element section = doc_inter.createElementNS(null, "SECTION");
            String label_section = el.getAttribute("label");
            section.setAttributeNS(null, "label", el.getAttribute("label"));
            section.setAttributeNS(null, "titre", el.getAttribute("titre"));
            section.setAttributeNS(null, "active", label_section.equals(label_section_active) ? "oui" : "non");
            this.ajouterSectionsAuPlanEtape(section, el, label_section_active);
            plan_etape.appendChild(section);
        }
    }

    private void remplacerVariables(Element contenu, Element parent, SuiviEDC suivi) {
        Document doc_inter = contenu.getOwnerDocument();
        for (Node n = parent.getFirstChild(); n != null; n = n.getNextSibling()) {
            if (n instanceof Element) {
                Element sousel = (Element)n;
                String tag = sousel.getLocalName();
                if ("SECTION".equals(tag)) {
                    Element section = doc_inter.createElementNS(null, "SECTION");
                    this.remplacerVariables(section, sousel, suivi);
                    contenu.appendChild(section);
                    continue;
                }
                if ("REF_SECTION".equals(tag)) continue;
                if ("VALEUR_VARIABLE".equals(tag)) {
                    String nom = sousel.getAttribute("nom");
                    Double valeur = new Double(this.getValeurVariable(nom, suivi));
                    Text nval = valeur == null ? doc_inter.createTextNode("[variable sans valeur: " + nom + "]") : doc_inter.createTextNode(valeur.toString());
                    contenu.appendChild(nval);
                    continue;
                }
                if ("BIBLIOTHEQUE".equals(tag) || "BIBLIOGRAPHIE".equals(tag) || "GLOSSAIRE".equals(tag) || "ENCHAINEMENT".equals(tag)) continue;
                Element nouveau = (Element)doc_inter.importNode(sousel, false);
                contenu.appendChild(nouveau);
                this.remplacerVariables(nouveau, sousel, suivi);
                continue;
            }
            contenu.appendChild(doc_inter.importNode(n, true));
        }
    }

    private void ajouterDimensionsImages(Element parent, File fichier_contrib) throws ExceptionMICA {
        for (Node n = parent.getFirstChild(); n != null; n = n.getNextSibling()) {
            if (!(n instanceof Element)) continue;
            Element sousel = (Element)n;
            String tag = sousel.getLocalName();
            if ("ZONE_IMAGE".equals(tag)) {
                String localisation = sousel.getAttribute("localisation");
                ArrayList<Element> fichiers = OutilsXML.enfants(sousel, "FICHIER");
                for (Element el_fichier : fichiers) {
                    int hauteur_max;
                    int largeur_max;
                    boolean redim;
                    String nom = el_fichier.getAttribute("nom");
                    File fichier = new File(fichier_contrib.getParentFile(), nom);
                    Dimensions dim = new Dimensions(fichier);
                    int largeur1 = dim.getLargeur();
                    int hauteur1 = dim.getHauteur();
                    el_fichier.setAttributeNS(null, "largeur1", "" + largeur1);
                    el_fichier.setAttributeNS(null, "hauteur1", "" + hauteur1);
                    if ("page".equals(localisation) && (largeur1 > 300 || hauteur1 > 300)) {
                        redim = true;
                        largeur_max = 300;
                        hauteur_max = 300;
                    } else if ("ic\u00f4ne".equals(localisation) && (largeur1 > 100 || hauteur1 > 100)) {
                        redim = true;
                        largeur_max = 100;
                        hauteur_max = 100;
                    } else {
                        redim = false;
                        largeur_max = 0;
                        hauteur_max = 0;
                    }
                    el_fichier.setAttributeNS(null, "redim", redim ? "oui" : "non");
                    if (redim) {
                        int hauteur2;
                        int largeur2;
                        if (1.0 * (double)largeur1 / (double)largeur_max > 1.0 * (double)hauteur1 / (double)hauteur_max) {
                            largeur2 = largeur_max;
                            hauteur2 = (int)Math.round(1.0 * (double)largeur_max / (double)largeur1 * (double)hauteur1);
                            if (hauteur2 > hauteur_max) {
                                hauteur2 = hauteur_max;
                            }
                        } else {
                            hauteur2 = hauteur_max;
                            largeur2 = (int)Math.round(1.0 * (double)hauteur_max / (double)hauteur1 * (double)largeur1);
                            if (largeur2 > largeur_max) {
                                largeur2 = largeur_max;
                            }
                        }
                        el_fichier.setAttributeNS(null, "largeur2", "" + largeur2);
                        el_fichier.setAttributeNS(null, "hauteur2", "" + hauteur2);
                        continue;
                    }
                    el_fichier.setAttributeNS(null, "largeur2", "" + largeur1);
                    el_fichier.setAttributeNS(null, "hauteur2", "" + hauteur1);
                }
                continue;
            }
            this.ajouterDimensionsImages(sousel, fichier_contrib);
        }
    }

    protected double getValeurVariable(String nom, SuiviEDC suivi) {
        if (this.formules_variables.get(nom) == null) {
            return suivi.getValeurVariable(nom);
        }
        String formule = this.formules_variables.get(nom);
        return new Formule(formule, this, suivi).evaluer();
    }

    public boolean testCondition(String condition, SuiviEDC suivi) {
        double res = new Formule(condition, this, suivi).evaluer();
        return res == 1.0;
    }

    public boolean enchainementPossible(String label_etape1, String label_etape2, SuiviEDC suivi) throws ExceptionMICA {
        if (label_etape2 == null) {
            throw new ExceptionMICA("enchainementPossible: label_etape2 null");
        }
        Element etape = this.lireEtape(label_etape1);
        if (etape == null) {
            throw new ExceptionMICA("enchainementPossible: Etape " + label_etape1 + " introuvable !");
        }
        ArrayList<Element> enchainements_etape = OutilsXML.enfants(etape, "ENCHAINEMENT");
        for (Element enchainement_etape : enchainements_etape) {
            String condition;
            String label_etape_enchainement = enchainement_etape.getAttribute("etape");
            if (!(suivi == null ? label_etape2.equals(label_etape_enchainement) : label_etape2.equals(label_etape_enchainement) && ("".equals(condition = enchainement_etape.getAttribute("condition")) || this.testCondition(condition, suivi)))) continue;
            return true;
        }
        return false;
    }

    public void verifierParametres(Hashtable<String, ArrayList<String>> parametres, SuiviEDC suivi) throws ExceptionMICA {
        String label_etape = suivi.getLabelEtape();
        if (label_etape == null) {
            throw new ExceptionMICA("verifierParametres: aucune \u00e9tape courante ?!?");
        }
        boolean bloquante = this.etapeBloquante(label_etape);
        Element etape = this.lireEtape(label_etape);
        boolean etape_passee = suivi.getValeurVariable(label_etape) == 1.0;
        ArrayList<Element> exercices = OutilsXML.enfants(etape, "EXERCICE");
        for (int i = 0; i < exercices.size(); ++i) {
            Element exercice = exercices.get(i);
            boolean reconsultable = !"non".equals(exercice.getAttribute("reconsultable"));
            int numero_question = 0;
            for (Node item = exercice.getFirstChild(); item != null; item = item.getNextSibling()) {
                Element sousel;
                if (!(item instanceof Element) || !"QUESTION_LIBRE".equals((sousel = (Element)item).getLocalName()) && !"QUESTION_QUESTIONNAIRE".equals(sousel.getLocalName())) continue;
                String nom_parametre = "exercice" + (i + 1) + "_question" + ++numero_question;
                ArrayList<String> valeurs = parametres.get(nom_parametre);
                if (valeurs == null || valeurs.isEmpty() || "".equals(valeurs.get(0))) {
                    if (etape_passee || !bloquante) continue;
                    throw new ExceptionMICA("L'\u00e9tape est bloquante: il faut r\u00e9pondre aux exercices pour continuer", true);
                }
                if (!etape_passee || reconsultable) continue;
                throw new ExceptionMICA("Vous n'avez pas le droit d'envoyer de nouvelles valeurs pour cet exercice.", true);
            }
        }
    }

    public void majVariables(Hashtable<String, ArrayList<String>> parametres, SuiviEDC suivi) throws ExceptionMICA {
        if (suivi.getLabelEtape() == null) {
            throw new ExceptionMICA("majVariables: aucune \u00e9tape courante ?!?");
        }
        for (Map.Entry<String, ArrayList<String>> parametre : parametres.entrySet()) {
            int numero_question;
            int numero_exo;
            String nom_parametre = parametre.getKey();
            ArrayList<String> valeurs_parametre = parametre.getValue();
            int pu1 = nom_parametre.indexOf(95);
            if (pu1 == -1) {
                throw new ExceptionMICA("Nom de param\u00e8tre incorrect: " + nom_parametre);
            }
            String s_numero_exo = nom_parametre.substring("exercice".length(), pu1);
            String s_numero_question = nom_parametre.substring(pu1 + 1 + "question".length());
            try {
                numero_exo = Integer.valueOf(s_numero_exo);
                numero_question = Integer.valueOf(s_numero_question);
            }
            catch (NumberFormatException ex) {
                throw new ExceptionMICA("majVariables " + nom_parametre, ex);
            }
            Element etape = this.lireEtape(suivi.getLabelEtape());
            Element question = this.chercherQuestion(etape, numero_exo, numero_question);
            String nom_variable = question.getAttribute("nom_variable");
            if ("".equals(nom_variable)) {
                throw new ExceptionMICA("Aucune variable d\u00e9finie pour la question " + numero_question + " de l'exercice " + numero_exo);
            }
            if ("QUESTION_LIBRE".equals(question.getLocalName())) {
                if (valeurs_parametre.size() > 1) {
                    throw new ExceptionMICA("Plus d'une valeur pour une r\u00e9ponse libre ?!?");
                }
                if ("".equals(valeurs_parametre.get(0))) continue;
                try {
                    suivi.setValeurVariable(nom_variable, Double.valueOf(valeurs_parametre.get(0)));
                    continue;
                }
                catch (NumberFormatException ex) {
                    throw new ExceptionMICA(valeurs_parametre.get(0) + " n'est pas un nombre !", true);
                }
            }
            String type = question.getAttribute("type");
            if ("QCU".equals(type)) {
                int numero_reponse;
                if (valeurs_parametre.size() > 1) {
                    throw new ExceptionMICA("Plus d'une valeur pour une r\u00e9ponse \u00e0 une question \u00e0 choix unique ?!?");
                }
                String s_numero_reponse = valeurs_parametre.get(0);
                try {
                    numero_reponse = Integer.valueOf(s_numero_reponse);
                }
                catch (NumberFormatException ex) {
                    throw new ExceptionMICA("majVariables " + nom_parametre, ex);
                }
                ArrayList<Element> reponses = OutilsXML.enfants(question, "REPONSE_QUESTIONNAIRE");
                if (numero_reponse < 1 || numero_reponse > reponses.size()) {
                    throw new ExceptionMICA("Mauvais num\u00e9ro de r\u00e9ponse : " + numero_reponse);
                }
                Element reponse = reponses.get(numero_reponse - 1);
                String s_points = reponse.getAttribute("points");
                try {
                    suivi.setValeurVariable(nom_variable, Double.valueOf(s_points));
                    continue;
                }
                catch (NumberFormatException ex) {
                    throw new ExceptionMICA(s_points + " n'est pas un nombre !", true);
                }
            }
            double points = 0.0;
            for (String valeur_parametre : valeurs_parametre) {
                double points_reponse;
                int numero_reponse;
                try {
                    numero_reponse = Integer.valueOf(valeur_parametre);
                }
                catch (NumberFormatException ex) {
                    throw new ExceptionMICA("majVariables " + nom_parametre, ex);
                }
                ArrayList<Element> reponses = OutilsXML.enfants(question, "REPONSE_QUESTIONNAIRE");
                if (numero_reponse < 1 || numero_reponse > reponses.size()) {
                    throw new ExceptionMICA("Mauvais num\u00e9ro de r\u00e9ponse : " + numero_reponse);
                }
                Element reponse = reponses.get(numero_reponse - 1);
                String s_points = reponse.getAttribute("points");
                try {
                    points_reponse = Double.valueOf(s_points);
                }
                catch (NumberFormatException ex) {
                    throw new ExceptionMICA("majVariables: Le nombre de points d'une r\u00e9ponse n'est pas un nombre: " + s_points, ex, true);
                }
                points += points_reponse;
            }
            suivi.setValeurVariable(nom_variable, new Double(points));
        }
    }

    public void majSuivi(SuiviEDC suivi, String label_nouvelle_etape, String label_nouvelle_section) throws ExceptionMICA {
        suivi.etapeTerminee();
        if (label_nouvelle_etape != null) {
            Element etape;
            ArrayList<Element> enchainements_etape;
            suivi.setLabelEtape(label_nouvelle_etape);
            if (label_nouvelle_section == null) {
                suivi.setLabelSection(this.labelPremiereSection(label_nouvelle_etape));
            }
            if ((enchainements_etape = OutilsXML.enfants(etape = this.lireEtape(label_nouvelle_etape), "ENCHAINEMENT")).size() == 0) {
                suivi.setTerminee();
            }
        }
        if (label_nouvelle_section != null) {
            suivi.setLabelSection(label_nouvelle_section);
        }
    }

    private Element chercherQuestion(Element etape, int numero_exo, int numero_question) throws ExceptionMICA {
        ArrayList<Element> exercices = OutilsXML.enfants(etape, "EXERCICE");
        if (numero_exo < 1 || numero_exo > exercices.size()) {
            throw new ExceptionMICA("Mauvais num\u00e9ro d'exercice : " + numero_exo);
        }
        Element exercice = exercices.get(numero_exo - 1);
        ArrayList<Element> questions = new ArrayList<Element>();
        for (Node item = exercice.getFirstChild(); item != null; item = item.getNextSibling()) {
            Element sousel;
            if (!(item instanceof Element) || !"QUESTION_LIBRE".equals((sousel = (Element)item).getLocalName()) && !"QUESTION_QUESTIONNAIRE".equals(sousel.getLocalName())) continue;
            questions.add(sousel);
        }
        if (numero_question < 1 || numero_question > questions.size()) {
            throw new ExceptionMICA("Mauvais num\u00e9ro de question : " + numero_question);
        }
        Element question = (Element)questions.get(numero_question - 1);
        return question;
    }

    public void afficherBibliotheque(HttpServletResponse resp) throws ExceptionMICA {
        ServletOutputStream out;
        if (this.bibliotheque == null) {
            throw new ExceptionMICA("Aucune biblioth\u00e8que \u00e0 afficher !");
        }
        try {
            out = resp.getOutputStream();
        }
        catch (IOException ex) {
            throw new ExceptionMICA("afficherBibliotheque: HttpServletResponse.getOutputStream", ex);
        }
        OutilsXML.transformationXSLT((OutputStream)out, this.bibliotheque, this.fichier_xsl);
    }

    public void afficherSommaire(PrintWriter pw, SuiviEDC suivi) {
        ServletMICA.entete(pw, this.titre, "Sommaire");
        this.plan.afficherSommaire(pw, suivi);
        pw.println("<p><a href=\"MICA?page=accueil\">Revenir \u00e0 l'accueil</a></p>");
        ServletMICA.pied(pw);
    }

    public void afficherGlossaire(PrintWriter pw) {
        ServletMICA.entete(pw, this.titre, "Glossaire");
        String lettres = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
        pw.println("<p>");
        for (int i = 0; i < "ABCDEFGHIJKLMNOPQRSTUVWXYZ".length(); ++i) {
            char c = "ABCDEFGHIJKLMNOPQRSTUVWXYZ".charAt(i);
            pw.println("[<a href=\"#" + Character.toLowerCase(c) + "\">" + c + "</a>] ");
        }
        pw.println("</p>");
        String t1 = "a\u00e0bc\u00e7de\u00e9\u00e8\u00eafghi\u00ef\u00eejklmno\u00f4pqrstu\u00f9vwxyz";
        String t2 = "AABCCDEEEEFGHIIIJKLMNOOPQRSTUUVWXYZ";
        String t3 = " \u00e0\u00e2\u00e9\u00e8\u00ea\u00ee\u00ef\u00f4\u00f6\u00f9\u00fb";
        String t4 = "_aaeeeiioouu";
        for (int i = 0; i < "ABCDEFGHIJKLMNOPQRSTUVWXYZ".length(); ++i) {
            String mot;
            char c = "ABCDEFGHIJKLMNOPQRSTUVWXYZ".charAt(i);
            ArrayList<String> selection_mots = new ArrayList<String>();
            Enumeration<String> mots = this.glossaire.keys();
            while (mots.hasMoreElements()) {
                mot = mots.nextElement();
                char lettre1 = mot.charAt(0);
                int ind = "a\u00e0bc\u00e7de\u00e9\u00e8\u00eafghi\u00ef\u00eejklmno\u00f4pqrstu\u00f9vwxyz".indexOf(lettre1);
                if (ind != -1) {
                    lettre1 = "AABCCDEEEEFGHIIIJKLMNOOPQRSTUUVWXYZ".charAt(ind);
                }
                if (lettre1 != c) continue;
                selection_mots.add(mot);
            }
            if (selection_mots.isEmpty()) continue;
            pw.println("<a name=\"" + Character.toLowerCase(c) + "\"></a>");
            pw.println("<h2>- " + c + " -</h2>");
            pw.println("<dl>");
            Iterator i$ = selection_mots.iterator();
            while (i$.hasNext()) {
                String ancre = mot = (String)i$.next();
                for (int j = 0; j < " \u00e0\u00e2\u00e9\u00e8\u00ea\u00ee\u00ef\u00f4\u00f6\u00f9\u00fb".length(); ++j) {
                    ancre = ancre.replace(" \u00e0\u00e2\u00e9\u00e8\u00ea\u00ee\u00ef\u00f4\u00f6\u00f9\u00fb".charAt(j), "_aaeeeiioouu".charAt(j));
                }
                pw.println("<dt><a name=\"" + ancre + "\"><b>" + mot + "</b></a></dt>");
                pw.println("<dd>" + OutilsXML.encoder(this.glossaire.get(mot)) + "</dd>");
            }
            pw.println("</dl>");
        }
        ServletMICA.pied(pw);
    }

    public void afficherBibliographie(PrintWriter pw) {
        ServletMICA.entete(pw, this.titre, "Bibliographie");
        this.bibliographie.afficher(pw);
        ServletMICA.pied(pw);
    }

    public void envoyerEquation(HttpServletResponse resp, int numero, SuiviEDC suivi) throws ExceptionMICA {
        ServletOutputStream out;
        if (suivi.getLabelEtape() == null) {
            throw new ExceptionMICA("envoyerEquation: aucune \u00e9tape courante ?!?");
        }
        Element parent = suivi.getLabelSection() == null ? this.lireEtape(suivi.getLabelEtape()) : this.lireSection(suivi.getLabelSection());
        Element el_equation = this.chercherEquation(parent, numero);
        if (el_equation == null) {
            throw new ExceptionMICA("Etape " + suivi.getLabelEtape() + ": \u00e9quation introuvable: " + numero, true);
        }
        String imageBase64 = OutilsXML.valeurElement(el_equation);
        DecodeurBase64 decodeur = new DecodeurBase64(new StringReader(imageBase64));
        resp.setContentType("image/png");
        try {
            out = resp.getOutputStream();
        }
        catch (IOException ex) {
            throw new ExceptionMICA("envoyerEquation: HttpServletResponse.getOutputStream", ex);
        }
        try {
            int c;
            while ((c = decodeur.read()) != -1) {
                out.write(c);
            }
            decodeur.close();
            out.close();
        }
        catch (IOException ex) {
            throw new ExceptionMICA("envoyerEquation " + numero, ex);
        }
    }

    private Element chercherEquation(Element parent, int numero) {
        int i = 0;
        Node n = parent.getFirstChild();
        while (n != null) {
            Element sousel;
            String tag;
            if (n instanceof Element && "EQUATION".equals(tag = (sousel = (Element)n).getLocalName()) && ++i == numero) {
                return sousel;
            }
            if (n.getFirstChild() != null) {
                n = n.getFirstChild();
                continue;
            }
            while (n != null && n.getNextSibling() == null) {
                if ((n = n.getParentNode()) != parent) continue;
                n = null;
            }
            if (n == null) continue;
            n = n.getNextSibling();
        }
        return null;
    }
}

