/*
 * Decompiled with CFR 0.152.
 */
package serveurmica;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.imageio.ImageIO;
import serveurmica.ExceptionMICA;

public class Dimensions {
    private int largeur;
    private int hauteur;

    public Dimensions(File f) throws ExceptionMICA {
        String nomf = f.getName();
        int posp = nomf.lastIndexOf(46);
        if (posp == -1) {
            throw new ExceptionMICA("Erreur: acune extension au fichier " + f.getName() + ". Impossible de d\u00e9terminer ses dimensions.");
        }
        String extension = nomf.substring(posp + 1).toLowerCase();
        if ("gif".equals(extension) || "png".equals(extension) || "jpg".equals(extension) || "jpeg".equals(extension)) {
            BufferedImage image;
            try {
                image = ImageIO.read(f);
            }
            catch (IOException ex) {
                throw new ExceptionMICA("Dimensions " + nomf, ex);
            }
            this.largeur = image.getWidth();
            this.hauteur = image.getHeight();
        } else {
            if ("mpg".equals(extension) || "mpeg".equals(extension)) {
                try {
                    FileInputStream in = new FileInputStream(f);
                    long signature = 435L;
                    int bi = 0;
                    int b1 = in.read();
                    int b2 = in.read();
                    int b3 = in.read();
                    int b4 = in.read();
                    long v = (b1 & 0xFF) << 24 | (b2 & 0xFF) << 16 | (b3 & 0xFF) << 8 | b4 & 0xFF;
                    while (bi != -1 && v != 435L) {
                        bi = in.read();
                        if (bi == -1) continue;
                        b1 = b2;
                        b2 = b3;
                        b3 = b4;
                        b4 = bi;
                        v = (b1 & 0xFF) << 24 | (b2 & 0xFF) << 16 | (b3 & 0xFF) << 8 | b4 & 0xFF;
                    }
                    if (v != 435L) {
                        throw new ExceptionMICA("Erreur: Dimensions non trouv\u00e9es pour " + nomf);
                    }
                    b1 = in.read();
                    b2 = in.read();
                    b3 = in.read();
                    this.largeur = (b1 & 0xFF) << 4 | (b2 & 0xF0) >> 4;
                    this.hauteur = (b2 & 0xF) << 8 | b3 & 0xFF;
                    in.close();
                }
                catch (FileNotFoundException ex) {
                    throw new ExceptionMICA("Dimensions " + nomf, ex);
                }
                catch (IOException ex) {
                    throw new ExceptionMICA("Dimensions " + nomf, ex);
                }
            }
            if ("ogg".equals(extension) || "ogv".equals(extension)) {
                try {
                    FileInputStream in = new FileInputStream(f);
                    long signature = 1332176723L;
                    int bi = 0;
                    int b1 = in.read();
                    int b2 = in.read();
                    int b3 = in.read();
                    int b4 = in.read();
                    long v = (b1 & 0xFF) << 24 | (b2 & 0xFF) << 16 | (b3 & 0xFF) << 8 | b4 & 0xFF;
                    if (v != signature) {
                        in.close();
                        throw new IOException("Erreur: Le fichier " + f.getPath() + " n'a pas la signature du format Ogg");
                    }
                    signature = -2139854747L;
                    v = (b1 & 0xFF) << 24 | (b2 & 0xFF) << 16 | (b3 & 0xFF) << 8 | b4 & 0xFF;
                    while (bi != -1 && v != signature) {
                        bi = in.read();
                        if (bi == -1) continue;
                        b1 = b2;
                        b2 = b3;
                        b3 = b4;
                        b4 = bi;
                        v = (b1 & 0xFF) << 24 | (b2 & 0xFF) << 16 | (b3 & 0xFF) << 8 | b4 & 0xFF;
                    }
                    if (v == signature) {
                        for (int i = 0; i < 10; ++i) {
                            b1 = in.read();
                        }
                    } else {
                        throw new ExceptionMICA("Erreur: Dimensions non trouv\u00e9es pour " + nomf);
                    }
                    b1 = in.read();
                    b2 = in.read();
                    b3 = in.read();
                    this.largeur = (b1 & 0xFF) << 16 | (b2 & 0xFF) << 8 | b3 & 0xFF;
                    b1 = in.read();
                    b2 = in.read();
                    b3 = in.read();
                    this.hauteur = (b1 & 0xFF) << 16 | (b2 & 0xFF) << 8 | b3 & 0xFF;
                    in.close();
                }
                catch (FileNotFoundException ex) {
                    throw new ExceptionMICA("Dimensions " + nomf, ex);
                }
                catch (IOException ex) {
                    throw new ExceptionMICA("Dimensions " + nomf, ex);
                }
            }
        }
    }

    public int getLargeur() {
        return this.largeur;
    }

    public int getHauteur() {
        return this.hauteur;
    }
}

