/*
 * Decompiled with CFR 0.152.
 */
package serveurmica;

import java.io.PrintWriter;
import java.util.ArrayList;
import org.w3c.dom.Element;
import serveurmica.OutilsXML;

public class Bibliographie {
    private ArrayList<ReferenceBibliographique> references = new ArrayList();

    public void ajouterReference(Element el) {
        this.references.add(new ReferenceBibliographique(el));
    }

    public boolean vide() {
        return this.references.isEmpty();
    }

    public void afficher(PrintWriter pw) {
        pw.println("<ul>");
        for (ReferenceBibliographique reference : this.references) {
            reference.afficher(pw);
        }
        pw.println("</ul>");
    }

    class ReferenceWeb
    implements Reference {
        String description;
        String url;
        String auteurs;
        String titre;
        String titre_site;
        String date_consultation;

        public ReferenceWeb(Element el) {
            Element el_description = OutilsXML.premierEnfant(el, "DESCRIPTION");
            this.description = el_description == null ? null : OutilsXML.valeurElement(el_description);
            this.url = el.getAttribute("url");
            this.auteurs = el.getAttribute("auteurs");
            this.titre = el.getAttribute("titre");
            this.titre_site = el.getAttribute("titreSite");
            if ("".equals(this.titre_site)) {
                this.titre_site = null;
            }
            this.date_consultation = el.getAttribute("dateConsultation");
        }

        public void afficher(PrintWriter pw) {
            pw.print("<b>" + OutilsXML.encoder(this.auteurs) + "</b>.");
            pw.print(" <b><i>" + OutilsXML.encoder(this.titre) + "</i></b>.");
            if (this.titre_site != null) {
                pw.print(" In <b><i>" + OutilsXML.encoder(this.titre_site) + "</i></b>.");
            }
            pw.print(" [consult\u00e9 le " + OutilsXML.encoder(this.date_consultation) + "]");
            pw.print(" <a href=\"" + OutilsXML.encoder(this.url) + "\">" + OutilsXML.encoder(this.url) + "</a>.");
            if (this.description != null) {
                pw.print(" " + OutilsXML.encoder(this.description));
            }
        }
    }

    class ReferenceArticle
    implements Reference {
        String titre_article;
        String titre_periodique;
        String premier_auteur;
        String autres_auteurs;
        String annee;
        String volume;
        String numero;
        String pagination;
        String url;
        String autre;

        public ReferenceArticle(Element el) {
            this.titre_article = el.getAttribute("titreArticle");
            this.titre_periodique = el.getAttribute("titrePeriodique");
            this.premier_auteur = el.getAttribute("premierAuteur");
            this.autres_auteurs = el.getAttribute("autresAuteurs");
            if ("".equals(this.autres_auteurs)) {
                this.autres_auteurs = null;
            }
            this.annee = el.getAttribute("annee");
            this.volume = el.getAttribute("volume");
            if ("".equals(this.volume)) {
                this.volume = null;
            }
            this.numero = el.getAttribute("numero");
            this.pagination = el.getAttribute("pagination");
            this.url = el.getAttribute("url");
            if ("".equals(this.url)) {
                this.url = null;
            }
            this.autre = el.getAttribute("autre");
            if ("".equals(this.autre)) {
                this.autre = null;
            }
        }

        public void afficher(PrintWriter pw) {
            pw.print("<b>");
            pw.print(OutilsXML.encoder(this.premier_auteur));
            if (this.autres_auteurs != null) {
                pw.print("; " + OutilsXML.encoder(this.autres_auteurs));
            }
            pw.print("</b>.");
            pw.print(" " + OutilsXML.encoder(this.titre_article) + ".");
            pw.print(" <b><i>" + OutilsXML.encoder(this.titre_periodique) + "</i></b>,");
            pw.print(" " + OutilsXML.encoder(this.annee));
            if (this.volume != null) {
                pw.print(", " + OutilsXML.encoder(this.volume));
            }
            pw.print(", n\u00b0" + OutilsXML.encoder(this.numero));
            pw.print(", " + OutilsXML.encoder(this.pagination) + ".");
            if (this.url != null) {
                pw.print(" <a href=\"" + OutilsXML.encoder(this.url) + "\">" + OutilsXML.encoder(this.url) + "</a>.");
            }
            if (this.autre != null) {
                pw.print(" " + OutilsXML.encoder(this.autre) + ".");
            }
        }
    }

    class ReferenceOuvrage
    implements Reference {
        String titre;
        String sous_titre;
        String premier_auteur;
        String autres_auteurs;
        String volume;
        String lieu;
        String editeur;
        String annee;
        String pagination;
        String collection;
        String isbn;
        String url;
        String autre;

        public ReferenceOuvrage(Element el) {
            this.titre = el.getAttribute("titre");
            this.sous_titre = el.getAttribute("sous-titre");
            if ("".equals(this.sous_titre)) {
                this.sous_titre = null;
            }
            this.premier_auteur = el.getAttribute("premierAuteur");
            this.autres_auteurs = el.getAttribute("autresAuteurs");
            if ("".equals(this.autres_auteurs)) {
                this.autres_auteurs = null;
            }
            this.volume = el.getAttribute("volume");
            if ("".equals(this.volume)) {
                this.volume = null;
            }
            this.lieu = el.getAttribute("lieu");
            if ("".equals(this.lieu)) {
                this.lieu = null;
            }
            this.editeur = el.getAttribute("editeur");
            this.annee = el.getAttribute("annee");
            this.pagination = el.getAttribute("pagination");
            if ("".equals(this.pagination)) {
                this.pagination = null;
            }
            this.collection = el.getAttribute("collection");
            if ("".equals(this.collection)) {
                this.collection = null;
            }
            this.isbn = el.getAttribute("isbn");
            if ("".equals(this.isbn)) {
                this.isbn = null;
            }
            this.url = el.getAttribute("url");
            if ("".equals(this.url)) {
                this.url = null;
            }
            this.autre = el.getAttribute("autre");
            if ("".equals(this.autre)) {
                this.autre = null;
            }
        }

        public void afficher(PrintWriter pw) {
            pw.print("<b>");
            pw.print(OutilsXML.encoder(this.premier_auteur));
            if (this.autres_auteurs != null) {
                pw.print("; " + OutilsXML.encoder(this.autres_auteurs));
            }
            pw.print("</b>.");
            pw.print(" <b><i>" + OutilsXML.encoder(this.titre) + "</i></b>.");
            if (this.sous_titre != null) {
                pw.print(" " + OutilsXML.encoder(this.sous_titre) + ".");
            }
            if (this.volume != null) {
                pw.print(" " + OutilsXML.encoder(this.volume) + ".");
            }
            if (this.lieu != null) {
                pw.print(", " + OutilsXML.encoder(this.lieu) + " :");
            }
            pw.print(" " + OutilsXML.encoder(this.editeur));
            pw.print(", " + OutilsXML.encoder(this.annee));
            pw.print(".");
            if (this.pagination != null) {
                pw.print(" " + OutilsXML.encoder(this.pagination) + ".");
            }
            if (this.collection != null) {
                pw.print(" coll. " + OutilsXML.encoder(this.collection) + ".");
            }
            if (this.isbn != null) {
                pw.print(" ISBN " + OutilsXML.encoder(this.isbn) + ".");
            }
            if (this.url != null) {
                pw.print(" <a href=\"" + OutilsXML.encoder(this.url) + "\">" + OutilsXML.encoder(this.url) + "</a>.");
            }
            if (this.autre != null) {
                pw.print(" " + OutilsXML.encoder(this.autre) + ".");
            }
        }
    }

    static interface Reference {
        public void afficher(PrintWriter var1);
    }

    class ReferenceBibliographique {
        private String label;
        private Reference ref;

        public ReferenceBibliographique(Element el) {
            this.label = el.getAttribute("label");
            Element el_ref = OutilsXML.premierEnfant(el, "REFERENCE_OUVRAGE");
            this.ref = el_ref != null ? new ReferenceOuvrage(el_ref) : ((el_ref = OutilsXML.premierEnfant(el, "REFERENCE_ARTICLE")) != null ? new ReferenceArticle(el_ref) : ((el_ref = OutilsXML.premierEnfant(el, "REFERENCE_WEB")) != null ? new ReferenceWeb(el_ref) : null));
        }

        public void afficher(PrintWriter pw) {
            pw.println("<li><a name=\"" + this.label + "\">");
            if (this.ref != null) {
                this.ref.afficher(pw);
            }
            pw.println("</li>");
        }
    }
}

