/*
Mex - Mini Editeur XML

Copyright (C) 2004 Observatoire de Paris-Meudon

Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier conformment aux dispositions de la Licence Publique Gnrale GNU, telle que publie par la Free Software Foundation ; version 2 de la licence, ou encore ( votre choix) toute version ultrieure.

Ce programme est distribu dans l'espoir qu'il sera utile, mais SANS AUCUNE GARANTIE ; sans mme la garantie implicite de COMMERCIALISATION ou D'ADAPTATION A UN OBJET PARTICULIER. Pour plus de dtail, voir la Licence Publique Gnrale GNU .

Vous devez avoir reu un exemplaire de la Licence Publique Gnrale GNU en mme temps que ce programme ; si ce n'est pas le cas, crivez  la Free Software Foundation Inc., 675 Mass Ave, Cambridge, MA 02139, Etats-Unis.
*/

package mex;

import java.io.File;
import java.util.Vector;

import com.apple.eawt.*; // java 1.4.1 (utiliser emptyaewt.jar pour les versions antrieures et non-Mac)

/**
 * Cette classe est la classe principale et reprsente l'application Mex.
 * Les vnements grs (nouveau/ouvrir/quitter) sont ceux de l'application,
 * par opposition aux vnements de FenetreSource qui sont ceux d'un document.
 */
public class Mex implements ApplicationListener {
    private static Vector fenetres; // (de FenetreSource) liste des documents ouverts de l'application
    private static boolean chargementNouveau; // true si un premier document vide est en train d'tre ouvert
    
    public static void main(String argv[]) {
        Application app = new Application();
        //app.setEnabledPreferencesMenu(true);
        chargementNouveau = (argv.length != 1);
        app.addApplicationListener(new Mex());
        
        fenetres = new Vector();
        if (argv.length == 1) {
            File f = new File(argv[0]);
            if (!f.exists())
                System.err.println("erreur: le fichier " + f.getAbsolutePath() + " n'existe pas.");
            else
                ouvrir(f);
        } else {
            fenetres.add(new FenetreSource());
            chargementNouveau = false;
        }
    }
    
    /**
     * Nouveau document
     */
    public static FenetreSource nouveau() {
        FenetreSource nf = new FenetreSource();
        fenetres.add(nf);
        return(nf);
    }
    
    /**
     * Ouverture d'un document XML
     */
    public static FenetreSource ouvrir(File f) {
        FenetreSource nf;
        while (chargementNouveau) {
            try {
                Thread.currentThread().sleep(100);
            } catch (InterruptedException ex) {
            }
        }
        for (int i=0; i<fenetres.size(); i++)
            if (f.equals(((FenetreSource)fenetres.get(i)).fichierCorrespondant())) {
                ((FenetreSource)fenetres.get(i)).toFront();
                return((FenetreSource)fenetres.get(i));
            }
        if (fenetres.size() > 0 && ((FenetreSource)fenetres.get(0)).estVide()) {
            nf = (FenetreSource)fenetres.get(0);
            nf.ouvrir(f);
        } else {
            nf = new FenetreSource(f);
            fenetres.add(nf);
        }
        return(nf);
    }
    
    /**
     * Ferme une fentre
     */
    public static void fermer(FenetreSource fs) {
        if (!fs.testEnregistrerAvant())
            return;
        fs.setVisible(false);
        fenetres.remove(fs);
        if (fenetres.size() == 0)
            quitter(false);
    }
    
    /**
     * Renvoit le nombre de fentres
     */
    public static int nombreFenetres() {
        return(fenetres.size());
    }
    
    /**
     * Quitter l'application
     */
    public static void quitter(boolean test) {
        if (test) {
            for (int i=0; i<fenetres.size(); i++)
                if (!((FenetreSource)fenetres.get(i)).testEnregistrerAvant())
                    return;
        }
        System.exit(0);
    }
    
    // MacOS X java 1.4.1 (ApplicationListener)
    
    public void handleAbout(ApplicationEvent event) {
        //apropos();
        //event.setHandled(true);
    }
    
    public void handleOpenApplication(ApplicationEvent event) {
    }
    
    public void handleReOpenApplication(ApplicationEvent event) {
    }
    
    public void handleOpenFile(ApplicationEvent event) {
        File f = new File(event.getFilename());
        ouvrir(f);
        event.setHandled(true);
    }
    
    public void handlePreferences(ApplicationEvent event) {
        //preferences();
        //event.setHandled(true);
    }
    
    public void handlePrintFile(ApplicationEvent event) {
        File f = new File(event.getFilename());
        FenetreSource fenetre = ouvrir(f);
        fenetre.imprimer();
        event.setHandled(true);
    }
    
    public void handleQuit(ApplicationEvent event) {
        quitter(true);
    }
}

