/*
Mex - Mini Editeur XML

Copyright (C) 2004 Observatoire de Paris-Meudon

Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier conformment aux dispositions de la Licence Publique Gnrale GNU, telle que publie par la Free Software Foundation ; version 2 de la licence, ou encore ( votre choix) toute version ultrieure.

Ce programme est distribu dans l'espoir qu'il sera utile, mais SANS AUCUNE GARANTIE ; sans mme la garantie implicite de COMMERCIALISATION ou D'ADAPTATION A UN OBJET PARTICULIER. Pour plus de dtail, voir la Licence Publique Gnrale GNU .

Vous devez avoir reu un exemplaire de la Licence Publique Gnrale GNU en mme temps que ce programme ; si ce n'est pas le cas, crivez  la Free Software Foundation Inc., 675 Mass Ave, Cambridge, MA 02139, Etats-Unis.
*/

package mex;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.text.*;

public class DialogueRechercher extends JDialog implements ActionListener, ItemListener {

    private JTextPane textPane;
    private StyledDocument doc;
    private JTextField tfRechercher;
    private JTextField tfRemplacer;
    private boolean dansSelection = false;
    private boolean ignorerCasse = false;
    private String texteRecherche = null;

    public DialogueRechercher(JTextPane textPane) {
        super((JFrame)textPane.getTopLevelAncestor(), "Rechercher", true);
        this.textPane = textPane;
        doc = textPane.getStyledDocument();
        
        JPanel cpane = new JPanel();
        cpane.setLayout(new BoxLayout(cpane, BoxLayout.Y_AXIS));
        
        // rechercher / remplacer
        setContentPane(cpane);
        JPanel chpane = new JPanel(new BorderLayout());
        JPanel qpane = new JPanel(new GridLayout(2, 1));
        qpane.add(new JLabel("Rechercher"));
        qpane.add(new JLabel("Remplacer par:"));
        qpane.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        JPanel tfpane = new JPanel(new GridLayout(2, 1)); // textfields
        tfRechercher = new JTextField("", 40);
        tfRechercher.addKeyListener(new KeyAdapter() {
            public void keyPressed(KeyEvent evt) {
                if (evt.getKeyCode() == KeyEvent.VK_ESCAPE)
                    setVisible(false);
            }
        });
        tfpane.add(tfRechercher);
        tfRemplacer = new JTextField("", 40);
        tfRemplacer.addKeyListener(new KeyAdapter() {
            public void keyPressed(KeyEvent evt) {
                if (evt.getKeyCode() == KeyEvent.VK_ESCAPE)
                    setVisible(false);
            }
        });
        tfpane.add(tfRemplacer);
        chpane.add(qpane, BorderLayout.CENTER);
        chpane.add(tfpane, BorderLayout.EAST);
        cpane.add(chpane);
        
        // options
        JPanel optpane = new JPanel(new FlowLayout());
        JRadioButton bfichier = new JRadioButton("Fichier entier");
        bfichier.setActionCommand("fichier");
        bfichier.setSelected(true);
        JRadioButton bsel = new JRadioButton("Slection");
        bsel.setActionCommand("selection");
        ButtonGroup groupe = new ButtonGroup();
        groupe.add(bfichier);
        groupe.add(bsel);
        bfichier.addActionListener(this);
        bsel.addActionListener(this);
        optpane.add(bfichier);
        optpane.add(bsel);
        JCheckBox chkmaj = new JCheckBox("Ignorer la casse");
        chkmaj.addItemListener(this);
        optpane.add(chkmaj);
        cpane.add(optpane);
        
        // actions
        JPanel actpane = new JPanel(new FlowLayout());
        JButton btout = new JButton("Tout remplacer");
        btout.setActionCommand("tout");
        btout.addActionListener(this);
        actpane.add(btout);
        JButton bremplacer = new JButton("Remplacer");
        bremplacer.setActionCommand("remplacer");
        bremplacer.addActionListener(this);
        actpane.add(bremplacer);
        JButton bremplrech = new JButton("Remplacer et rechercer");
        bremplrech.setActionCommand("remplrech");
        bremplrech.addActionListener(this);
        actpane.add(bremplrech);
        JButton bprec = new JButton("Prcdent");
        bprec.setActionCommand("precedent");
        bprec.addActionListener(this);
        actpane.add(bprec);
        JButton bsuiv = new JButton("Suivant");
        bsuiv.setActionCommand("suivant");
        bsuiv.addActionListener(this);
        actpane.add(bsuiv);
        cpane.add(actpane);
        getRootPane().setDefaultButton(bsuiv);
        pack();
        Rectangle r = textPane.getTopLevelAncestor().getBounds();
        addWindowListener(new WindowAdapter() {
            boolean gotFocus = false;
            public void windowActivated(WindowEvent we) {
                // Once window gets focus, set initial focus
                if (!gotFocus) {
                    tfRechercher.requestFocus();
                    gotFocus = true;
                }
            }
        });
        setLocation(r.x + r.width/4, r.y + r.height/4);
    }
    
    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if ("suivant".equals(cmd))
            suivant();
        else if ("precedent".equals(cmd))
            precedent();
        else if ("remplacer".equals(cmd))
            remplacer();
        else if ("tout".equals(cmd))
            toutRemplacer();
        else if ("remplrech".equals(cmd))
            remplRech();
        else if ("fichier".equals(cmd))
            dansSelection = false;
        else if ("selection".equals(cmd))
            dansSelection = true;
    }
    
    public void itemStateChanged(ItemEvent e) {
        ignorerCasse = (e.getStateChange() == ItemEvent.SELECTED);
    }
    
    public void rechercher() {
        texteRecherche = tfRechercher.getText();
        if (texteRecherche == null || texteRecherche.length() == 0)
            return;
        int len = texteRecherche.length();
        int ind = -1;
        String text;
        // recherche bourrin
        try {
            for (int i=0; i<doc.getLength()-len; i++) {
                text = doc.getText(i, len);
                if (text.equals(texteRecherche)) {
                    ind = i;
                    break;
                }
            }
        } catch (BadLocationException ex) {
            System.err.println("BadLocationException: " + ex.getMessage());
            return;
        }
        if (ind != -1) {
            textPane.setCaretPosition(ind);
            textPane.moveCaretPosition(ind+len);
        } else
            getToolkit().beep();
    }
    
    public void suivant() {
        suivant (textPane.getSelectionStart());
    }
    
    // recherche suivant a partir de rech_pos
    public void suivant(int rech_pos) {
        texteRecherche = tfRechercher.getText();
        if (texteRecherche == null || texteRecherche.length() == 0)
            return;
        int len = texteRecherche.length();
        if (len >= doc.getLength()) {
            getToolkit().beep();
            return;
        }
        if ( (rech_pos + len) > doc.getLength() ) rech_pos = 0;
        try {
                if (doc.getText(rech_pos, len).equals(texteRecherche) &&
                        textPane.getSelectionStart() == rech_pos &&
                        textPane.getSelectionEnd() == rech_pos + len)
                    rech_pos++;
            }
        catch (BadLocationException ex)
            {
                System.err.println("BadLocationException: " + ex.getMessage());
                return;
            }
        int ind = -1;
        String text;
        // recherche bourrin
        try {
            for (int i=rech_pos; i<doc.getLength()-len+1; i++) {
                text = doc.getText(i, len);
                if ((!ignorerCasse && text.equals(texteRecherche)) ||
                        (ignorerCasse && text.equalsIgnoreCase(texteRecherche))) {
                    ind = i;
                    break;
                }
            }
        } catch (BadLocationException ex) {
            System.err.println("BadLocationException: " + ex.getMessage());
            return;
        }
        if (ind != -1) {
            textPane.setCaretPosition(ind);
            textPane.moveCaretPosition(ind+len);
        }
        else if (rech_pos != 0) {
                suivant(0);
             }
             else
             {
                getToolkit().beep();
             }
    }
    
    public void precedent() {
        precedent (textPane.getSelectionStart());
    }
    
    // recherche precedent a partir de rech_pos
    public void precedent(int rech_pos) {
        texteRecherche = tfRechercher.getText();
        if (texteRecherche == null || texteRecherche.length() == 0)
            return;
        int len = texteRecherche.length();
        if (len >= doc.getLength()) {
            getToolkit().beep();
            return;
        }
        int ind = -1;
        if (rech_pos + len > doc.getLength())
            rech_pos = doc.getLength() - len;
        if (rech_pos < 0)
            rech_pos = 0;
        try {
                if ((doc.getText(rech_pos, len).equals(texteRecherche))
                        && ((textPane.getSelectionEnd() - textPane.getSelectionStart() ) == len))
                    rech_pos--;
            }
        catch (BadLocationException ex)
            {
                System.err.println("BadLocationException: " + ex.getMessage());
                return;
            }
        String text;
        try {
            for (int i=rech_pos; i>=0; i--) {
                text = doc.getText(i, len);
                if ((!ignorerCasse && text.equals(texteRecherche)) ||
                        (ignorerCasse && text.equalsIgnoreCase(texteRecherche))) {
                    ind = i;
                    break;
                }
            }
        } catch (BadLocationException ex) {
            System.err.println("BadLocationException: " + ex.getMessage());
            return;
        }
        if (ind != -1) {
            textPane.setCaretPosition(ind);
            textPane.moveCaretPosition(ind+len);
        }
        else if (rech_pos != (doc.getLength()-len)) {
                precedent(doc.getLength()-len); }
             else {
                getToolkit().beep(); }
    }
    
    public void remplacer() {
        String texteRemplacer = tfRemplacer.getText();
        if ("".equals(texteRemplacer))
            texteRemplacer = null;
        
        if (textPane.getSelectionStart()==textPane.getSelectionEnd()) return;
        
        int start = textPane.getSelectionStart();
        int end = textPane.getSelectionEnd();
        try {
            if (start != end)
                doc.remove(start, end - start);
            if (texteRemplacer != null)
                doc.insertString(start, texteRemplacer, null);
        } catch (BadLocationException ex) {
            System.err.println("BadLocationException: " + ex.getMessage());
            return;
        }
    }
    
    public void toutRemplacer() {
        texteRecherche = tfRechercher.getText();
        if (texteRecherche == null || texteRecherche.length() == 0)
            return;
        String texteRemplacer = tfRemplacer.getText();
        if ("".equals(texteRemplacer))
            texteRemplacer = null;
        
        //textPane.debutEditionSpeciale("Remplacer", false);
        int len = texteRecherche.length();
        int ind = -1;
        int i0;
        int ifin;
        if (dansSelection) {
            i0 = textPane.getSelectionStart();
            ifin = textPane.getSelectionEnd();
        } else {
            i0 = 0;
            ifin = doc.getLength()-len;
        }
        String text;
        try {
            for (int i=i0; i<ifin; i++) {
                text = doc.getText(i, len);
                if ((!ignorerCasse && text.equals(texteRecherche)) ||
                        (ignorerCasse && text.equalsIgnoreCase(texteRecherche))) {
                    ind = i;
                    doc.remove(i, len);
                    if (texteRemplacer != null) {
                        doc.insertString(i, texteRemplacer, null);
                    }
                    if (dansSelection)
                        ifin = textPane.getSelectionEnd();
                    else
                        ifin = doc.getLength()-len;
                }
            }
        } catch (BadLocationException ex) {
            System.err.println("BadLocationException: " + ex.getMessage());
            //textPane.finEditionSpeciale();
            return;
        }
        if (ind == -1)
            getToolkit().beep();
        //textPane.finEditionSpeciale();
    }
    
    public void remplRech() {
        remplacer();
        suivant();
    }
    
    public String getTexteRecherche() {
        return(texteRecherche);
    }
}
