/*
 * Decompiled with CFR 0.152.
 */
package mex;

import com.apple.eawt.Application;
import com.apple.eawt.ApplicationEvent;
import com.apple.eawt.ApplicationListener;
import java.io.File;
import java.util.Vector;
import mex.FenetreSource;

public class Mex
implements ApplicationListener {
    private static Vector fenetres;
    private static boolean chargementNouveau;

    public static void main(String[] stringArray) {
        Application application = new Application();
        chargementNouveau = stringArray.length != 1;
        application.addApplicationListener(new Mex());
        fenetres = new Vector();
        if (stringArray.length == 1) {
            File file = new File(stringArray[0]);
            if (!file.exists()) {
                System.err.println("erreur: le fichier " + file.getAbsolutePath() + " n'existe pas.");
            } else {
                Mex.ouvrir(file);
            }
        } else {
            fenetres.add(new FenetreSource());
            chargementNouveau = false;
        }
    }

    public static FenetreSource nouveau() {
        FenetreSource fenetreSource = new FenetreSource();
        fenetres.add(fenetreSource);
        return fenetreSource;
    }

    public static FenetreSource ouvrir(File file) {
        FenetreSource fenetreSource;
        while (chargementNouveau) {
            try {
                Thread.currentThread();
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        for (int i = 0; i < fenetres.size(); ++i) {
            if (!file.equals(((FenetreSource)fenetres.get(i)).fichierCorrespondant())) continue;
            ((FenetreSource)fenetres.get(i)).toFront();
            return (FenetreSource)fenetres.get(i);
        }
        if (fenetres.size() > 0 && ((FenetreSource)fenetres.get(0)).estVide()) {
            fenetreSource = (FenetreSource)fenetres.get(0);
            fenetreSource.ouvrir(file);
        } else {
            fenetreSource = new FenetreSource(file);
            fenetres.add(fenetreSource);
        }
        return fenetreSource;
    }

    public static void fermer(FenetreSource fenetreSource) {
        if (!fenetreSource.testEnregistrerAvant()) {
            return;
        }
        fenetreSource.setVisible(false);
        fenetres.remove(fenetreSource);
        if (fenetres.size() == 0) {
            Mex.quitter(false);
        }
    }

    public static int nombreFenetres() {
        return fenetres.size();
    }

    public static void quitter(boolean bl) {
        if (bl) {
            for (int i = 0; i < fenetres.size(); ++i) {
                if (((FenetreSource)fenetres.get(i)).testEnregistrerAvant()) continue;
                return;
            }
        }
        System.exit(0);
    }

    public void handleAbout(ApplicationEvent applicationEvent) {
    }

    public void handleOpenApplication(ApplicationEvent applicationEvent) {
    }

    public void handleReOpenApplication(ApplicationEvent applicationEvent) {
    }

    public void handleOpenFile(ApplicationEvent applicationEvent) {
        File file = new File(applicationEvent.getFilename());
        Mex.ouvrir(file);
        applicationEvent.setHandled(true);
    }

    public void handlePreferences(ApplicationEvent applicationEvent) {
    }

    public void handlePrintFile(ApplicationEvent applicationEvent) {
        File file = new File(applicationEvent.getFilename());
        FenetreSource fenetreSource = Mex.ouvrir(file);
        fenetreSource.imprimer();
        applicationEvent.setHandled(true);
    }

    public void handleQuit(ApplicationEvent applicationEvent) {
        Mex.quitter(true);
    }
}

