/*
 * Decompiled with CFR 0.152.
 */
package mex;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.util.ArrayList;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import mex.FenetreSource;
import org.apache.xerces.parsers.DOMParser;
import org.w3c.dom.Element;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class FenetreValidation
extends JFrame
implements MouseListener,
ActionListener {
    File fichierXML;
    File fichierSchema;
    JEditorPane editorPane;
    String contenu;
    ArrayList erreurs;
    FenetreSource sourceFrame;

    public FenetreValidation(File file, FenetreSource fenetreSource) {
        super("Liste d'erreurs pour " + file.getName());
        this.sourceFrame = fenetreSource;
        this.newdoc(file, null);
    }

    public FenetreValidation(File file, File file2, FenetreSource fenetreSource) {
        super("Liste d'erreurs pour " + file.getName());
        this.sourceFrame = fenetreSource;
        this.newdoc(file, file2);
    }

    public void newdoc(File file, File file2) {
        this.fichierXML = file;
        this.fichierSchema = file2;
        Rectangle rectangle = this.sourceFrame.getBounds();
        this.setLocation(rectangle.x + rectangle.width / 2, rectangle.y + rectangle.height / 2);
        this.setSize(new Dimension(620, 460));
        this.affichage();
        this.miseAJour();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                try {
                    FenetreValidation.this.editorPane.scrollRectToVisible(FenetreValidation.this.editorPane.modelToView(0));
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        });
    }

    protected void affichage() {
        this.editorPane = new JEditorPane();
        this.editorPane.setEditable(false);
        JScrollPane jScrollPane = new JScrollPane(this.editorPane);
        jScrollPane.setVerticalScrollBarPolicy(22);
        jScrollPane.setPreferredSize(new Dimension(600, 400));
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)jScrollPane, "Center");
        this.setContentPane(jPanel);
        this.editorPane.addMouseListener(this);
    }

    protected void print(String string) {
        this.contenu = this.contenu + string;
    }

    protected void println(String string) {
        this.contenu = this.contenu + string + "\n";
    }

    protected String getTargetNamespace() {
        try {
            String string;
            DOMParser dOMParser = new DOMParser();
            String string2 = this.fichierSchema.toURL().toString();
            dOMParser.parse(string2);
            Element element = dOMParser.getDocument().getDocumentElement();
            if (!"schema".equals(element.getLocalName())) {
                System.err.println("la racine du sch\u00e9ma n'est pas schema ?!?");
            }
            if ("".equals(string = element.getAttribute("targetNamespace"))) {
                return null;
            }
            return string;
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            return null;
        }
    }

    public void miseAJour() {
        String string = this.fichierXML.getPath();
        String string2 = null;
        if (this.fichierSchema != null) {
            string2 = this.fichierSchema.getAbsolutePath();
        }
        this.contenu = "";
        this.erreurs = new ArrayList();
        boolean[] blArray = new boolean[1];
        try {
            Object object;
            DOMParser dOMParser = new DOMParser();
            blArray[0] = false;
            ErrorStorer errorStorer = new ErrorStorer(blArray);
            dOMParser.setErrorHandler(errorStorer);
            dOMParser.setFeature("http://apache.org/xml/features/allow-java-encodings", true);
            dOMParser.setFeature("http://xml.org/sax/features/validation", true);
            dOMParser.setFeature("http://apache.org/xml/features/continue-after-fatal-error", true);
            if (this.fichierSchema != null) {
                while (string2.indexOf(32) != -1) {
                    int n = string2.indexOf(32);
                    string2 = string2.substring(0, n) + "%20" + string2.substring(n + 1);
                }
                object = this.getTargetNamespace();
                if (object == null || "".equals(object)) {
                    dOMParser.setProperty("http://apache.org/xml/properties/schema/external-schemaLocation", "anyURI " + string2);
                    dOMParser.setProperty("http://apache.org/xml/properties/schema/external-noNamespaceSchemaLocation", string2);
                } else {
                    dOMParser.setProperty("http://apache.org/xml/properties/schema/external-schemaLocation", (String)object + " " + string2);
                }
            }
            dOMParser.parse(string);
            object = dOMParser.getDocument();
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            return;
        }
        if (!blArray[0]) {
            this.print("Ce fichier est parfait !");
        }
        this.editorPane.setText(this.contenu);
        this.setVisible(true);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.miseAJour();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        int n = this.editorPane.viewToModel(mouseEvent.getPoint());
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        for (int i = 0; i < this.erreurs.size(); ++i) {
            Erreur erreur = (Erreur)this.erreurs.get(i);
            if (erreur.p1 > n) {
                n3 = erreur.p1;
                break;
            }
            n2 = erreur.p1;
            n4 = erreur.ligne;
        }
        if (n3 == 0) {
            n3 = this.contenu.length();
        }
        this.editorPane.setCaretPosition(n2);
        this.editorPane.moveCaretPosition(n3);
        this.sourceFrame.selectLigne(n4);
        this.sourceFrame.toFront();
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    class Erreur {
        public int ligne;
        public int p1;

        public Erreur(int n, int n2) {
            this.ligne = n;
            this.p1 = n2;
        }
    }

    class ErrorStorer
    implements ErrorHandler {
        boolean[] terreur;

        public ErrorStorer(boolean[] blArray) {
            this.terreur = blArray;
        }

        public void warning(SAXParseException sAXParseException) {
            this.handleError(sAXParseException, "Warning");
        }

        public void error(SAXParseException sAXParseException) {
            this.handleError(sAXParseException, "Error");
        }

        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            this.handleError(sAXParseException, "Fatal error");
        }

        private void handleError(SAXParseException sAXParseException, String string) {
            FenetreValidation.this.erreurs.add(new Erreur(sAXParseException.getLineNumber(), FenetreValidation.this.contenu.length()));
            this.terreur[0] = true;
            FenetreValidation.this.println(string + "  at line number " + sAXParseException.getLineNumber() + ": ");
            FenetreValidation.this.println(sAXParseException.getMessage() + "\n");
        }
    }
}

