/*
 * Decompiled with CFR 0.152.
 */
package mex;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.text.TabSet;
import javax.swing.text.TabStop;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;
import mex.DialogueRechercher;
import mex.DocumentRenderer;
import mex.FenetreValidation;
import mex.Mex;

public class FenetreSource
extends JFrame
implements ActionListener {
    private File fichierXML;
    private JTextPane zoneTexte;
    private StyledDocument doc;
    private String encodage = "ISO-8859-1";
    private FenetreValidation fvalidation;
    private boolean modif;
    private UndoManager undoMgr;
    private Style styleElement;
    private Style styleNomAttribut;
    private Style styleValeurAttribut;
    private Style styleTexte;
    private Style styleEntite;
    private Style styleCommentaire;
    private int poscol;
    private int fincol;
    private boolean ignorerModifs;
    private JMenuItem menuAnnuler;
    private JMenuItem menuRetablir;

    public FenetreSource() {
        super("Sans Titre");
        this.initFenetre();
        this.fichierXML = null;
        this.nouveau();
    }

    public FenetreSource(File file) {
        this.initFenetre();
        this.ouvrir(file);
    }

    public void nouveau() {
        this.fichierXML = null;
        this.zoneTexte.setText("");
        this.modif = false;
        this.ignorerModifs = false;
        this.setVisible(true);
        this.zoneTexte.requestFocus();
    }

    protected void changementDoc() {
        boolean bl = this.ignorerModifs;
        this.ignorerModifs = true;
        this.undoMgr = new UndoManager();
        this.doc.addUndoableEditListener(new MonEcouteurDAnnulations());
        this.doc.addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                if (!FenetreSource.this.ignorerModifs) {
                    FenetreSource.this.majCouleurs(documentEvent.getOffset(), documentEvent.getLength());
                }
                if (documentEvent.getLength() == 1) {
                    try {
                        int n = documentEvent.getOffset();
                        String string = FenetreSource.this.zoneTexte.getText(n, 1);
                        if ("\n".equals(string)) {
                            SwingUtilities.invokeLater(new AjoutIndentation(n));
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        System.err.println("BadLocationException: " + badLocationException.getMessage());
                    }
                }
                FenetreSource.this.modif = true;
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                if (!FenetreSource.this.ignorerModifs) {
                    FenetreSource.this.majCouleurs(documentEvent.getOffset(), documentEvent.getLength());
                }
                FenetreSource.this.modif = true;
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                if (!FenetreSource.this.ignorerModifs) {
                    FenetreSource.this.majCouleurs(documentEvent.getOffset(), documentEvent.getLength());
                }
                FenetreSource.this.modif = true;
            }
        });
        String[] stringArray = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        boolean bl2 = false;
        for (int i = 0; i < stringArray.length; ++i) {
            if (!"Monaco".equals(stringArray[i])) continue;
            bl2 = true;
            break;
        }
        if (bl2) {
            Style style = this.zoneTexte.getStyle("default");
            StyleConstants.setFontFamily(style, "Monaco");
            StyleConstants.setFontSize(style, 12);
            this.zoneTexte.setFont(new Font("Monaco", 0, 12));
        }
        this.setTabs(4);
        this.ignorerModifs = bl;
    }

    protected void initFenetre() {
        this.setDefaultCloseOperation(0);
        this.zoneTexte = new JTextPane();
        this.doc = this.zoneTexte.getStyledDocument();
        this.changementDoc();
        Style style = this.zoneTexte.getStyle("default");
        this.styleTexte = this.zoneTexte.addStyle(null, style);
        StyleConstants.setForeground(this.styleTexte, Color.black);
        this.styleElement = this.zoneTexte.addStyle(null, style);
        StyleConstants.setForeground(this.styleElement, new Color(150, 0, 0));
        this.styleNomAttribut = this.zoneTexte.addStyle(null, style);
        StyleConstants.setForeground(this.styleNomAttribut, new Color(0, 0, 150));
        this.styleValeurAttribut = this.zoneTexte.addStyle(null, style);
        StyleConstants.setForeground(this.styleValeurAttribut, new Color(0, 100, 0));
        this.styleEntite = this.zoneTexte.addStyle(null, style);
        StyleConstants.setForeground(this.styleEntite, new Color(0, 100, 100));
        this.styleCommentaire = this.zoneTexte.addStyle(null, style);
        StyleConstants.setForeground(this.styleCommentaire, Color.gray);
        JScrollPane jScrollPane = new JScrollPane(this.zoneTexte);
        jScrollPane.setVerticalScrollBarPolicy(22);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout());
        JButton jButton = new JButton("Valider");
        jButton.setActionCommand("valider");
        int n = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        this.zoneTexte.getInputMap().put(KeyStroke.getKeyStroke(75, n), "valider");
        this.zoneTexte.getActionMap().put("valider", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                FenetreSource.this.valider();
            }
        });
        this.zoneTexte.getInputMap().put(KeyStroke.getKeyStroke(9, 0), "tabulation");
        this.zoneTexte.getInputMap().put(KeyStroke.getKeyStroke(9, 1), "shifttab");
        this.zoneTexte.getActionMap().put("tabulation", new ActionTab(false));
        this.zoneTexte.getActionMap().put("shifttab", new ActionTab(true));
        jButton.addActionListener(this);
        jPanel.add(jButton);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)jScrollPane, "Center");
        jPanel2.add((Component)jPanel, "South");
        this.setContentPane(jPanel2);
        this.initMenus();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                Mex.fermer(FenetreSource.this);
            }
        });
        int n2 = Mex.nombreFenetres();
        this.setLocation(50 + n2 * 20, 50 + n2 * 20);
        Dimension dimension = new Dimension(600, 700);
        Dimension dimension2 = this.getToolkit().getScreenSize();
        if (dimension2.height < dimension.height + 100) {
            dimension.height = dimension2.height - 100;
        }
        if (dimension2.width < dimension.width + 100) {
            dimension.width = dimension2.width - 100;
        }
        this.setSize(dimension);
    }

    protected JMenuItem ajouterMenu(JMenu jMenu, String string, String string2, int n) {
        JMenuItem jMenuItem = new JMenuItem(string);
        if (n != 0) {
            int n2 = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
            jMenuItem.setAccelerator(KeyStroke.getKeyStroke(n, n2));
        }
        jMenuItem.addActionListener(this);
        jMenuItem.setActionCommand(string2);
        jMenu.add(jMenuItem).setEnabled(true);
        return jMenuItem;
    }

    protected void initMenus() {
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("Fichier");
        this.ajouterMenu(jMenu, "Nouveau", "nouveau", 78);
        this.ajouterMenu(jMenu, "Ouvrir...", "ouvrir", 79);
        jMenu.addSeparator();
        this.ajouterMenu(jMenu, "Fermer", "fermer", 87);
        this.ajouterMenu(jMenu, "Enregistrer", "enregistrer", 83);
        this.ajouterMenu(jMenu, "Enregistrer Sous...", "enregistrerSous", 0);
        jMenu.addSeparator();
        this.ajouterMenu(jMenu, "Imprimer...", "imprimer", 80);
        if (!System.getProperty("os.name").startsWith("Mac")) {
            jMenu.addSeparator();
            this.ajouterMenu(jMenu, "Quitter", "quitter", 81);
        }
        jMenuBar.add(jMenu);
        JMenu jMenu2 = new JMenu("Edition");
        this.menuAnnuler = this.ajouterMenu(jMenu2, "Annuler", "annuler", 90);
        this.menuAnnuler.setEnabled(false);
        this.menuRetablir = this.ajouterMenu(jMenu2, "R\u00e9tablir", "retablir", 82);
        this.menuRetablir.setEnabled(false);
        jMenu2.addSeparator();
        this.ajouterMenu(jMenu2, "Couper", "couper", 88);
        this.ajouterMenu(jMenu2, "Copier", "copier", 67);
        this.ajouterMenu(jMenu2, "Coller", "coller", 86);
        jMenu2.addSeparator();
        this.ajouterMenu(jMenu2, "Rechercher", "rechercher", 70);
        jMenuBar.add(jMenu2);
        this.setJMenuBar(jMenuBar);
    }

    protected File dialogueOuvrir() {
        FileDialog fileDialog = new FileDialog((Frame)this, "Choisir le fichier XML", 0);
        fileDialog.show();
        String string = null;
        String string2 = fileDialog.getDirectory();
        if (string2 != null && string2.endsWith(File.separator)) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        String string3 = fileDialog.getFile();
        if (string2 == null) {
            string = string3;
        } else if (string3 != null) {
            string = string2 + File.separator + string3;
        }
        if (string != null) {
            return new File(string);
        }
        return null;
    }

    protected void detecterEncodage(String string) {
        if (string != null && string.startsWith("<?xml ")) {
            int n = string.indexOf("encoding");
            if (n == -1) {
                return;
            }
            string = string.substring(n);
            n = string.indexOf(34);
            int n2 = string.indexOf(39);
            int n3 = 34;
            if (n == -1 && n2 != -1) {
                n = n2;
                n3 = 39;
            }
            if (n == -1) {
                return;
            }
            n2 = string.substring(n + 1).indexOf(n3);
            if (n2 == -1) {
                return;
            }
            this.encodage = string.substring(n + 1, n2 + n + 1);
        }
    }

    protected void detecterEncodage(File file) {
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            String string = bufferedReader.readLine();
            if (string != null) {
                this.detecterEncodage(string);
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            System.err.println("IOException: " + iOException.getMessage());
        }
    }

    protected void detecterEncodage() {
        Element element = this.doc.getParagraphElement(0);
        int n = element.getStartOffset();
        int n2 = element.getEndOffset();
        try {
            String string = this.zoneTexte.getText(n, n2 - n);
            this.detecterEncodage(string);
        }
        catch (BadLocationException badLocationException) {
            System.err.println("BadLocationException: " + badLocationException.getMessage());
        }
    }

    public void ouvrir(File file) {
        Object object;
        if (file == null) {
            object = this.dialogueOuvrir();
            if (object == null) {
                return;
            }
            if (((File)object).equals(this.fichierXML)) {
                return;
            }
            file = object;
            if (this.doc.getLength() > 0) {
                Mex.ouvrir(file);
                return;
            }
        }
        this.fichierXML = file;
        this.ignorerModifs = true;
        this.detecterEncodage(file);
        try {
            object = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), this.encodage));
            this.zoneTexte.read((Reader)object, null);
        }
        catch (IOException iOException) {
            this.ignorerModifs = false;
            System.err.println("IOException: " + iOException.getMessage());
            return;
        }
        this.doc = this.zoneTexte.getStyledDocument();
        this.changementDoc();
        this.toutColorier();
        this.setTitle(file.getName());
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                FenetreSource.this.ignorerModifs = false;
                FenetreSource.this.modif = false;
            }
        });
        this.setVisible(true);
        this.zoneTexte.requestFocus();
    }

    public void colorier(int n, int n2) {
        int n3;
        boolean bl = this.ignorerModifs;
        this.ignorerModifs = true;
        Buffer buffer = new Buffer();
        if (buffer.subEquals("\n", n)) {
            if (n2 - n > 1) {
                this.doc.setCharacterAttributes(n + 1, n2 - n - 1, this.styleTexte, false);
            }
        } else {
            this.doc.setCharacterAttributes(n, n2 - n, this.styleTexte, false);
        }
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        char c = '\"';
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        int n4 = n;
        for (n3 = n; n3 < n2; ++n3) {
            char c2;
            if (bl7) {
                if (!buffer.subEquals("-->", n3)) continue;
                bl7 = false;
                this.doc.setCharacterAttributes(n4, (n3 += 2) - n4 + 1, this.styleCommentaire, false);
                continue;
            }
            if (bl2) {
                c2 = buffer.getChar(n3);
                if (c2 == ' ' || c2 == '\n') {
                    bl2 = false;
                    this.doc.setCharacterAttributes(n4, n3 - n4, this.styleElement, false);
                    bl3 = true;
                    n4 = n3 + 1;
                    continue;
                }
                if (c2 != '>' && n3 != n2 - 1) continue;
                bl2 = false;
                this.doc.setCharacterAttributes(n4, n3 - n4 + 1, this.styleElement, false);
                continue;
            }
            if (bl3) {
                c2 = buffer.getChar(n3);
                if (c2 == '>' || n3 == n2 - 1) {
                    bl3 = false;
                    this.doc.setCharacterAttributes(n4, n3 - n4 + 1, this.styleElement, false);
                    continue;
                }
                if (c2 != '=') continue;
                bl3 = false;
                this.doc.setCharacterAttributes(n4, n3 - n4, this.styleNomAttribut, false);
                bl4 = true;
                continue;
            }
            if (bl4) {
                c2 = buffer.getChar(n3);
                if (c2 != '\"' && c2 != '\'') continue;
                bl4 = false;
                bl5 = true;
                c = c2;
                n4 = n3;
                continue;
            }
            if (bl5) {
                c2 = buffer.getChar(n3);
                if (c2 != c && n3 != n2 - 1) continue;
                bl5 = false;
                this.doc.setCharacterAttributes(n4, n3 - n4 + 1, this.styleValeurAttribut, false);
                bl3 = true;
                n4 = n3 + 1;
                continue;
            }
            if (bl6) {
                c2 = buffer.getChar(n3);
                if (c2 != ';' && c2 != ' ' && c2 != '\n' && n3 != n2 - 1) continue;
                bl6 = false;
                this.doc.setCharacterAttributes(n4, n3 - n4 + 1, this.styleEntite, false);
                continue;
            }
            c2 = buffer.getChar(n3);
            if (c2 == '<') {
                if (buffer.subEquals("<!--", n3)) {
                    bl7 = true;
                } else {
                    bl2 = true;
                }
                n4 = n3;
                continue;
            }
            if (c2 == '>') {
                this.doc.setCharacterAttributes(n3, 1, this.styleElement, false);
                continue;
            }
            if (c2 != '&' && c2 != '%') continue;
            bl6 = true;
            n4 = n3;
        }
        if (bl7) {
            for (n3 = n2; n3 < this.doc.getLength() && bl7; ++n3) {
                if (!buffer.subEquals("-->", n3)) continue;
                bl7 = false;
                this.doc.setCharacterAttributes(n4, (n3 += 2) - n4 + 1, this.styleCommentaire, false);
            }
            if (bl7) {
                this.doc.setCharacterAttributes(n4, this.doc.getLength() - n4, this.styleCommentaire, false);
            }
        }
        this.ignorerModifs = bl;
    }

    protected int debutMajCouleurs(int n) {
        Buffer buffer = new Buffer();
        Element element = this.doc.getCharacterElement(n);
        boolean bl = element.getAttributes().containsAttributes(this.styleCommentaire);
        if (!bl && n > 2 && n < this.doc.getLength() && (element = this.doc.getCharacterElement(n - 1)).getAttributes().containsAttributes(this.styleCommentaire) && !buffer.subEquals("-->", n - 3)) {
            bl = true;
        }
        if (bl) {
            for (int i = n; i >= 0; --i) {
                if (!buffer.subEquals("<!--", i)) continue;
                return i;
            }
        } else {
            for (int i = n; i >= 0; --i) {
                char c = buffer.getChar(i);
                if (c == '<') {
                    return i;
                }
                if (c != '>' || i >= n) continue;
                return i + 1;
            }
        }
        return 0;
    }

    protected int finMajCouleurs(int n) {
        if (n == 0) {
            return n;
        }
        Buffer buffer = new Buffer();
        Element element = this.doc.getCharacterElement(n - 1);
        if (element.getAttributes().containsAttributes(this.styleCommentaire)) {
            for (int i = n; i < this.doc.getLength(); ++i) {
                if (!buffer.subEquals("-->", i)) continue;
                return i + 3;
            }
        } else {
            for (int i = n; i < this.doc.getLength(); ++i) {
                char c = buffer.getChar(i);
                if (c != '>') continue;
                return i + 1;
            }
        }
        return this.doc.getLength();
    }

    protected void majCouleurs(int n, int n2) {
        this.poscol = this.debutMajCouleurs(n);
        this.fincol = this.finMajCouleurs(n + n2);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                FenetreSource.this.colorier(FenetreSource.this.poscol, FenetreSource.this.fincol);
            }
        });
    }

    public void toutColorier() {
        this.colorier(0, this.doc.getLength() - 1);
    }

    public boolean testEnregistrerAvant() {
        if (this.modif) {
            int n = JOptionPane.showConfirmDialog(this, "Enregistrer avant ?", "", 1);
            if (n == 0) {
                this.enregistrer(this.fichierXML);
            }
            return n != 2;
        }
        return true;
    }

    public boolean estVide() {
        return this.doc != null && this.doc.getLength() == 0;
    }

    public File fichierCorrespondant() {
        return this.fichierXML;
    }

    protected File dialogueEnregistrement() {
        FileDialog fileDialog = new FileDialog((Frame)this, null, 1);
        fileDialog.show();
        String string = fileDialog.getFile();
        if (string == null) {
            return null;
        }
        File file = new File(fileDialog.getDirectory(), string);
        if (file.getName().indexOf(46) == -1 && (file = new File(file.getPath() + ".xml")).exists() && JOptionPane.showConfirmDialog(this, "Ce fichier existe d\u00e9j\u00e0. Le remplacer ?", "", 0) == 1) {
            return null;
        }
        if (this.fvalidation != null) {
            this.fvalidation.setVisible(false);
            this.fvalidation = null;
        }
        return file;
    }

    public void enregistrer(File file) {
        BufferedWriter bufferedWriter;
        if (file == null) {
            file = this.dialogueEnregistrement();
        }
        if (file == null) {
            return;
        }
        this.detecterEncodage();
        try {
            bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), this.encodage));
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, exception.getLocalizedMessage(), "Enregistrement", 0);
            return;
        }
        try {
            this.zoneTexte.write(bufferedWriter);
            ((Writer)bufferedWriter).close();
            this.modif = false;
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(this, iOException.getLocalizedMessage(), "Erreur d'entr\u00e9e/sortie", 0);
        }
        this.fichierXML = file;
        this.setTitle(this.fichierXML.getName());
    }

    public void enregistrerSous() {
        File file = this.dialogueEnregistrement();
        if (file == null) {
            return;
        }
        this.enregistrer(file);
    }

    public void imprimer() {
        DocumentRenderer documentRenderer = new DocumentRenderer();
        documentRenderer.print(this.zoneTexte);
    }

    protected void majMenusAnnulation() {
        this.menuAnnuler.setEnabled(this.undoMgr.canUndo());
        this.menuRetablir.setEnabled(this.undoMgr.canRedo());
    }

    public void annuler() {
        try {
            this.undoMgr.undo();
        }
        catch (CannotUndoException cannotUndoException) {
            JOptionPane.showMessageDialog(this, "Impossible d'annuler: " + cannotUndoException.getLocalizedMessage(), "Annulation", 0);
        }
        this.majMenusAnnulation();
    }

    public void retablir() {
        try {
            this.undoMgr.redo();
        }
        catch (CannotRedoException cannotRedoException) {
            JOptionPane.showMessageDialog(this, "Impossible de r\u00e9tablir: " + cannotRedoException.getLocalizedMessage(), "R\u00e9tablir", 0);
        }
        this.majMenusAnnulation();
    }

    public void rechercher() {
        DialogueRechercher dialogueRechercher = new DialogueRechercher(this.zoneTexte);
        dialogueRechercher.show();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if ("valider".equals(string)) {
            this.valider();
        } else if ("nouveau".equals(string)) {
            Mex.nouveau();
        } else if ("ouvrir".equals(string)) {
            this.ouvrir(null);
        } else if ("fermer".equals(string)) {
            Mex.fermer(this);
        } else if ("enregistrer".equals(string)) {
            this.enregistrer(this.fichierXML);
        } else if ("enregistrerSous".equals(string)) {
            this.enregistrerSous();
        } else if ("imprimer".equals(string)) {
            this.imprimer();
        } else if ("quitter".equals(string)) {
            Mex.quitter(true);
        } else if ("annuler".equals(string)) {
            this.annuler();
        } else if ("retablir".equals(string)) {
            this.retablir();
        } else if ("couper".equals(string)) {
            this.zoneTexte.cut();
        } else if ("copier".equals(string)) {
            this.zoneTexte.copy();
        } else if ("coller".equals(string)) {
            this.zoneTexte.paste();
        } else if ("rechercher".equals(string)) {
            this.rechercher();
        }
    }

    public void allerLigne(int n) {
        n = n > 0 ? --n : 0;
        int n2 = this.doc.getDefaultRootElement().getElement(n).getStartOffset();
        try {
            this.zoneTexte.scrollRectToVisible(this.zoneTexte.modelToView(this.doc.getLength()));
            this.zoneTexte.scrollRectToVisible(this.zoneTexte.modelToView(n2));
        }
        catch (BadLocationException badLocationException) {
            System.err.println(badLocationException.getClass().getName() + " " + badLocationException.getLocalizedMessage());
        }
    }

    public void selectLigne(int n) {
        n = n > 0 ? --n : 0;
        Element element = this.doc.getDefaultRootElement().getElement(n);
        try {
            this.zoneTexte.scrollRectToVisible(this.zoneTexte.modelToView(element.getStartOffset()));
        }
        catch (BadLocationException badLocationException) {
            System.err.println(badLocationException.getClass().getName() + " " + badLocationException.getLocalizedMessage());
        }
        this.zoneTexte.setCaretPosition(element.getStartOffset());
        if (element.getEndOffset() <= this.doc.getLength()) {
            this.zoneTexte.moveCaretPosition(element.getEndOffset());
        } else {
            this.zoneTexte.moveCaretPosition(this.doc.getLength());
        }
        this.zoneTexte.requestFocus();
    }

    public void valider() {
        if (!this.testEnregistrerAvant()) {
            return;
        }
        if (this.fvalidation == null) {
            this.fvalidation = new FenetreValidation(this.fichierXML, this);
        } else {
            this.fvalidation.miseAJour();
        }
    }

    public void setTabs(int n) {
        FontMetrics fontMetrics = this.zoneTexte.getFontMetrics(this.zoneTexte.getFont());
        int n2 = fontMetrics.charWidth('w');
        int n3 = n2 * n;
        TabStop[] tabStopArray = new TabStop[10];
        for (int i = 0; i < tabStopArray.length; ++i) {
            int n4 = i + 1;
            tabStopArray[i] = new TabStop(n4 * n3);
        }
        TabSet tabSet = new TabSet(tabStopArray);
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        StyleConstants.setTabSet(simpleAttributeSet, tabSet);
        int n5 = this.doc.getLength();
        this.doc.setParagraphAttributes(0, n5, simpleAttributeSet, false);
    }

    protected class MonEcouteurDAnnulations
    implements UndoableEditListener {
        protected MonEcouteurDAnnulations() {
        }

        public void undoableEditHappened(UndoableEditEvent undoableEditEvent) {
            if (!FenetreSource.this.ignorerModifs) {
                FenetreSource.this.undoMgr.addEdit(new MyEdit(undoableEditEvent.getEdit()));
                FenetreSource.this.majMenusAnnulation();
            }
        }
    }

    protected class MyEdit
    extends AbstractUndoableEdit {
        public static final int ERREUR = 0;
        public static final int AJOUTER = 1;
        public static final int SUPPRIMER = 2;
        private int type;
        private int offset;
        private int length;
        private Vector edits = new Vector();

        public MyEdit(UndoableEdit undoableEdit) {
            if (undoableEdit instanceof AbstractDocument.DefaultDocumentEvent) {
                AbstractDocument.DefaultDocumentEvent defaultDocumentEvent = (AbstractDocument.DefaultDocumentEvent)undoableEdit;
                this.type = defaultDocumentEvent.getType() == DocumentEvent.EventType.INSERT ? 1 : (defaultDocumentEvent.getType() == DocumentEvent.EventType.REMOVE ? 2 : 0);
                this.offset = defaultDocumentEvent.getOffset();
                this.length = defaultDocumentEvent.getLength();
            } else {
                this.type = 0;
            }
            this.edits.add(undoableEdit);
        }

        public boolean addEdit(UndoableEdit undoableEdit) {
            MyEdit myEdit = (MyEdit)undoableEdit;
            if (this.type == 1 && myEdit.getOffset() == this.offset + this.length || this.type == 2 && myEdit.getOffset() == this.offset) {
                this.edits.add(myEdit.getEvent());
                this.length += myEdit.getLength();
                return true;
            }
            if (this.type == 1 && myEdit.getOffset() == this.offset || this.type == 2 && myEdit.getOffset() == this.offset - myEdit.getLength()) {
                this.edits.add(myEdit.getEvent());
                this.length += myEdit.getLength();
                this.offset -= myEdit.getLength();
                return true;
            }
            return false;
        }

        public AbstractDocument.DefaultDocumentEvent getEvent() {
            if (this.edits.size() == 1) {
                return (AbstractDocument.DefaultDocumentEvent)this.edits.get(0);
            }
            return null;
        }

        public int getType() {
            return this.type;
        }

        public int getOffset() {
            return this.offset;
        }

        public int getLength() {
            return this.length;
        }

        public void undo() throws CannotUndoException {
            super.undo();
            int n = this.edits.size();
            while (n-- > 0) {
                UndoableEdit undoableEdit = (UndoableEdit)this.edits.elementAt(n);
                undoableEdit.undo();
            }
        }

        public void redo() throws CannotRedoException {
            super.redo();
            Enumeration enumeration = this.edits.elements();
            while (enumeration.hasMoreElements()) {
                ((UndoableEdit)enumeration.nextElement()).redo();
            }
        }

        public boolean canUndo() {
            int n = this.edits.size();
            if (n > 0) {
                return ((UndoableEdit)this.edits.elementAt(n - 1)).canUndo();
            }
            return false;
        }

        public boolean canRedo() {
            int n = this.edits.size();
            if (n > 0) {
                return ((UndoableEdit)this.edits.elementAt(0)).canRedo();
            }
            return false;
        }
    }

    class Buffer {
        int tailleMax = 200;
        String sbuff;
        int debut;
        int fin;

        public Buffer() {
            this.lire(0);
        }

        public void lire(int n) {
            int n2 = this.tailleMax;
            if (n + n2 > FenetreSource.this.doc.getLength()) {
                n2 = FenetreSource.this.doc.getLength() - n;
            }
            try {
                this.sbuff = FenetreSource.this.doc.getText(n, n2);
            }
            catch (BadLocationException badLocationException) {
                System.err.println("BadLocationException: " + badLocationException.getMessage());
            }
            if (this.sbuff.length() != n2) {
                System.err.println("erreur: " + this.sbuff.length() + " != " + n2);
            }
            this.debut = n;
            this.fin = n + n2;
        }

        public char getChar(int n) {
            if (n >= FenetreSource.this.doc.getLength()) {
                return ' ';
            }
            if (n >= this.fin) {
                this.lire(n);
            } else if (n < this.debut) {
                int n2 = n - this.tailleMax + 1;
                if (n2 < 0) {
                    n2 = 0;
                }
                this.lire(n2);
            }
            return this.sbuff.charAt(n - this.debut);
        }

        public boolean subEquals(String string, int n) {
            int n2;
            if (n >= FenetreSource.this.doc.getLength()) {
                System.err.println("erreur dans Buffer.subEquals: ind >= doc.getLength() : " + n + " >= " + FenetreSource.this.doc.getLength());
            }
            if (n + (n2 = string.length()) >= FenetreSource.this.doc.getLength()) {
                return false;
            }
            if (n2 > this.tailleMax) {
                System.err.println("erreur dans Buffer.subEquals: " + n2 + " > taille maxi (" + this.tailleMax + ")");
            }
            if (n < this.debut || n + n2 > this.fin) {
                this.lire(n);
            }
            int n3 = 0;
            int n4 = n - this.debut;
            while (n3 < n2) {
                if (string.charAt(n3) != this.sbuff.charAt(n4)) {
                    return false;
                }
                ++n3;
                ++n4;
            }
            return true;
        }
    }

    class ActionTab
    extends AbstractAction {
        boolean shift;

        public ActionTab(boolean bl) {
            this.shift = bl;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = FenetreSource.this.zoneTexte.getSelectionStart();
            int n2 = FenetreSource.this.zoneTexte.getSelectionEnd();
            String string = null;
            try {
                if (Math.abs(n2 - n) > 0) {
                    if (n2 < n) {
                        int n3 = n2;
                        n2 = n;
                        n = n3;
                    }
                    string = FenetreSource.this.zoneTexte.getText(n, n2 - n);
                }
            }
            catch (BadLocationException badLocationException) {
                System.err.println("BadLocationException: " + badLocationException.getMessage());
            }
            String string2 = string == null || string.indexOf(10) == -1 || string.indexOf(9) != -1 || string.length() < 1 || string.charAt(0) != ' ' ? "\t" : "    ";
            if (string != null && string.indexOf(10) != -1) {
                if (!this.shift) {
                    string = string2 + string;
                    for (int i = 0; i < string.length() - 1; ++i) {
                        if (string.charAt(i) != '\n') continue;
                        string = string.substring(0, i + 1) + string2 + string.substring(i + 1);
                        i += string2.length();
                    }
                } else {
                    if (string.startsWith(string2)) {
                        string = string.substring(string2.length());
                    }
                    for (int i = 0; i < string.length() - 1 - string2.length(); ++i) {
                        if (string.charAt(i) != '\n' || !string.substring(i + 1).startsWith(string2)) continue;
                        string = string.substring(0, i + 1) + string.substring(i + 1 + string2.length());
                    }
                }
                FenetreSource.this.zoneTexte.replaceSelection(string);
                FenetreSource.this.zoneTexte.select(n, n + string.length());
            } else {
                FenetreSource.this.zoneTexte.replaceSelection(string2);
            }
        }
    }

    class AjoutIndentation
    implements Runnable {
        int pos;

        public AjoutIndentation(int n) {
            this.pos = n;
        }

        public void run() {
            Element element = FenetreSource.this.doc.getParagraphElement(this.pos - 1);
            int n = element.getStartOffset();
            int n2 = element.getEndOffset();
            try {
                int n3;
                String string = FenetreSource.this.zoneTexte.getText(n, n2 - n);
                if (string.length() > 0 && string.charAt(string.length() - 1) == '\n') {
                    string = string.substring(0, string.length() - 1);
                }
                if ((n3 = (string = string + '*').indexOf(string.trim())) > 0) {
                    FenetreSource.this.doc.insertString(this.pos + 1, string.substring(0, n3), null);
                }
            }
            catch (BadLocationException badLocationException) {
                System.err.println("BadLocationException: " + badLocationException.getMessage());
            }
        }
    }
}

