/*
 * Decompiled with CFR 0.152.
 */
package mex;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.StyledDocument;

public class DialogueRechercher
extends JDialog
implements ActionListener,
ItemListener {
    private JTextPane textPane;
    private StyledDocument doc;
    private JTextField tfRechercher;
    private JTextField tfRemplacer;
    private boolean dansSelection = false;
    private boolean ignorerCasse = false;
    private String texteRecherche = null;

    public DialogueRechercher(JTextPane jTextPane) {
        super((JFrame)jTextPane.getTopLevelAncestor(), "Rechercher", true);
        this.textPane = jTextPane;
        this.doc = jTextPane.getStyledDocument();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        this.setContentPane(jPanel);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        JPanel jPanel3 = new JPanel(new GridLayout(2, 1));
        jPanel3.add(new JLabel("Rechercher"));
        jPanel3.add(new JLabel("Remplacer par:"));
        jPanel3.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        JPanel jPanel4 = new JPanel(new GridLayout(2, 1));
        this.tfRechercher = new JTextField("", 40);
        this.tfRechercher.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 27) {
                    DialogueRechercher.this.setVisible(false);
                }
            }
        });
        jPanel4.add(this.tfRechercher);
        this.tfRemplacer = new JTextField("", 40);
        this.tfRemplacer.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 27) {
                    DialogueRechercher.this.setVisible(false);
                }
            }
        });
        jPanel4.add(this.tfRemplacer);
        jPanel2.add((Component)jPanel3, "Center");
        jPanel2.add((Component)jPanel4, "East");
        jPanel.add(jPanel2);
        JPanel jPanel5 = new JPanel(new FlowLayout());
        JRadioButton jRadioButton = new JRadioButton("Fichier entier");
        jRadioButton.setActionCommand("fichier");
        jRadioButton.setSelected(true);
        JRadioButton jRadioButton2 = new JRadioButton("S\u00e9lection");
        jRadioButton2.setActionCommand("selection");
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton);
        buttonGroup.add(jRadioButton2);
        jRadioButton.addActionListener(this);
        jRadioButton2.addActionListener(this);
        jPanel5.add(jRadioButton);
        jPanel5.add(jRadioButton2);
        JCheckBox jCheckBox = new JCheckBox("Ignorer la casse");
        jCheckBox.addItemListener(this);
        jPanel5.add(jCheckBox);
        jPanel.add(jPanel5);
        JPanel jPanel6 = new JPanel(new FlowLayout());
        JButton jButton = new JButton("Tout remplacer");
        jButton.setActionCommand("tout");
        jButton.addActionListener(this);
        jPanel6.add(jButton);
        JButton jButton2 = new JButton("Remplacer");
        jButton2.setActionCommand("remplacer");
        jButton2.addActionListener(this);
        jPanel6.add(jButton2);
        JButton jButton3 = new JButton("Remplacer et rechercer");
        jButton3.setActionCommand("remplrech");
        jButton3.addActionListener(this);
        jPanel6.add(jButton3);
        JButton jButton4 = new JButton("Pr\u00e9c\u00e9dent");
        jButton4.setActionCommand("precedent");
        jButton4.addActionListener(this);
        jPanel6.add(jButton4);
        JButton jButton5 = new JButton("Suivant");
        jButton5.setActionCommand("suivant");
        jButton5.addActionListener(this);
        jPanel6.add(jButton5);
        jPanel.add(jPanel6);
        this.getRootPane().setDefaultButton(jButton5);
        this.pack();
        Rectangle rectangle = jTextPane.getTopLevelAncestor().getBounds();
        this.addWindowListener(new WindowAdapter(){
            boolean gotFocus = false;

            public void windowActivated(WindowEvent windowEvent) {
                if (!this.gotFocus) {
                    DialogueRechercher.this.tfRechercher.requestFocus();
                    this.gotFocus = true;
                }
            }
        });
        this.setLocation(rectangle.x + rectangle.width / 4, rectangle.y + rectangle.height / 4);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if ("suivant".equals(string)) {
            this.suivant();
        } else if ("precedent".equals(string)) {
            this.precedent();
        } else if ("remplacer".equals(string)) {
            this.remplacer();
        } else if ("tout".equals(string)) {
            this.toutRemplacer();
        } else if ("remplrech".equals(string)) {
            this.remplRech();
        } else if ("fichier".equals(string)) {
            this.dansSelection = false;
        } else if ("selection".equals(string)) {
            this.dansSelection = true;
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        this.ignorerCasse = itemEvent.getStateChange() == 1;
    }

    public void rechercher() {
        this.texteRecherche = this.tfRechercher.getText();
        if (this.texteRecherche == null || this.texteRecherche.length() == 0) {
            return;
        }
        int n = this.texteRecherche.length();
        int n2 = -1;
        try {
            for (int i = 0; i < this.doc.getLength() - n; ++i) {
                String string = this.doc.getText(i, n);
                if (!string.equals(this.texteRecherche)) continue;
                n2 = i;
                break;
            }
        }
        catch (BadLocationException badLocationException) {
            System.err.println("BadLocationException: " + badLocationException.getMessage());
            return;
        }
        if (n2 != -1) {
            this.textPane.setCaretPosition(n2);
            this.textPane.moveCaretPosition(n2 + n);
        } else {
            this.getToolkit().beep();
        }
    }

    public void suivant() {
        this.suivant(this.textPane.getSelectionStart());
    }

    public void suivant(int n) {
        this.texteRecherche = this.tfRechercher.getText();
        if (this.texteRecherche == null || this.texteRecherche.length() == 0) {
            return;
        }
        int n2 = this.texteRecherche.length();
        if (n2 >= this.doc.getLength()) {
            this.getToolkit().beep();
            return;
        }
        if (n + n2 > this.doc.getLength()) {
            n = 0;
        }
        try {
            if (this.doc.getText(n, n2).equals(this.texteRecherche) && this.textPane.getSelectionStart() == n && this.textPane.getSelectionEnd() == n + n2) {
                ++n;
            }
        }
        catch (BadLocationException badLocationException) {
            System.err.println("BadLocationException: " + badLocationException.getMessage());
            return;
        }
        int n3 = -1;
        try {
            for (int i = n; i < this.doc.getLength() - n2 + 1; ++i) {
                String string = this.doc.getText(i, n2);
                if ((this.ignorerCasse || !string.equals(this.texteRecherche)) && (!this.ignorerCasse || !string.equalsIgnoreCase(this.texteRecherche))) continue;
                n3 = i;
                break;
            }
        }
        catch (BadLocationException badLocationException) {
            System.err.println("BadLocationException: " + badLocationException.getMessage());
            return;
        }
        if (n3 != -1) {
            this.textPane.setCaretPosition(n3);
            this.textPane.moveCaretPosition(n3 + n2);
        } else if (n != 0) {
            this.suivant(0);
        } else {
            this.getToolkit().beep();
        }
    }

    public void precedent() {
        this.precedent(this.textPane.getSelectionStart());
    }

    public void precedent(int n) {
        this.texteRecherche = this.tfRechercher.getText();
        if (this.texteRecherche == null || this.texteRecherche.length() == 0) {
            return;
        }
        int n2 = this.texteRecherche.length();
        if (n2 >= this.doc.getLength()) {
            this.getToolkit().beep();
            return;
        }
        int n3 = -1;
        if (n + n2 > this.doc.getLength()) {
            n = this.doc.getLength() - n2;
        }
        if (n < 0) {
            n = 0;
        }
        try {
            if (this.doc.getText(n, n2).equals(this.texteRecherche) && this.textPane.getSelectionEnd() - this.textPane.getSelectionStart() == n2) {
                --n;
            }
        }
        catch (BadLocationException badLocationException) {
            System.err.println("BadLocationException: " + badLocationException.getMessage());
            return;
        }
        try {
            for (int i = n; i >= 0; --i) {
                String string = this.doc.getText(i, n2);
                if ((this.ignorerCasse || !string.equals(this.texteRecherche)) && (!this.ignorerCasse || !string.equalsIgnoreCase(this.texteRecherche))) continue;
                n3 = i;
                break;
            }
        }
        catch (BadLocationException badLocationException) {
            System.err.println("BadLocationException: " + badLocationException.getMessage());
            return;
        }
        if (n3 != -1) {
            this.textPane.setCaretPosition(n3);
            this.textPane.moveCaretPosition(n3 + n2);
        } else if (n != this.doc.getLength() - n2) {
            this.precedent(this.doc.getLength() - n2);
        } else {
            this.getToolkit().beep();
        }
    }

    public void remplacer() {
        String string = this.tfRemplacer.getText();
        if ("".equals(string)) {
            string = null;
        }
        if (this.textPane.getSelectionStart() == this.textPane.getSelectionEnd()) {
            return;
        }
        int n = this.textPane.getSelectionStart();
        int n2 = this.textPane.getSelectionEnd();
        try {
            if (n != n2) {
                this.doc.remove(n, n2 - n);
            }
            if (string != null) {
                this.doc.insertString(n, string, null);
            }
        }
        catch (BadLocationException badLocationException) {
            System.err.println("BadLocationException: " + badLocationException.getMessage());
            return;
        }
    }

    public void toutRemplacer() {
        int n;
        int n2;
        this.texteRecherche = this.tfRechercher.getText();
        if (this.texteRecherche == null || this.texteRecherche.length() == 0) {
            return;
        }
        String string = this.tfRemplacer.getText();
        if ("".equals(string)) {
            string = null;
        }
        int n3 = this.texteRecherche.length();
        int n4 = -1;
        if (this.dansSelection) {
            n2 = this.textPane.getSelectionStart();
            n = this.textPane.getSelectionEnd();
        } else {
            n2 = 0;
            n = this.doc.getLength() - n3;
        }
        try {
            for (int i = n2; i < n; ++i) {
                String string2 = this.doc.getText(i, n3);
                if ((this.ignorerCasse || !string2.equals(this.texteRecherche)) && (!this.ignorerCasse || !string2.equalsIgnoreCase(this.texteRecherche))) continue;
                n4 = i;
                this.doc.remove(i, n3);
                if (string != null) {
                    this.doc.insertString(i, string, null);
                }
                n = this.dansSelection ? this.textPane.getSelectionEnd() : this.doc.getLength() - n3;
            }
        }
        catch (BadLocationException badLocationException) {
            System.err.println("BadLocationException: " + badLocationException.getMessage());
            return;
        }
        if (n4 == -1) {
            this.getToolkit().beep();
        }
    }

    public void remplRech() {
        this.remplacer();
        this.suivant();
    }

    public String getTexteRecherche() {
        return this.texteRecherche;
    }
}

