<?xml version='1.0' encoding='ISO-8859-1'?>

<xsl:stylesheet version="2.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:u="http://www.uved.fr/schema/2.0"
    xmlns:imscp="http://www.imsglobal.org/xsd/imscp_v1p1"
    xmlns:lom="http://ltsc.ieee.org/xsd/LOM"
    xmlns:adlcp="http://www.adlnet.org/xsd/adlcp_v1p3"
    xmlns:imsss="http://www.imsglobal.org/xsd/imsss"
    xmlns:adlnav="http://www.adlnet.org/xsd/adlnav_v1p3"
    exclude-result-prefixes="u">
    
    <!-- ************************************************ -->
    <!--
        Cration de fichiers SCORM
        Il est impossible de faire des redirections multiples avec XSLTC et Xalan avec des output method diffrentes,
        du coup on ne peut pas inclure cette feuille de style dans UVED_LANCEUR
        et on doit la lancer  ct.
        Avec Jaxe, on rsoud le problme avec les transformations successives UVED_FUSION | UVED_SCORM | UVED_LANCEUR
    -->
    <!-- ************************************************ -->
    
    <xsl:output method="xml" indent="yes" encoding="ISO-8859-1"/>
    
    <xsl:include href="./UVED_OUTILS.xsl" />
    
    <!-- dclaration des variables globales -->
    <xsl:param name="chainEditPath"/>
    <xsl:param name="jaxe-fichier-xml"/>  <!-- chemin complet vers le fichier XML quand il est dit avec Jaxe -->

    <!-- sparateur de chemins ( / ou \ ) -->
    <xsl:variable name="sep"><xsl:choose>
        <xsl:when test="contains($jaxe-fichier-xml, '\')">\</xsl:when>
        <xsl:otherwise>/</xsl:otherwise>
    </xsl:choose></xsl:variable>
    <!-- chemin du rpertoire du fichier XML si jaxe-fichier-xml est utilis -->
    <xsl:variable name="chemin-jaxe-xml"><xsl:if test="$jaxe-fichier-xml!=''"><xsl:call-template name="repfichier"><xsl:with-param name="chemin" select="$jaxe-fichier-xml"/></xsl:call-template></xsl:if></xsl:variable>
    
    <xsl:variable name="racine"><xsl:choose>
        <xsl:when test="/u:UVED/u:CONTENUS">..</xsl:when>
        <xsl:otherwise>.</xsl:otherwise> <!-- dans le rpertoire courant s'il ne s'agit pas d'un site entier, contrairement  UVED 1.0 -->
    </xsl:choose></xsl:variable>
    <xsl:variable name="cheminSite"><xsl:choose>
        <xsl:when test="$jaxe-fichier-xml!=''"><xsl:value-of select="concat($chemin-jaxe-xml, $sep, translate($racine,'/',$sep), $sep, 'site', $sep, 'html', $sep)"/></xsl:when>
        <xsl:otherwise><xsl:value-of select="concat($chainEditPath, '../site/html/')"/></xsl:otherwise>
    </xsl:choose></xsl:variable>
    
    
    <xsl:template match="/">
        <xsl:call-template name="scorm-manifest"/>
        <xsl:apply-templates/>
    </xsl:template>
    
    <xsl:template match="@*|node()">
        <xsl:param name="dossier" select="$chemin-jaxe-xml"/>
        <xsl:copy>
            <xsl:apply-templates select="@*|node()">
               <xsl:with-param name="dossier" select="$dossier"/>
            </xsl:apply-templates>
        </xsl:copy>
    </xsl:template>
    
    <!-- Cration du fichier imsmanifest.xml. Le noeud courant doit tre la racine du document cr par UVED_FUSION. -->
    <xsl:template name="scorm-manifest">
        <xsl:call-template name="ecrireDansFichier">
            <xsl:with-param name="fichier" select="concat($cheminSite,'imsmanifest.xml')"/>
            <xsl:with-param name="contenu">
                <imscp:manifest identifier="id-manifeste">
                    <imscp:metadata>
                        <imscp:schema>ADL SCORM</imscp:schema>
                        <imscp:schemaversion>2004 3rd Edition</imscp:schemaversion>
                        <xsl:call-template name="lom"/>
                    </imscp:metadata>
                    <xsl:choose>
                        <xsl:when test="/u:UVED/u:CONTENUS/@niveauxOrg!='' and /u:UVED/u:CONTENUS/@niveauxOrg!='0'">
                            <imscp:organizations default="contenus">
                                <xsl:for-each select="/u:UVED/u:CONTENUS/u:SECTION">
                                    <xsl:call-template name="scorm-organization"/>
                                </xsl:for-each>
                            </imscp:organizations>
                        </xsl:when>
                        <xsl:when test="/u:UVED/u:CONTENUS">
                            <imscp:organizations default="contenus">
                                <imscp:organization identifier="contenus" structure="hierarchical">
                                    <imscp:title><xsl:value-of select="/u:UVED/u:CONTENUS/@titre"/></imscp:title>
                                    <xsl:for-each select="/u:UVED/u:CONTENUS/u:SECTION">
                                        <xsl:call-template name="scorm-item"/>
                                    </xsl:for-each>
                                </imscp:organization>
                            </imscp:organizations>
                        </xsl:when>
                        <xsl:otherwise>
                            <imscp:organizations default="/u:UVED/u:SECTION/@label">
                                <imscp:organization identifier="/u:UVED/u:SECTION/@label" structure="hierarchical">
                                    <imscp:title><xsl:value-of select="/u:UVED/u:SECTION/@titre"/></imscp:title>
                                    <xsl:for-each select="/u:UVED/u:SECTION">
                                        <xsl:call-template name="scorm-item"/>
                                    </xsl:for-each>
                                </imscp:organization>
                            </imscp:organizations>
                        </xsl:otherwise>
                    </xsl:choose>
                    <xsl:call-template name="scorm-ressources"/>
                </imscp:manifest>
            </xsl:with-param>
        </xsl:call-template>
    </xsl:template>
    
    <xsl:template name="lom">
        <xsl:variable name="langue"><xsl:value-of select="/u:UVED/u:METADONNEES/u:LANGUE"/></xsl:variable>
        <lom:lom>
            <lom:metaMetadata>
                <lom:metadataSchema>LOMv1.0</lom:metadataSchema>
            </lom:metaMetadata>
            <lom:general>
                <lom:title>
                    <lom:string>
                        <xsl:choose>
                            <xsl:when test="/u:UVED/u:CONTENUS">
                                <xsl:value-of select="/u:UVED/u:CONTENUS/@titre"/>
                            </xsl:when>
                            <xsl:otherwise>
                                <xsl:value-of select="/u:UVED/u:SECTION/@titre"/>
                            </xsl:otherwise>
                        </xsl:choose>
                    </lom:string>
                </lom:title>
                <xsl:if test="$langue != ''">
                    <!-- remarque : pb de compatibilit ici entre LOM, LOM-fr, UVED, ... -->
                    <lom:language><xsl:value-of select="substring($langue,1,2)"/></lom:language>
                </xsl:if>
                <xsl:for-each select="/u:UVED/u:METADONNEES/u:MOTSCLE/u:MOTCLE">
                    <lom:keyword>
                        <lom:string><xsl:value-of select="."/></lom:string>
                    </lom:keyword>
                </xsl:for-each>
            </lom:general>
            <lom:lifeCycle>
                <xsl:if test="/u:UVED/u:METADONNEES/u:VERSION != ''">
                    <lom:version>
                        <lom:string><xsl:value-of select="/u:UVED/u:METADONNEES/u:VERSION"/></lom:string>
                    </lom:version>
                </xsl:if>
                <xsl:if test="/u:UVED/u:METADONNEES/u:ETAT != ''">
                    <lom:status>
                        <lom:string><xsl:value-of select="/u:UVED/u:METADONNEES/u:ETAT"/></lom:string>
                    </lom:status>
                </xsl:if>
                <xsl:for-each select="/u:UVED/u:METADONNEES/u:AUTEURS/u:AUTEUR">
                    <lom:contribute>
                        <lom:role>
                            <xsl:value-of select="@fonction"/>
                        </lom:role>
                        <lom:entity>
                            <xsl:value-of select="concat(@prenom,', ',@nom, ', ', @organisme)"/>
                        </lom:entity>
                        <xsl:if test="/u:UVED/u:METADONNEES/u:DATECRE">
                            <xsl:variable name="date" select="/u:UVED/u:METADONNEES/u:DATECRE"/>
                            <lom:date><xsl:value-of select="concat(substring-after(substring-after($date, '/'), '/'), '-', substring-before(substring-after($date, '/'), '/'), '-', substring-before($date, '/'))"/></lom:date>
                        </xsl:if>
                    </lom:contribute>
                </xsl:for-each>
            </lom:lifeCycle>
        </lom:lom>
    </xsl:template>
    
    <xsl:template name="scorm-organization">
        <imscp:organization identifier="{@label}" structure="hierarchical">
            <imscp:title><xsl:value-of select="@titre"/></imscp:title>
            <xsl:choose>
                <xsl:when test="count(ancestor::SECTION) &lt; /u:UVED/u:CONTENUS/@niveauxOrg - 1">
                    <xsl:for-each select="u:SECTION">
                        <xsl:call-template name="scorm-organization"/>
                    </xsl:for-each>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:for-each select="u:SECTION">
                        <xsl:call-template name="scorm-item"/>
                    </xsl:for-each>
                </xsl:otherwise>
            </xsl:choose>
        </imscp:organization>
    </xsl:template>
    
    <xsl:template name="scorm-item">
        <imscp:item identifier="{@label}" isvisible="true" identifierref="res-{@label}">
            <imscp:title><xsl:value-of select="@titre"/></imscp:title>
            <xsl:for-each select="*[self::u:SECTION or self::u:GRAIN]">
                <xsl:call-template name="scorm-item"/>
            </xsl:for-each>
        </imscp:item>
        <!--
        <imsss:sequencing>
            <imsss:controlMode flow="true"/>
        </imsss:sequencing>
        -->
    </xsl:template>
    
    <xsl:template name="scorm-ressources">
        <imscp:resources>
            <imscp:resource identifier="medias" type="webcontent" adlcp:scormType="asset">
                <file href="medias/html/aide.html"/>
                <file href="medias/html/mentions.html"/>
                <file href="medias/navigation/cours/activite.png"/>
                <file href="medias/navigation/cours/attention.png"/>
                <file href="medias/navigation/cours/citation.png"/>
                <file href="medias/navigation/cours/complement.png"/>
                <file href="medias/navigation/cours/conclusion.png"/>
                <file href="medias/navigation/cours/confere.png"/>
                <file href="medias/navigation/cours/conseil.png"/>
                <file href="medias/navigation/cours/definition.png"/>
                <file href="medias/navigation/cours/ensavoirplus.png"/>
                <file href="medias/navigation/cours/exemple.png"/>
                <file href="medias/navigation/cours/exercice.png"/>
                <file href="medias/navigation/cours/explication.png"/>
                <file href="medias/navigation/cours/internet.png"/>
                <file href="medias/navigation/cours/introduction.png"/>
                <file href="medias/navigation/cours/lien_interne.png"/>
                <file href="medias/navigation/cours/media.png"/>
                <file href="medias/navigation/cours/methode.png"/>
                <file href="medias/navigation/cours/note.png"/>
                <file href="medias/navigation/cours/objectifs.png"/>
                <file href="medias/navigation/cours/prerequis.png"/>
                <file href="medias/navigation/cours/qcm.png"/>
                <file href="medias/navigation/cours/rappel.png"/>
                <file href="medias/navigation/cours/reference.png"/>
                <file href="medias/navigation/cours/remarque.png"/>
                <file href="medias/navigation/cours/syntaxe.png"/>
                <file href="medias/navigation/icones/accueil.png"/>
                <file href="medias/navigation/icones/aide.png"/>
                <file href="medias/navigation/icones/credits.png"/>
                <file href="medias/navigation/icones/imprimer.png"/>
                <file href="medias/navigation/icones/pageprecedente_disabled.png"/>
                <file href="medias/navigation/icones/pageprecedente.png"/>
                <file href="medias/navigation/icones/pagesuivante_disabled.png"/>
                <file href="medias/navigation/icones/pagesuivante.png"/>
                <file href="medias/navigation/icones/plandusite.png"/>
                <file href="medias/navigation/icones/ressources.png"/>
                <file href="medias/navigation/interface/background_button.png"/>
                <file href="medias/navigation/interface/background_footer.png"/>
                <file href="medias/navigation/interface/background_header.gif"/>
                <file href="medias/navigation/interface/background_table_th.png"/>
                <file href="medias/navigation/interface/logo.png"/>
                <file href="medias/navigation/interface/photo_header.jpg"/>
                <file href="medias/navigation/puces/bullet_black.gif"/>
                <file href="medias/navigation/puces/bullet_toggle_minus.gif"/>
                <file href="medias/navigation/puces/bullet_toggle_plus.gif"/>
                <file href="medias/navigation/puces/puce_301.gif"/>
                <file href="medias/scripts/cirm.js"/>
                <file href="medias/scripts/event.js"/>
                <file href="medias/scripts/qcm.js"/>
                <file href="medias/scripts/swfobject.js"/>
                <file href="medias/scripts/yahoo.js"/>
                <file href="medias/styles/cirm/cirm-tooltip.css"/>
                <file href="medias/styles/cirm/cirm-treeview.css"/>
                <file href="medias/styles/module/aide.css"/>
                <file href="medias/styles/module/aideqcm.css"/>
                <file href="medias/styles/module/author.css"/>
                <file href="medias/styles/module/content-cours-blocs.css"/>
                <file href="medias/styles/module/content-cours-plan.css"/>
                <file href="medias/styles/module/content-cours-tooltip.css"/>
                <file href="medias/styles/module/content-cours.css"/>
                <file href="medias/styles/module/content-exercices.css"/>
                <file href="medias/styles/module/content-map.css"/>
                <file href="medias/styles/module/content-presentation.css"/>
                <file href="medias/styles/module/content-ressources.css"/>
                <file href="medias/styles/module/content-table.css"/>
                <file href="medias/styles/module/content.css"/>
                <file href="medias/styles/module/footer.css"/>
                <file href="medias/styles/module/header.css"/>
                <file href="medias/styles/module/mentions.css"/>
                <file href="medias/styles/module/print.css"/>
                <file href="medias/styles/module/style.css"/>
                <file href="medias/symboles/grec-majuscules/Delta.png"/>
                <file href="medias/symboles/grec-majuscules/Gamma.png"/>
                <file href="medias/symboles/grec-majuscules/Lambda.png"/>
                <file href="medias/symboles/grec-majuscules/Omega.png"/>
                <file href="medias/symboles/grec-majuscules/Phi.png"/>
                <file href="medias/symboles/grec-majuscules/Pi.png"/>
                <file href="medias/symboles/grec-majuscules/Psi.png"/>
                <file href="medias/symboles/grec-majuscules/Sigma.png"/>
                <file href="medias/symboles/grec-majuscules/sigmaf.png"/>
                <file href="medias/symboles/grec-majuscules/Theta.png"/>
                <file href="medias/symboles/grec-majuscules/thetasym.png"/>
                <file href="medias/symboles/grec-majuscules/Xi.png"/>
                <file href="medias/symboles/grec-minuscules/alpha.png"/>
                <file href="medias/symboles/grec-minuscules/beta.png"/>
                <file href="medias/symboles/grec-minuscules/chi.png"/>
                <file href="medias/symboles/grec-minuscules/delta.png"/>
                <file href="medias/symboles/grec-minuscules/epsilon.png"/>
                <file href="medias/symboles/grec-minuscules/eta.png"/>
                <file href="medias/symboles/grec-minuscules/gamma.png"/>
                <file href="medias/symboles/grec-minuscules/iota.png"/>
                <file href="medias/symboles/grec-minuscules/kappa.png"/>
                <file href="medias/symboles/grec-minuscules/lambda.png"/>
                <file href="medias/symboles/grec-minuscules/mu.png"/>
                <file href="medias/symboles/grec-minuscules/nu.png"/>
                <file href="medias/symboles/grec-minuscules/omega.png"/>
                <file href="medias/symboles/grec-minuscules/omicron.png"/>
                <file href="medias/symboles/grec-minuscules/phi.png"/>
                <file href="medias/symboles/grec-minuscules/phi2.png"/>
                <file href="medias/symboles/grec-minuscules/pi.png"/>
                <file href="medias/symboles/grec-minuscules/piv.png"/>
                <file href="medias/symboles/grec-minuscules/psi.png"/>
                <file href="medias/symboles/grec-minuscules/rho.png"/>
                <file href="medias/symboles/grec-minuscules/sigma.png"/>
                <file href="medias/symboles/grec-minuscules/tau.png"/>
                <file href="medias/symboles/grec-minuscules/theta.png"/>
                <file href="medias/symboles/grec-minuscules/upsilon.png"/>
                <file href="medias/symboles/grec-minuscules/xi.png"/>
                <file href="medias/symboles/grec-minuscules/zeta.png"/>
                <file href="medias/symboles/maths/asymp.png"/>
                <file href="medias/symboles/maths/cap.png"/>
                <file href="medias/symboles/maths/cup.png"/>
                <file href="medias/symboles/maths/exist.png"/>
                <file href="medias/symboles/maths/forall.png"/>
                <file href="medias/symboles/maths/ge.png"/>
                <file href="medias/symboles/maths/harr.png"/>
                <file href="medias/symboles/maths/hdarr.png"/>
                <file href="medias/symboles/maths/infin.png"/>
                <file href="medias/symboles/maths/isin.png"/>
                <file href="medias/symboles/maths/larr.png"/>
                <file href="medias/symboles/maths/ldarr.png"/>
                <file href="medias/symboles/maths/le.png"/>
                <file href="medias/symboles/maths/nabla.png"/>
                <file href="medias/symboles/maths/ne.png"/>
                <file href="medias/symboles/maths/not.png"/>
                <file href="medias/symboles/maths/part.png"/>
                <file href="medias/symboles/maths/plusmn.png"/>
                <file href="medias/symboles/maths/rarr.png"/>
                <file href="medias/symboles/maths/rdarr.png"/>
                <file href="medias/symboles/maths/sim.png"/>
                <file href="medias/symboles/maths/sub.png"/>
            </imscp:resource>
            <xsl:for-each select="//u:SECTION|//u:GRAIN">
                <xsl:variable name="chemin"><xsl:for-each select="(ancestor-or-self::u:SECTION)[self::u:SECTION]"><xsl:value-of select="concat(@label, $sep)"/></xsl:for-each>index.html</xsl:variable>
                <imscp:resource identifier="res-{@label}" type="webcontent" href="{$chemin}" adlcp:scormType="sco">
                    <imscp:file href="{$chemin}"/>
                    <imscp:dependency identifierref="medias"/>
                </imscp:resource>
            </xsl:for-each>
        </imscp:resources>
    </xsl:template>
</xsl:stylesheet>
