<?xml version="1.0" encoding='ISO-8859-1'?>

<xsl:stylesheet version="2.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:u="http://www.uved.fr/schema/2.0"
    exclude-result-prefixes="u">
    
<!-- ************************************************ -->
<!-- creation de la prsentation (index) pour les cours UVED -->
<!-- ************************************************ -->
<!-- version 0.2 Romuald Lorthioir - CIRM - Universit de Rennes 1 -->
<!-- version 1.0 pour UVED 2.0 - Damien Guillaume, Observatoire de Paris -->

<xsl:template name="UVED_PRESENTATION">

    <xsl:call-template name="ecrireDansFichier">
        <xsl:with-param name="fichier" select="concat($cheminSite,'index.html')"/>
        <xsl:with-param name="contenu">
            <html lang="fr">
            
                <xsl:call-template name="headerRessource">
                    <xsl:with-param name="titre">UVED - Prsentation</xsl:with-param>
                </xsl:call-template>
               <body>
               <xsl:call-template name="bodyheaderRessource">
                    <xsl:with-param name="selection">presentation</xsl:with-param>
                </xsl:call-template>
               
               <!-- CONTENT -->
            
                <div id="content" class="presentation"> <a name="top"></a> 
                    <div class="titre-section"> 
                        <h3>Prsentation</h3>
                    </div>
                    
                    <xsl:call-template name="ligne-ancres" />
                    
                    <xsl:for-each select="/u:UVED/u:CONTENUS/u:PRESENTATION/node()">
                        <xsl:choose>
                            <xsl:when test="self::u:CARACTERISTIQUE">
                                <xsl:call-template name="bloc-presentation">
                                    <xsl:with-param name="titre" select="'Caractristiques'"/>
                                    <xsl:with-param name="ancre" select="'A'"/>
                                </xsl:call-template>
                            </xsl:when>
                            <xsl:when test="self::u:FINALITE">
                                <xsl:call-template name="bloc-presentation">
                                    <xsl:with-param name="titre" select="'Finalits'"/>
                                    <xsl:with-param name="ancre" select="'B'"/>
                                </xsl:call-template>
                            </xsl:when>
                            <xsl:when test="self::u:CONTENU">
                                <xsl:call-template name="bloc-presentation">
                                    <xsl:with-param name="titre" select="'Contenu'"/>
                                    <xsl:with-param name="ancre" select="'C'"/>
                                </xsl:call-template>
                            </xsl:when>
                            <xsl:when test="self::u:PARAGRAPHE|self::u:MEDIA">
                                <xsl:call-template name="bloc-presentation">
                                    <xsl:with-param name="titre" select="@titre"/>
                                    <xsl:with-param name="ancre" select="''"/>
                                </xsl:call-template>
                            </xsl:when>
                        </xsl:choose>
                    </xsl:for-each>
                    <xsl:choose>
                        <xsl:when test="/u:UVED/u:CONTENUS/@niveauxOrg!=''">
                            <xsl:call-template name="bloc-organisation"/>
                        </xsl:when>
                        <xsl:otherwise>
                            <div class="bloc-standard">
                                <xsl:variable name="href-premiere-section"><xsl:for-each select="(//u:SECTION)[1]"><xsl:call-template name="urlPage"/></xsl:for-each></xsl:variable>
                                <a href="{$href-premiere-section}">Cours</a>
                            </div>
                            <div class="haut-page"><a href="#top"><span>haut de page</span></a></div>
                        </xsl:otherwise>
                    </xsl:choose>
                </div>
                <!-- DIV en ALT -->
                <xsl:call-template name="presentationDivInvisibles"/>
                <xsl:call-template name="footerRessource" />
               </body>
            </html>
        </xsl:with-param>
    </xsl:call-template>
</xsl:template>

<!-- ************************************************ -->
<!-- Bloc Caracteristiques -->
<!-- ************************************************ -->
<xsl:template name="bloc-presentation">
    <xsl:param name="titre"/>
    <xsl:param name="ancre"/>
    
    <div class="bloc-standard">
        <a name="{$ancre}"><xsl:value-of select="''"/></a>
        <xsl:if test="$titre!=''">
            <h3><xsl:value-of select="$titre"/></h3>
        </xsl:if>
        <xsl:apply-templates select="."/>
    </div>
    <div class="haut-page"><a href="#top"><span>haut de page</span></a></div>
</xsl:template>

<!-- ************************************************ -->
<!-- Niveaux organisationnels -->
<!-- ************************************************ -->
<xsl:template name="bloc-organisation">
    
    <div class="bloc-standard">
        <a name="D"><xsl:value-of select="''"/></a> 
        <h3>Organisation</h3>
        
        <xsl:for-each select="/u:UVED/u:CONTENUS">
            <xsl:call-template name="liste-sections-org"/>
        </xsl:for-each>
    </div>
    <div class="haut-page"><a href="#top"><span>haut de page</span></a></div>
</xsl:template>

<xsl:template name="liste-sections-org">
    <xsl:variable name="niveauxOrg" select="/u:UVED/u:CONTENUS/@niveauxOrg"/>
    <xsl:variable name="niveaux" select="count(ancestor-or-self::u:SECTION)"/>
    <ul>
        <xsl:for-each select="u:SECTION">
            <li>
                <xsl:choose>
                    <xsl:when test="$niveaux &lt; $niveauxOrg">
                        <xsl:value-of select="@titre"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <a>
                            <xsl:attribute name="href">
                                <xsl:call-template name="urlPage"/>
                            </xsl:attribute>
                            <xsl:value-of select="@titre"/>
                        </a>
                    </xsl:otherwise>
                </xsl:choose>
                <xsl:if test="$niveaux &lt; $niveauxOrg and u:SECTION">
                    <xsl:call-template name="liste-sections-org"/>
                </xsl:if>
            </li>
        </xsl:for-each>
    </ul>
</xsl:template>

<!-- ************************************************ -->
<!-- creation des ancres-->
<!-- ************************************************ -->
<xsl:template name="ligne-ancres">
    <div class="navigation"> 
        <ul>
            <xsl:if test="count(/u:UVED/u:CONTENUS/u:PRESENTATION/u:CARACTERISTIQUE)>0">
                <li><a href="#A">Caractristiques</a></li>
            </xsl:if>
            <xsl:if test="count(/u:UVED/u:CONTENUS/u:PRESENTATION/u:FINALITE)>0">
                <li><a href="#B">Finalits</a></li>
            </xsl:if>
            <xsl:if test="count(/u:UVED/u:CONTENUS/u:PRESENTATION/u:CONTENU)>0">
                <li><a href="#C">Contenu</a></li>
            </xsl:if>
            <xsl:if test="/u:UVED/u:CONTENUS/@niveauxOrg!=''">
                <li><a href="#D">Organisation</a></li>
            </xsl:if>
        </ul>
    </div>
</xsl:template>

<!-- ************************************************ -->
<!-- Cas particulier des alts BIBLIO et WEBO          -->
<!-- ************************************************ -->
<xsl:template name="presentationDivInvisibles">
    
    <xsl:for-each select="/u:UVED/u:CONTENUS/u:PRESENTATION//*">
        <xsl:if test="self::u:MOTDUGLOSSAIRE or self::u:LIENMOTDUGLOSSAIRE or self::u:REFERENCEBIBLIOGRAPHIQUE or self::u:LIENREFERENCEBIBLIOGRAPHIQUE or self::u:REFERENCEWEBOGRAPHIQUE or self::u:LIENREFERENCEWEBOGRAPHIQUE">
            <xsl:apply-templates select="." mode="div"/>
        </xsl:if>
    </xsl:for-each>
    
</xsl:template>


</xsl:stylesheet>
