<?xml version="1.0" encoding='ISO-8859-1'?>

<xsl:stylesheet version="2.0"
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
        xmlns:u="http://www.uved.fr/schema/2.0"
        xmlns:copie="http://xml.apache.org/xalan/java/jaxeuved.CopieFichiers"
        xmlns:icones="http://xml.apache.org/xalan/java/jaxeuved.FaireIcones"
        exclude-result-prefixes="u copie icones">
<xsl:output 
      method="html"
      encoding="ISO-8859-1"
      doctype-system="http://www.w3.org/TR/html4/strict.dtd"
      doctype-public="-//W3C//DTD HTML 4.01//EN" 
      indent="yes" />
      
 <!-- version 0.1 Romuald Lorthioir - CIRM - Universit de Rennes 1 -->
 <!-- version 0.2 Damien Guillaume  - Observatoire de Paris -->
 <!-- version 1.0 pour UVED 2.0 -  Damien Guillaume, Observatoire de Paris -->

    <!-- include des lments HTML fixes -->
    <xsl:include href="./UVED_OUTILS.xsl" />
    <xsl:include href="./UVED_HTML.xsl" />
    <xsl:include href="./UVED_CREDITS.xsl" />
    <xsl:include href="./UVED_ANNEXE.xsl" />
    <xsl:include href="./UVED_BIBLIOGRAPHIE.xsl" />
    <xsl:include href="./UVED_COURS.xsl" />
    <xsl:include href="./UVED_GLOSSAIRE.xsl" />
    <xsl:include href="./UVED_PRESENTATION.xsl" />
    <xsl:include href="./UVED_RESSOURCES.xsl" />
    <xsl:include href="./UVED_SOMMAIRE.xsl" />
    <xsl:include href="./UVED_WEBOGRAPHIE.xsl" />
    <xsl:include href="./UVED_EXERCICES.xsl" />

    <!-- dclaration des variables globales -->
    <xsl:param name="chainEditPath"/>
    <xsl:param name="jaxe-fichier-xml"/>  <!-- chemin complet vers le fichier XML quand il est dit avec Jaxe -->

    <!-- sparateur de chemins ( / ou \ ) -->
    <xsl:variable name="sep"><xsl:choose>
        <xsl:when test="contains($jaxe-fichier-xml, '\')">\</xsl:when>
        <xsl:otherwise>/</xsl:otherwise>
    </xsl:choose></xsl:variable>
    <!-- chemin du rpertoire du fichier XML si jaxe-fichier-xml est utilis -->
    <xsl:variable name="chemin-jaxe-xml"><xsl:if test="$jaxe-fichier-xml!=''"><xsl:call-template name="repfichier"><xsl:with-param name="chemin" select="$jaxe-fichier-xml"/></xsl:call-template></xsl:if></xsl:variable>
    
    <xsl:variable name="racine"><xsl:choose>
        <xsl:when test="/u:UVED/u:CONTENUS">..</xsl:when>
        <xsl:otherwise>.</xsl:otherwise> <!-- dans le rpertoire courant s'il ne s'agit pas d'un site entier, contrairement  UVED 1.0 -->
    </xsl:choose></xsl:variable>
    <xsl:variable name="cheminSite"><xsl:choose>
        <xsl:when test="$jaxe-fichier-xml!=''"><xsl:value-of select="concat($chemin-jaxe-xml, $sep, translate($racine,'/',$sep), $sep, 'site', $sep, 'html', $sep)"/></xsl:when>
        <xsl:otherwise><xsl:value-of select="concat($chainEditPath, '../site/html/')"/></xsl:otherwise>
    </xsl:choose></xsl:variable>

    <xsl:template match="/">

    <xsl:message terminate="no">
        <xsl:text>UVED : Debut de la creation de la page des credits</xsl:text>
    </xsl:message>
    <xsl:call-template name="UVED_CREDITS"/>
    <xsl:message terminate="no">
        <xsl:text>UVED : Fin de la creation de la page des credits</xsl:text>
    </xsl:message>

    <xsl:message terminate="no">
        <xsl:text>UVED : Debut de la creation de la page des ressources</xsl:text>
    </xsl:message>
    <xsl:call-template name="UVED_RESSOURCES"/>
    <xsl:message terminate="no">
        <xsl:text>UVED : Fin de la creation de la page des ressources</xsl:text>
    </xsl:message>

    <xsl:message terminate="no">
        <xsl:text>UVED : Debut de la creation de la page bibliographie</xsl:text>
    </xsl:message>
    <xsl:call-template name="UVED_BIBLIOGRAPHIE"/>
    <xsl:message terminate="no">
        <xsl:text>UVED : Fin de la creation de la page bibliographie</xsl:text>
    </xsl:message>

    <xsl:message terminate="no">
        <xsl:text>UVED : Debut de la creation de la page webographie</xsl:text>
    </xsl:message>
    <xsl:call-template name="UVED_WEBOGRAPHIE"/>
    <xsl:message terminate="no">
        <xsl:text>UVED : Fin de la creation de la page webographie</xsl:text>
    </xsl:message>

    <xsl:message terminate="no">
        <xsl:text>UVED : Debut de la creation de la page glossaire</xsl:text>
    </xsl:message>
    <xsl:call-template name="UVED_GLOSSAIRE"/>
    <xsl:message terminate="no">
        <xsl:text>UVED : Fin de la creation de la page glossaire</xsl:text>
    </xsl:message>

    <xsl:message terminate="no">
        <xsl:text>UVED : Debut de la creation de la page sommaire</xsl:text>
    </xsl:message>
    <xsl:call-template name="UVED_SOMMAIRE"/>
    <xsl:message terminate="no">
        <xsl:text>UVED : Fin de la creation de la page sommaire</xsl:text>
    </xsl:message>
    
    <xsl:if test="/u:UVED/u:CONTENUS/u:PRESENTATION">
        <xsl:message terminate="no">
            <xsl:text>UVED : Debut de la creation de la page presentation</xsl:text>
        </xsl:message>
        <xsl:call-template name="UVED_PRESENTATION"/>
        <xsl:message terminate="no">
            <xsl:text>UVED : Fin de la creation de la page presentation</xsl:text>
        </xsl:message>
    </xsl:if>

    <xsl:message terminate="no">
        <xsl:text>UVED : Debut de la creation des pages d'annexes</xsl:text>
    </xsl:message>
    <xsl:call-template name="UVED_ANNEXE"/>
    <xsl:message terminate="no">
        <xsl:text>UVED : Fin de la creation  des pages d'annexes</xsl:text>
    </xsl:message>

    <xsl:message terminate="no">
        <xsl:text>UVED : Debut de la creation des pages de cours</xsl:text>
    </xsl:message>
    <xsl:call-template name="UVED_COURS"/>
    <xsl:message terminate="no">
        <xsl:text>UVED : Fin de la creation des pages de cours</xsl:text>
    </xsl:message>

    <xsl:message terminate="no">
        <xsl:text>UVED : Debut de la creation des pages d'aide et solutions pour les exercices</xsl:text>
    </xsl:message>
    <xsl:call-template name="UVED_EXERCICES" /> 
    <xsl:message terminate="no">
         <xsl:text>UVED : Fin de la creation des pages d'aide et solutions pour les exercices</xsl:text>
    </xsl:message>

    <xsl:if use-when="function-available('copie:copieFichier')" test="$jaxe-fichier-xml!='' and function-available('copie:copieFichier')">
        <!-- attention, use-when est du XSLT 2.0, mais sans a saxon ne marche pas -->
        <xsl:message terminate="no">
             <xsl:text>UVED : Copie des fichiers de ressources</xsl:text>
        </xsl:message>
        <xsl:for-each select="//u:FICHIER">
            <xsl:variable name="chemin-section"><xsl:for-each select="(ancestor::u:SECTION)[self::u:SECTION]"><xsl:value-of select="concat(@label, $sep)"/></xsl:for-each></xsl:variable>
            <xsl:value-of select="copie:copieFichier(ancestor::*[@dossier][1]/@dossier, translate(@chemin,'/',$sep), concat($cheminSite, $chemin-section))"/>
        </xsl:for-each>
        <xsl:for-each select="//u:FICHIERLIE">
            <xsl:variable name="chemin-section"><xsl:for-each select="(ancestor::u:SECTION)[self::u:SECTION]"><xsl:value-of select="concat(@label, $sep)"/></xsl:for-each></xsl:variable>
            <xsl:value-of select="copie:copieFichier(ancestor::*[@dossier][1]/@dossier, translate(@chemin,'/',$sep), concat($cheminSite, $chemin-section))"/>
        </xsl:for-each>
        <xsl:for-each select="//u:DOSSIERLIE">
            <xsl:variable name="chemin-section"><xsl:for-each select="(ancestor::u:SECTION)[self::u:SECTION]"><xsl:value-of select="concat(@label, $sep)"/></xsl:for-each></xsl:variable>
            <xsl:value-of select="copie:copieDossier(ancestor::*[@dossier][1]/@dossier, translate(@chemin,'/',$sep), concat($cheminSite, $chemin-section))"/>
        </xsl:for-each>
        <xsl:for-each select="//u:EQUAJAXE|//u:EQUATEX">
            <xsl:variable name="chemin-section"><xsl:for-each select="(ancestor::u:SECTION)[self::u:SECTION]"><xsl:value-of select="concat(@label, $sep)"/></xsl:for-each></xsl:variable>
            <xsl:value-of select="copie:copieFichier(ancestor::*[@dossier][1]/@dossier, translate(@image,'/',$sep), concat($cheminSite, $chemin-section))"/>
        </xsl:for-each>
        <xsl:for-each select="//u:LIENDOCUMENT[not(starts-with(@url,'http:')) and not(contains(@url,'..'))]">
            <xsl:variable name="chemin-section"><xsl:for-each select="(ancestor::u:SECTION)[self::u:SECTION]"><xsl:value-of select="concat(@label, $sep)"/></xsl:for-each></xsl:variable>
            <xsl:value-of select="copie:copieFichier(ancestor::*[@dossier][1]/@dossier, translate(@url,'/',$sep), concat($cheminSite, $chemin-section))"/>
        </xsl:for-each>
        <xsl:message terminate="no">
             <xsl:text>UVED : Fin de la copie des fichiers de ressources</xsl:text>
        </xsl:message>
    </xsl:if>
    
    <xsl:if use-when="function-available('icones:reduction')" test="$jaxe-fichier-xml!='' and function-available('icones:reduction')">
        <xsl:message terminate="no">
             <xsl:text>UVED : Reduction des images en page et en icone</xsl:text>
        </xsl:message>
        <xsl:for-each select="//u:MEDIA[@localisation='icne' or @localisation='page']">
            <xsl:variable name="chemin-section"><xsl:for-each select="(ancestor::u:SECTION)[self::u:SECTION]"><xsl:value-of select="concat(@label, $sep)"/></xsl:for-each></xsl:variable>
            <xsl:for-each select="u:FICHIER[@format='gif' or @format='png' or @format='jpeg']">
                <xsl:variable name="res" select="icones:reduction(ancestor::*[@dossier][1]/@dossier, translate(@chemin,'/',$sep), ../@localisation, concat($cheminSite, $chemin-section))"/>
                <xsl:if test="$res!='ok'">
                    <xsl:message>Erreur a la reduction de <xsl:value-of select="@chemin"/></xsl:message>
                </xsl:if>
            </xsl:for-each>
        </xsl:for-each>
        <xsl:message terminate="no">
             <xsl:text>UVED : Fin de la reduction des images en icone</xsl:text>
        </xsl:message>
    </xsl:if>
    
    <html>
        <head><title>Cours UVED</title></head>
        <body>
            <p><a href="{$racine}/site/html/index.html">Prsentation</a></p>
            <p><a>
            <xsl:attribute name="href"><xsl:value-of select="$racine"/>/site/html/<xsl:for-each select="(//u:SECTION)[1]"><xsl:call-template name="urlPage"/></xsl:for-each></xsl:attribute>
            Cours
            </a></p>
        </body>
    </html>
    
   </xsl:template>

</xsl:stylesheet>