<?xml version="1.0" encoding='ISO-8859-1'?>

<xsl:stylesheet version="2.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:u="http://www.uved.fr/schema/2.0"
    exclude-result-prefixes="u">

<!-- version 0.5 Romuald Lorthioir - CIRM - Universit de Rennes 1 -->
<!-- version 1.0 pour UVED 2.0 - Damien Guillaume, Observatoire de Paris -->


<!-- ************************************************ -->
<!-- header des pages prsentation et ressources -->
<!-- ************************************************ -->
    <xsl:template name="headerRessource">
        <xsl:param name="titre"/>
        <xsl:variable name="href-premiere-section"><xsl:for-each select="(//u:SECTION)[1]"><xsl:call-template name="urlPage"/></xsl:for-each></xsl:variable>
        <head>
            <title><xsl:value-of select="$titre"/></title>
            
            <meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1"><xsl:value-of select="''"/></meta>
            <meta http-equiv="Content-Style-Type" content="text/css"><xsl:value-of select="''"/></meta>
            <meta http-equiv="Content-Script-Type" content="text/javascript"><xsl:value-of select="''"/></meta>
            <link rel="stylesheet" type="text/css" href="../medias/styles/cirm/cirm-tooltip.css" media="screen"><xsl:value-of select="''"/></link>
            <link rel="stylesheet" type="text/css" href="../medias/styles/cirm/cirm-treeview.css" media="screen"><xsl:value-of select="''"/></link>
            <link rel="stylesheet" type="text/css" href="../medias/styles/module/style.css" media="screen"><xsl:value-of select="''"/></link>
            <link rel="stylesheet" type="text/css" href="../medias/styles/module/print.css" media="print"><xsl:value-of select="''"/></link>
            <script type="text/javascript" src="../medias/scripts/yahoo.js"><xsl:value-of select="''"/></script>
            <script type="text/javascript" src="../medias/scripts/event.js"><xsl:value-of select="''"/></script>
            <script type="text/javascript" src="../medias/scripts/cirm.js"><xsl:value-of select="''"/></script>
            <script type="text/javascript">
                function getCurrentCoursePage()
                {
                    var currentCoursePage = CIRM.utils.Cookie.read( "currentCoursePage" );
                    if ( currentCoursePage != null )
                    {
                        document.location.href = currentCoursePage;
                    }
                    else
                    {
                        document.location.href = "<xsl:value-of select="$href-premiere-section" />";
                    }
                };
                function _initialize()
                {
                    CIRM.utils.Frame.initialize();
                };
                YAHOO.util.Event.on( window, "load", _initialize );
            </script>
        </head>
    </xsl:template>

<!-- ************************************************ -->
<!-- header de toutes les pages de cours UVED-->
<!-- ************************************************ -->
    <xsl:template name="headerPage">
        <xsl:param name="idPage"/>
        <xsl:param name="pagePrecedente"/>
        <xsl:param name="pageSuivante"/>
        
        <xsl:variable name="prefixe"><xsl:for-each select="ancestor-or-self::u:SECTION">../</xsl:for-each>../</xsl:variable>
        
        <head>
            <title><xsl:choose>
                <xsl:when test="@titre!=''"><xsl:value-of select="@titre"/></xsl:when>
                <xsl:when test="self::u:CONCLUSION">Conclusion</xsl:when>
                <xsl:otherwise><xsl:value-of select="name()"/></xsl:otherwise>
            </xsl:choose></title>
            
            <meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1"><xsl:value-of select="''"/></meta>
            <meta http-equiv="Content-Style-Type" content="text/css"><xsl:value-of select="''"/></meta>
            <meta http-equiv="Content-Script-Type" content="text/javascript"><xsl:value-of select="''"/></meta>
            <link rel="stylesheet" type="text/css" href="{$prefixe}medias/styles/cirm/cirm-tooltip.css" media="screen"><xsl:value-of select="''"/></link>
            <link rel="stylesheet" type="text/css" href="{$prefixe}medias/styles/cirm/cirm-treeview.css" media="screen"><xsl:value-of select="''"/></link>
            <link rel="stylesheet" type="text/css" href="{$prefixe}medias/styles/module/style.css" media="screen"><xsl:value-of select="''"/></link>
            <link rel="stylesheet" type="text/css" href="{$prefixe}medias/styles/module/print.css" media="print"><xsl:value-of select="''"/></link>
            <xsl:if test="$pagePrecedente!=''">
                <link rel="Prev"  href="{$pagePrecedente}"/>
            </xsl:if>
            <xsl:if test="$pageSuivante!=''">
                <link rel="Next"  href="{$pageSuivante}"/>
            </xsl:if>
            <script type="text/javascript" src="{$prefixe}medias/scripts/yahoo.js"><xsl:value-of select="''"/></script>
            <script type="text/javascript" src="{$prefixe}medias/scripts/event.js"><xsl:value-of select="''"/></script>
            <script type="text/javascript" src="{$prefixe}medias/scripts/cirm.js"><xsl:value-of select="''"/></script>
            <script type="text/javascript" src="{$prefixe}medias/scripts/qcm.js"><xsl:value-of select="''"/></script>
            <script type="text/javascript">
                var treeInstance;
                var forcedNodeId="<xsl:value-of select="$idPage" />";
                function _getCurrentNodeId()
                {
                    var ulElement = document.getElementById( "tree" );
                    var aElement = ulElement.getElementsByTagName( "a" );
                    for ( var i = 0; aElement.length >= i; i++ )
                    {
                        var current = aElement[ i ];
                        var currentFileName = _getFileName( current.getAttribute( "href" ) );
                        var documentFileName = _getFileName( document.location.href );
                        if ( currentFileName == documentFileName || _startsWith( currentFileName, documentFileName ) )
                        {
                            return current.parentNode.id;
                        }
                    }
                };
                function _getFileName(url)
                {
                    var array = url.split( "/" );
                    var result = array[ array.length - 1 ];
                    return result;
                };
                function _getBaseCookie()
                {
                    var url = window.location.pathname;
                    var array = url.split( "/" );
                    for ( var i = 0; i &lt; <xsl:value-of select="count(ancestor-or-self::u:SECTION)+1"/>; i++ )
                        array.pop();
                    return array.join("/");
                };
                function _initialize()
                {
                    CIRM.utils.Frame.initialize();
                    treeInstance = new CIRM.utils.TreeView( "tree" );
                    var currentNodeId = ( forcedNodeId != "" ) ? forcedNodeId : _getCurrentNodeId();
                    treeInstance.expandTo( currentNodeId );
                    CIRM.utils.Cookie.write( "currentNodeId", currentNodeId, _getBaseCookie() );
                    CIRM.utils.Cookie.write( "currentCoursePage", "<xsl:call-template name="urlPage"/>", _getBaseCookie() );
                };
                function _startsWith(source, value)
                {
                    if ( source.indexOf( value ) == 0 )
                    {
                        return true;
                    }
                    return false;
                };
                YAHOO.util.Event.on( window, "load", _initialize );
            </script>
        </head>
    </xsl:template>


<!-- ************************************************ -->
<!-- header pour la page plan du cours UVED-->
<!-- ************************************************ -->
    <xsl:template name="headerPagePlan">
        <head>
            <title>UVED - Plan</title>
        
            <meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1"><xsl:value-of select="''"/></meta>
            <meta http-equiv="Content-Style-Type" content="text/css"><xsl:value-of select="''"/></meta>
            <meta http-equiv="Content-Script-Type" content="text/javascript"><xsl:value-of select="''"/></meta>
            <link rel="stylesheet" type="text/css" href="../medias/styles/cirm/cirm-treeview.css" media="screen"><xsl:value-of select="''"/></link>
            <link rel="stylesheet" type="text/css" href="../medias/styles/module/style.css" media="screen"><xsl:value-of select="''"/></link>
            <link rel="stylesheet" type="text/css" href="../medias/styles/module/print.css" media="print"><xsl:value-of select="''"/></link>
            <script type="text/javascript" src="../medias/scripts/yahoo.js"><xsl:value-of select="''"/></script>
            <script type="text/javascript" src="../medias/scripts/event.js"><xsl:value-of select="''"/></script>
            <script type="text/javascript" src="../medias/scripts/cirm.js"><xsl:value-of select="''"/></script>
            <script type="text/javascript">
                var treeInstance;
                function _getCurrentNodeId()
                {
                    return CIRM.utils.Cookie.read( "currentNodeId" );
                };
                function _initialize()
                {
                    treeInstance = new CIRM.utils.TreeView( "tree" );
                    treeInstance.expandTo( _getCurrentNodeId() );
                };
                YAHOO.util.Event.on( window, "load", _initialize );
            </script>
            <style type="text/css">
                html,
                body
                {
                    overflow: auto;
                }
            </style>
        </head>
    </xsl:template>

<!-- ************************************************ -->
<!-- header de toutes les pages d'annexe UVED-->
<!-- ************************************************ -->
    <xsl:template name="headerPageAnnexe">
        <xsl:variable name="prefixe"><xsl:for-each select="ancestor-or-self::u:SECTION">../</xsl:for-each>../</xsl:variable>
        <head>
            <title>UVED - Annexe</title>
            
            <meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1"><xsl:value-of select="''"/></meta>
            <meta http-equiv="Content-Style-Type" content="text/css"><xsl:value-of select="''"/></meta>
            <meta http-equiv="Content-Script-Type" content="text/javascript"><xsl:value-of select="''"/></meta>
            <link rel="stylesheet" type="text/css" href="{$prefixe}medias/styles/cirm/cirm-tooltip.css" media="screen"><xsl:value-of select="''"/></link>
            <link rel="stylesheet" type="text/css" href="{$prefixe}medias/styles/cirm/cirm-treeview.css" media="screen"><xsl:value-of select="''"/></link>
            <link rel="stylesheet" type="text/css" href="{$prefixe}medias/styles/module/style.css" media="screen"><xsl:value-of select="''"/></link>
            <link rel="stylesheet" type="text/css" href="{$prefixe}medias/styles/module/print.css" media="print"><xsl:value-of select="''"/></link>
            <script type="text/javascript" src="{$prefixe}medias/scripts/yahoo.js"><xsl:value-of select="''"/></script>
            <script type="text/javascript" src="{$prefixe}medias/scripts/event.js"><xsl:value-of select="''"/></script>
            <script type="text/javascript" src="{$prefixe}medias/scripts/cirm.js"><xsl:value-of select="''"/></script>
            <script type="text/javascript" src="{$prefixe}medias/scripts/qcm.js"><xsl:value-of select="''"/></script>
        </head>
    </xsl:template>
  
<!-- ************************************************ -->
<!-- header de la page de crdits UVED-->
<!-- ************************************************ -->
    <xsl:template name="headerCredits">
        <head>
            <title>
                <xsl:value-of select="u:UVED/u:CONTENUS/@titre" />
            </title>
            <meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1" />
            <meta http-equiv="Content-Style-Type" content="text/css" />
            <meta http-equiv="Content-Script-Type" content="text/javascript" />
        </head>
        
        <link rel="stylesheet" type="text/css" title="NORMAL" href="../medias/styles/module/author.css" media="screen"><xsl:value-of select="''"/></link>
    </xsl:template>

<!-- ************************************************ -->
<!-- header des pages d'aide pour les QCMs et exercices UVED-->
<!-- ************************************************ -->
    <xsl:template name="headerAideExercice">
        <xsl:variable name="prefixe"><xsl:for-each select="ancestor::u:SECTION">../</xsl:for-each>../</xsl:variable>
        <head>
            <title><xsl:value-of select="name()"/></title>
            <meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1" />
            <meta http-equiv="Content-Style-Type" content="text/css" />
            <meta http-equiv="Content-Script-Type" content="text/javascript" />
        </head>
        
        <link rel="stylesheet" type="text/css" title="NORMAL" href="{$prefixe}medias/styles/module/style.css" media="screen"><xsl:value-of select="''"/></link>
        <link rel="stylesheet" type="text/css" title="NORMAL" href="{$prefixe}medias/styles/module/aideqcm.css" media="screen"><xsl:value-of select="''"/></link>
    </xsl:template>

<!-- ************************************************ -->
<!-- header des pages de medias en icne -->
<!-- ************************************************ -->
    <xsl:template name="headerMedia">
        <xsl:variable name="prefixe"><xsl:for-each select="ancestor::u:SECTION">../</xsl:for-each>../</xsl:variable>
        <head>
            <title><xsl:choose>
                <xsl:when test="@titre"><xsl:value-of select="@titre"/></xsl:when>
                <xsl:otherwise>MEDIA</xsl:otherwise>
            </xsl:choose></title>
            <meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1" />
            <meta http-equiv="Content-Style-Type" content="text/css" />
            <meta http-equiv="Content-Script-Type" content="text/javascript" />
        </head>
        
        <link rel="stylesheet" type="text/css" title="NORMAL" href="{$prefixe}medias/styles/module/style.css" media="screen"><xsl:value-of select="''"/></link>
    </xsl:template>

<!-- ************************************************ -->
<!-- body header de toutes les pages de cours UVED -->
<!-- ************************************************ -->
    <xsl:template name="bodyheaderPage">
        <xsl:variable name="prefixe"><xsl:for-each select="ancestor-or-self::u:SECTION">../</xsl:for-each></xsl:variable>
        
        <div id="header">
            <div id="titre-axe"><h1>UVED</h1></div>
        
            <div id="titre-module">
                <h2>
                    <xsl:value-of select="//u:CONTENUS/@titre"/>
                    <xsl:if test="/u:UVED/u:CONTENUS/@niveauxOrg!=''">
                        <span class="sous-titre">
                            <xsl:text> - </xsl:text>
                            <xsl:for-each select="ancestor-or-self::u:SECTION[count(ancestor::u:SECTION) &lt; number(/u:UVED/u:CONTENUS/@niveauxOrg)][1]">
                                <xsl:value-of select="@titre"/>
                            </xsl:for-each>
                        </span>
                    </xsl:if>
                </h2>
            </div>
        
            <div id="menu-haut">
            <ul>
                <li>
                    <a href="{$prefixe}index.html" accesskey="A" id="rubrique1" title="Prsentation"><span>Prsentation</span></a>
                </li>
        
                <li>
                    <a href="#" accesskey="Z" id="rubrique2" class="current" title="Cours"><span>Cours</span></a>
                </li>
        
                <li>
                    <a href="{$prefixe}ressources.html" accesskey="R" id="rubrique4" title="Ressources"><span>Ressources</span></a>
                </li>
            </ul>
            </div>
        
        
        </div>
        
        <!-- fil d'Ariane -->
        <div id="breadcrumb">
            <xsl:for-each select="ancestor-or-self::u:SECTION">
                <xsl:text> / </xsl:text>
                <xsl:choose>
                    <xsl:when test="/u:UVED/u:CONTENUS/@niveauxOrg != '' and count(ancestor::u:SECTION) &lt; number(/u:UVED/u:CONTENUS/@niveauxOrg)">
                        <a href="{$prefixe}index.html#D" class="niveauorg"><xsl:value-of select="@titre"/></a>
                    </xsl:when>
                    <xsl:otherwise>
                        <a>
                            <xsl:attribute name="href"><xsl:value-of select="$prefixe"/><xsl:call-template name="urlPage"/></xsl:attribute>
                            <xsl:value-of select="@titre"/>
                        </a>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:for-each>
        </div>
        
    </xsl:template>

<!-- ************************************************ -->
<!-- body header de toutes les annexes -->
<!-- ************************************************ -->
    <xsl:template name="bodyheaderPageAnnexe">
        <div id="header">
            <div id="titre-axe"><h1>UVED</h1></div>
        
            <div id="titre-module">
                <h2><xsl:value-of select="//u:CONTENUS/@titre" /></h2>
            </div>
        </div>
    </xsl:template>

<!-- ************************************************ -->
<!-- body header de toutes les pages de ressources -->
<!-- ************************************************ -->
    <xsl:template name="bodyheaderRessource">
        <xsl:param name="selection"/>
        
        <div id="header">
            <div id="titre-axe"><h1>UVED</h1></div>
        
            <div id="titre-module">
                <h2><xsl:value-of select="//u:CONTENUS/@titre" /></h2>
            </div>
        
            <div id="menu-haut">
            <ul>
                <li>
                    <a href="index.html" accesskey="A" id="rubrique1" title="Prsentation">
                        <xsl:if test="$selection='presentation'">
                            <xsl:attribute name="class">current</xsl:attribute>
                        </xsl:if>
                        <span>Prsentation</span>
                    </a>
                </li>
        
                <li>
                    <xsl:variable name="href-premiere-section"><xsl:for-each select="(//u:SECTION)[1]"><xsl:call-template name="urlPage"/></xsl:for-each></xsl:variable>
                    <a href="{$href-premiere-section}" onclick="javascript:getCurrentCoursePage(); return false" accesskey="Z" id="rubrique2" title="Cours"><span>Cours</span></a>
                </li>
        
                <li>
                    <a href="ressources.html" accesskey="R" id="rubrique4" title="Ressources">
                        <xsl:if test="$selection='ressources'">
                            <xsl:attribute name="class">current</xsl:attribute>
                        </xsl:if>
                        <span>Ressources</span>
                    </a>
                </li>
            </ul>
            </div>
        </div>
        <div id="breadcrumb">&#xA0;</div>
    </xsl:template>


<!-- ************************************************ -->
<!-- footer des pages presentation et ressources UVED -->
<!-- ************************************************ -->
    <xsl:template name="footerRessource">
        <xsl:call-template name="footer">
            <xsl:with-param name="pagePrecedente" select="''"/>
            <xsl:with-param name="pageSuivante" select="''"/>
            <xsl:with-param name="prefixe" select="''"/>
        </xsl:call-template>
    </xsl:template>

<!-- ************************************************ -->
<!-- footer de toutes les pages du cours UVED -->
<!-- ************************************************ -->
    <xsl:template name="footerPage">
        <xsl:param name="pagePrecedente" />
        <xsl:param name="pageSuivante" />
        
        <xsl:variable name="prefixe"><xsl:for-each select="ancestor-or-self::u:SECTION">../</xsl:for-each></xsl:variable>
        
        <xsl:call-template name="footer">
            <xsl:with-param name="pagePrecedente" select="$pagePrecedente"/>
            <xsl:with-param name="pageSuivante" select="$pageSuivante"/>
            <xsl:with-param name="prefixe" select="$prefixe"/>
        </xsl:call-template>
    </xsl:template>

<!-- ************************************************ -->
<!-- footer de toutes les pages -->
<!-- ************************************************ -->
    <xsl:template name="footer">
        <xsl:param name="pagePrecedente"/>
        <xsl:param name="pageSuivante"/>
        <xsl:param name="prefixe"/>
        
        <div id="footer">
            <ul id="menu-bas">
                <li id="home">
                    <a href="{$prefixe}index.html" title="Accueil">
                        <img src="{$prefixe}../medias/navigation/icones/accueil.png" width="16" height="16" alt="Accueil"/>
                    </a>
                </li>
                <li id="map">
                    <a href="javascript:CIRM.utils.Window.openCenterWindow('{$prefixe}plan.html',600,600,'Plan');" title="Plan">
                        <img src="{$prefixe}../medias/navigation/icones/plandusite.png" width="16" height="16" alt="Plan"/>
                    </a>
                </li>
                <li id="ressources">
                    <a href="{$prefixe}ressources.html" title="Ressources">
                        <img src="{$prefixe}../medias/navigation/icones/ressources.png" width="16" height="16" alt="Ressources"/>
                    </a>
                </li>
                <li id="help">
                    <a href="javascript:CIRM.utils.Window.openCenterWindow('{$prefixe}../medias/html/aide.html',800, 600, 'Aide');" title="Aide">
                        <img src="{$prefixe}../medias/navigation/icones/aide.png" width="16" height="16" alt="Aide"/>
                    </a>
                </li>
                <li id="credits">
                    <a href="javascript:CIRM.utils.Window.openCenterWindow('{$prefixe}credits.html', 600, 400, 'Credits');" title="Crdits">
                        <img src="{$prefixe}../medias/navigation/icones/credits.png" width="16" height="16" alt="Crdits"/>
                    </a>
                </li>
                <li id="print">
                    <a href="javascript:print();" title="Imprimer la page">
                        <img src="{$prefixe}../medias/navigation/icones/imprimer.png" width="16" height="16" alt="Imprimer"/>
                    </a>
                </li>
                <li id="previous"><xsl:choose>
                    <xsl:when test="$pagePrecedente=''">
                        <a href="#" title="Page prcdente" class="disabled">
                            <img src="{$prefixe}../medias/navigation/icones/pageprecedente_disabled.png" width="16" height="16" alt="&lt;-"/>
                            Page prcdente
                        </a>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:variable name="titreLien"><xsl:call-template name="titrePagePrecedente"/></xsl:variable>
                        <a href="{$pagePrecedente}" title="{$titreLien}">
                            <img src="{$prefixe}../medias/navigation/icones/pageprecedente.png" width="16" height="16" alt="&lt;-"/>
                            <xsl:text> </xsl:text><xsl:value-of select="$titreLien"/>
                        </a>
                    </xsl:otherwise>
                </xsl:choose></li>
                
                <li id="next"><xsl:choose>
                    <xsl:when test="$pageSuivante=''">
                        <a href="#" title="Page suivante" class="disabled">
                            <img src="{$prefixe}../medias/navigation/icones/pagesuivante_disabled.png" width="16" height="16" alt="-&gt;"/>
                            Page suivante
                        </a>&#xA0;<!-- espace ici pour viter un bug de Safari -->
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:variable name="titreLien"><xsl:call-template name="titrePageSuivante"/></xsl:variable>
                        <a href="{$pageSuivante}" title="{$titreLien}">
                            <img src="{$prefixe}../medias/navigation/icones/pagesuivante.png" width="16" height="16" alt="-&gt;"/>
                            <xsl:text> </xsl:text><xsl:value-of select="$titreLien"/>
                        </a>&#xA0;<!-- espace ici pour viter un bug de Safari -->
                    </xsl:otherwise>
                </xsl:choose></li>
            </ul>
            
            <div class="copyright">
                <span><a href="javascript:CIRM.utils.Window.openCenterWindow('{$prefixe}../medias/html/mentions.html',600, 400, 'Mentions');" title="Afficher les mentions lgales">mentions lgales</a> - @ 2008 - UVED</span>
            </div>
        </div>
    </xsl:template>
    
    <!-- Renvoie "Page suivante" ou "Section suivante" -->
    <xsl:template name="titrePageSuivante">
        <xsl:choose>
            <xsl:when test="/u:UVED/u:CONTENUS/@niveauxOrg != ''">
                <xsl:variable name="niveauxOrg" select="number(/u:UVED/u:CONTENUS/@niveauxOrg)"/>
                <xsl:variable name="idsectionorg" select="generate-id(ancestor-or-self::u:SECTION[count(ancestor::u:SECTION) &lt; $niveauxOrg][1])"/>
                <xsl:choose>
                    <xsl:when test="self::u:SECTION or following::*[self::u:GRAIN or self::u:CONCLUSION or self::u:SECTION][generate-id(ancestor-or-self::u:SECTION[count(ancestor::u:SECTION) &lt; $niveauxOrg][1]) = $idsectionorg]">
                        <xsl:text>Page suivante</xsl:text>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:text>Section suivante</xsl:text>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:when>
            <xsl:otherwise>
                <xsl:text>Page suivante</xsl:text>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    <!-- Renvoie "Page prcdente" ou "Section prcdente" -->
    <xsl:template name="titrePagePrecedente">
        <xsl:choose>
            <xsl:when test="/u:UVED/u:CONTENUS/@niveauxOrg != ''">
                <xsl:variable name="niveauxOrg" select="number(/u:UVED/u:CONTENUS/@niveauxOrg)"/>
                <xsl:variable name="idsectionorg" select="generate-id(ancestor-or-self::u:SECTION[count(ancestor::u:SECTION) &lt; $niveauxOrg][1])"/>
                <xsl:choose>
                    <xsl:when test="preceding::*[self::u:INTRODUCTION or self::u:PREREQUIS or self::u:OBJECTIFS or self::u:CITATION or self::u:RAPPEL or self::u:DEFINITION or self::u:METHODE or self::u:ATTENTION or self::u:CONSEIL or self::u:GRAIN or self::u:CONCLUSION][generate-id(ancestor-or-self::u:SECTION[count(ancestor::u:SECTION) &lt; $niveauxOrg][1]) = $idsectionorg]">
                        <xsl:text>Page prcdente</xsl:text>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:text>Section prcdente</xsl:text>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:when>
            <xsl:otherwise>
                <xsl:text>Page prcdente</xsl:text>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
<!-- ************************************************ -->
<!-- renvoie l'URL de la page du noeud courant (par rapport  la racine du site) -->
<!-- ************************************************ -->
    <xsl:template name="urlPage">
        <xsl:variable name="debut"><xsl:for-each select="(ancestor::u:SECTION)[self::u:SECTION]">
            <xsl:value-of select="concat(@label,'/')"/>
        </xsl:for-each></xsl:variable>
        <xsl:choose>
            <xsl:when test="self::u:SECTION"><xsl:choose>
                <xsl:when test="u:INTRODUCTION|u:PREREQUIS|u:OBJECTIFS|u:CITATION|u:RAPPEL|u:DEFINITION|u:METHODE|u:ATTENTION|u:CONSEIL"><xsl:value-of select="concat($debut,@label)"/>/index.html</xsl:when>
                <xsl:otherwise><xsl:for-each select="descendant::*[self::u:SECTION|self::u:GRAIN][1]"><xsl:call-template name="urlPage"/></xsl:for-each></xsl:otherwise>
            </xsl:choose></xsl:when>
            <xsl:when test="self::u:GRAIN"><xsl:value-of select="concat($debut,@label,'.html')"/></xsl:when>
            <xsl:otherwise><xsl:value-of select="concat($debut,name(),'.html')"/></xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
<!-- ************************************************ -->
<!-- id de la page du noeud courant -->
<!-- ************************************************ -->
    <xsl:template name="idPage">
        <xsl:for-each select="(ancestor::u:SECTION)[self::u:SECTION]">
            <xsl:value-of select="concat(@label,'_')"/>
        </xsl:for-each><xsl:choose>
            <xsl:when test="self::u:SECTION|self::u:GRAIN"><xsl:value-of select="@label"/></xsl:when>
            <xsl:otherwise><xsl:value-of select="name()"/></xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
<!-- ************************************************ -->
<!-- sommaire de toutes les pages de la section organisationnelle de l'lment courant -->
<!-- ************************************************ -->
    <xsl:template name="sommairePage">
        <xsl:param name="prefixe"/>
        <xsl:choose>
            <xsl:when test="/u:UVED/u:CONTENUS">
                <xsl:choose>
                    <xsl:when test="ancestor-or-self::u:SECTION and /u:UVED/u:CONTENUS/@niveauxOrg!='' and number(/u:UVED/u:CONTENUS/@niveauxOrg)!=0">
                        <xsl:variable name="niveauxOrg" select="number(/u:UVED/u:CONTENUS/@niveauxOrg)"/>
                        <xsl:for-each select="ancestor-or-self::u:SECTION[count(ancestor::u:SECTION) &lt; $niveauxOrg][1]/u:SECTION">
                            <xsl:call-template name="sommairePage2">
                                <xsl:with-param name="prefixe" select="$prefixe"/>
                            </xsl:call-template>
                        </xsl:for-each>
                    </xsl:when>
                    <xsl:otherwise> <!-- pour le sommaire ou si niveauxOrg n'est pas utilis -->
                        <xsl:for-each select="/u:UVED/u:CONTENUS/u:SECTION">
                            <xsl:call-template name="sommairePage2">
                                <xsl:with-param name="prefixe" select="$prefixe"/>
                            </xsl:call-template>
                        </xsl:for-each>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:when>
            <xsl:otherwise>
                <xsl:for-each select="/u:UVED/u:SECTION">
                    <xsl:call-template name="sommairePage2">
                        <xsl:with-param name="prefixe" select="$prefixe"/>
                    </xsl:call-template>
                </xsl:for-each>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <xsl:template name="sommairePage2">
        <xsl:param name="prefixe"/>
        <li>
            <xsl:attribute name="id"><xsl:call-template name="idPage"/></xsl:attribute>
            <a><xsl:attribute name="href"><xsl:value-of select="$prefixe"/><xsl:call-template name="urlPage"/></xsl:attribute>
                <xsl:choose>
                    <xsl:when test="@titre"><xsl:value-of select="@titre"/></xsl:when>
                    <xsl:when test="self::u:CONCLUSION">Conclusion</xsl:when>
                    <xsl:otherwise><xsl:value-of select="name()"/></xsl:otherwise>
                </xsl:choose></a>
            
            <xsl:if test="count(u:SECTION|u:GRAIN|u:CONCLUSION) > 0"> <!-- pas ANNEXES ni les ressources -->
                <ul>
                    <xsl:for-each select="u:SECTION|u:GRAIN|u:CONCLUSION">
                        <xsl:call-template name="sommairePage2">
                            <xsl:with-param name="prefixe" select="$prefixe"/>
                        </xsl:call-template>
                    </xsl:for-each>
                </ul>
            </xsl:if>
        </li>
    </xsl:template>


<!-- ************************************************ -->
<!-- Traitement des lments de bloc  -->
<!-- ************************************************ -->

    <xsl:template match="u:PARAGRAPHE">
        <!-- div class=bloc-standard / div class=content ? -->
        <p><xsl:apply-templates/></p>
    </xsl:template>
    
    <xsl:template match="u:INTRODUCTION">
        <xsl:variable name="prefixe"><xsl:for-each select="ancestor::u:SECTION">../</xsl:for-each></xsl:variable>
        <div class="bloc-expositif">
            <h3>
                <img src="{$prefixe}../medias/navigation/cours/introduction.png" width="25" height="25" alt="introduction"/>
                Introduction
            </h3>
            <div class="contenu-bloc">
                <xsl:apply-templates />
                <div class="fin-bloc"/>
            </div>
        </div>
    </xsl:template>
    
    <xsl:template match="u:CONCLUSION">
        <xsl:variable name="prefixe"><xsl:for-each select="ancestor::u:SECTION">../</xsl:for-each></xsl:variable>
        <div class="bloc-expositif">
            <h3>
                <img src="{$prefixe}../medias/navigation/cours/conclusion.png" width="25" height="25" alt="conclusion"/>
                Conclusion
            </h3>
            <div class="contenu-bloc">
                <xsl:apply-templates />
                <div class="fin-bloc"/>
            </div>
        </div>
    </xsl:template>
    
    <xsl:template match="u:PREREQUIS">
        <xsl:variable name="prefixe"><xsl:for-each select="ancestor::u:SECTION">../</xsl:for-each></xsl:variable>
        <div class="bloc-expositif">
            <h3>
                <img src="{$prefixe}../medias/navigation/cours/prerequis.png" width="25" height="25" alt="prerequis"/>
                Prrequis
            </h3>
            <div class="contenu-bloc">
                <xsl:apply-templates />
                <div class="fin-bloc"/>
            </div>
        </div>
    </xsl:template>
    
    <xsl:template match="u:OBJECTIFS">
        <xsl:variable name="prefixe"><xsl:for-each select="ancestor::u:SECTION">../</xsl:for-each></xsl:variable>
        <div class="bloc-expositif">
            <h3>
                <img src="{$prefixe}../medias/navigation/cours/objectifs.png" width="25" height="25" alt="objectifs"/>
                Objectifs
            </h3>
            <div class="contenu-bloc">
                <xsl:apply-templates />
                <div class="fin-bloc"/>
            </div>
        </div>
    </xsl:template>
    
    <xsl:template match="u:CITATION">
        <xsl:variable name="prefixe"><xsl:for-each select="ancestor::u:SECTION">../</xsl:for-each></xsl:variable>
        <div class="bloc-expositif">
            <h3>
                <img src="{$prefixe}../medias/navigation/cours/citation.png" width="25" height="25" alt="citation"/>
                Citation
            </h3>
            <div class="contenu-bloc">
                <xsl:apply-templates />
                <div class="fin-bloc"/>
            </div>
        </div>
    </xsl:template>
    
    <xsl:template match="u:RAPPEL">
        <xsl:variable name="prefixe"><xsl:for-each select="ancestor::u:SECTION">../</xsl:for-each></xsl:variable>
        <div class="bloc-expositif">
            <h3>
                <img src="{$prefixe}../medias/navigation/cours/rappel.png" width="25" height="25" alt="rappel"/>
                Rappel
            </h3>
            <div class="contenu-bloc">
                <xsl:apply-templates />
                <div class="fin-bloc"/>
            </div>
        </div>
    </xsl:template>
    
    <xsl:template match="u:DEFINITION">
        <xsl:variable name="prefixe"><xsl:for-each select="ancestor::u:SECTION">../</xsl:for-each></xsl:variable>
        <div class="bloc-expositif">
            <h3>
                <img src="{$prefixe}../medias/navigation/cours/definition.png" width="25" height="25" alt="dfinition"/>
                Dfinition
            </h3>
            <div class="contenu-bloc">
                <xsl:apply-templates />
                <div class="fin-bloc"/>
            </div>
        </div>
    </xsl:template>
    
    <xsl:template match="u:METHODE">
        <xsl:variable name="prefixe"><xsl:for-each select="ancestor::u:SECTION">../</xsl:for-each></xsl:variable>
        <div class="bloc-expositif">
            <h3>
                <img src="{$prefixe}../medias/navigation/cours/methode.png" width="25" height="25" alt="mthode"/>
                Mthode
            </h3>
            <div class="contenu-bloc">
                <xsl:apply-templates />
                <div class="fin-bloc"/>
            </div>
        </div>
    </xsl:template>
    
    <xsl:template match="u:ATTENTION">
        <xsl:variable name="prefixe"><xsl:for-each select="ancestor::u:SECTION">../</xsl:for-each></xsl:variable>
        <div class="bloc-expositif">
            <h3>
                <img src="{$prefixe}../medias/navigation/cours/attention.png" width="25" height="25" alt="attention"/>
                Attention
            </h3>
            <div class="contenu-bloc">
                <xsl:apply-templates />
                <div class="fin-bloc"/>
            </div>
        </div>
    </xsl:template>
    
    <xsl:template match="u:CONSEIL">
        <xsl:variable name="prefixe"><xsl:for-each select="ancestor::u:SECTION">../</xsl:for-each></xsl:variable>
        <div class="bloc-expositif">
            <h3>
                <img src="{$prefixe}../medias/navigation/cours/conseil.png" width="25" height="25" alt="conseil"/>
                Conseil
            </h3>
            <div class="contenu-bloc">
                <xsl:apply-templates />
                <div class="fin-bloc"/>
            </div>
        </div>
    </xsl:template>
    
    <xsl:template match="u:REMARQUE">
        <xsl:variable name="prefixe"><xsl:for-each select="ancestor::u:SECTION">../</xsl:for-each></xsl:variable>
        <div class="bloc-expositif">
            <h3>
                <img src="{$prefixe}../medias/navigation/cours/remarque.png" width="25" height="25" alt="remarque"/>
                Remarque
            </h3>
            <div class="contenu-bloc">
                <xsl:apply-templates />
                <div class="fin-bloc"/>
            </div>
        </div>
    </xsl:template>
    
    <xsl:template match="u:EXEMPLE">
        <xsl:variable name="prefixe"><xsl:for-each select="ancestor::u:SECTION">../</xsl:for-each></xsl:variable>
        <div class="bloc-expositif">
            <h3>
                <img src="{$prefixe}../medias/navigation/cours/exemple.png" width="25" height="25" alt="exemple"/>
                Exemple
            </h3>
            <div class="contenu-bloc">
                <xsl:apply-templates />
                <div class="fin-bloc"/>
            </div>
        </div>
    </xsl:template>
    
    <xsl:template match="u:COMPLEMENT">
        <xsl:variable name="prefixe"><xsl:for-each select="ancestor::u:SECTION">../</xsl:for-each></xsl:variable>
        <div class="bloc-expositif">
            <h3>
                <img src="{$prefixe}../medias/navigation/cours/complement.png" width="25" height="25" alt="complement"/>
                Complment
            </h3>
            <div class="contenu-bloc">
                <xsl:apply-templates />
                <div class="fin-bloc"/>
            </div>
        </div>
    </xsl:template>
    
    <xsl:template match="u:ENSAVOIRPLUS">
        <xsl:variable name="prefixe"><xsl:for-each select="ancestor::u:SECTION">../</xsl:for-each></xsl:variable>
        <div class="bloc-expositif">
            <h3>
                <img src="{$prefixe}../medias/navigation/cours/ensavoirplus.png" width="25" height="25" alt="en savoir plus"/>
                En savoir plus
            </h3>
            <div class="contenu-bloc">
                <xsl:apply-templates />
                <div class="fin-bloc"/>
            </div>
        </div>
    </xsl:template>
    
    <xsl:template match="u:SYNTAXE">
        <xsl:variable name="prefixe"><xsl:for-each select="ancestor::u:SECTION">../</xsl:for-each></xsl:variable>
        <div class="bloc-expositif">
            <h3>
                <img src="{$prefixe}../medias/navigation/cours/syntaxe.png" width="25" height="25" alt="syntaxe"/>
                Syntaxe
            </h3>
            <div class="contenu-bloc">
                <xsl:apply-templates />
                <div class="fin-bloc"/>
            </div>
        </div>
    </xsl:template>
    
    <xsl:template match="u:EXPLICATION">
        <xsl:variable name="prefixe"><xsl:for-each select="ancestor::u:SECTION">../</xsl:for-each></xsl:variable>
        <div class="bloc-expositif">
            <h3>
                <img src="{$prefixe}../medias/navigation/cours/explication.png" width="25" height="25" alt="explication"/>
                Explication
            </h3>
            <div class="contenu-bloc">
                <xsl:apply-templates />
                <div class="fin-bloc"/>
            </div>
        </div>
    </xsl:template>
    
    <xsl:template match="u:CONFERE">
        <xsl:variable name="prefixe"><xsl:for-each select="ancestor::u:SECTION">../</xsl:for-each></xsl:variable>
        <div class="bloc-expositif">
            <h3>
                <img src="{$prefixe}../medias/navigation/cours/confere.png" width="25" height="25" alt="confere"/>
                Confre
            </h3>
            <div class="contenu-bloc">
                <xsl:apply-templates />
                <div class="fin-bloc"/>
            </div>
        </div>
    </xsl:template>
    
    <xsl:template match="u:ACTIVITE">
        <xsl:variable name="prefixe"><xsl:for-each select="ancestor::u:SECTION">../</xsl:for-each></xsl:variable>
        <div class="bloc-expositif">
            <h3>
                <img src="{$prefixe}../medias/navigation/cours/activite.png" width="25" height="25" alt="activite"/>
                Activit
            </h3>
            <div class="contenu-bloc">
                <xsl:apply-templates />
                <div class="fin-bloc"/>
            </div>
        </div>
    </xsl:template>
   
    <xsl:template match="u:COMMENTAIRE">
    </xsl:template>
   
   
<!-- ************************************************ -->
<!-- EXERCICE  -->
<!-- ************************************************ -->

    <xsl:template match="u:EXERCICE">
        <xsl:variable name="prefixe"><xsl:for-each select="ancestor::u:SECTION">../</xsl:for-each></xsl:variable>
        <div class="bloc-expositif">
            <h3>
                <img src="{$prefixe}../medias/navigation/cours/exercice.png" width="25" height="25" alt="exercice"/>
                Exercice
            </h3>
            <div class="contenu-bloc">
                <h4><xsl:value-of select="@titre"/></h4>
                <xsl:apply-templates select="u:ENONCE"/>
                <xsl:if test="u:DIFFICULTE | u:TEMPS">
                    <p>
                        <xsl:if test="u:DIFFICULTE">
                            Difficult : <xsl:value-of select="u:DIFFICULTE"/>&#xA0;&#xA0;
                        </xsl:if>
                        <xsl:if test="u:TEMPS">
                            Temps : <xsl:value-of select="u:TEMPS"/>
                        </xsl:if>
                    </p>
                </xsl:if>
                <xsl:apply-templates select="u:QUESTION"/>
                <div class="fin-bloc"/>
            </div>
        </div>
    </xsl:template>
    
    <xsl:template match="u:ENONCE">
        <xsl:variable name="classe"><xsl:choose>
            <xsl:when test="parent::u:EXERCICE">enonceexercice</xsl:when>
            <xsl:when test="parent::u:QUESTION">enoncequestion</xsl:when>
        </xsl:choose></xsl:variable>
        <div class="{$classe}">
            <xsl:apply-templates/>
        </div>
    </xsl:template>
    
    <xsl:template match="u:QUESTION">
        <xsl:variable name="numquestion"><xsl:number level="any" from="u:EXERCICE" count="u:QUESTION"/></xsl:variable>
        <div class="question">
            <b>Question <xsl:value-of select="$numquestion"/>)</b>&#xA0;&#xA0;
            <xsl:apply-templates select="u:ENONCE"/>
            <p>
                <xsl:apply-templates select="u:AIDE" mode="lien"/>
                <xsl:apply-templates select="u:SOLUTION" mode="lien"/>
                <xsl:apply-templates select="u:POINTS"/>
            </p>
        </div>
    </xsl:template>
    
    <xsl:template match="u:AIDE" mode="lien">
        <xsl:variable name="numaide"><xsl:number level="any" from="u:SECTION" count="u:AIDE | u:SOLUTION"/></xsl:variable>
        
        <xsl:variable name="nomFichier" select="concat('aide',$numaide,'.html')"/>
        <a href="{$nomFichier}" onclick="javascript:CIRM.utils.Window.openCenterWindow('{$nomFichier}',600, 400, 'Aide'); return false" title="Aide"><span class="help">Aide</span></a>&#xA0;&#xA0;
    </xsl:template>
    
    <xsl:template match="u:AIDE">
        <xsl:apply-templates/>
    </xsl:template>
    
    <xsl:template match="u:SOLUTION" mode="lien">
        <xsl:variable name="numaide">
            <xsl:number level="any" from="u:SECTION" count="u:AIDE | u:SOLUTION"/>
        </xsl:variable>
        <xsl:variable name="nomFichier" select="concat('aide',$numaide,'.html')"/>
        <a href="{$nomFichier}" class="liensolution" onclick="javascript:CIRM.utils.Window.openCenterWindow('{$nomFichier}',600, 400, 'Solution'); return false"><span class="help">Solution</span></a>&#xA0;&#xA0;
    </xsl:template>
    
    <xsl:template match="u:SOLUTION">
        <xsl:apply-templates/>
    </xsl:template>
    
    <xsl:template match="u:POINTS">
        [<em><xsl:value-of select="."/> points</em>]
    </xsl:template>


<!-- ************************************************ -->
<!-- QCM  -->
<!-- ************************************************ -->

    <xsl:template match="u:QCM">
        <xsl:variable name="prefixe"><xsl:for-each select="ancestor::u:SECTION">../</xsl:for-each></xsl:variable>
        <div class="bloc-expositif">
            <h3>
                <img src="{$prefixe}../medias/navigation/cours/qcm.png" width="25" height="25" alt="qcm"/>
                QCM
            </h3>
            <div class="contenu-bloc">
                <h4><xsl:value-of select="@titre"/></h4>
                <xsl:variable name="numqcm"><xsl:number level="any" from="u:SECTION" count="u:QCM" /></xsl:variable>
                <!-- remarque: le onsubmit ne marchera pas sur de vieux navigateurs, mais c'est le seul
                    moyen d'avoir un code valide -->
                <form name="qcm{$numqcm}" action="#" onsubmit="resultat({$numqcm}); return false">
                    <xsl:apply-templates select="u:QUESTIONQCM"/>
                    <br/>
                    <input value="Solution" type="submit"/>&#xA0;
                    <xsl:apply-templates select="u:AIDE" mode="lien"/>
                </form>
            </div>
        </div>
    </xsl:template>
    
    <xsl:template match="u:QUESTIONQCM">
        <div class="questionqcm">
            <xsl:apply-templates/>
        </div>
    </xsl:template>
    
    <xsl:template match="u:ENONCEQCM">
        <xsl:variable name="numquestion"><xsl:number level="any" from="u:QCM" count="u:QUESTIONQCM"/></xsl:variable>
        <div class="enonceqcm">
            <xsl:value-of select="$numquestion"/>)&#xA0;<xsl:apply-templates/>
        </div>
    </xsl:template>
    
    <xsl:template match="u:REPONSEQCM">
        <br/>
        <xsl:variable name="vraifaux"><xsl:choose>
            <xsl:when test="@bonne='oui'">V</xsl:when>
            <xsl:when test="@bonne='non'">F</xsl:when>
            <xsl:otherwise><xsl:choose>
                <xsl:when test="u:COMMENTAIREREP='ok'">V</xsl:when>
                <xsl:otherwise>F</xsl:otherwise>
            </xsl:choose></xsl:otherwise>
        </xsl:choose></xsl:variable>
        <xsl:variable name="numquestion"><xsl:number level="any" from="u:QCM" count="u:QUESTIONQCM" /></xsl:variable>
        <input type="radio" name="repq{$numquestion}" value="{$vraifaux}{normalize-space(u:COMMENTAIREREP)}"/>
        <xsl:apply-templates/>
    </xsl:template>
    
    <xsl:template match="u:TEXTEREP">
        <span class="reptexte">
            <xsl:apply-templates/>
        </span>
    </xsl:template>
    
    <xsl:template match="u:COMMENTAIREREP">
    </xsl:template>
    

<!-- ************************************************ -->
<!-- Traitement des lments du groupe styletexte -->
<!-- ************************************************ -->

    <xsl:template match="u:B">
        <b><xsl:apply-templates/></b>
    </xsl:template>

    <xsl:template match="u:I">
        <i><xsl:apply-templates/></i>
    </xsl:template>
       
    <xsl:template match="u:EM">
        <em><xsl:apply-templates/></em>
    </xsl:template>
    
    <xsl:template match="u:SUP">
        <sup><xsl:apply-templates/></sup>
    </xsl:template>
    
    <xsl:template match="u:SUB">
        <sub><xsl:apply-templates/></sub>
    </xsl:template>
    
    <xsl:template match="u:NBSP">&#xA0;</xsl:template>
    
    <xsl:template match="u:BR">
        <br/>
    </xsl:template>


<!-- ************************************************ -->
<!-- Traitement des lments de titre -->
<!-- ************************************************ -->

    <xsl:template match="u:SECTION">
        <xsl:variable name="niveauxOrg"><xsl:choose>
            <xsl:when test="/u:UVED/u:CONTENUS/@niveauxOrg!=''"><xsl:value-of select="/u:UVED/u:CONTENUS/@niveauxOrg"/></xsl:when>
            <xsl:otherwise>0</xsl:otherwise>
        </xsl:choose></xsl:variable>
        <xsl:variable name="niveau" select="count(ancestor-or-self::u:SECTION) - number($niveauxOrg)"/>
        <xsl:variable name="niveau2"><xsl:choose>
            <xsl:when test="$niveau > 4">4</xsl:when>
            <xsl:otherwise><xsl:value-of select="$niveau"/></xsl:otherwise>
        </xsl:choose></xsl:variable>
        <div class="titre-section">
            <a name="{@label}"/>
            <h1 class="titre-section{$niveau2}">
                <xsl:value-of select="@titre" />
            </h1>
        </div>
    </xsl:template>
    
    <xsl:template match="u:GRAIN">
        <div class="titre-section">
            <a name="{@label}"/>
            <h1 class="titre-grain">
                <xsl:value-of select="@titre" />
            </h1>
        </div>
    </xsl:template>
    
    <xsl:template match="u:ANNEXE">
        <div class="titre-section">
            <a name="{@label}"/>
            <h1 class="titre-annexe">
                <xsl:value-of select="@titre" />
            </h1>
        </div>
    </xsl:template>

   <!--GESTION DES LISTES-->
    <xsl:template match="u:LISTE">
        <xsl:if test="@titre!=''">
            <xsl:choose>
                <xsl:when test="ancestor::u:LISTE">
                    <h6><xsl:value-of select="@titre"/></h6>
                </xsl:when>
                <xsl:otherwise>
                    <h4><xsl:value-of select="@titre"/></h4>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:if>
        <xsl:choose>
            <xsl:when test="@type='puces'">
                <ul><xsl:apply-templates select="u:ITEM"/></ul>
            </xsl:when>
            <xsl:otherwise>
                <ol><xsl:apply-templates select="u:ITEM"/></ol>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
   
   <xsl:template match="u:ITEM">
        <li><xsl:apply-templates /></li>
   </xsl:template>
   
   <!-- GESTION DES TABLES -->
    <xsl:template match="u:ZONETABLE">
        <div class="zonetable">
            <h3><xsl:value-of select="@titre"/></h3>
            <xsl:apply-templates select="u:TABLE"/>
            <xsl:apply-templates select="u:LEGENDE"/>
        </div>
    </xsl:template>
    
    <xsl:template match="u:TABLE">
        <table border="1" cellspacing="0" cellpadding="2">
            <xsl:apply-templates select="u:TR" />
        </table>
    </xsl:template>

    <xsl:template match="u:TR">
        <tr class="p{2 - (position() mod 2)}">
            <xsl:apply-templates select="u:TH" />
            <xsl:apply-templates select="u:TD" />
        </tr>
    </xsl:template>
        
    <xsl:template match="u:TH">
        <th>
            <xsl:if test="@colspan"><xsl:attribute name="colspan"><xsl:value-of select="@colspan"/></xsl:attribute></xsl:if>
            <xsl:if test="@rowspan"><xsl:attribute name="rowspan"><xsl:value-of select="@rowspan"/></xsl:attribute></xsl:if>
            <xsl:if test="@align"><xsl:attribute name="align"><xsl:value-of select="@align"/></xsl:attribute></xsl:if>
            <xsl:apply-templates />
        </th>
    </xsl:template>
        
    <xsl:template match="u:TD">
        <td>
            <xsl:if test="@colspan"><xsl:attribute name="colspan"><xsl:value-of select="@colspan"/></xsl:attribute></xsl:if>
            <xsl:if test="@rowspan"><xsl:attribute name="rowspan"><xsl:value-of select="@rowspan"/></xsl:attribute></xsl:if>
            <xsl:if test="@align"><xsl:attribute name="align"><xsl:value-of select="@align"/></xsl:attribute></xsl:if>
            <xsl:apply-templates />
        </td>
    </xsl:template>
    
    
<!-- ************************************************ -->
<!-- Traitement des medias -->
<!-- ************************************************ -->

    <xsl:template match="u:MEDIA">
        <xsl:variable name="prefixe"><xsl:for-each select="ancestor::u:SECTION">../</xsl:for-each></xsl:variable>
        <xsl:choose>
            <!-- media en page -->
            <xsl:when test="@localisation='page'">
                <xsl:variable name="numero"><xsl:number level="any" from="u:SECTION" count="u:MEDIA"/></xsl:variable>
                <xsl:variable name="nomFichier" select="concat('media',$numero,'.html')"/>
                <xsl:variable name="taille-max"><xsl:choose>
                    <xsl:when test="u:TAILLE/@largeur &gt; u:TAILLE/@hauteur"><xsl:value-of select="u:TAILLE/@largeur"/></xsl:when>
                    <xsl:otherwise><xsl:value-of select="u:TAILLE/@hauteur"/></xsl:otherwise>
                </xsl:choose></xsl:variable>
                <xsl:variable name="ratio" select="300 div number($taille-max)"/>
                <div class="media-page">
                    <xsl:choose>
                        <xsl:when test="u:FICHIER/@format='gif' or u:FICHIER/@format='png' or u:FICHIER/@format='jpeg'">
                            <xsl:variable name="chemin-image"><xsl:choose>
                                <xsl:when test="$jaxe-fichier-xml!='' and (u:TAILLE/@largeur &gt; 300 or u:TAILLE/@hauteur &gt; 300)"><xsl:value-of select="concat('images_page/', u:FICHIER/@chemin)"/></xsl:when>
                                <xsl:otherwise><xsl:value-of select="u:FICHIER/@chemin"/></xsl:otherwise>
                            </xsl:choose></xsl:variable>
                            <div class="bloc-media">
                                <xsl:if test="@titre">
                                    <h3><xsl:value-of select="@titre"/></h3>
                                </xsl:if>
                                <div class="media">
                                    <a href="{$nomFichier}" target="_blank" onclick="javascript:CIRM.utils.Window.openCenterWindow('{$nomFichier}',{u:TAILLE/@largeur + 20}, {u:TAILLE/@hauteur + 200}, 'Media'); return false">
                                        <xsl:if test="@titre">
                                            <xsl:attribute name="title"><xsl:value-of select="@titre"/></xsl:attribute>
                                        </xsl:if>
                                        <xsl:variable name="largeur"><xsl:choose>
                                            <xsl:when test="u:TAILLE/@largeur &gt; 300 or u:TAILLE/@hauteur &gt; 300"><xsl:value-of select="round(number(u:TAILLE/@largeur) * $ratio)"/></xsl:when>
                                            <xsl:otherwise><xsl:value-of select="u:TAILLE/@largeur"/></xsl:otherwise>
                                        </xsl:choose></xsl:variable>
                                        <xsl:variable name="hauteur"><xsl:choose>
                                            <xsl:when test="u:TAILLE/@largeur &gt; 300 or u:TAILLE/@hauteur &gt; 300"><xsl:value-of select="round(number(u:TAILLE/@hauteur) * $ratio)"/></xsl:when>
                                            <xsl:otherwise><xsl:value-of select="u:TAILLE/@hauteur"/></xsl:otherwise>
                                        </xsl:choose></xsl:variable>
                                        <img src="{$chemin-image}" width="{$largeur}" height="{$hauteur}" alt="media"/>
                                    </a>
                                </div>
                                <xsl:apply-templates select="u:LEGENDE"/>
                                <xsl:apply-templates select="u:CREDITS"/>
                            </div>
                        </xsl:when>
                        <xsl:otherwise>
                            <xsl:call-template name="media-content"/>
                        </xsl:otherwise>
                    </xsl:choose>
                </div>
            </xsl:when>
            <!-- media en icne -->
            <xsl:when test="@localisation='icne'">
                <xsl:variable name="numero"><xsl:number level="any" from="u:SECTION" count="u:MEDIA"/></xsl:variable>
                <xsl:variable name="nomFichier" select="concat('media',$numero,'.html')"/>
                <a href="{$nomFichier}" target="_blank" onclick="javascript:CIRM.utils.Window.openCenterWindow('{$nomFichier}',{u:TAILLE/@largeur + 20}, {u:TAILLE/@hauteur + 200}, 'Media'); return false">
                    <xsl:if test="@titre">
                        <xsl:attribute name="title"><xsl:value-of select="@titre"/></xsl:attribute>
                    </xsl:if>
                    <xsl:choose>
                        <xsl:when test="$jaxe-fichier-xml!='' and (u:FICHIER/@format='gif' or u:FICHIER/@format='png' or u:FICHIER/@format='jpeg') and (u:TAILLE/@largeur &gt; 100 or u:TAILLE/@hauteur &gt; 100)">
                            <xsl:variable name="taille-max"><xsl:choose>
                                <xsl:when test="u:TAILLE/@largeur &gt; u:TAILLE/@hauteur"><xsl:value-of select="u:TAILLE/@largeur"/></xsl:when>
                                <xsl:otherwise><xsl:value-of select="u:TAILLE/@hauteur"/></xsl:otherwise>
                            </xsl:choose></xsl:variable>
                            <xsl:variable name="ratio" select="100 div number($taille-max)"/>
                            <img src="images_icone/{u:FICHIER/@chemin}" width="{round(number(u:TAILLE/@largeur) * $ratio)}" height="{round(number(u:TAILLE/@hauteur) * $ratio)}" alt="media" align="right" class="icone"/>
                        </xsl:when>
                        <xsl:otherwise>
                            <img src="{$prefixe}../medias/navigation/cours/media.png" width="50" height="50" alt="media" align="right" class="icone"/>
                        </xsl:otherwise>
                    </xsl:choose>
                </a>
            </xsl:when>
            <!-- media en texte -->
            <xsl:otherwise>
                <xsl:call-template name="media-content"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    <xsl:template name="fichier-media">
        <xsl:variable name="debut-chemin"><xsl:for-each select="(ancestor::u:SECTION)[self::u:SECTION]"><xsl:value-of select="concat(@label, $sep)"/></xsl:for-each></xsl:variable>
        <xsl:variable name="numero"><xsl:number level="any" from="u:SECTION" count="u:MEDIA"/></xsl:variable>
        <xsl:variable name="cheminFichier" select="concat($cheminSite,$debut-chemin,'media', $numero, '.html')"/>
        
        <xsl:call-template name="ecrireDansFichier">
            <xsl:with-param name="fichier" select="$cheminFichier"/>
            <xsl:with-param name="contenu">
                <html>
                    <xsl:call-template name="headerMedia" />
                    <body>
                        <div class="cours">
                            <xsl:call-template name="media-content"/>
                        </div>
                        <xsl:apply-templates select=".//*[self::u:MOTDUGLOSSAIRE | self::u:LIENMOTDUGLOSSAIRE | self::u:REFERENCEBIBLIOGRAPHIQUE | self::u:LIENREFERENCEBIBLIOGRAPHIQUE | self::u:REFERENCEWEBOGRAPHIQUE | self::u:LIENREFERENCEWEBOGRAPHIQUE]" mode="div"/>
                        <div id="close">
                            <a href="javascript:window.close();">Fermer la fentre</a>
                        </div>
                    </body>
                </html>
            </xsl:with-param>
        </xsl:call-template>
    </xsl:template>
    
    <xsl:template name="media-content">
        <div class="bloc-media">
            <xsl:if test="@titre">
                <h3><xsl:value-of select="@titre"/></h3>
            </xsl:if>
            <div class="media">
                <xsl:choose>
                <xsl:when test="u:FICHIER/@format='gif' or u:FICHIER/@format='jpeg' or u:FICHIER/@format='png'">
                  <img src="{u:FICHIER/@chemin}">
                     <xsl:if test="u:TAILLE/@largeur!=''">
                         <xsl:attribute name="width"><xsl:value-of select="u:TAILLE/@largeur"/></xsl:attribute>
                     </xsl:if>
                     <xsl:if test="u:TAILLE/@hauteur!=''">
                         <xsl:attribute name="height"><xsl:value-of select="u:TAILLE/@hauteur"/></xsl:attribute>
                     </xsl:if>
                  </img>
                </xsl:when>
                <xsl:when test="u:FICHIER/@format='mpeg'">
                    <embed src="{u:FICHIER/@chemin}" type="video/mpg" width="{u:TAILLE/@largeur}" height="{u:TAILLE/@hauteur}">
                        <xsl:for-each select="u:PARAMETRES/u:PARAMETRE">
                            <param name="@nom" value="@valeur"/>
                        </xsl:for-each>
                    </embed>
                    <noembed>
                        Il faut un lecteur de vido lisant le format mpeg pour afficher cette squence.
                    </noembed>
                </xsl:when>
                <xsl:when test="u:FICHIER/@format='java'">
                    <xsl:variable name="class" select="u:PARAMETRES/u:PARAMETRE[@nom='classe']/@valeur"/>
                    <xsl:variable name="archive" select="u:PARAMETRES/u:PARAMETRE[@nom='archive']/@valeur"/>
                    <xsl:variable name="codebase" select="u:PARAMETRES/u:PARAMETRE[@nom='codebase']/@valeur"/>
                    <object classid="clsid:8AD9C840-044E-11D1-B3E9-00805F499D93" 
                            width="{u:TAILLE/@largeur}" height="{u:TAILLE/@hauteur}">
                        <param name="code" value="{$class}"/>
                        <xsl:for-each select="u:PARAMETRES/u:PARAMETRE[@nom!='classe']">
                            <param name="{@nom}" value="{@valeur}"/>
                        </xsl:for-each>
                        <xsl:comment>[if gte IE 7]&gt; &lt;!</xsl:comment>
                        <object classid="java:{$class}"
                                type="application/x-java-applet"
                                archive="{$archive}"
                                width="{u:TAILLE/@largeur}" height="{u:TAILLE/@hauteur}">
                            <xsl:if test="u:PARAMETRES/u:PARAMETRE[@nom='codebase']">
                                <xsl:attribute name="codebase"><xsl:value-of select="$codebase"/></xsl:attribute>
                            </xsl:if>
                            <!-- Konqueror browser needs the following param -->
                            <param name="code" value="{$class}" />
                            <xsl:if test="u:PARAMETRES/u:PARAMETRE[@nom='codebase']">
                                <!-- Safari browser needs the following param -->
                                <param name="JAVA_CODEBASE" value="{$codebase}" />
                            </xsl:if>
                            <xsl:for-each select="u:PARAMETRES/u:PARAMETRE[@nom!='classe' and @nom!='codebase']">
                                <param name="{@nom}" value="{@valeur}"/>
                            </xsl:for-each>
                            Java doit tre activ dans le navigateur pour voir cette applet.
                        </object>
                        <xsl:comment>&lt;![endif]</xsl:comment>
                    </object>
                </xsl:when>
                <xsl:when test="u:FICHIER/@format='flash'">
                    <object codebase="http://download.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=8,0,24,0" classid="clsid:D27CDB6E-AE6D-11cf-96B8-444553540000" width="{u:TAILLE/@largeur}" height="{u:TAILLE/@hauteur}" title="{@titre}">
                        <param name="movie" value="{u:FICHIER/@chemin}"/>
                        <xsl:variable name="parametres"><xsl:call-template name="getParametres"/></xsl:variable>
                         <param name="flashvars" value="{$parametres}" />
                        <xsl:choose>
                            <xsl:when test="$parametres">
                                <embed src="{u:FICHIER/@chemin}?{$parametres}" quality="high" pluginspage="http://www.macromedia.com/go/getflashplayer" type="application/x-shockwave-flash" width="{u:TAILLE/@largeur}" height="{u:TAILLE/@hauteur}"></embed>
                            </xsl:when>
                            <xsl:otherwise>
                                <embed src="{u:FICHIER/@chemin}" quality="high" pluginspage="http://www.macromedia.com/go/getflashplayer" type="application/x-shockwave-flash" width="{u:TAILLE/@largeur}" height="{u:TAILLE/@hauteur}"></embed>
                            </xsl:otherwise>
                        </xsl:choose>
                    </object>
                </xsl:when>
                </xsl:choose>
            </div>
            
            <xsl:apply-templates select="u:LEGENDE"/>
            <xsl:apply-templates select="u:CREDITS"/>
        </div>
    </xsl:template>
    
    <xsl:template name="getParametres">
        <xsl:for-each select="u:PARAMETRES/u:PARAMETRE">
           <xsl:value-of select="concat(@nom,'=',@valeur,'&#38;')" />
        </xsl:for-each>
    </xsl:template>

    <xsl:template match="u:LEGENDE">
        <div class="bloc-legende">
            <xsl:apply-templates/>
        </div>
    </xsl:template>
    
    <xsl:template match="u:CREDITS">
        <div class="bloc-credits">
            Crdits: <xsl:apply-templates/>
        </div>
    </xsl:template>
    
    <xsl:template match="u:FICHIER">
        <img src="{@chemin}" />
    </xsl:template>
    
    
<!-- ************************************************ -->
<!-- Elments mlangs au texte -->
<!-- ************************************************ -->

    <xsl:key name="biblio" match="u:REFERENCEBIBLIOGRAPHIQUE" use="@labelReference"/>
    <xsl:key name="webo" match="u:REFERENCEWEBOGRAPHIQUE" use="@labelAdress"/>
    
    <xsl:template match="u:LIEN">
        <xsl:variable name="prefixe"><xsl:for-each select="ancestor::u:SECTION">../</xsl:for-each></xsl:variable>
        <xsl:variable name="label" select="@label"/>
        <xsl:variable name="url"><xsl:choose>
            <xsl:when test="@type='section'">
                <xsl:for-each select="(//u:SECTION[@label=$label])[1]">
                    <xsl:value-of select="$prefixe"/><xsl:call-template name="urlPage"/>
                </xsl:for-each>
            </xsl:when>
            <xsl:when test="@type='grain'">
                <xsl:for-each select="(//u:GRAIN[@label=$label])[1]">
                    <xsl:value-of select="$prefixe"/><xsl:call-template name="urlPage"/>
                </xsl:for-each>
            </xsl:when>
            <xsl:when test="@type='annexe'">
                <xsl:for-each select="(//u:ANNEXE[@label=$label])[1]">
                    <xsl:value-of select="$prefixe"/><xsl:for-each select="(ancestor::u:SECTION)[self::u:SECTION]">
                        <xsl:value-of select="concat(@label,'/')"/>
                    </xsl:for-each><xsl:value-of select="concat(@label,'.html')"/>
                </xsl:for-each>
            </xsl:when>
        </xsl:choose></xsl:variable>
        <xsl:variable name="titre"><xsl:choose>
            <xsl:when test="@type='section'">
                <xsl:for-each select="(//u:SECTION[@label=$label])[1]">
                    <xsl:value-of select="concat('section &quot;', @titre, '&quot;')"/>
                </xsl:for-each>
            </xsl:when>
            <xsl:when test="@type='grain'">
                <xsl:for-each select="(//u:GRAIN[@label=$label])[1]">
                    <xsl:value-of select="concat('page &quot;', @titre, '&quot;')"/>
                </xsl:for-each>
            </xsl:when>
            <xsl:when test="@type='annexe'">
                <xsl:for-each select="(//u:ANNEXE[@label=$label])[1]">
                    <xsl:value-of select="concat('annexe &quot;', @titre, '&quot;')"/>
                </xsl:for-each>
            </xsl:when>
        </xsl:choose></xsl:variable>
        <xsl:choose>
            <xsl:when test="@type='annexe'">
                <a href="javascript:CIRM.utils.Window.openCenterWindow('{$url}',800,600,'{@label}')" title="{$titre}">
                    <xsl:apply-templates/>
                </a>
            </xsl:when>
            <xsl:otherwise>
                <a href="{$url}" title="{$titre}">
                    <img src="{$prefixe}../medias/navigation/cours/lien_interne.png" width="16" height="16" alt="lien interne"/>&#xA0;<xsl:apply-templates/>
                </a>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <xsl:template match="u:LIENWEB">
        <xsl:variable name="prefixe"><xsl:for-each select="ancestor::u:SECTION">../</xsl:for-each></xsl:variable>
        <a href="{@url}" title="site {@url}" target="_blank">
            <img src="{$prefixe}../medias/navigation/cours/internet.png" width="16" height="16" alt="lien externe"/>&#xA0;<xsl:apply-templates/>
        </a>
    </xsl:template>

    <xsl:template match="u:LIENDOCUMENT">
        <a href="{@url}" title="{.}" target="_blank">
            <xsl:apply-templates/>
        </a>
    </xsl:template>
    
    <xsl:template match="u:NOTE">
        <xsl:variable name="prefixe"><xsl:for-each select="ancestor::u:SECTION">../</xsl:for-each></xsl:variable>
        <a href="#" onmouseover="CIRM.utils.ToolTip.show('tip-{generate-id(.)}', event)" onmouseout="CIRM.utils.ToolTip.hide()">
            <img src="{$prefixe}../medias/navigation/cours/note.png" width="16" height="16" alt="note" />
        </a>
    </xsl:template>
    
    <xsl:template match="u:MOTDUGLOSSAIRE">
        <xsl:variable name="prefixe"><xsl:for-each select="ancestor::u:SECTION">../</xsl:for-each></xsl:variable>
        <xsl:variable name="motreftrans" select="translate(@mot,' ','_aaeeeiioouu')"/>
        <a href="{$prefixe}glossaire.html#{$motreftrans}" onmouseover="CIRM.utils.ToolTip.show('tip-{generate-id(.)}', event)" onmouseout="CIRM.utils.ToolTip.hide()">
            <xsl:value-of select="@mot" />
        </a>
    </xsl:template>
    
    <xsl:template match="u:LIENMOTDUGLOSSAIRE">
        <xsl:variable name="prefixe"><xsl:for-each select="ancestor::u:SECTION">../</xsl:for-each></xsl:variable>
        <xsl:variable name="motreftrans" select="translate(@labelReference,' ','_aaeeeiioouu')"/>
        <a href="{$prefixe}glossaire.html#{$motreftrans}" onmouseover="CIRM.utils.ToolTip.show('tip-{generate-id(.)}', event)" onmouseout="CIRM.utils.ToolTip.hide()">
            <xsl:value-of select="@mot" />
        </a>
    </xsl:template>
    
    <xsl:template match="u:REFERENCEBIBLIOGRAPHIQUE">
        <xsl:variable name="prefixe"><xsl:for-each select="ancestor::u:SECTION">../</xsl:for-each></xsl:variable>
        <xsl:variable name="desc" select="normalize-space(u:REFOUVRAGE/@titre | u:REFARTICLE/@titreArticle)"/>
        <a href="{$prefixe}bibliographie.html#{@labelReference}" onmouseover="CIRM.utils.ToolTip.show('tip-{generate-id(.)}', event)" onmouseout="CIRM.utils.ToolTip.hide()"><img src="{$prefixe}../medias/navigation/cours/reference.png" width="16" height="16" alt="{$desc}" /></a>
    </xsl:template>
   
    <xsl:template match="u:LIENREFERENCEBIBLIOGRAPHIQUE">
        <xsl:variable name="prefixe"><xsl:for-each select="ancestor::u:SECTION">../</xsl:for-each></xsl:variable>
        <xsl:variable name="ref" select="@labelReference" />
        <xsl:variable name="idRefLien" select="generate-id(.)" />
        <xsl:for-each select="//u:REFERENCEBIBLIOGRAPHIQUE">
            <xsl:variable name="idRef" select="generate-id(key('biblio',$ref)[1])"/>
            <xsl:if test="generate-id(.)=$idRef">
                <xsl:variable name="desc" select="normalize-space(u:REFOUVRAGE/@titre | u:REFARTICLE/@titreArticle)"/>
                <a href="{$prefixe}bibliographie.html#{@labelReference}" onmouseover="CIRM.utils.ToolTip.show('tip-l{$idRefLien}', event)" onmouseout="CIRM.utils.ToolTip.hide()">
                    <img src="{$prefixe}../medias/navigation/cours/reference.png" width="16" height="16" alt="{$desc}" />
                </a>
            </xsl:if>
        </xsl:for-each>
    </xsl:template>

    <xsl:template match="u:REFERENCEWEBOGRAPHIQUE">
        <xsl:variable name="prefixe"><xsl:for-each select="ancestor::u:SECTION">../</xsl:for-each></xsl:variable>
        <a href="{@URL}" target="_blank" onmouseover="CIRM.utils.ToolTip.show('tip-{generate-id()}', event)" onmouseout="CIRM.utils.ToolTip.hide()"><img src="{$prefixe}../medias/navigation/cours/internet.png" width="16" height="16" alt="{@titre}"/></a>
    </xsl:template>
   
    <xsl:template match="u:LIENREFERENCEWEBOGRAPHIQUE">
        <xsl:variable name="prefixe"><xsl:for-each select="ancestor::u:SECTION">../</xsl:for-each></xsl:variable>
        <xsl:variable name="ref" select="@labelReference" />
        <xsl:variable name="idRefLien" select="generate-id(.)" />
        <xsl:for-each select="//u:REFERENCEWEBOGRAPHIQUE">
            <xsl:variable name="idRef" select="generate-id(key('webo',$ref)[1])" />
            <xsl:if test="generate-id()=$idRef">
                <a href="{@URL}" target="_blank" onmouseover="CIRM.utils.ToolTip.show('tip-l{$idRefLien}', event)" onmouseout="CIRM.utils.ToolTip.hide()"><img src="{$prefixe}../medias/navigation/cours/internet.png" width="16" height="16" alt="{@titre}" /></a>
            </xsl:if>
        </xsl:for-each>
    </xsl:template>
   
    <xsl:template match="u:SYMBOLE">
        <xsl:variable name="nomlettre" select="substring-after(substring-after(@nom, '/'), '/')"/>
        <xsl:variable name="nomsansext" select="substring-before($nomlettre,'.')"/>
        <xsl:choose>
            <!--
            <xsl:when test="$nomsansext!='phi' and $nomsansext!='phi2' and $nomsansext!='sigmaf' and $nomsansext!='thetasym' and $nomsansext!='piv' and $nomsansext!='upsih'"><xsl:text disable-output-escaping='yes'>&amp;</xsl:text><xsl:value-of select="$nomsansext"/>;</xsl:when>
            -->
            <!-- BUG: disable-output-escaping fait drailler XSLTC, qui n'encode plus les caractres aprs...
                 En plus on ne peut pas spcifier un encodage avec redirect si on utilise XSLTC.
                 Le bug ne se produit pas avec Xalan, mais Xalan souffre du bug de la double dclaration de DTD -->
            <!-- disable-output-escaping ne marche pas non plus avec Saxon ! -->
            
            <!-- pour chaque symbole on donne l'quivalent sous forme de caractre UNICODE -->
            <xsl:when test="$nomsansext='Alpha'">&#x391;</xsl:when>
            <xsl:when test="$nomsansext='Beta'">&#x392;</xsl:when>
            <xsl:when test="$nomsansext='Gamma'">&#x393;</xsl:when>
            <xsl:when test="$nomsansext='Delta'">&#x394;</xsl:when>
            <xsl:when test="$nomsansext='Epsilon'">&#x395;</xsl:when>
            <xsl:when test="$nomsansext='Zeta'">&#x396;</xsl:when>
            <xsl:when test="$nomsansext='Eta'">&#x397;</xsl:when>
            <xsl:when test="$nomsansext='Theta'">&#x398;</xsl:when>
            <xsl:when test="$nomsansext='Iota'">&#x399;</xsl:when>
            <xsl:when test="$nomsansext='Kappa'">&#x39A;</xsl:when>
            <xsl:when test="$nomsansext='Lambda'">&#x39B;</xsl:when>
            <xsl:when test="$nomsansext='Mu'">&#x39C;</xsl:when>
            <xsl:when test="$nomsansext='Nu'">&#x39D;</xsl:when>
            <xsl:when test="$nomsansext='Xi'">&#x39E;</xsl:when>
            <xsl:when test="$nomsansext='Omicron'">&#x39F;</xsl:when>
            <xsl:when test="$nomsansext='Pi'">&#x3A0;</xsl:when>
            <xsl:when test="$nomsansext='Rho'">&#x3A1;</xsl:when>
            <xsl:when test="$nomsansext='Sigma'">&#x3A3;</xsl:when>
            <xsl:when test="$nomsansext='Tau'">&#x3A4;</xsl:when>
            <xsl:when test="$nomsansext='Upsilon'">&#x3A5;</xsl:when>
            <xsl:when test="$nomsansext='Phi'">&#x3A6;</xsl:when>
            <xsl:when test="$nomsansext='Chi'">&#x3A7;</xsl:when>
            <xsl:when test="$nomsansext='Psi'">&#x3A8;</xsl:when>
            <xsl:when test="$nomsansext='Omega'">&#x3A9;</xsl:when>
            <xsl:when test="$nomsansext='alpha'">&#x3B1;</xsl:when>
            <xsl:when test="$nomsansext='beta'">&#x3B2;</xsl:when>
            <xsl:when test="$nomsansext='gamma'">&#x3B3;</xsl:when>
            <xsl:when test="$nomsansext='delta'">&#x3B4;</xsl:when>
            <xsl:when test="$nomsansext='epsilon'">&#x3B5;</xsl:when>
            <xsl:when test="$nomsansext='zeta'">&#x3B6;</xsl:when>
            <xsl:when test="$nomsansext='eta'">&#x3B7;</xsl:when>
            <xsl:when test="$nomsansext='theta'">&#x3B8;</xsl:when>
            <xsl:when test="$nomsansext='iota'">&#x3B9;</xsl:when>
            <xsl:when test="$nomsansext='kappa'">&#x3BA;</xsl:when>
            <xsl:when test="$nomsansext='lambda'">&#x3BB;</xsl:when>
            <xsl:when test="$nomsansext='mu'">&#x3BC;</xsl:when>
            <xsl:when test="$nomsansext='nu'">&#x3BD;</xsl:when>
            <xsl:when test="$nomsansext='xi'">&#x3BE;</xsl:when>
            <xsl:when test="$nomsansext='omicron'">&#x3BF;</xsl:when>
            <xsl:when test="$nomsansext='pi'">&#x3C0;</xsl:when>
            <xsl:when test="$nomsansext='rho'">&#x3C1;</xsl:when>
            <!--<xsl:when test="$nomsansext='sigmaf'">&#x3C2;</xsl:when> pas toujours bien affich -->
            <xsl:when test="$nomsansext='sigma'">&#x3C3;</xsl:when>
            <xsl:when test="$nomsansext='tau'">&#x3C4;</xsl:when>
            <xsl:when test="$nomsansext='upsilon'">&#x3C5;</xsl:when>
            <!--<xsl:when test="$nomsansext='phi'">&#x3C6;</xsl:when> phi = unicode 03A6 != 03D5, invers dans Safari -->
            <xsl:when test="$nomsansext='chi'">&#x3C7;</xsl:when>
            <xsl:when test="$nomsansext='psi'">&#x3C8;</xsl:when>
            <xsl:when test="$nomsansext='omega'">&#x3C9;</xsl:when>
            <!--<xsl:when test="$nomsansext='thetasym'">&#x3D1;</xsl:when> pas toujours bien affich -->
            <!--<xsl:when test="$nomsansext='upsih'">&#x3D2;</xsl:when> pas toujours bien affich -->
            <!--<xsl:when test="$nomsansext='piv'">&#x3D6;</xsl:when> pas toujours bien affich -->
            
            <xsl:when test="$nomsansext='asymp'">&#x2248;</xsl:when>
            <xsl:when test="$nomsansext='cap'">&#x2229;</xsl:when>
            <xsl:when test="$nomsansext='cup'">&#x222A;</xsl:when>
            <xsl:when test="$nomsansext='exist'">&#x2203;</xsl:when>
            <xsl:when test="$nomsansext='forall'">&#x2200;</xsl:when>
            <xsl:when test="$nomsansext='ge'">&#x2265;</xsl:when>
            <xsl:when test="$nomsansext='harr'">&#x2194;</xsl:when>
            <xsl:when test="$nomsansext='hdarr'">&#x21D4;</xsl:when>
            <xsl:when test="$nomsansext='infin'">&#x221E;</xsl:when>
            <xsl:when test="$nomsansext='isin'">&#x2208;</xsl:when>
            <xsl:when test="$nomsansext='larr'">&#x2190;</xsl:when>
            <!-- ldarr = symbole HTML lArr ne s'affiche pas avec IE 6 -->
            <xsl:when test="$nomsansext='le'">&#x2264;</xsl:when>
            <xsl:when test="$nomsansext='nabla'">&#x2207;</xsl:when>
            <xsl:when test="$nomsansext='ne'">&#x2260;</xsl:when>
            <xsl:when test="$nomsansext='not'">&#xAC;</xsl:when>
            <xsl:when test="$nomsansext='part'">&#x2202;</xsl:when>
            <xsl:when test="$nomsansext='plusmn'">&#xB1;</xsl:when>
            <xsl:when test="$nomsansext='rarr'">&#x2192;</xsl:when>
            <xsl:when test="$nomsansext='rdarr'">&#x21D2;</xsl:when>
            <!-- sim ne s'affiche pas avec IE 6 -->
            <xsl:when test="$nomsansext='sub'">&#x2282;</xsl:when>
            
            <xsl:otherwise>
                <xsl:variable name="prefixe">../<xsl:for-each select="ancestor-or-self::u:SECTION">../</xsl:for-each>medias/</xsl:variable>
                <img src="{$prefixe}{@nom}" border="0" alt="{$nomlettre}"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    <xsl:template match="u:EQUAJAXE">
        <img class="jaxe" src="{@image}" alt="{@texte}" longdesc="{@texte}" />
    </xsl:template>
    
    <xsl:template match="u:EQUATEX">
        <img class="equatex" src="{@image}" alt="{@texte}" longdesc="{@texte}" />
    </xsl:template>
    
<!-- ************************************************ -->
<!-- Traitement particulier div hors content          -->
<!-- ************************************************ -->
    <xsl:key name="mots" match="u:MOTDUGLOSSAIRE" use="@mot"/>
    
    <xsl:template match="u:NOTE" mode="div">
        <div id="tip-{generate-id(.)}" class="tooltip">
            <h6>Note</h6>
            <p><xsl:apply-templates /></p>
        </div>
    </xsl:template>
  
    <xsl:template match="u:MOTDUGLOSSAIRE" mode="div">
        <div id="tip-{generate-id(.)}" class="tooltip">
            <h6>Dfinition</h6>
            <p><xsl:apply-templates /></p>
        </div>
    </xsl:template>
  
   <xsl:template match="u:LIENMOTDUGLOSSAIRE" mode="div">
        <div id="tip-{generate-id(.)}" class="tooltip">
             <h6>Dfinition</h6>
             <xsl:variable name="ref" select="@labelReference" />
             <xsl:for-each select="//u:MOTDUGLOSSAIRE">
                 <xsl:variable name="idRef" select="generate-id(key('mots',$ref)[1])"/>
                 <xsl:if test="generate-id(.)=$idRef">
                     <p><xsl:apply-templates /></p>
                 </xsl:if>
             </xsl:for-each>
        </div>
   </xsl:template>

    <xsl:template match="u:REFERENCEBIBLIOGRAPHIQUE" mode="div">
        <div id="tip-{generate-id(.)}" class="tooltip">
            <h6>Rfrence bibliographique</h6>
            <xsl:apply-templates select="u:REFOUVRAGE | u:REFARTICLE" mode="div"/>
        </div>
    </xsl:template>
    
    <xsl:template match="u:LIENREFERENCEBIBLIOGRAPHIQUE" mode="div">
        <xsl:variable name="ref" select="@labelReference" />
        <xsl:variable name="idRefLien" select="generate-id(.)" />
                
        <xsl:for-each select="//u:REFERENCEBIBLIOGRAPHIQUE">
            <xsl:variable name="idRef" select="generate-id(key('biblio',$ref)[1])"/>
            <xsl:if test="generate-id(.)=$idRef">
                <div id="tip-l{$idRefLien}" class="tooltip">
                    <h6><xsl:value-of select="'Rfrence bibliographique'" /></h6>
                    <xsl:apply-templates select="u:REFOUVRAGE | u:REFARTICLE" mode="div"/>
                </div>
            </xsl:if>
        </xsl:for-each>
    </xsl:template>
    
    <xsl:template match="u:REFOUVRAGE" mode="div">
        <p>
            <b>
                <xsl:value-of select="@premierAuteur"/>
                <xsl:if test="@autresAuteurs">
                    ; <xsl:value-of select="@autresAuteurs"/>
                </xsl:if>
            </b>.
            <b><i><xsl:value-of select="@titre"/></i></b>.
            <xsl:if test="@sous-titre">
                <xsl:value-of select="@sous-titre"/>.
            </xsl:if>
            <xsl:if test="@volume">
                <xsl:value-of select="@volume"/>.
            </xsl:if>
            <xsl:if test="@lieu">
                <xsl:value-of select="@lieu"/> :
            </xsl:if>
            <xsl:value-of select="@editeur"/>
            <xsl:if test="@annee">
                <xsl:text>, </xsl:text><xsl:value-of select="@annee"/>
            </xsl:if>
            <xsl:text>.</xsl:text>
            <xsl:if test="@pagination">
                <xsl:text> </xsl:text><xsl:value-of select="@pagination"/>.
            </xsl:if>
            <xsl:if test="@collection">
                coll. <xsl:value-of select="@collection"/>.
            </xsl:if>
            <xsl:if test="@isbn">
                ISBN <xsl:value-of select="@isbn"/>.
            </xsl:if>
        </p>
    </xsl:template>
    
    <xsl:template match="u:REFARTICLE" mode="div">
        <p>
            <b>
                <xsl:value-of select="@premierAuteur"/>
                <xsl:if test="@autresAuteurs">
                    ; <xsl:value-of select="@autresAuteurs"/>
                </xsl:if>
            </b>.
            <xsl:value-of select="@titreArticle"/>.
            <b><i><xsl:value-of select="@titrePeriodique"/></i></b>,
            <xsl:value-of select="@annee"/>
            <xsl:if test="@volume">
                <xsl:text>, </xsl:text><xsl:value-of select="@volume"/>
            </xsl:if>
            <xsl:if test="@numero">
                <xsl:text>, n</xsl:text><xsl:value-of select="@numero"/>,
            </xsl:if>
            <xsl:if test="@pagination">
                <xsl:value-of select="@pagination"/>.
            </xsl:if>
        </p>
    </xsl:template>
    
    <xsl:template match="u:REFERENCEWEBOGRAPHIQUE" mode="div">
        <div id="tip-{generate-id(.)}" class="tooltip">
            <xsl:apply-templates select="." mode="div2"/>
        </div>
    </xsl:template>
    
    <xsl:template match="u:LIENREFERENCEWEBOGRAPHIQUE" mode="div">
        <xsl:variable name="ref" select="@labelReference" />
        <xsl:variable name="idRefLien" select="generate-id(.)" />
        
        <xsl:for-each select="//u:REFERENCEWEBOGRAPHIQUE">
            <xsl:variable name="idRef" select="generate-id(key('webo',$ref)[1])"/>
            <xsl:if test="generate-id(.)=$idRef">
                <div id="tip-l{$idRefLien}" class="tooltip">
                    <xsl:apply-templates select="." mode="div2"/>
                </div>
            </xsl:if>
        </xsl:for-each>
    </xsl:template>
    
    <xsl:template match="u:REFERENCEWEBOGRAPHIQUE" mode="div2">
        <h6>Rfrence webographique</h6>
        <p>
            <b><xsl:value-of select="@auteurs"/></b>.
            <b><i><xsl:value-of select="@titre"/></i></b>.
            <xsl:if test="@titreSite">
                In <b><i><xsl:value-of select="@titreSite"/></i></b>.
            </xsl:if>
            [consult le <xsl:value-of select="@dateConsultation"/>]
            <tt><xsl:value-of select="@URL"/></tt>
        </p>
    </xsl:template>
    
</xsl:stylesheet>

