<?xml version="1.0" encoding='ISO-8859-1'?>

<xsl:stylesheet version="2.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:u="http://www.uved.fr/schema/2.0"
    exclude-result-prefixes="u">

    <!-- ************************************************ -->
    <!-- creation de la page de credits pour les cours UVED -->
    <!-- ************************************************ -->
    <!-- version 0.1 Romuald Lorthioir - CIRM - Universit de Rennes 1 -->
    <!-- version 1.0 pour UVED 2.0 -  Damien Guillaume, Observatoire de Paris -->

    <xsl:template name="UVED_CREDITS">

        <xsl:call-template name="ecrireDansFichier">
            <xsl:with-param name="fichier" select="concat($cheminSite,'credits.html')"/>
            <xsl:with-param name="contenu">
                <html lang="fr">
    
                    <xsl:call-template name="headerCredits" />
                    <body>
                        <h3>Auteurs</h3>
    
                        <ul>
                            <xsl:for-each select="u:UVED//u:METADONNEES/u:AUTEURS/u:AUTEUR">
                                <xsl:sort order="ascending" select="@nom" />
                                <xsl:if test="not(preceding::u:AUTEUR[@nom=current()/@nom and @prenom=current()/@prenom])">
                                    <li>
                                        <b>
                                            <xsl:value-of select="@nom" />
                                            <xsl:text>&#xA0;</xsl:text>
                                            <xsl:value-of select="@prenom" />
                                        </b>
                                        ,
                                        <xsl:value-of select="@fonction" />
                                        ,
                                        <xsl:value-of select="@organisme" />
                                        .
                                    </li>
                                </xsl:if>
                            </xsl:for-each>
                        </ul>
    
                        <div id="close">
                            <a href="javascript:window.close();" title="">Fermer la fentre</a>
                        </div>
    
                    </body>
                </html>
            </xsl:with-param>
        </xsl:call-template>
    </xsl:template>

</xsl:stylesheet>
