/**
 * @file    cirm.js
 * @version 1.0.0.0
 * @author  Stephane RIO et Damien Guillaume
 * @email   stephane.rio@univ-rennes1.fr
 * @date    2007.06.06
*/

var CIRM = window.CIRM || {};

/**
 * CIRM object.
*/
CIRM.create = function( namespace )
{
    if ( !namespace || !namespace.length )
	{
        return null;
    }
    var levels = namespace.split( "." );
    var current = CIRM;
    for ( var i = ( levels[ 0 ] == "CIRM" ) ? 1 : 0; i < levels.length; ++i )
	{
        current[ levels[ i ] ] = current[ levels[ i ] ] || {};
        current = current[ levels[ i ] ];
    }
    return current;
};


/**/

CIRM.create( "CIRM.utils" );

/**/


/**
 * Ajax Utilities
*/
CIRM.utils.Ajax =
{
	
	getXMLHttpRequest: function()
	{
		try
		{
			return new XMLHttpRequest();
		}
		catch ( e )
		{
			var options = new Array( 'Msxml2.XMLHTTP.5.0', 'Msxml2.XMLHTTP.4.0', 'Msxml2.XMLHTTP.3.0', 'Msxml2.XMLHTTP', 'Microsoft.XMLHTTP' );
			for ( var i = 0; i < options.length; i++ )
			{
				try 
				{
					return new ActiveXObject( options[ i ] );
				}
				catch ( e )
				{
					//
				}
			}
			throw new Error( "Browser does not support XMLHttpRequest" );
		}
	}
	
}

/**
 * Browser object.
*/
CIRM.utils.Browser =
{
	
	/**
	 *
	*/
	isGecko: function()
	{
		var userAgent = navigator.userAgent.toLowerCase();
		return ( !CIRM.utils.Browser.isOpera() && !CIRM.utils.Browser.isSafari() && userAgent.indexOf( "gecko" ) > -1 );
	},
	
	/**
	 *
	*/
	isInternetExplorer: function()
	{
		var userAgent = navigator.userAgent.toLowerCase();
		return ( !CIRM.utils.Browser.isOpera() && userAgent.indexOf( "msie" ) > -1 );
	},
	
	/**
	 *
	*/
	isOpera: function()
	{
		var userAgent = navigator.userAgent.toLowerCase();
		return ( userAgent.indexOf( "opera" ) > -1 );
	},
	
	/**
	 *
	*/
	isSafari: function()
	{
		var userAgent = navigator.userAgent.toLowerCase();
		return ( userAgent.indexOf( "safari" ) > -1 );
	}

};

/**
 * Cookie object.
*/
CIRM.utils.Cookie = 
{
	
	/**
	 * Writes a cookie.
	 *
	 * @param name
	 * @param value
	*/
	write: function( name, value, path )
	{
	    if (!path) {
		    document.cookie = name + "=" + escape( value ) + ";";
	    } else {
		    document.cookie = name + "=" + escape( value ) + ";" + "path=" + path + ";";
	    }
	},
	
	/**
	 * Reads a cookie.
	 *
	 * @param  name
	 * @return value
	*/
	read: function( name )
	{
		var cookies = document.cookie.split( /;/ );
		for ( var i = 0; i < cookies.length; i++ )
		{
			var current = cookies[ i ].split( /=/ );
			if ( current[ 0 ].substring( 1 ) == name )
			{
				return unescape( current[ 1 ] );
			}
		}
		return null;
	}

};

/**
 * Element object.
*/
CIRM.utils.Element =
{

	/**
	 *
	*/
	isElementExist: function( elementId )
	{
		return document.getElementById( elementId ) != null;
	},
	
	/**
	 *
	*/
	getElementHeight: function( elementId )
	{
		if ( typeof( elementId ) != "undefined" && CIRM.utils.Element.isElementExist( elementId ) )
		{
			return document.getElementById( elementId ).offsetHeight;
		}
		return 0;
	},
		
	/**
	 *
	*/
	getElementWidth: function( elementId )
	{
		if ( typeof( elementId ) != "undefined" && CIRM.utils.Element.isElementExist( elementId ) )
		{
			return document.getElementById( elementId ).offsetWidth;
		}
		return 0;
	},
	
	/**
	 *
	*/
	setElementHeight: function( elementId, value )
	{
		if ( CIRM.utils.Element.isElementExist( elementId ) )
		{
			document.getElementById( elementId ).style.height = value + "px";
		}
	},
	
	/**
	 *
	*/
	setElementWidth: function( elementId, value )
	{
		if ( CIRM.utils.Element.isElementExist( elementId ) )
		{
			document.getElementById( elementId ).style.width = value + "px";
		}
	}
	
};

/**
 * Frame object.
*/
CIRM.utils.Frame = 
{
	
	/**
	 *
	*/
	initialize: function()
	{
		CIRM.utils.Frame._update();
		YAHOO.util.Event.addListener( window, "resize", CIRM.utils.Frame._update )
	},
	
	/**
	 *
	*/
	_update: function()
	{
		var clientHeight = CIRM.utils.Screen.getClientHeight();
		var headerHeight = CIRM.utils.Element.getElementHeight( "header" );
		//var menuHeight = CIRM.utils.Element.getElementHeight( "menu-haut" );
		var footerHeight = CIRM.utils.Element.getElementHeight( "footer" );
		var height = clientHeight - ( headerHeight /*+ menuHeight*/ + footerHeight + 67 );
		if ( CIRM.utils.Element.isElementExist( "breadcrumb" ) )
		{
			height = height - CIRM.utils.Element.getElementHeight( "breadcrumb" );
		}
		if ( CIRM.utils.Element.isElementExist( "course-map" ) )
		{
			CIRM.utils.Element.setElementHeight( "course-map", height );
		}
		CIRM.utils.Element.setElementHeight( "content", height );
	}
	
};

/**
 * Screen object.
*/
CIRM.utils.Screen = 
{
	/**
	 *
	*/
	getClientHeight: function()
	{
		var height = self.innerHeight;
		var mode = document.compatMode;
		if ( ( mode || CIRM.utils.Browser.isInternetExplorer() ) && !CIRM.utils.Browser.isOpera() )
		{
			height = ( mode == "CSS1Compat" ) ? document.documentElement.clientHeight : document.body.clientHeight;
		}
		return height;
	},
	
	/**
	 *
	*/
	getClientWidth: function()
	{
		var width = self.innerWidth;
		var mode = document.compatMode;
		if ( mode || CIRM.utils.Browser.isInternetExplorer() )
		{
			width = ( mode == "CSS1Compat" ) ? document.documentElement.clientWidth : document.body.clientWidth;
		}
		return width;
	},
	
	/**
	 *
	*/
	getDocumentHeight: function()
	{
		var scrollHeight = ( document.compatMode != "CSS1Compat" ) ? document.body.scrollHeight : document.documentElement.scrollHeight;
		var height = Math.max( scrollHeight, CIRM.utils.Screen.getClientHeight() );
		return height;
	},
	
	/**
	 *
	*/
	getDocumentWidth: function()
	{
		var scrollWidth = ( document.compatMode != "CSS1Compat" ) ? document.body.scrollWidth : document.documentElement.scrollWidth;
		var width = Math.max( scrollWidth, CIRM.utils.Screen.getClientWidth() );
		return width;
	},
	
	/**
	 *
	*/
	getScreenHeight: function()
	{
		return screen.height;
	},
	
	/**
	 *
	*/
	getScreenWidth: function()
	{
		return screen.width;
	},
	
	/**
	 *
	*/
	getMouseX: function( evt )
	{
		if ( !evt )
		{
			evt = window.event;
		}
		var xMouse = 0;
		if ( evt.pageX )
		{
			xMouse = evt.pageX;
		}
		else if ( evt.clientX )
		{
			xMouse = evt.clientX + document.body.scrollLeft;
		}
		return xMouse;
	},

	/**
	 *
	*/
	getMouseY: function( evt )
	{
		if ( !evt )
		{
			evt = window.event;
		}
		var yMouse = 0;
		if ( evt.pageY )
		{
			yMouse = evt.pageY;
		}
		else if ( evt.clientY )
		{
			yMouse = evt.clientY + document.body.scrollTop;
		}
		return yMouse;
	}
	
};

/**
 *
*/
CIRM.utils.ToolTip =
{
	
	_shiftX:15,
    _shiftY:15,
	__tip__:null,
	
	/**
	 * 
	*/
	show: function( tipId, e )
	{
		var divElement = document.getElementById( tipId );
		if ( divElement.nodeName == "DIV" && divElement.className == "tooltip" )
		{
			this.__tip__ = divElement;
		}
		if ( this.__tip__ != null )
		{
			document.getElementsByTagName( "body" )[ 0 ].appendChild( this.__tip__ );
			this.__tip__.style.display = "block";
			this._moveTo( e );
		}
	},
	
	/**
	 * 
	*/
	hide: function( tipId )
	{
		if ( tipId != null )
		{
			this.__tip__ = document.getElementById( tipId );
		}
		if ( this.__tip__ != null )
		{
			this.__tip__.style.display = "none";
			document.getElementById( "content" ).appendChild( this.__tip__ );
			this.__tip__ = null;
		}
	},
	
	/**
	 * 
	*/
	_moveTo: function( e )
	{
		var xTip = null;
		var yTip = null;
		
		var xMouse = CIRM.utils.Screen.getMouseX( e );
	 	var yMouse = CIRM.utils.Screen.getMouseY( e );

		var widthTip  =	parseFloat( this.__tip__.offsetWidth );
		var heightTip = parseFloat( this.__tip__.offsetHeight );
		
		var headerHeight = ( document.getElementById( "header" ) ) ? CIRM.utils.Element.getElementHeight( "header" ) : 0;
		
		var contentScroll = document.getElementById( "content" ).scrollTop;
		
		if ( xMouse + this._shiftX + widthTip > CIRM.utils.Screen.getClientWidth() )
		{
			xTip = xMouse - this._shiftX - widthTip;
			if ( xTip < 0 )
			{
				xTip = 0;
			}
		}
		else
		{
			xTip = xMouse + this._shiftX;
		}
		
		if ( yMouse + this._shiftY + heightTip > CIRM.utils.Screen.getClientHeight() )
		{
			yTip = yMouse - this._shiftY - heightTip;
			if ( yTip < 0 )
			{
				yTip = 0;
			}
		}
		else
		{
			yTip = yMouse + this._shiftY;
		}
		
		this.__tip__.style.left = xTip + "px";
		this.__tip__.style.top =  yTip + "px";
	}

};

/**
 * TreeView object.
*/
CIRM.utils.TreeView = function( treeId )
{
	
	if ( treeId )
	{
		 this._create( treeId );
	}
	
};
	
/**
 *
*/
CIRM.utils.TreeView.prototype = 
{
	
	_TREE : null,

	/**
	 *
	*/
	collapseAll: function()
	{
		if ( this._TREE != null )
		{ 
			this._expandCollapseList( this._TREE, null, "closed" );
		}
	},
	
	/**
	 *
	*/
	expandAll: function()
	{
		if ( this._TREE != null )
		{
			this._expandCollapseList( this._TREE, null, "opened" );
		}
	},
	
	/**
	 *
	*/
	expandTo: function ( liId )
	{
		if ( this._TREE != null && typeof( liId ) != "undefined" )
		{
			var result = this._expandCollapseList( this._TREE, liId, "opened" );
			if ( result )
			{
				var liElement = document.getElementById( liId );
				if ( liElement.scrollIntoView )
				{
					liElement.scrollIntoView( false );
				}
				this._setSelectedItem( liId );
			}
		}
	},
		
	/**
	 *
	*/
	_changeParent: function( url )
	{
		if ( url != "" && url != "#" )
		{
			if ( window.opener )
			{
				/*if ( window.opener.document.getElementById( "tree" ) )
				{*/
					window.opener.location.href = url;
				/*}
				else
				{
					document.location.href = url;
				}*/
			}
			else
			{
				document.location.href = url;
			}
		}
	},
	
	/**/
	
	/**
	 *
	*/
	_create: function( treeId )
	{
		var ulElement = document.getElementById( treeId );
		if ( ulElement.nodeName == "UL" && ulElement.className == "tree-view" )
		{
			this._TREE = ulElement;
		}
		if ( this._TREE != null )
		{
			this._process( this._TREE );
		}
	},
	
	/**
	 *
	*/
	_setSelectedItem: function( liId )
	{
		if ( this._TREE != null && typeof( liId ) != "undefined" )
		{
			var aElement = this._TREE.getElementsByTagName( "a" );
			for ( var i = 0; i < aElement.length; i++ )
			{
				var current = aElement[ i ];
				if ( liId != null && current.parentNode.id == liId )
				{
					current.className = "selected";
					if ( current.parentNode.className != "bullet" )
					{
						current.parentNode.className = "opened";
					}
				}
				else
				{
					current.className = "";
				}
			}
		}
	},

	/**
	 *
	*/
	_process: function( ulElement )
	{
		if ( !ulElement.childNodes || ulElement.childNodes.length == 0 )
		{ 
			return false;
		}
		for ( var i = 0; i < ulElement.childNodes.length; i++ )
		{
			var currentSubElement = ulElement.childNodes[ i ];
			currentSubElement.className = "closed";
			if ( currentSubElement.nodeName == "LI" )
			{
				var subListExists = false;
				for ( var j = 0; j < currentSubElement.childNodes.length; j++ )
				{
					var currentSubSubElement = currentSubElement.childNodes[ j ];		
					/***/
					if ( currentSubSubElement.nodeName == "A" )
					{
						var owner = this;
						currentSubSubElement.onclick = function()
						{
							if ( this.parentNode.className != "bullet" )
							{
								if ( this.parentNode.className == "closed" )
								{
									this.parentNode.className = "opened";
								}
							}
							CIRM.utils.Cookie.write( "currentNodeId", this.parentNode.id );
							owner._setSelectedItem( this.parentNode.id );
							owner._changeParent( this.getAttribute( "href" ) );
							return false;
						}
					}
					/***/
					if ( currentSubSubElement.nodeName == "UL" )
					{
						subListExists = true;
						this._process( currentSubSubElement );
					}
				}
			
				var spanElement = document.createElement( "SPAN" );
				spanElement.className = "bullet";
				if ( subListExists == true )
				{
					currentSubElement.className = "closed";
					spanElement.onclick = function()
					{
						if ( this.parentNode.className != "bullet" )
						{
							if ( this.parentNode.className == "closed" )
							{
								this.parentNode.className = "opened";
							}
							else
							{
								this.parentNode.className = "closed";
							}
						}
						return false;
					}
				}
				else
				{
					currentSubElement.className = "bullet";
				}
				spanElement.appendChild( document.createTextNode( "\u00A0" ) );
				currentSubElement.insertBefore( spanElement, currentSubElement.firstChild );
			}
		}
	},

	/**
	 *
	*/
	_expandCollapseList: function( ulElement, itemId, styleName )
	{
		if ( !ulElement.childNodes || ulElement.childNodes.length == 0 )
		{ 
			return false;
		}
		for ( var i = 0; i < ulElement.childNodes.length; i++ )
		{
			var currentSubElement = ulElement.childNodes[ i ];
			if ( itemId != null && currentSubElement.id == itemId )
			{
				return true;
			}
			else
			{
				if ( currentSubElement.nodeName == "LI" )
				{
					var subListExists = false;
					for ( var j = 0; j < currentSubElement.childNodes.length; j++ )
					{
						var currentSubSubElement = currentSubElement.childNodes[ j ];
						if ( currentSubSubElement.nodeName == "UL" )
						{
							subListExists = true;
							var result = this._expandCollapseList( currentSubSubElement, itemId, styleName );
							if ( itemId != null && result == true )
							{
								currentSubElement.className = styleName;
								return true;
							}
						}
					}
					if ( itemId == null && subListExists == true )
					{
						currentSubElement.className = styleName;
					}
				}
			}
		}
	}
	
};

/**
 *
*/
CIRM.utils.Window = 
{
	
	_defaultParams: " ,toolbar=0, location=0, directories=0, status=0, scrollbars=1, resizable=1, menubar=0",
	
	/**
	 *
	*/
	openCenterWindow: function( url, width, height, title )
	{
		if ( url != null && width != null && height != null && title != null )
		{
			var x = ( screen.width - width ) / 2;
			var y = ( screen.height - height ) / 2;
			var win = window.open( url, title, "left=" + x + ", top=" + y + ", width=" + width + ", height=" + height + this._defaultParams );
			win.focus();
		}
	}
	
}
