<?xml version="1.0" encoding="ISO-8859-1"?>


<xsl:stylesheet 
version="1.0"
xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
xmlns:uved="http://www.uved.fr/schema/2.0"
xmlns:lom="http://ltsc.ieee.org/xsd/LOM"
xmlns:lomfr="http://www.lom-fr.org/xsd/LOMFR"
xmlns:interunt="http://www2.educnet.education.fr/sections/superieur/unt/inter/chaine-editoria"
exclude-result-prefixes="uved">

<xsl:output method="xml" omit-xml-declaration="no" indent="yes"/>

<xsl:variable name="transform-from">AaBbCcDdEeFfGgHhIiJjKkLlMmNnOoPpQqRrSsTtUuVvWwXxYyZz_:</xsl:variable>
  <xsl:variable name="transform-to">aabbccddeeffgghhiijjkkllmmnnooppqqrrssttuuvvwwxxyyzzaaaaaaaaaaaacceeeeeeeeiiiiiiiinnoooooooooouuuuuuuuyy--</xsl:variable>

<xsl:template match="interunt:docInterUnt">
    <uved:UVED>
        <xsl:apply-templates select="interunt:metadonnees"/>
        <uved:SECTION>
            <xsl:attribute name="label"><xsl:value-of select="translate(interunt:id,$transform-from,$transform-to)"/></xsl:attribute>
            <xsl:attribute name="titre"><xsl:value-of select="interunt:titre"/></xsl:attribute>
            <xsl:apply-templates select="*[not(self::interunt:metadonnees)]"/>
        </uved:SECTION>
    </uved:UVED>
</xsl:template>


<!--#####################################-->
<!-- Dbut de la gestion des mtadonnes -->
<!--#####################################-->

<xsl:template match="interunt:metadonnees">
    <xsl:if test="../../interunt:docInterUnt">
        <xsl:apply-templates select="lom:lom"/>
    </xsl:if>
</xsl:template>

<xsl:template match="lom:lom">
    <uved:METADONNEES>
        <xsl:apply-templates select="lom:lifeCycle" mode="auteurs"/>
        <xsl:apply-templates select="lom:lifeCycle" mode="dateCre"/>
        <xsl:apply-templates select="lom:lifeCycle" mode="dateMAJ"/>
        <xsl:apply-templates select="lom:general" mode="langue"/>
        <xsl:apply-templates select="lom:lifeCycle" mode="version"/>
        <xsl:apply-templates select="lom:lifeCycle" mode="etat"/>
        <xsl:apply-templates select="lom:educational"/>
        <xsl:apply-templates select="lom:general" mode="motsClefs"/>
        <xsl:apply-templates select="lom:technical"/>
    </uved:METADONNEES>
</xsl:template>

<xsl:template match="lom:general" mode="langue">
    <uved:LANGUE>
        <xsl:value-of select="lom:language"/>
    </uved:LANGUE>
</xsl:template>

<xsl:template match="lom:general" mode="motsClefs">
    <xsl:if test="lom:keyword">
        <uved:MOTSCLE>
            <xsl:for-each select="lom:keyword">
                <uved:MOTCLE>
                    <xsl:value-of select="lom:string"/>
                </uved:MOTCLE>
            </xsl:for-each>
        </uved:MOTSCLE>
    </xsl:if>
</xsl:template>

<xsl:template match="lom:educational">
    <xsl:variable name="niveau" select="./lom:context/lom:value"/>
    <xsl:choose>
        <xsl:when test="$niveau='licence'"><uved:NIVEAULMD>L</uved:NIVEAULMD></xsl:when>
        <xsl:when test="$niveau='mastere'"><uved:NIVEAULMD>M</uved:NIVEAULMD></xsl:when>
        <xsl:when test="$niveau='doctorat'"><uved:NIVEAULMD>D</uved:NIVEAULMD></xsl:when>
        <xsl:otherwise/>
    </xsl:choose>
</xsl:template>

<xsl:template match="lom:lifeCycle" mode="version">
    <uved:VERSION>
        <xsl:value-of select="lom:version/lom:string"/>
    </uved:VERSION>
</xsl:template>

<xsl:template match="lom:lifeCycle" mode="auteurs">
    <uved:AUTEURS>
    <xsl:for-each select=".//lom:contribute/lom:entity">
        <xsl:choose>
            <xsl:when test="contains(.,'VCARD')">
                <uved:AUTEUR>
                    <xsl:attribute name="nom">
                        <xsl:value-of select="substring-before(substring-after(substring-before(substring-after(.,'VERSION:'),'FN:'),'N:'),';')"/>
                    </xsl:attribute>
                    <xsl:attribute name="prenom">
                        <xsl:value-of select="normalize-space(substring-after(substring-after(substring-before(substring-after(.,'VERSION:'),'FN:'),'N:'),';'))"/>
                    </xsl:attribute>
                    <xsl:attribute name="fonction">
                        <xsl:value-of select="normalize-space(substring-before(substring-after(.,'ROLE:'),'ORG:'))"/>
                    </xsl:attribute>
                    <xsl:attribute name="organisme">
                        <xsl:value-of select="normalize-space(substring-before(substring-after(.,'ORG:'),'END:'))"/>
                    </xsl:attribute>
                </uved:AUTEUR>
            </xsl:when>
            <xsl:when test="../lom:role/lom:value='author'">
                <uved:AUTEUR>
                    <xsl:attribute name="nom"><xsl:value-of select="substring-after(.,' ')"/></xsl:attribute>
                    <xsl:attribute name="prenom"><xsl:value-of select="substring-before(.,' ')"/></xsl:attribute>
                    <xsl:attribute name="fonction">placeholder</xsl:attribute>
                    <xsl:attribute name="organisme">placeholder</xsl:attribute>
                </uved:AUTEUR>
            </xsl:when>
        </xsl:choose>
    </xsl:for-each>
    </uved:AUTEURS>
</xsl:template>

<xsl:template match="lom:lifeCycle" mode="dateCre">
    <xsl:variable name="date"><xsl:call-template name="math-min"><xsl:with-param name="noeuds" select=".//lom:contribute/lom:date"/></xsl:call-template>
    </xsl:variable>
    <uved:DATECRE>
        <xsl:value-of select="concat(substring(normalize-space($date),9,2),'/',substring(normalize-space($date),6,2),'/',substring(normalize-space($date),1,4))"/>
    </uved:DATECRE>
</xsl:template>

<xsl:template match="lom:lifeCycle" mode="dateMAJ">
    <xsl:variable name="date"><xsl:call-template name="math-max"><xsl:with-param name="noeuds" select=".//lom:contribute/lom:date"/></xsl:call-template>
    </xsl:variable>
    <uved:DATEMAJ>
        <xsl:value-of select="concat(substring(normalize-space($date),9,2),'/',substring(normalize-space($date),6,2),'/',substring(normalize-space($date),1,4))"/>
    </uved:DATEMAJ>
</xsl:template>

<xsl:template match="lom:lifeCycle" mode="etat">
    <xsl:choose>
        <xsl:when test="./lom:status/lom:value='draft'">
            <uved:ETAT>document de travail</uved:ETAT>
        </xsl:when>
        <xsl:when test="./lom:status/lom:value='final'">
            <uved:ETAT>final</uved:ETAT>
        </xsl:when>
        <xsl:when test="./lom:status/lom:value='revised'">
            <uved:ETAT>rvis</uved:ETAT>
        </xsl:when>
        <xsl:otherwise>
            <uved:ETAT>indisponible</uved:ETAT>
        </xsl:otherwise>
    </xsl:choose>
</xsl:template>

<xsl:template match="lom:technical">
    <uved:LOCALISATION>
        <xsl:value-of select="lom:location"/>
    </uved:LOCALISATION>
</xsl:template>

<!--###################################-->
<!-- Fin de la gestion des mtadonnes -->
<!--###################################-->

<xsl:template match="interunt:section">
    <xsl:choose>
        <xsl:when test="interunt:type='presentation' and /interunt:docInterUnt/interunt:metadonnees/interunt:schemaOrigine/interunt:nom='UVED'">
            <uved:SECTION>
                <xsl:attribute name="label"><xsl:value-of select="translate(interunt:id,$transform-from,$transform-to)"/></xsl:attribute>
                <xsl:attribute name="titre"><xsl:value-of select="interunt:titre"/></xsl:attribute>
                <xsl:apply-templates select="*[not(self::interunt:glossaire|self::interunt:bibliographie|self::interunt:webographie)]"/>
                <xsl:apply-templates select="interunt:glossaire"/>
                <xsl:apply-templates select="interunt:bibliographie"/>
                <xsl:apply-templates select="interunt:webographie"/>
            </uved:SECTION>
        </xsl:when>
        <xsl:when test="interunt:type='grain' and /interunt:docInterUnt/interunt:metadonnees/interunt:schemaOrigine/interunt:nom='UVED'">
            <uved:GRAIN>
                <xsl:attribute name="label"><xsl:value-of select="concat('grain-',substring-after(interunt:id,':'))"/></xsl:attribute>
                <xsl:attribute name="titre"><xsl:value-of select="interunt:titre"/></xsl:attribute>
                <xsl:apply-templates select="./*"/>
            </uved:GRAIN>
        </xsl:when>
        <xsl:otherwise>
            <xsl:choose>
                <xsl:when test="../interunt:section|../interunt:docInterUnt">
                    <uved:SECTION>
                        <xsl:attribute name="label"><xsl:value-of select="translate(interunt:id,$transform-from,$transform-to)"/></xsl:attribute>
                        <xsl:attribute name="titre"><xsl:value-of select="interunt:titre"/></xsl:attribute>
                        <xsl:apply-templates select="*[not(self::interunt:glossaire|self::interunt:bibliographie|self::interunt:webographie)]"/>
                        <xsl:apply-templates select="interunt:glossaire"/>
                        <xsl:apply-templates select="interunt:bibliographie"/>
                        <xsl:apply-templates select="interunt:webographie"/>
                    </uved:SECTION>
                </xsl:when>
                <xsl:otherwise>
                    <uved:CONTENUS>
                        <xsl:attribute name="titre"><xsl:value-of select="interunt:titre"/></xsl:attribute>
                        <uved:SECTION>
                            <xsl:attribute name="label"><xsl:value-of select="translate(generate-id(),$transform-from,$transform-to)"/></xsl:attribute>
                            <xsl:attribute name="titre"><xsl:value-of select="interunt:titre"/></xsl:attribute>
                            <xsl:apply-templates select="./*"/>
                        </uved:SECTION>
                    </uved:CONTENUS>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:otherwise>
    </xsl:choose>
</xsl:template>

<xsl:template match="interunt:contenu">
    <xsl:choose>
        <xsl:when test="interunt:type='introduction'">
            <uved:INTRODUCTION>
                <xsl:apply-templates select="./*"/>
            </uved:INTRODUCTION>
        </xsl:when>
        <xsl:when test="interunt:type='prerequis'">
            <uved:PREREQUIS>
                <xsl:apply-templates select="./*"/>
            </uved:PREREQUIS>
        </xsl:when>
        <xsl:when test="interunt:type='objectifs'">
            <uved:OBJECTIFS>
                <xsl:apply-templates select="./*"/>
            </uved:OBJECTIFS>
        </xsl:when>
        <xsl:when test="interunt:type='citation'">
            <uved:CITATION>
                <xsl:apply-templates select="./*"/>
            </uved:CITATION>
        </xsl:when>
        <xsl:when test="interunt:type='rappel'">
            <uved:RAPPEL>
                <xsl:apply-templates select="./*"/>
            </uved:RAPPEL>
        </xsl:when>
        <xsl:when test="interunt:type='definition'">
            <uved:DEFINITION>
                <xsl:apply-templates select="./*"/>
            </uved:DEFINITION>
        </xsl:when>
        <xsl:when test="interunt:type='methode'">
            <uved:METHODE>
                <xsl:apply-templates select="./*"/>
            </uved:METHODE>
        </xsl:when>
        <xsl:when test="interunt:type='attention'">
            <uved:ATTENTION>
                <xsl:apply-templates select="./*"/>
            </uved:ATTENTION>
        </xsl:when>
        <xsl:when test="interunt:type='conseil'">
            <uved:CONSEIL>
                <xsl:apply-templates select="./*"/>
            </uved:CONSEIL>
        </xsl:when>
        <xsl:when test="interunt:type='caracteristique'">
            <uved:GRAIN>
                <xsl:attribute name="label"><xsl:value-of select="concat('grain-',translate(generate-id(),$transform-from,$transform-to))"/></xsl:attribute>
                <xsl:attribute name="titre">caracteristique</xsl:attribute>
                <xsl:apply-templates select="./*"/>
            </uved:GRAIN>
        </xsl:when>
        <xsl:when test="interunt:type='finalite'">
            <uved:GRAIN>
                <xsl:attribute name="label"><xsl:value-of select="concat('grain-',translate(generate-id(),$transform-from,$transform-to))"/></xsl:attribute>
                <xsl:attribute name="titre">finalite</xsl:attribute>
                <xsl:apply-templates select="./*"/>
            </uved:GRAIN>
        </xsl:when>
        <xsl:when test="interunt:type='contenu'">
            <uved:GRAIN>
                <xsl:attribute name="label"><xsl:value-of select="concat('grain-',translate(generate-id(),$transform-from,$transform-to))"/></xsl:attribute>
                <xsl:attribute name="titre">contenu</xsl:attribute>
                <xsl:apply-templates select="./*"/>
            </uved:GRAIN>
        </xsl:when>
        <xsl:when test="interunt:type='grain' and /interunt:docInterUnt/interunt:metadonnees/interunt:schemaOrigine/interunt:nom='UVED'">
            <uved:GRAIN>
                <xsl:attribute name="label"><xsl:value-of select="concat('grain-',translate(substring-after(interunt:id,':'),$transform-from,$transform-to))"/></xsl:attribute>
                <xsl:attribute name="titre">contenu</xsl:attribute>
                <xsl:apply-templates select="./*"/>
            </uved:GRAIN>
        </xsl:when>
        <xsl:otherwise>
            <!--uved:GRAIN>
                <xsl:attribute name="label"><xsl:value-of select="substring-after(interunt:id,':')"/></xsl:attribute>
                <xsl:attribute name="titre"><xsl:value-of select="interunt:titre"/></xsl:attribute-->
                <xsl:apply-templates select="./*"/>
            <!--/uved:GRAIN-->
        </xsl:otherwise>
    </xsl:choose>
</xsl:template>

<xsl:template match="interunt:blocExpositif">
    <xsl:choose>
        <xsl:when test="interunt:type='introduction'">
            <uved:INTRODUCTION>
                <xsl:apply-templates select="./*"/>
            </uved:INTRODUCTION>
        </xsl:when>
        <xsl:when test="interunt:type='prerequis'">
            <uved:PREREQUIS>
                <xsl:apply-templates select="./*"/>
            </uved:PREREQUIS>
        </xsl:when>
        <xsl:when test="interunt:type='objectifs'">
            <uved:OBJECTIFS>
                <xsl:apply-templates select="./*"/>
            </uved:OBJECTIFS>
        </xsl:when>
        <xsl:when test="interunt:type='citation'">
            <uved:CITATION>
                <xsl:apply-templates select="./*"/>
            </uved:CITATION>
        </xsl:when>
        <xsl:when test="interunt:type='rappel'">
            <uved:RAPPEL>
                <xsl:apply-templates select="./*"/>
            </uved:RAPPEL>
        </xsl:when>
        <xsl:when test="interunt:type='definition'">
            <uved:DEFINITION>
                <xsl:apply-templates select="./*"/>
            </uved:DEFINITION>
        </xsl:when>
        <xsl:when test="interunt:type='methode'">
            <uved:METHODE>
                <xsl:apply-templates select="./*"/>
            </uved:METHODE>
        </xsl:when>
        <xsl:when test="interunt:type='attention'">
            <uved:ATTENTION>
                <xsl:apply-templates select="./*"/>
            </uved:ATTENTION>
        </xsl:when>
        <xsl:when test="interunt:type='conseil'">
            <uved:CONSEIL>
                <xsl:apply-templates select="./*"/>
            </uved:CONSEIL>
        </xsl:when>
        <xsl:when test="interunt:type='caracteristique'">
            <uved:GRAIN>
                <xsl:attribute name="label"><xsl:value-of select="concat('grain-',translate(generate-id(),$transform-from,$transform-to))"/></xsl:attribute>
                <xsl:attribute name="titre">caracteristique</xsl:attribute>
                <xsl:apply-templates select="./*"/>
            </uved:GRAIN>
        </xsl:when>
        <xsl:when test="interunt:type='finalite'">
            <uved:GRAIN>
                <xsl:attribute name="label"><xsl:value-of select="concat('grain-',translate(generate-id(),$transform-from,$transform-to))"/></xsl:attribute>
                <xsl:attribute name="titre">finalite</xsl:attribute>
                <xsl:apply-templates select="./*"/>
            </uved:GRAIN>
        </xsl:when>
        <xsl:when test="interunt:type='contenu'">
            <uved:GRAIN>
                <xsl:attribute name="label"><xsl:value-of select="concat('grain-',translate(generate-id(),$transform-from,$transform-to))"/></xsl:attribute>
                <xsl:attribute name="titre">contenu</xsl:attribute>
                <xsl:apply-templates select="./*"/>
            </uved:GRAIN>
        </xsl:when>
        <xsl:when test="interunt:type='grain' and /interunt:docInterUnt/interunt:metadonnes/interunt:schemaOrigine/interunt:nom='UVED'">
            <uved:GRAIN>
                <xsl:attribute name="label"><xsl:value-of select="concat('grain-',translate(substring-after(interunt:id,':'),$transform-from,$transform-to))"/></xsl:attribute>
                <xsl:attribute name="titre"><xsl:value-of select="interunt:titre"/></xsl:attribute>
                <xsl:apply-templates select="./*"/>
            </uved:GRAIN>
        </xsl:when>
        <xsl:when test="../../interunt:type='grain' and /interunt:docInterUnt/interunt:metadonnees/interunt:schemaOrigine/interunt:nom='UVED'">
            <xsl:apply-templates select="./*"/>
        </xsl:when>
        <xsl:when test="../../interunt:itemAnnexe">
            <xsl:apply-templates select="./*"/>
        </xsl:when>
        <xsl:otherwise>
            <uved:GRAIN>
                <xsl:attribute name="label"><xsl:value-of select="concat('grain-',translate(generate-id(),$transform-from,$transform-to))"/></xsl:attribute>
                <xsl:attribute name="titre"><xsl:value-of select="interunt:titre"/></xsl:attribute>
                <xsl:apply-templates select="./*"/>
            </uved:GRAIN>
        </xsl:otherwise>
    </xsl:choose>
</xsl:template>

<xsl:template match="interunt:annexes">
    <uved:ANNEXES>
        <xsl:apply-templates select="./*"/>
    </uved:ANNEXES>
</xsl:template>

<xsl:template match="interunt:itemAnnexe">
    <uved:ANNEXE>
        <xsl:attribute name="titre"><xsl:value-of select="interunt:titre"/></xsl:attribute>
        <xsl:attribute name="label"><xsl:value-of select="translate(./interunt:id,$transform-from,$transform-to)"/></xsl:attribute>
        <xsl:apply-templates select="./*"/>
    </uved:ANNEXE>
</xsl:template>

<!-- balise vides -->
<xsl:template match="interunt:type"/>

<xsl:template match="interunt:label"/>

<xsl:template match="interunt:titre"/>

<xsl:template match="interunt:id"/>

<xsl:template match="interunt:niveau"/>
<!-- /balise vides -->

<xsl:template match="interunt:paragraphe">
    <uved:PARAGRAPHE>
        <xsl:apply-templates/>
    </uved:PARAGRAPHE>
</xsl:template>

<xsl:template match="interunt:webographie">
    <uved:WEBOGRAPHIE>
        <xsl:for-each select="//interunt:itemWebographie">
            <xsl:apply-templates select="."/>
        </xsl:for-each>
    </uved:WEBOGRAPHIE>
</xsl:template>

<xsl:template match="interunt:itemWebographie">
    <uved:REFERENCEWEBOGRAPHIQUE>
        <xsl:attribute name="labelAdress"><xsl:value-of select="./interunt:label"/></xsl:attribute>
        <xsl:attribute name="URL"><xsl:value-of select="./interunt:url"/></xsl:attribute>
        <!-- Placeholders -->
        <xsl:attribute name="auteurs">placeholder</xsl:attribute>
        <xsl:attribute name="titre">placeholder</xsl:attribute>
        <xsl:attribute name="dateConsultation">placeholder</xsl:attribute>
    </uved:REFERENCEWEBOGRAPHIQUE>
</xsl:template>

<xsl:template match="interunt:refWebo">
    <uved:LIENREFERENCEWEBOGRAPHIQUE>
        <xsl:attribute name="labelReference"><xsl:value-of select="./interunt:label"/></xsl:attribute>
    </uved:LIENREFERENCEWEBOGRAPHIQUE>
</xsl:template>

<xsl:template match="interunt:bibliographie">
    <uved:BIBLIOGRAPHIE>
        <xsl:apply-templates/>
    </uved:BIBLIOGRAPHIE>
</xsl:template>

<xsl:template match="interunt:itemBibliographie">
    <uved:REFERENCEBIBLIOGRAPHIQUE>
        <xsl:attribute name="labelReference"><xsl:value-of select="./interunt:label"/></xsl:attribute>
        <uved:REFOUVRAGE>
            <xsl:attribute name="titre"><xsl:value-of select="./interunt:titre"/></xsl:attribute>
            <xsl:for-each select="./interunt:auteur">
                <xsl:attribute name="autresAuteurs"><xsl:value-of select="."/></xsl:attribute>
            </xsl:for-each>
            <xsl:attribute name="premierAuteur"><xsl:value-of select="./interunt:label"/></xsl:attribute>
            <xsl:attribute name="editeur"><xsl:value-of select="placeholder"/></xsl:attribute>
            <xsl:attribute name="annee">placeholder</xsl:attribute>
        </uved:REFOUVRAGE>
    </uved:REFERENCEBIBLIOGRAPHIQUE>
</xsl:template>

<xsl:template match="interunt:refBiblio">
    <uved:LIENREFERENCEBIBLIOGRAPHIQUE>
        <xsl:attribute name="labelReference"><xsl:value-of select="./interunt:label"/></xsl:attribute>
    </uved:LIENREFERENCEBIBLIOGRAPHIQUE>
</xsl:template>

<xsl:template match="interunt:glossaire">
    <uved:GLOSSAIRE>
        <xsl:apply-templates/>
    </uved:GLOSSAIRE>
</xsl:template>

<xsl:template match="interunt:refGlossaire">
    <uved:LIENMOTDUGLOSSAIRE>
        <xsl:attribute name="mot"><xsl:value-of select="interunt:label"/></xsl:attribute>
        <xsl:attribute name="labelReference"><xsl:value-of select="interunt:label"/></xsl:attribute>
    </uved:LIENMOTDUGLOSSAIRE>
</xsl:template>

<xsl:template match="interunt:acronymes">
    <uved:GLOSSAIRE>
        <xsl:apply-templates/>
    </uved:GLOSSAIRE>
</xsl:template>

<xsl:template match="interunt:refAcronyme">
    <uved:LIENMOTDUGLOSSAIRE>
        <xsl:attribute name="mot"><xsl:value-of select="interunt:label"/></xsl:attribute>
        <xsl:attribute name="labelReference"><xsl:value-of select="interunt:label"/></xsl:attribute>
    </uved:LIENMOTDUGLOSSAIRE>
</xsl:template>

<xsl:template match="interunt:refDocument">
    <xsl:choose>
        <xsl:when test="substring(normalize-space(interunt:url),1,4)='http'">
            <uved:LIENWEB url="{normalize-space(interunt:url)}">
                <xsl:value-of select="normalize-space(.)"/>
            </uved:LIENWEB>
        </xsl:when>
        <xsl:otherwise>
            <uved:LIENDOCUMENT url="{interunt:url}">
                <xsl:value-of select="normalize-space(.)"/>
            </uved:LIENDOCUMENT>
        </xsl:otherwise>
    </xsl:choose>
</xsl:template>

<xsl:template match="interunt:refSection">
    <uved:LIEN>
        <xsl:attribute name="type">section</xsl:attribute>
        <xsl:attribute name="label"><xsl:value-of select="translate(interunt:refId,$transform-from,$transform-to)"/></xsl:attribute>
        <xsl:value-of select="interunt:label"/>
    </uved:LIEN>
</xsl:template>

<xsl:template match="interunt:refAnnexe">
    <uved:LIEN>
        <xsl:attribute name="type">annexe</xsl:attribute>
        <xsl:attribute name="label"><xsl:value-of select="translate(interunt:refId,$transform-from,$transform-to)"/></xsl:attribute>
        <xsl:value-of select="interunt:label"/>
    </uved:LIEN>
</xsl:template>

<xsl:template match="interunt:code">
    <uved:EM>
        <xsl:value-of select="normalize-space(.)"/>
    </uved:EM>
</xsl:template>

<xsl:template match="interunt:itemGlossaire">
    <uved:MOTDUGLOSSAIRE>
        <xsl:attribute name="mot"><xsl:value-of select="interunt:titre"/></xsl:attribute>
        <xsl:value-of select="interunt:paragraphe"/>
    </uved:MOTDUGLOSSAIRE>
</xsl:template>

<xsl:template match="interunt:adresseWeb">
    <uved:LIENWEB url="{normalize-space(interunt:url)}">
        <xsl:value-of select="translate(interunt:label,$transform-from,$transform-to)"/>
    </uved:LIENWEB>
</xsl:template>

<xsl:template match="interunt:locution">
    <xsl:apply-templates/>
</xsl:template>

<!-- Gestion des tables -->
<xsl:template match="interunt:tableau">
    <uved:ZONETABLE>
        <uved:TABLE>
            <xsl:apply-templates select="interunt:tr"/>
        </uved:TABLE>
        <xsl:apply-templates select="interunt:legende"/>
    </uved:ZONETABLE>
</xsl:template>

<xsl:template match="interunt:tr">
    <uved:TR>
        <xsl:apply-templates select="interunt:th|interunt:td"/>
    </uved:TR>
</xsl:template>

<xsl:template match="interunt:th">
    <uved:TH>
        <xsl:if test="interunt:colspan"><xsl:attribute name="colspan"><xsl:value-of select="interunt:colspan"/></xsl:attribute></xsl:if>
        <xsl:if test="interunt:rowspan"><xsl:attribute name="rowspan"><xsl:value-of select="interunt:rowspan"/></xsl:attribute></xsl:if>
        <xsl:apply-templates/>
    </uved:TH>
</xsl:template>

<xsl:template match="interunt:td">
    <uved:TD>
        <xsl:if test="interunt:colspan"><xsl:attribute name="colspan"><xsl:value-of select="interunt:colspan"/></xsl:attribute></xsl:if>
        <xsl:if test="interunt:rowspan"><xsl:attribute name="rowspan"><xsl:value-of select="interunt:rowspan"/></xsl:attribute></xsl:if>
        <xsl:apply-templates/>
    </uved:TD>
</xsl:template>

<xsl:template match="interunt:legende">
    <uved:LEGENDE><xsl:value-of select="."/></uved:LEGENDE>
</xsl:template>

<xsl:template match="interunt:liste">
    <uved:LISTE>
        <xsl:attribute name="type"><xsl:value-of select="interunt:type"/></xsl:attribute>
        <xsl:attribute name="titre"><xsl:value-of select="interunt:titre"/></xsl:attribute>
        <xsl:apply-templates select="./interunt:item"/>
    </uved:LISTE>
</xsl:template>

<xsl:template match="interunt:item">
    <uved:ITEM>
        <xsl:apply-templates/>
    </uved:ITEM>
</xsl:template>

<xsl:template match="interunt:media | interunt:imagette">
    <uved:MEDIA>
        <uved:FICHIER>
            <xsl:variable name="extension"><xsl:value-of select="substring-after(interunt:typeMIME,'/')"/></xsl:variable>
            <xsl:choose>
                <xsl:when test="$extension='png' or $extension='PNG'">
                    <xsl:attribute name="format">png</xsl:attribute>
                </xsl:when>
                <xsl:when test="$extension='jpeg' or $extension='JPEG'">
                    <xsl:attribute name="format">jpeg</xsl:attribute>
                </xsl:when>
                <xsl:when test="$extension='gif' or $extension='GIF'">
                    <xsl:attribute name="format">gif</xsl:attribute>
                </xsl:when>
                <xsl:when test="$extension='x-shockwave-flash'">
                    <xsl:attribute name="format">swf</xsl:attribute>
                </xsl:when>
                <xsl:when test="$extension='mpeg' or $extension='MPEG'">
                    <xsl:attribute name="format">mpeg</xsl:attribute>
                </xsl:when>
                <xsl:when test="$extension='mp4' or $extension='MP4'">
                    <xsl:attribute name="format">mp4</xsl:attribute>
                </xsl:when>
                <xsl:when test="$extension='octet-stream'">
                    <xsl:attribute name="format">class</xsl:attribute>
                </xsl:when>
                <xsl:when test="$extension='java-archive'">
                    <xsl:attribute name="format">java</xsl:attribute>
                </xsl:when>
            </xsl:choose>
            <xsl:attribute name="chemin"><xsl:value-of select="normalize-space(interunt:fichier)"/></xsl:attribute>
        </uved:FICHIER>
        <xsl:apply-templates select="./interunt:legende"/>
        <uved:TAILLE>
            <xsl:attribute name="largeur"><xsl:value-of select="interunt:largeur"/></xsl:attribute>
            <xsl:attribute name="hauteur"><xsl:value-of select="interunt:hauteur"/></xsl:attribute>
        </uved:TAILLE>
        <xsl:apply-templates select="./interunt:credits"/>
        <xsl:if test="child::interunt:parametre">
            <uved:PARAMETRES>
                <xsl:for-each select="./interunt:parametre">
                    <uved:PARAMETRE>
                        <xsl:attribute name="nom"><xsl:value-of select="./interunt:clef"/></xsl:attribute>
                        <xsl:attribute name="valeur"><xsl:value-of select="./interunt:valeur"/></xsl:attribute>
                    </uved:PARAMETRE>
                </xsl:for-each>
            </uved:PARAMETRES>
        </xsl:if>
    </uved:MEDIA>
</xsl:template>

<xsl:template match="interunt:credits">
    <uved:CREDITS><xsl:apply-templates/></uved:CREDITS>
</xsl:template>

<xsl:template match="interunt:equation">
    <xsl:choose>
        <xsl:when test="./interunt:type='equatex'">
            <uved:EQUATEX>
                <xsl:attribute name="texte"><xsl:value-of select="interunt:texte"/></xsl:attribute>
                <xsl:attribute name="image"></xsl:attribute>
            </uved:EQUATEX>
        </xsl:when>
        <xsl:when test="./interunt:type='equajaxe'">
            <uved:EQUAJAXE>
                <xsl:attribute name="texte"><xsl:value-of select="interunt:texte"/></xsl:attribute>
                <xsl:attribute name="image"></xsl:attribute>
            </uved:EQUAJAXE>
        </xsl:when>
    </xsl:choose>
</xsl:template>

<xsl:template match="interunt:exercice">
    <xsl:choose>
        <xsl:when test="./interunt:type='qcm'">
            <uved:QCM>
                <xsl:attribute name="titre"><xsl:value-of select="./interunt:titre"/></xsl:attribute>
                <xsl:apply-templates/>
            </uved:QCM>
        </xsl:when>
        <xsl:when test="./interunt:type='exercice'">
            <uved:EXERCICE>
                <xsl:attribute name="titre"><xsl:value-of select="./interunt:titre"/></xsl:attribute>
                <xsl:apply-templates/>
            </uved:EXERCICE>
        </xsl:when>
        <xsl:otherwise>
            <uved:EXERCICE>
                <xsl:attribute name="titre"><xsl:value-of select="./interunt:titre"/></xsl:attribute>
                <xsl:apply-templates/>
            </uved:EXERCICE>
        </xsl:otherwise>
    </xsl:choose>
</xsl:template>

<xsl:template match="interunt:aide">
    <uved:AIDE>
        <xsl:apply-templates/>
    </uved:AIDE>
</xsl:template>

<xsl:template match="interunt:questionQCM">
    <uved:QUESTIONQCM>
        <xsl:apply-templates/>
    </uved:QUESTIONQCM>
</xsl:template>

<xsl:template match="interunt:reponseQCM">
    <uved:REPONSEQCM>
        <xsl:attribute name="bonne"><xsl:value-of select="./interunt:bonne"/></xsl:attribute>
        <xsl:apply-templates/>
    </uved:REPONSEQCM>
</xsl:template>

<xsl:template match="interunt:bonne">
</xsl:template>

<xsl:template match="interunt:propositionRep">
    <uved:TEXTEREP>
        <xsl:value-of select="."/>
    </uved:TEXTEREP>
</xsl:template>

<xsl:template match="interunt:commentaireRep">
    <uved:COMMENTAIREREP>
        <xsl:value-of select="."/>
    </uved:COMMENTAIREREP>
</xsl:template>

<xsl:template match="interunt:points">
    <uved:POINTS>
        <xsl:apply-templates/>
    </uved:POINTS>
</xsl:template>

<xsl:template match="interunt:question">
    <uved:QUESTION>
        <xsl:apply-templates/>
    </uved:QUESTION>
</xsl:template>

<xsl:template match="interunt:enonce">
    <xsl:choose>
        <xsl:when test="parent::interunt:questionQCM">
            <uved:ENONCEQCM>
                <xsl:value-of select="."/>
            </uved:ENONCEQCM>
        </xsl:when>
        <xsl:otherwise>
            <uved:ENONCE>
                <xsl:apply-templates/>
            </uved:ENONCE>
        </xsl:otherwise>
    </xsl:choose>
</xsl:template>

<xsl:template match="interunt:difficulte">
    <uved:DIFFICULTE><xsl:value-of select="."/></uved:DIFFICULTE>
</xsl:template>

<xsl:template match="interunt:temps">
    <uved:TEMPS><xsl:value-of select="."/></uved:TEMPS>
</xsl:template>

<xsl:template match="interunt:aide">
    <uved:AIDE>
        <xsl:apply-templates/>
    </uved:AIDE>
</xsl:template>

<xsl:template match="interunt:solution">
    <uved:SOLUTION>
        <xsl:apply-templates/>
    </uved:SOLUTION>
</xsl:template>

<xsl:template match="interunt:emphase">
    <uved:EM>
        <xsl:value-of select="."/>
    </uved:EM>
</xsl:template>

<xsl:template match="interunt:bonne">
</xsl:template>

<xsl:template match="interunt:exposant">
    <uved:SUP>
        <xsl:value-of select="."/>
    </uved:SUP>
</xsl:template>

<xsl:template match="interunt:indice">
    <uved:SUB>
        <xsl:value-of select="."/>
    </uved:SUB>
</xsl:template>


<!--#######################-->
<!--## fonctions annexes ##-->
<!--#######################-->

<!-- renvoit l'extension d'un fichier  partir de son nom -->
<xsl:template name="extensionfichier">
    <xsl:param name="nom"/>
    <xsl:choose>
        <xsl:when test="contains($nom,'.')">
            <xsl:call-template name="extensionfichier"><xsl:with-param name="nom" select="substring-after($nom,'.')"/></xsl:call-template>
        </xsl:when>
        <xsl:otherwise><xsl:value-of select="$nom"/></xsl:otherwise>
    </xsl:choose>
</xsl:template>

<xsl:template name="math-min">
    <xsl:param name="noeuds" select="/.."/>
    <xsl:choose>
        <xsl:when test="not($noeuds)">NaN</xsl:when>
        <xsl:otherwise>
            <xsl:for-each select="$noeuds">
                <xsl:sort data-type="number"/>
                <xsl:if test="position()=1">
                    <xsl:value-of select="."/>
                </xsl:if>
            </xsl:for-each>
        </xsl:otherwise>
    </xsl:choose>
</xsl:template>

<xsl:template name="math-max">
    <xsl:param name="noeuds" select="/.."/>
    <xsl:choose>
        <xsl:when test="not($noeuds)">NaN</xsl:when>
        <xsl:otherwise>
            <xsl:for-each select="$noeuds">
                <xsl:sort data-type="number" order="descending"/>
                <xsl:if test="position()=1">
                    <xsl:value-of select="."/>
                </xsl:if>
            </xsl:for-each>
        </xsl:otherwise>
    </xsl:choose>
</xsl:template>

</xsl:stylesheet>